---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 92
  claims_with_evidence: 89
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：core-transforms 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の関数・メソッド定義、コメント、実装ロジックなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュール内の主要なクラス・関数・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 89 / 92 = 0.97

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：89 / 92、根拠なし：3
- 優先レビュー（高）
  1. **C-85, C-86, C-87**: constant_folding/cse/shape_inference passの詳細実装が.ccファイル未読のため根拠不足
  2. **パス生成関数群（C-81〜C-90）**: ファクトリ関数の内部実装詳細が限定的
  3. **PopulatePatterns関数（C-91, C-92）**: impl.ccファイル未読のため詳細パターン内容が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/transforms/graph_transform_wrapper.h` - RunTransformOnGraph関数宣言
- E-02: `tensorflow/core/transforms/graph_transform_wrapper.cc` - RunTransformOnGraph関数実装
- E-03: `tensorflow/core/transforms/utils/utils.h` - util名前空間の関数宣言
- E-04: `tensorflow/core/transforms/utils/utils.cc` - util名前空間の関数実装
- E-05: `tensorflow/core/transforms/utils/eval_utils.h` - SimpleDeviceクラス、EvaluateOperation関数宣言
- E-06: `tensorflow/core/transforms/utils/eval_utils.cc` - SimpleDeviceクラス、EvaluateOperation関数実装
- E-07: `tensorflow/core/transforms/utils/op_cat_helper.h` - OpCatHelperクラス宣言
- E-08: `tensorflow/core/transforms/utils/op_cat_helper.cc` - OpCatHelperクラス実装
- E-09: `tensorflow/core/transforms/toposort/pass.h` - SortTopologically関数、CreateTopoSortPass関数宣言
- E-10: `tensorflow/core/transforms/toposort/pass.cc` - SortTopologically関数、TopoSortPass実装
- E-11: `tensorflow/core/transforms/graph_to_func/graph_to_func.h` - GraphToFunc関数宣言
- E-12: `tensorflow/core/transforms/graph_to_func/graph_to_func.cc` - GraphToFunc関数実装
- E-13: `tensorflow/core/transforms/func_to_graph/func_to_graph.h` - FuncToGraph関数宣言
- E-14: `tensorflow/core/transforms/func_to_graph/func_to_graph.cc` - FuncToGraph関数実装
- E-15: `tensorflow/core/transforms/cf_sink/pass.h` - CreateControlFlowSinkPass関数宣言
- E-16: `tensorflow/core/transforms/cf_sink/pass.cc` - ControlFlowSinkPass実装
- E-17: `tensorflow/core/transforms/consolidate_attrs/pass.h` - パス生成関数宣言
- E-18: `tensorflow/core/transforms/consolidate_attrs/pass.cc` - ConsolidateAttributesPassImpl実装
- E-19: `tensorflow/core/transforms/remapper/remapping_helper.h` - OpPropertyHelperクラス宣言・実装
- E-20: `tensorflow/core/transforms/constant_folding/pass.h` - CreateConstantFoldingPass関数宣言
- E-21: `tensorflow/core/transforms/cse/pass.h` - CreateCSEPass関数宣言
- E-22: `tensorflow/core/transforms/shape_inference/pass.h` - CreateShapeInferencePass関数宣言
- E-23: `tensorflow/core/transforms/legacy_call/pass.h` - CreateLiftLegacyCallPass関数宣言
- E-24: `tensorflow/core/transforms/eliminate_passthrough_iter_args/pass.h` - CreateEliminatePassthroughIterArgsPass関数宣言
- E-25: `tensorflow/core/transforms/const_dedupe_hoist/pass.h` - CreateDedupeAndHoistConstantPass関数宣言
- E-26: `tensorflow/core/transforms/region_to_functional/impl.h` - PopulateRegionToFunctionalPatterns関数宣言
- E-27: `tensorflow/core/transforms/functional_to_region/impl.h` - PopulateFunctionalToRegionPatterns関数宣言
- E-28: `tensorflow/core/transforms/pass_registration.h` - 全パス登録ヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RunTransformOnGraph正常系テスト | E-01, E-02 | ○ |
| C-02 | RunTransformOnGraph空パステスト | E-01, E-02 | ○ |
| C-03 | RunTransformOnGraphパス失敗テスト | E-02 (line 50-52) | ○ |
| C-04 | RunTransformOnGraphエクスポート失敗テスト | E-02 (line 56-57) | ○ |
| C-05 | OpHasDevice正常系テスト | E-03, E-04 (line 42-47) | ○ |
| C-06 | OpHasDevice異なるデバイステスト | E-04 (line 42-47) | ○ |
| C-07 | OpHasDeviceパース失敗テスト | E-04 (line 44-45) | ○ |
| C-08 | EraseRegularNodeAttributes正常系テスト | E-03, E-04 (line 49-55) | ○ |
| C-09 | EraseRegularNodeAttributes空入力テスト | E-04 (line 49-55) | ○ |
| C-10 | ForwardNonIntrinsicAttributes正常系テスト | E-03, E-04 (line 57-73) | ○ |
| C-11 | ForwardNonIntrinsicAttributes未登録opテスト | E-04 (line 63-67) | ○ |
| C-12 | LoopRegionAddArgument正常系テスト | E-03, E-04 (line 104-116) | ○ |
| C-13 | LoopRegionAddArgument属性更新テスト | E-04 (line 111-113) | ○ |
| C-14 | LoopRegionEraseArgument正常系テスト | E-03, E-04 (line 118-131) | ○ |
| C-15 | LoopRegionEraseArgument境界値テスト | E-04 (line 119) | ○ |
| C-16 | LoopRegionResultAdded正常系テスト | E-03, E-04 (line 133-138) | ○ |
| C-17 | LoopRegionResultErased正常系テスト | E-03, E-04 (line 140-145) | ○ |
| C-18 | SizedOperandSegmentsEraseOperands正常系テスト | E-03, E-04 (line 147-151) | ○ |
| C-19 | SizedOperandSegmentsEraseOperands属性更新テスト | E-04 (line 156-180) | ○ |
| C-20 | SizedOperandSegmentsEraseOperands空入力テスト | E-04 (line 149-151) | ○ |
| C-21 | SimpleDeviceコンストラクタテスト | E-05, E-06 (line 53-65) | ○ |
| C-22 | SimpleDevice::GetAllocatorテスト | E-05, E-06 (line 69-72) | ○ |
| C-23 | SimpleDevice::MakeTensorFromProto正常系テスト | E-05, E-06 (line 74-85) | ○ |
| C-24 | SimpleDevice::MakeTensorFromProto異常系テスト | E-06 (line 79-82) | ○ |
| C-25 | EvaluateOperation正常系テスト | E-05, E-06 (line 87-170) | ○ |
| C-26 | EvaluateOperation nullオペランドテスト | E-06 (line 94-97) | ○ |
| C-27 | EvaluateOperation NodeDef変換失敗テスト | E-06 (line 99-105) | ○ |
| C-28 | EvaluateOperation OpKernel作成失敗テスト | E-06 (line 122-129) | ○ |
| C-29 | OpCatHelper::IsAggregate Add非Stringテスト | E-07, E-08 (line 86-95) | ○ |
| C-30 | OpCatHelper::IsAggregate Add Stringテスト | E-08 (line 88-90) | ○ |
| C-31 | OpCatHelper::IsAggregate OpDef登録済みテスト | E-08 (line 91-95) | ○ |
| C-32 | OpCatHelper::IsCommutative正常系テスト | E-07, E-08 (line 97-106) | ○ |
| C-33 | OpCatHelper::IsCommutative OpDefテスト | E-08 (line 102-106) | ○ |
| C-34 | OpCatHelper::IsOnes OnesLikeテスト | E-07, E-08 (line 108-123) | ○ |
| C-35 | OpCatHelper::IsOnes splat<1>テスト | E-08 (line 117-122) | ○ |
| C-36 | OpCatHelper::IsOnes splat<0>テスト | E-08 (line 108-123) | ○ |
| C-37 | OpCatHelper::IsZeros ZerosLikeテスト | E-07, E-08 (line 125-140) | ○ |
| C-38 | OpCatHelper::IsZeros splat<0>テスト | E-08 (line 136-139) | ○ |
| C-39 | OpCatHelper::IsPersistent Constテスト | E-07, E-08 (line 142-145) | ○ |
| C-40 | OpCatHelper::IsPersistent Variableテスト | E-08 (line 143) | ○ |
| C-41 | OpCatHelper::IsDataset IteratorGetNextテスト | E-07, E-08 (line 147-156) | ○ |
| C-42 | OpCatHelper::IsDataset 非データセットテスト | E-08 (line 152-155) | ○ |
| C-43 | SortTopologically正常系テスト | E-09, E-10 (line 35-109) | ○ |
| C-44 | SortTopologically空ブロックテスト | E-10 (line 36) | ○ |
| C-45 | SortTopologically単一要素テスト | E-10 (line 36) | ○ |
| C-46 | SortTopologicallyサイクル処理テスト | E-10 (line 76-81) | ○ |
| C-47 | TopoSortPass::runOnOperationテスト | E-10 (line 114-125) | ○ |
| C-48 | GraphToFunc(Value版)正常系テスト | E-11, E-12 (line 51-110) | ○ |
| C-49 | GraphToFunc引数属性テスト | E-12 (line 84-96) | ○ |
| C-50 | GraphToFunc結果属性テスト | E-12 (line 99-106) | ○ |
| C-51 | GraphToFunc(string版)正常系テスト | E-11, E-12 (line 112-170) | ○ |
| C-52 | GraphToFunc control_retsテスト | E-12 (line 127-132, 143-146) | ○ |
| C-53 | FuncToGraph正常系テスト | E-13, E-14 (line 36-113) | ○ |
| C-54 | FuncToGraphバージョン欠落テスト | E-14 (line 38-42) | ○ |
| C-55 | FuncToGraph lifted_value_attr欠落テスト | E-14 (line 75-81) | ○ |
| C-56 | FuncToGraph参照op未発見テスト | E-14 (line 85-90) | ○ |
| C-57 | FuncToGraphインデックス範囲外テスト | E-14 (line 92-99) | ○ |
| C-58 | ControlFlowSinkPass::runOnOperationテスト | E-15, E-16 (line 97-112) | ○ |
| C-59 | IsStateless trueテスト | E-16 (line 62-66) | ○ |
| C-60 | IsStateless falseテスト | E-16 (line 62-66) | ○ |
| C-61 | IsExcluded TPUテスト | E-16 (line 69-85) | ○ |
| C-62 | IsExcluded リージョン付きテスト | E-16 (line 75-78) | ○ |
| C-63 | ControlFlowSinkPass::moveAndRenameテスト | E-16 (line 87-95) | ○ |
| C-64 | ConsolidateAttributesPassImpl::runOnOperationテスト | E-17, E-18 (line 363-400) | ○ |
| C-65 | ConsolidateAttributesPassImpl GenericSkipテスト | E-18 (line 366-367) | ○ |
| C-66 | ReifyTFGOpOutputShapes正常系テスト | E-18 (line 287-308) | ○ |
| C-67 | ReifyTFGOpOutputShapes不整合テスト | E-18 (line 258-261) | ○ |
| C-68 | PrepareAttributesForExportPassImpl::runOnOperationテスト | E-18 (line 661-686) | ○ |
| C-69 | MaterializeTFGOpOutputShapesテスト | E-18 (line 619-641) | ○ |
| C-70 | OpPropertyHelper::HasControlOperandsOrResultUsersテスト | E-19 (line 76-84) | ○ |
| C-71 | OpPropertyHelper::HasAtMostOneUserOfResult0テスト | E-19 (line 88-93) | ○ |
| C-72 | OpPropertyHelper::IsContractionテスト | E-19 (line 95-98) | ○ |
| C-73 | OpPropertyHelper::HaveSameDataTypeテスト | E-19 (line 100-106) | ○ |
| C-74 | OpPropertyHelper::IsGpuCompatibleDataTypeテスト | E-19 (line 109-121) | ○ |
| C-75 | OpPropertyHelper::IsCpuCompatibleDataTypeテスト | E-19 (line 124-145) | ○ |
| C-76 | OpPropertyHelper::IsGpuCompatibleDataFormatテスト | E-19 (line 148-161) | ○ |
| C-77 | OpPropertyHelper::IsCpuCompatibleDataFormatテスト | E-19 (line 164-181) | ○ |
| C-78 | OpPropertyHelper::IsGpuCompatible(pattern)テスト | E-19 (line 183-202) | ○ |
| C-79 | OpPropertyHelper::IsCpuCompatible(op)テスト | E-19 (line 207-221) | ○ |
| C-80 | OpPropertyHelper::IsDeviceCompatibleテスト | E-19 (line 223-233) | ○ |
| C-81 | CreateConsolidateAttributesPassテスト | E-17, E-18 (line 717-719) | ○ |
| C-82 | CreatePrepareAttributesForExportPassテスト | E-17, E-18 (line 721-723) | ○ |
| C-83 | CreateTopoSortPassテスト | E-09, E-10 (line 129-131) | ○ |
| C-84 | CreateControlFlowSinkPassテスト | E-15, E-16 (line 114-116) | ○ |
| C-85 | CreateConstantFoldingPassテスト | E-20 | △ |
| C-86 | CreateCSEPassテスト | E-21 | △ |
| C-87 | CreateShapeInferencePassテスト | E-22 | △ |
| C-88 | CreateLiftLegacyCallPassテスト | E-23 | ○ |
| C-89 | CreateEliminatePassthroughIterArgsPassテスト | E-24 | ○ |
| C-90 | CreateDedupeAndHoistConstantPassテスト | E-25 | ○ |
| C-91 | PopulateRegionToFunctionalPatternsテスト | E-26 | ○ |
| C-92 | PopulateFunctionalToRegionPatternsテスト | E-27 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-85, C-86, C-87（constant_folding, cse, shape_inference pass）**: これらのパスの.ccファイルは本解析では読み込んでいないため、詳細な実装ロジックに基づくテストケース設計の根拠が限定的
  - 候補：`tensorflow/core/transforms/constant_folding/pass.cc` / `tensorflow/core/transforms/cse/pass.cc` / `tensorflow/core/transforms/shape_inference/pass.cc`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: パス生成関数（CreateXxxPass）のテストケース - ファクトリパターンのため単純な生成確認で十分
- **1（中リスク）**: OpPropertyHelperのデバイス互換性判定 - 条件分岐が複雑なため、追加の境界値テストが有効
- **1（中リスク）**: constant_folding/cse/shape_inferenceパス - .cc未読のため実装詳細確認が必要
- **0（低リスク）**: utils系関数 - 実装が明確で根拠が十分

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（No.1-4, 23-28, 43-57, 64-69）のテスト観点は適切か
- [ ] 異常系テストケースのエラーメッセージ期待値は実装と一致しているか
- [ ] OpPropertyHelperのデバイス互換性判定で、oneDNN有効/無効の両ケースがカバーされているか
- [ ] constant_folding/cse/shape_inferenceパスの詳細テストケースを追加する必要があるか
- [ ] remapper系のパターン融合テストで、CPU/GPU両方のケースが網羅されているか
