---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート: core-util 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコード内の関数・クラス・メソッド定義が存在するか
2. **根拠との整合性**: テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**: 主要なpublic関数・メソッドがテスト対象として含まれているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.99**
  - 根拠あり: 138 / 140、根拠なし: 2
- 優先レビュー（高）
  1. **UT-CUT-086 (IsMKLEnabled)**: 実装詳細がヘッダーのみで確認困難
  2. **UT-CUT-133 (SetGraphDumper)**: カスタムダンパー設定の検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/util/activation_mode.h` - ActivationMode列挙型、GetActivationModeFromString関数宣言、ToString関数定義
- E-02: `tensorflow/core/util/activation_mode.cc` - GetActivationModeFromString関数実装
- E-03: `tensorflow/core/util/bad_indices_policy.h` - BadIndicesPolicy列挙型、BadIndicesPolicyFromString関数宣言
- E-04: `tensorflow/core/util/bad_indices_policy.cc` - BadIndicesPolicyFromString関数実装
- E-05: `tensorflow/core/util/batch_util.h` - CopyElementToSlice、CopySliceToElement等の関数宣言
- E-06: `tensorflow/core/util/bcast.h` - BCast、BCastListクラス定義、ComputeBatchIndices関数定義
- E-07: `tensorflow/core/util/padding.h` - Padding列挙型、CheckValidPadding、GetPaddingFromString関数宣言
- E-08: `tensorflow/core/util/padding.cc` - パディング関数の実装
- E-09: `tensorflow/core/util/mirror_pad_mode.h` - MirrorPadMode列挙型、GetNodeAttr関数宣言
- E-10: `tensorflow/core/util/mirror_pad_mode.cc` - GetNodeAttr関数実装
- E-11: `tensorflow/core/util/tensor_format.h` - TensorFormat、FilterTensorFormat列挙型、各種ヘルパー関数
- E-12: `tensorflow/core/util/overflow.h` - MultiplyWithoutOverflow、AddWithoutOverflow関数定義
- E-13: `tensorflow/core/util/util.h` - MovingAverageクラス、NodeNamePrefix等の関数宣言
- E-14: `tensorflow/core/util/einsum_op_util.h` - ValidateEinsumEquation、ParseEinsumEquation関数宣言
- E-15: `tensorflow/core/util/work_sharder.h` - Shard関数、Sharderクラス、ScopedPerThreadMaxParallelismクラス定義
- E-16: `tensorflow/core/util/strided_slice_op.h` - ValidateStridedSliceOp関数、StridedSliceAssignBCastクラス定義
- E-17: `tensorflow/core/util/guarded_philox_random.h` - GuardedPhiloxRandomクラス定義
- E-18: `tensorflow/core/util/events_writer.h` - EventsWriterクラス定義
- E-19: `tensorflow/core/util/equal_graph_def.h` - EqualGraphDef、EqualNodeDef等の関数宣言
- E-20: `tensorflow/core/util/saved_tensor_slice_util.h` - EncodeTensorNameSlice、DecodeTensorNameSlice等の関数宣言
- E-21: `tensorflow/core/util/tensor_slice_set.h` - TensorSliceSetクラス定義
- E-22: `tensorflow/core/util/dump_graph.h` - DumpGraphDefToFile、DumpGraphToFile等の関数宣言

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | GetActivationModeFromString: Noneを正しく解析 | E-01, E-02 | ○ |
| C-002 | GetActivationModeFromString: Sigmoidを正しく解析 | E-01, E-02 | ○ |
| C-003 | GetActivationModeFromString: Reluを正しく解析 | E-01, E-02 | ○ |
| C-004 | GetActivationModeFromString: Relu6を正しく解析 | E-01, E-02 | ○ |
| C-005 | GetActivationModeFromString: ReluXを正しく解析 | E-01, E-02 | ○ |
| C-006 | GetActivationModeFromString: Tanhを正しく解析 | E-01, E-02 | ○ |
| C-007 | GetActivationModeFromString: BandPassを正しく解析 | E-01, E-02 | ○ |
| C-008 | GetActivationModeFromString: 無効な文字列でエラー | E-01, E-02 | ○ |
| C-009 | GetActivationModeFromString: 空文字列でエラー | E-01, E-02 | ○ |
| C-010 | ToString(ActivationMode): NONE列挙値を文字列変換 | E-01 | ○ |
| C-011 | ToString(ActivationMode): SIGMOID列挙値を文字列変換 | E-01 | ○ |
| C-012 | ToString(ActivationMode): 全列挙値の文字列変換 | E-01 | ○ |
| C-013 | BadIndicesPolicyFromString: 空文字列でkDefault | E-03, E-04 | ○ |
| C-014 | BadIndicesPolicyFromString: DEFAULTを解析 | E-03, E-04 | ○ |
| C-015 | BadIndicesPolicyFromString: ERRORを解析 | E-03, E-04 | ○ |
| C-016 | BadIndicesPolicyFromString: IGNOREを解析 | E-03, E-04 | ○ |
| C-017 | BadIndicesPolicyFromString: 無効な文字列でエラー | E-03, E-04 | ○ |
| C-018 | CopyElementToSlice: 正常コピー | E-05 | ○ |
| C-019 | CopyElementToSlice: インデックス範囲外エラー | E-05 | ○ |
| C-020 | CopyElementToSlice: インデックス0境界値 | E-05 | ○ |
| C-021 | CopySliceToElement: 正常コピー | E-05 | ○ |
| C-022 | CopySliceToElement: 負のインデックスエラー | E-05 | ○ |
| C-023 | CopyContiguousSlices: 連続スライスコピー | E-05 | ○ |
| C-024 | CopyContiguousSlices: スライス数0境界値 | E-05 | ○ |
| C-025 | MaybeMoveSliceToElement: スライス移動 | E-05 | ○ |
| C-026 | SetElementZero: ゼロ初期化 | E-05 | ○ |
| C-027 | SetElementZero: 型不一致エラー | E-05 | ○ |
| C-028 | BCast: 同じ形状でオブジェクト作成 | E-06 | ○ |
| C-029 | BCast: ブロードキャスト可能形状でオブジェクト作成 | E-06 | ○ |
| C-030 | BCast: ブロードキャスト不可形状でIsValid=false | E-06 | ○ |
| C-031 | BCast::IsValid: 有効なブロードキャストでtrue | E-06 | ○ |
| C-032 | BCast::IsBroadcastingRequired: ブロードキャスト不要でfalse | E-06 | ○ |
| C-033 | BCast::x_reshape: リシェイプ情報取得 | E-06 | ○ |
| C-034 | BCast::output_shape: 出力形状計算 | E-06 | ○ |
| C-035 | BCast::FromShape: TensorShapeからVec変換 | E-06 | ○ |
| C-036 | BCast::ToShape: VecからTensorShape変換 | E-06 | ○ |
| C-037 | ComputeBatchIndices: バッチインデックス計算 | E-06 | ○ |
| C-038 | ComputeBatchIndices: 出力バッチサイズ0で空ベクタ | E-06 | ○ |
| C-039 | GetPaddingFromString: SAMEを解析 | E-07, E-08 | ○ |
| C-040 | GetPaddingFromString: VALIDを解析 | E-07, E-08 | ○ |
| C-041 | GetPaddingFromString: EXPLICITを解析 | E-07, E-08 | ○ |
| C-042 | GetPaddingFromString: 無効なパディングでエラー | E-07, E-08 | ○ |
| C-043 | CheckValidPadding: EXPLICITで正しいパディング数 | E-07, E-08 | ○ |
| C-044 | CheckValidPadding: EXPLICITでパディング数不正エラー | E-07, E-08 | ○ |
| C-045 | CheckValidPadding: 負のパディング値エラー | E-07, E-08 | ○ |
| C-046 | CheckValidPadding: バッチ次元パディングエラー | E-07, E-08 | ○ |
| C-047 | CheckValidPadding: 非EXPLICITでpaddings非空エラー | E-07, E-08 | ○ |
| C-048 | GetPaddingAttrString: 属性文字列取得 | E-07, E-08 | ○ |
| C-049 | GetPaddingAttrStringWithExplicit: 属性文字列取得 | E-07, E-08 | ○ |
| C-050 | GetNodeAttr(MirrorPadMode): REFLECTモード解析 | E-09, E-10 | ○ |
| C-051 | GetNodeAttr(MirrorPadMode): SYMMETRICモード解析 | E-09, E-10 | ○ |
| C-052 | GetNodeAttr(MirrorPadMode): 無効なモードでエラー | E-09, E-10 | ○ |
| C-053 | GetMirrorPadModeAttrString: 属性文字列取得 | E-09, E-10 | ○ |
| C-054 | FormatFromString: NHWCフォーマット解析 | E-11 | ○ |
| C-055 | FormatFromString: NCHWフォーマット解析 | E-11 | ○ |
| C-056 | FormatFromString: NCHW_VECT_Cフォーマット解析 | E-11 | ○ |
| C-057 | FormatFromString: 無効なフォーマットでfalse | E-11 | ○ |
| C-058 | ToString(TensorFormat): FORMAT_NHWC文字列変換 | E-11 | ○ |
| C-059 | GetTensorSpatialDims: NHWCで空間次元数計算 | E-11 | ○ |
| C-060 | GetTensorSpatialDims: NCHW_VECT_Cで空間次元数計算 | E-11 | ○ |
| C-061 | GetTensorBatchDimIndex: NHWCでバッチ次元インデックス | E-11 | ○ |
| C-062 | GetTensorBatchDimIndex: HWNCでバッチ次元インデックス | E-11 | ○ |
| C-063 | GetTensorFeatureDimIndex: NHWCで特徴次元インデックス | E-11 | ○ |
| C-064 | GetTensorFeatureDimIndex: NCHWで特徴次元インデックス | E-11 | ○ |
| C-065 | GetTensorSpatialDimIndex: 空間次元インデックス計算 | E-11 | ○ |
| C-066 | ShapeFromFormat: NHWCフォーマットで形状作成 | E-11 | ○ |
| C-067 | ShapeFromFormat: NCHWフォーマットで形状作成 | E-11 | ○ |
| C-068 | MultiplyWithoutOverflow: 正の数同士の乗算 | E-12 | ○ |
| C-069 | MultiplyWithoutOverflow: 一方が0で0 | E-12 | ○ |
| C-070 | MultiplyWithoutOverflow: 負の引数で-1 | E-12 | ○ |
| C-071 | MultiplyWithoutOverflow: オーバーフロー検出 | E-12 | ○ |
| C-072 | MultiplyWithoutOverflow: INT64_MAXギリギリで成功 | E-12 | ○ |
| C-073 | AddWithoutOverflow: 正の数同士の加算 | E-12 | ○ |
| C-074 | AddWithoutOverflow: 負の引数で-1 | E-12 | ○ |
| C-075 | AddWithoutOverflow: オーバーフロー検出 | E-12 | ○ |
| C-076 | NodeNamePrefix: スラッシュを含む名前で先頭部分 | E-13 | ○ |
| C-077 | NodeNamePrefix: スラッシュを含まない名前で空文字列 | E-13 | ○ |
| C-078 | NodeNameFullPrefix: 複数スラッシュで最後まで | E-13 | ○ |
| C-079 | MovingAverage: constructor | E-13 | ○ |
| C-080 | MovingAverage::AddValue: 値追加 | E-13 | ○ |
| C-081 | MovingAverage::GetAverage: 平均値計算 | E-13 | ○ |
| C-082 | MovingAverage::Clear: クリア機能 | E-13 | ○ |
| C-083 | MovingAverage::GetAverage: ウィンドウ動作 | E-13 | ○ |
| C-084 | PrintMemory: メモリ内容16進数出力 | E-13 | ○ |
| C-085 | SliceDebugString: テンソルインデックス文字列生成 | E-13 | ○ |
| C-086 | IsMKLEnabled: MKL有効状態確認 | **根拠不足** | △ |
| C-087 | ValidateEinsumEquation: 有効なeinsum式検証 | E-14 | ○ |
| C-088 | ValidateEinsumEquation: 無効なeinsum式でエラー | E-14 | ○ |
| C-089 | ParseEinsumEquation: einsum式パース | E-14 | ○ |
| C-090 | ParseEinsumEquation: 省略記号を含むeinsum式 | E-14 | ○ |
| C-091 | Shard: 作業分割実行 | E-15 | ○ |
| C-092 | Shard: total=0で作業なし | E-15 | ○ |
| C-093 | Shard: max_parallelism=1で直列実行 | E-15 | ○ |
| C-094 | SetPerThreadMaxParallelism: 並列度設定 | E-15 | ○ |
| C-095 | GetPerThreadMaxParallelism: 並列度取得 | E-15 | ○ |
| C-096 | ScopedPerThreadMaxParallelism: スコープ管理 | E-15 | ○ |
| C-097 | ValidateStridedSliceOp: 有効なストライドスライス検証 | E-16 | ○ |
| C-098 | ValidateStridedSliceOp: ランク不明でエラー | E-16 | ○ |
| C-099 | StridedSliceAssignBCast: constructor | E-16 | ○ |
| C-100 | StridedSliceAssignBCast::IsValid: 状態確認 | E-16 | ○ |
| C-101 | StridedSliceAssignBCast::RemapDimensions: 次元リマップ | E-16 | ○ |
| C-102 | GuardedPhiloxRandom::Init: シード初期化 | E-17 | ○ |
| C-103 | GuardedPhiloxRandom::ReserveSamples128: サンプル予約 | E-17 | ○ |
| C-104 | GuardedPhiloxRandom::ReserveSamples32: サンプル予約 | E-17 | ○ |
| C-105 | GuardedPhiloxRandom::ReserveRandomOutputs: 出力予約 | E-17 | ○ |
| C-106 | EventsWriter: constructor | E-18 | ○ |
| C-107 | EventsWriter::Init: ファイル初期化 | E-18 | ○ |
| C-108 | EventsWriter::FileName: ファイル名取得 | E-18 | ○ |
| C-109 | EventsWriter::WriteEvent: イベント書き込み | E-18 | ○ |
| C-110 | EventsWriter::WriteSerializedEvent: シリアライズイベント書き込み | E-18 | ○ |
| C-111 | EventsWriter::Flush: バッファフラッシュ | E-18 | ○ |
| C-112 | EventsWriter::Close: ファイルクローズ | E-18 | ○ |
| C-113 | EqualGraphDef: 同一GraphDefでtrue | E-19 | ○ |
| C-114 | EqualGraphDef: ノード順序異なっても同一でtrue | E-19 | ○ |
| C-115 | EqualGraphDef: 異なるGraphDefでfalse | E-19 | ○ |
| C-116 | EqualNodeDef: 同一NodeDefでtrue | E-19 | ○ |
| C-117 | GraphDefHash: 同一GraphDefで同じハッシュ | E-19 | ○ |
| C-118 | NodeDefHash: 同一NodeDefで同じハッシュ | E-19 | ○ |
| C-119 | EncodeTensorNameSlice: エンコード | E-20 | ○ |
| C-120 | DecodeTensorNameSlice: デコード | E-20 | ○ |
| C-121 | DecodeTensorNameSlice: 無効な文字列でエラー | E-20 | ○ |
| C-122 | ParseShapeAndSlice: パース | E-20 | ○ |
| C-123 | ParseShapeAndSlice: 無効な文字列でエラー | E-20 | ○ |
| C-124 | TensorSliceSet: constructor | E-21 | ○ |
| C-125 | TensorSliceSet::Register: スライス登録 | E-21 | ○ |
| C-126 | TensorSliceSet::Register: 重複スライスエラー | E-21 | ○ |
| C-127 | TensorSliceSet::QueryMeta: 登録済みスライスでtrue | E-21 | ○ |
| C-128 | TensorSliceSet::QueryMeta: 未登録スライスでfalse | E-21 | ○ |
| C-129 | RegisterTensorSlice: テンソルスライス登録 | E-21 | ○ |
| C-130 | DumpGraphDefToFile: GraphDefファイル保存 | E-22 | ○ |
| C-131 | DumpGraphToFile: Graphファイル保存 | E-22 | ○ |
| C-132 | DumpFunctionDefToFile: FunctionDefファイル保存 | E-22 | ○ |
| C-133 | SetGraphDumper: カスタムダンパー設定 | **根拠不足** | △ |
| C-134 | FilterFormatFromString: HWIOフォーマット解析 | E-11 | ○ |
| C-135 | FilterFormatFromString: OIHWフォーマット解析 | E-11 | ○ |
| C-136 | GetFilterTensorSpatialDims: 空間次元数計算 | E-11 | ○ |
| C-137 | GetFilterTensorInputChannelsDimIndex: インデックス計算 | E-11 | ○ |
| C-138 | GetFilterTensorOutputChannelsDimIndex: インデックス計算 | E-11 | ○ |
| C-139 | ShapeFromFilterTensorFormat: フィルタ形状作成 | E-11 | ○ |
| C-140 | ShapeFromFormat: フォーマット変換 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CUT-086 (IsMKLEnabled)**: 実装はutil.ccにあると推測されるが、ヘッダーファイルのみ確認。実際の戻り値の条件が環境依存のため詳細な検証が困難
  - 候補: tensorflow/core/util/util.cc / 環境変数による動的判定 / ビルド設定
- **UT-CUT-133 (SetGraphDumper)**: カスタムダンパーの設定とその効果の検証には、dump_graph.ccの実装確認が必要
  - 候補: tensorflow/core/util/dump_graph.cc / グローバル変数によるダンパー保持

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース - ソースコード内に明確な関数定義が存在し、入出力の期待値が明確
- **1 (中リスク)**: 環境依存テスト (IsMKLEnabled等) - 実行環境によって結果が異なる可能性
- **1 (中リスク)**: ファイルI/O関連テスト (EventsWriter, DumpGraph等) - ファイルシステムの状態に依存

## 6) レビュアーチェックリスト（最小）
- [ ] UT-CUT-086 (IsMKLEnabled): 実際のテスト実装時に環境依存性を考慮しているか確認
- [ ] UT-CUT-133 (SetGraphDumper): カスタムダンパー設定後のダンプ動作を検証する方法を確認
- [ ] オーバーフロー関連テスト (UT-CUT-068〜075): 境界値の計算が正確か確認
- [ ] BCast関連テスト (UT-CUT-028〜038): ブロードキャストルールがnumpyと一致しているか確認
- [ ] イベントライター関連テスト (UT-CUT-106〜112): ファイル操作の後処理（クリーンアップ）が含まれているか確認
