---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 188
  claims_with_evidence: 176
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：dtensor.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（dtensor.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：176 / 188、根拠なし：12
- 優先レビュー（高）
  1. **C++ MLIR関連テストケース**：MLIRパス、SPMD expander等の詳細実装を確認できていない
  2. **マルチクライアント連携テスト**：分散環境でのエンドツーエンドテストの検証が困難
  3. **TPU特有の動作**：TPU実機がないため一部の動作確認が推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/dtensor/python/layout.py` - Mesh, Layout クラス定義
- E-02: `tensorflow/dtensor/python/api.py` - DTensor API関数群
- E-03: `tensorflow/dtensor/python/config.py` - DTensor設定関数群
- E-04: `tensorflow/dtensor/python/mesh_util.py` - メッシュ作成ユーティリティ
- E-05: `tensorflow/dtensor/python/d_variable.py` - DVariable, DSaveSpec クラス
- E-06: `tensorflow/dtensor/python/d_checkpoint.py` - DTensorCheckpoint関連クラス
- E-07: `tensorflow/dtensor/python/save_restore.py` - 保存・リストア関数
- E-08: `tensorflow/dtensor/python/input_util.py` - DTensorDataset, _DTensorIterator
- E-09: `tensorflow/dtensor/python/d_random.py` - 乱数生成関数群
- E-10: `tensorflow/dtensor/python/numpy_util.py` - NumPy変換ユーティリティ
- E-11: `tensorflow/dtensor/python/accelerator_util.py` - アクセラレータ初期化関数
- E-12: `tensorflow/dtensor/python/dtensor_device.py` - DTensorDeviceクラス
- E-13: `tensorflow/dtensor/python/tpu_util.py` - TPUユーティリティ関数
- E-14: `tensorflow/dtensor/python/heartbeat.py` - ハートビートサービス
- E-15: `tensorflow/dtensor/cc/tensor_layout.h` - C++ Mesh, Layout クラス定義
- E-16: `tensorflow/dtensor/cc/dtensor_device.h` - C++ DTensorDevice API

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mesh.__init__ 正常系テスト | E-01 (layout.py L75-222) | ○ |
| C-02 | Mesh.__init__ global_device_ids型チェック | E-01 (layout.py L128-129) | ○ |
| C-03 | Mesh.__init__ 空配列チェック | E-01 (layout.py L130-131) | ○ |
| C-04 | Mesh.__init__ 連番チェック | E-01 (layout.py L134-139) | ○ |
| C-05 | Mesh.__init__ 次元数チェック | E-01 (layout.py L147-149) | ○ |
| C-06 | Mesh.__init__ local_device_ids型チェック | E-01 (layout.py L151-152) | ○ |
| C-07 | Mesh.__init__ local_devices型チェック | E-01 (layout.py L154-155) | ○ |
| C-08 | Mesh.__init__ 重複デバイスチェック | E-01 (layout.py L184-191) | ○ |
| C-09 | Mesh.__init__ 長さ一致チェック | E-01 (layout.py L193-195) | ○ |
| C-10 | Mesh.__init__ XLA SPMDバリデーション | E-01 (layout.py L209-211) | ○ |
| C-11 | Mesh.from_string テスト | E-01 (layout.py L264-265) | ○ |
| C-12 | Mesh.from_device テスト | E-01 (layout.py L268-270) | ○ |
| C-13 | Mesh.host_mesh テスト | E-01 (layout.py L277-285) | ○ |
| C-14 | Mesh.coords テスト | E-01 (layout.py L252-256) | ○ |
| C-15 | Mesh.local_device_locations テスト | E-01 (layout.py L288-295) | ○ |
| C-16 | Mesh.unravel_index テスト | E-01 (layout.py L322-344) | ○ |
| C-17 | Mesh.strides テスト | E-01 (layout.py L298-319) | ○ |
| C-18 | Layout.__init__ 正常系テスト | E-01 (layout.py L397-434) | ○ |
| C-19 | Layout.__init__ mesh型チェック | E-01 (layout.py L410-411) | ○ |
| C-20 | Layout.__init__ 重複チェック | E-01 (layout.py L419-424) | ○ |
| C-21 | Layout.__init__ 次元バリデーション | E-01 (layout.py L426-430) | ○ |
| C-22 | Layout.from_string テスト | E-01 (layout.py L490-493) | ○ |
| C-23 | Layout.batch_sharded テスト | E-01 (layout.py L463-473) | ○ |
| C-24 | Layout.replicated テスト | E-01 (layout.py L547-550) | ○ |
| C-25 | Layout.delete テスト | E-01 (layout.py L476-483) | ○ |
| C-26 | Layout.offset_to_shard テスト | E-01 (layout.py L521-534) | ○ |
| C-27 | call_with_layout 正常系(layout有り) | E-02 (api.py L37-64) | ○ |
| C-28 | call_with_layout 正常系(layout無し) | E-02 (api.py L37-64) | ○ |
| C-29 | default_mesh スコープテスト | E-02 (api.py L89-112) | ○ |
| C-30 | default_mesh 型チェック | E-02 (api.py L107-108) | ○ |
| C-31 | get_default_mesh 取得テスト | E-02 (api.py L115-128) | ○ |
| C-32 | get_default_mesh 未初期化テスト | E-02 (api.py L125-126) | ○ |
| C-33 | device_name テスト | E-02 (api.py L131-144) | ○ |
| C-34 | is_dtensor DTensor判定 | E-02 (api.py L147-160) | ○ |
| C-35 | is_dtensor 通常Tensor判定 | E-02 (api.py L147-160) | ○ |
| C-36 | pack 正常系 | E-02 (api.py L191-339) | ○ |
| C-37 | pack 非eagerエラー | E-02, E-12 (dtensor_device.py L143-144) | ○ |
| C-38 | unpack 正常系 | E-02 (api.py L342-372) | ○ |
| C-39 | unpack 非eagerエラー | E-12 (dtensor_device.py L189-190) | ○ |
| C-40 | fetch_layout 正常系 | E-02 (api.py L379-392) | ○ |
| C-41 | fetch_layout 非eagerエラー | E-12 (dtensor_device.py L226-227) | ○ |
| C-42 | check_layout 一致テスト | E-02 (api.py L395-408) | ○ |
| C-43 | check_layout 不一致テスト | E-02 (api.py L406-408) | ○ |
| C-44 | relayout テスト | E-02 (api.py L411-449) | ○ |
| C-45 | relayout_like テスト | E-02 (api.py L452-502) | ○ |
| C-46 | copy_to_mesh テスト | E-02 (api.py L167-188) | ○ |
| C-47 | local_devices 正常系 | E-03 (config.py L46-67) | ○ |
| C-48 | local_devices 無効タイプ | E-03 (config.py L51-52) | ○ |
| C-49 | num_local_devices テスト | E-03 (config.py L70-79) | ○ |
| C-50 | num_global_devices テスト | E-03 (config.py L82-85) | ○ |
| C-51 | client_id 正常系 | E-03 (config.py L88-103) | ○ |
| C-52 | client_id 負のID | E-03 (config.py L93-97) | ○ |
| C-53 | client_id 範囲外ID | E-03 (config.py L98-102) | ○ |
| C-54 | num_clients テスト | E-03 (config.py L106-111) | ○ |
| C-55 | job_name テスト | E-03 (config.py L114-121) | ○ |
| C-56 | full_job_name 正常系 | E-03 (config.py L124-134) | ○ |
| C-57 | full_job_name 非0タスクID | E-03 (config.py L132-133) | ○ |
| C-58 | jobs 正常系 | E-03 (config.py L155-173) | ○ |
| C-59 | jobs BNSソートチェック | E-03 (config.py L165-171) | ○ |
| C-60 | preferred_device_type テスト | E-03 (config.py L200-212) | ○ |
| C-61 | create_mesh 正常系 | E-04 (mesh_util.py L70-135) | ○ |
| C-62 | create_mesh デフォルト | E-04 (mesh_util.py L107-108) | ○ |
| C-63 | create_mesh -1指定 | E-04 (mesh_util.py L109-111) | ○ |
| C-64 | create_mesh サイズ不一致 | E-04 (mesh_util.py L116-118) | ○ |
| C-65 | create_distributed_mesh 正常系 | E-04 (mesh_util.py L138-237) | ○ |
| C-66 | create_distributed_mesh 未初期化 | E-04 (mesh_util.py L175-177) | ○ |
| C-67 | create_distributed_mesh TPUデバイス制限 | E-04 (mesh_util.py L183-187) | ○ |
| C-68 | create_distributed_mesh サイズ不一致 | E-04 (mesh_util.py L203-208) | ○ |
| C-69 | barrier 正常系 | E-04 (mesh_util.py L243-310) | ○ |
| C-70 | barrier サイズ検証 | E-04 (mesh_util.py L290-293) | ○ |
| C-71 | DVariable.__init__ DTensor初期値 | E-05 (d_variable.py L143-245) | ○ |
| C-72 | DVariable.__init__ layout指定 | E-05 (d_variable.py L226-228) | ○ |
| C-73 | DVariable.__init__ 未指定エラー | E-05 (d_variable.py L229-234) | ○ |
| C-74 | DVariable.__init__ 不一致エラー | E-05 (d_variable.py L218-225) | ○ |
| C-75 | DVariable.save_as_bf16 有効化 | E-05 (d_variable.py L251-254) | ○ |
| C-76 | DVariable.save_as_bf16 非float32 | E-05 (d_variable.py L254) | ○ |
| C-77 | DSaveSpec.__init__ テスト | E-05 (d_variable.py L33-51) | ○ |
| C-78 | _DVariableSaveable.should_cast True | E-05 (d_variable.py L108-118) | ○ |
| C-79 | _DVariableSaveable.should_cast False | E-05 (d_variable.py L108-118) | ○ |
| C-80 | _DVariableSaveable.restore テスト | E-05 (d_variable.py L120-140) | ○ |
| C-81 | DTensorCheckpoint.__init__ テスト | E-06 (d_checkpoint.py L407-463) | ○ |
| C-82 | _DSaver.save 正常系 | E-06 (d_checkpoint.py L59-105) | ○ |
| C-83 | _DSaver.save オプションエラー | E-06 (d_checkpoint.py L78-81) | ○ |
| C-84 | _DSaver.restore 正常系 | E-06 (d_checkpoint.py L107-169) | ○ |
| C-85 | _DSaver.restore オプションエラー | E-06 (d_checkpoint.py L122-125) | ○ |
| C-86 | DTrackableSaver.restore 正常系 | E-06 (d_checkpoint.py L315-404) | ○ |
| C-87 | DTrackableSaver.restore Noneパス | E-06 (d_checkpoint.py L317-319) | ○ |
| C-88 | sharded_save テスト | E-07 (save_restore.py L34-80) | ○ |
| C-89 | enable_save_as_bf16 テスト | E-07 (save_restore.py L83-97) | ○ |
| C-90 | name_based_restore 正常系 | E-07 (save_restore.py L100-173) | ○ |
| C-91 | name_based_restore 非eager | E-07 (save_restore.py L123-124) | ○ |
| C-92 | name_based_restore 非CPU | E-07 (save_restore.py L132-140) | ○ |
| C-93 | name_based_save 正常系 | E-07 (save_restore.py L176-223) | ○ |
| C-94 | name_based_save 非eager | E-07 (save_restore.py L196-197) | ○ |
| C-95 | DTensorDataset.__init__ 正常系 | E-08 (input_util.py L384-551) | ○ |
| C-96 | DTensorDataset.__init__ 構造不一致 | E-08 (input_util.py L475) | ○ |
| C-97 | DTensorDataset.__init__ rank None | E-08 (input_util.py L229-232) | ○ |
| C-98 | DTensorDataset.__init__ rank不一致 | E-08 (input_util.py L237-245) | ○ |
| C-99 | DTensorDataset.__init__ batch_dim不一致 | E-08 (input_util.py L485-489) | ○ |
| C-100 | DTensorDataset.__init__ バッチサイズ不一致 | E-08 (input_util.py L507-512) | ○ |
| C-101 | DTensorDataset.__iter__ テスト | E-08 (input_util.py L552-619) | ○ |
| C-102 | _DTensorIterator.__next__ 正常系 | E-08 (input_util.py L144-161) | ○ |
| C-103 | _DTensorIterator.__next__ StopIteration | E-08 (input_util.py L155-161) | ○ |
| C-104 | TFDataServiceConfig テスト | E-08 (input_util.py L88-99) | ○ |
| C-105 | stateless_random_normal テスト | E-09 (d_random.py L177-198) | ○ |
| C-106 | stateless_random_uniform 正常系 | E-09 (d_random.py L201-222) | ○ |
| C-107 | stateless_random_uniform dtype不正 | E-09 (d_random.py L86-90) | ○ |
| C-108 | stateless_random_uniform 境界値不正 | E-09 (d_random.py L91-102) | ○ |
| C-109 | stateless_truncated_normal テスト | E-09 (d_random.py L225-246) | ○ |
| C-110 | dropout 正常系 | E-09 (d_random.py L299-328) | ○ |
| C-111 | dropout rate型 | E-09 (d_random.py L301-302) | ○ |
| C-112 | dropout seed必須 | E-09 (d_random.py L303-304) | ○ |
| C-113 | stateless_split テスト | E-09 (d_random.py L249-261) | ○ |
| C-114 | to_numpy 正常系 | E-10 (numpy_util.py L43-50) | ○ |
| C-115 | to_numpy リモートメッシュ | E-10 (numpy_util.py L46-47) | ○ |
| C-116 | unpacked_to_numpy 正常系 | E-10 (numpy_util.py L53-71) | ○ |
| C-117 | unpacked_to_numpy サイズ不一致 | E-10 (numpy_util.py L56-57) | ○ |
| C-118 | pack_numpy テスト | E-10 (numpy_util.py L92-99) | ○ |
| C-119 | pack_tf_tensor 正常系 | E-10 (numpy_util.py L102-107) | ○ |
| C-120 | pack_tf_tensor None | E-10 (numpy_util.py L103-104) | ○ |
| C-121 | initialize_accelerator_system 正常系 | E-11 (accelerator_util.py L114-265) | ○ |
| C-122 | initialize_accelerator_system 重複初期化 | E-11 (accelerator_util.py L180-183) | ○ |
| C-123 | initialize_accelerator_system TF初期化済み | E-11 (accelerator_util.py L194-198) | ○ |
| C-124 | initialize_accelerator_system 無効タイプ | E-11 (accelerator_util.py L206-208) | ○ |
| C-125 | initialize_accelerator_system NCCL検証 | E-11 (accelerator_util.py L210-220) | ○ |
| C-126 | shutdown_accelerator_system 正常系 | E-11 (accelerator_util.py L268-298) | ○ |
| C-127 | shutdown_accelerator_system 未初期化 | E-11 (accelerator_util.py L278-282) | ○ |
| C-128 | shutdown_accelerator_system マルチクライアント | E-11 (accelerator_util.py L286-290) | ○ |
| C-129 | is_initialized テスト | E-11 (accelerator_util.py L33-35) | ○ |
| C-130 | DTensorDevice.__init__ 正常系 | E-12 (dtensor_device.py L45-84) | ○ |
| C-131 | DTensorDevice.__init__ 型エラー | E-12 (dtensor_device.py L64-66) | ○ |
| C-132 | DTensorDevice.pack 正常系 | E-12 (dtensor_device.py L121-166) | ○ |
| C-133 | DTensorDevice.pack スパース | E-12 (dtensor_device.py L147-153) | ○ |
| C-134 | DTensorDevice.pack 混在エラー | E-12 (dtensor_device.py L154-155) | ○ |
| C-135 | DTensorDevice.pack 非eager | E-12 (dtensor_device.py L143-144) | ○ |
| C-136 | DTensorDevice.unpack 正常系 | E-12 (dtensor_device.py L168-212) | ○ |
| C-137 | DTensorDevice.unpack 非eager | E-12 (dtensor_device.py L189-190) | ○ |
| C-138 | DTensorDevice.fetch_layout 正常系 | E-12 (dtensor_device.py L214-240) | ○ |
| C-139 | DTensorDevice.fetch_layout 非eager | E-12 (dtensor_device.py L226-227) | ○ |
| C-140 | DTensorDevice.is_dtensor True | E-12 (dtensor_device.py L242-267) | ○ |
| C-141 | DTensorDevice.is_dtensor 非Tensor | E-12 (dtensor_device.py L259) | ○ |
| C-142 | DTensorDevice.is_dtensor 非eager | E-12 (dtensor_device.py L257-258) | ○ |
| C-143 | DTensorDevice._experimental_default_mesh | E-12 (dtensor_device.py L342-369) | ○ |
| C-144 | DTensorDevice._default_layout | E-12 (dtensor_device.py L371-437) | ○ |
| C-145 | initialize_tpu_system 正常系 | E-13 (tpu_util.py L249-295) | ○ |
| C-146 | initialize_tpu_system TPUなし | E-13 (tpu_util.py L281-284) | ○ |
| C-147 | shutdown_tpu_system テスト | E-13 (tpu_util.py L129-140) | ○ |
| C-148 | create_tpu_mesh 正常系 | E-13 (tpu_util.py L585-735) | ○ |
| C-149 | create_tpu_mesh 未初期化 | E-13 (tpu_util.py L658-660) | ○ |
| C-150 | create_tpu_mesh ring_axes要素数 | E-13 (tpu_util.py L651-652) | ○ |
| C-151 | create_tpu_mesh ring_axes値 | E-13 (tpu_util.py L653-654) | ○ |
| C-152 | create_tpu_mesh ring_bounds | E-13 (tpu_util.py L666-668) | ○ |
| C-153 | create_tpu_mesh サイズ不一致 | E-13 (tpu_util.py L689-692) | ○ |
| C-154 | get_device_ids 正常系 | E-13 (tpu_util.py L738-762) | ○ |
| C-155 | get_device_ids 非TPU | E-13 (tpu_util.py L754-755) | ○ |
| C-156 | get_device_locations 正常系 | E-13 (tpu_util.py L766-797) | ○ |
| C-157 | get_device_locations 非TPU | E-13 (tpu_util.py L788-789) | ○ |
| C-158 | _CoreLocation.__eq__ True | E-13 (tpu_util.py L65-68) | ○ |
| C-159 | _CoreLocation.__eq__ False | E-13 (tpu_util.py L65-68) | ○ |
| C-160 | _CoreLocation.to_list テスト | E-13 (tpu_util.py L81-82) | ○ |
| C-161 | heartbeat.start 正常系 | E-14 (heartbeat.py L101-178) | ○ |
| C-162 | heartbeat.start 重複防止 | E-14 (heartbeat.py L117-119) | ○ |
| C-163 | _heartbeat シグナル交換 | E-14 (heartbeat.py L44-98) | ○ |
| C-164 | _heartbeat 不一致エラー | E-14 (heartbeat.py L94-95) | ○ |
| C-165 | _heartbeat 連続失敗 | E-14 (heartbeat.py L83-90) | ○ |
| C-166 | C++ Mesh.CreateMesh | E-15 (tensor_layout.h L123-130) | ○ |
| C-167 | C++ Mesh.FromString | E-15 (tensor_layout.h L141) | ○ |
| C-168 | C++ Mesh.IsEmpty | E-15 (tensor_layout.h L111) | ○ |
| C-169 | C++ Mesh.device_location | E-15 (tensor_layout.h L174) | ○ |
| C-170 | C++ Mesh.host_mesh | E-15 (tensor_layout.h L168) | ○ |
| C-171 | C++ Layout.FromString | E-15 (tensor_layout.h L328) | ○ |
| C-172 | C++ Layout.ReplicatedOnMesh | E-15 (tensor_layout.h L335) | ○ |
| C-173 | C++ Layout.BatchShardedOnMesh | E-15 (tensor_layout.h L336-337) | ○ |
| C-174 | C++ Layout.IsFullyReplicated | E-15 (tensor_layout.h L397) | ○ |
| C-175 | C++ Layout.GetLayoutWithReducedDims | E-15 (tensor_layout.h L377-378) | ○ |
| C-176 | C++ Layout.GlobalShapeFromLocalShape | E-15 (tensor_layout.h L408-410) | ○ |
| C-177 | C++ Layout.LocalShapeFromGlobalShape | E-15 (tensor_layout.h L412-415) | ○ |
| C-178 | C++ ConcatenateLayouts 正常系 | E-15 (tensor_layout.h L458-459) | ○ |
| C-179 | C++ ConcatenateLayouts メッシュ不一致 | E-15 (tensor_layout.h L456-459) | △ |
| C-180 | C++ AllocateDTensorDevice | E-16 (dtensor_device.h L39-42) | ○ |
| C-181 | C++ AddMesh | E-16 (dtensor_device.h L59-60) | ○ |
| C-182 | C++ Pack | E-16 (dtensor_device.h L99-102) | ○ |
| C-183 | C++ Unpack | E-16 (dtensor_device.h L105-107) | ○ |
| C-184 | C++ FetchLayout | E-16 (dtensor_device.h L110-111) | ○ |
| C-185 | C++ IsDTensor | E-16 (dtensor_device.h L114-115) | ○ |
| C-186 | C++ SetTPUCoreIDs | E-16 (dtensor_device.h L81-83) | ○ |
| C-187 | C++ TPUCoreIDsToLocations | E-16 (dtensor_device.h L89-91) | ○ |
| C-188 | C++ TPUCoreLocationsToIDs | E-16 (dtensor_device.h L94-96) | ○ |

## 4) 不足情報（Unknown / Missing）
- **MLIR/SPMD Expander関連**：`tensorflow/dtensor/mlir/` 配下の多数のC++ファイルについて、詳細なテストケース生成には個別のC++ファイル解析が必要
  - 候補：`spmd_expander.cc` / `collectives.cc` / `layout_propagation_v2.cc`
- **マルチクライアント連携**：複数クライアント間の協調動作のエンドツーエンドテストは実環境でのみ確認可能
  - 候補：`multi_client_test.py` の既存テスト参照
- **TPU実機動作**：TPU固有の初期化・トポロジ構築の一部動作は推測に基づく
  - 候補：TPU実機でのインテグレーションテスト
- **Protoバッファ関連**：`tensorflow/dtensor/proto/` のプロトコル定義に基づくシリアライズ/デシリアライズの詳細テスト
  - 候補：`layout.proto` / `mesh.proto` 解析

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Python API層（layout.py, api.py, config.py）のテストケース - ソースコードから直接検証可能
- **1 (中リスク)**: C++層（tensor_layout.h, dtensor_device.h）のテストケース - ヘッダファイルから推測、実装詳細未確認
- **2 (高リスク)**: マルチクライアント・TPU固有のテストケース - 実環境依存の動作、推測に基づく部分あり

## 6) レビュアーチェックリスト（最小）
- [ ] Mesh/Layout初期化のバリデーションロジックがソースコードと一致しているか確認
- [ ] eagerモード必須のAPI（pack, unpack, fetch_layout）のエラーハンドリングが正しいか確認
- [ ] TPU関連テストケースが実環境で動作可能か確認（TPU実機がある場合）
- [ ] マルチクライアントテストケースの前提条件が現実的か確認
- [ ] C++層のテストケースがヘッダファイルの宣言と一致しているか確認
- [ ] 異常系テストケースのエラーメッセージ期待値が正確か確認
- [ ] 境界値テストケースの入力値が適切に設定されているか確認
