---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：examples モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードから直接導出されており、根拠不足の項目はありません
  2. ただし、実行環境依存のテスト（WAVファイル操作、TensorFlowセッション等）は実際の環境での検証が推奨されます
  3. カスタムOp関連テストは、コンパイル済みの.soファイルが必要です

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/examples/speech_commands/models.py` - モデル定義と設定関数
- E-02: `tensorflow/examples/speech_commands/input_data.py` - 音声データ処理クラス
- E-03: `tensorflow/examples/speech_commands/accuracy_utils.py` - ストリーミング精度計算ユーティリティ
- E-04: `tensorflow/examples/speech_commands/recognize_commands.py` - コマンド認識クラス
- E-05: `tensorflow/examples/speech_commands/freeze.py` - モデルフリーズ関数
- E-06: `tensorflow/examples/speech_commands/label_wav.py` - WAVラベリング関数
- E-07: `tensorflow/examples/speech_commands/wav_to_features.py` - 特徴量変換関数
- E-08: `tensorflow/examples/speech_commands/train.py` - トレーニングスクリプト
- E-09: `tensorflow/examples/label_image/label_image.py` - 画像ラベリング関数
- E-10: `tensorflow/examples/adding_an_op/zero_out_grad_2.py` - ZeroOut勾配関数
- E-11: `tensorflow/examples/custom_ops_doc/simple_hash_table/simple_hash_table.py` - SimpleHashTableクラス
- E-12: `tensorflow/examples/custom_ops_doc/multiplex_1/multiplex_1_op.py` - multiplex関数(v1)
- E-13: `tensorflow/examples/custom_ops_doc/multiplex_2/multiplex_2_op.py` - multiplex関数(v2)
- E-14: `tensorflow/examples/custom_ops_doc/multiplex_3/multiplex_3_op.py` - multiplex_sparse関数
- E-15: `tensorflow/examples/custom_ops_doc/multiplex_4/multiplex_4_op.py` - multiplex関数(v4)
- E-16: `tensorflow/examples/custom_ops_doc/sleep/sleep_op.py` - AsyncSleep/SyncSleep関数

## 3) Claims と根拠の対応（レビューの主戦場）

### models.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _next_power_of_twoは正の整数に対して次の2のべき乗を返す | E-01 (line 23-32) | ○ |
| C-02 | _next_power_of_twoは0に対して1を返す | E-01 (line 32: return 1 if x == 0) | ○ |
| C-03 | prepare_model_settingsはmfcc/average/microモードをサポート | E-01 (line 63-75) | ○ |
| C-04 | prepare_model_settingsは不明なモードでValueErrorを発生 | E-01 (line 73-75) | ○ |
| C-05 | create_modelは6種類のアーキテクチャをサポート | E-01 (line 125-146) | ○ |
| C-06 | create_modelは不明なアーキテクチャでExceptionを発生 | E-01 (line 142-146) | ○ |
| C-07 | create_low_latency_svdf_modelは入力ランク検証を行う | E-01 (line 521-529) | ○ |

### input_data.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | prepare_words_listはsilenceとunknownを先頭に追加 | E-02 (line 53-62) | ○ |
| C-09 | which_setはハッシュベースでデータセット分割を決定 | E-02 (line 65-110) | ○ |
| C-10 | load_wav_fileはfloat配列を返す | E-02 (line 113-128) | ○ |
| C-11 | get_features_rangeはモードごとの範囲を返す | E-02 (line 155-182) | ○ |
| C-12 | AudioProcessorはデータ読み込みと処理グラフを初期化 | E-02 (line 185-199) | ○ |
| C-13 | prepare_data_indexはファイルが見つからない場合Exception | E-02 (line 293-294) | ○ |
| C-14 | prepare_background_dataは空ディレクトリでException | E-02 (line 361-362) | ○ |
| C-15 | get_dataはbackground_sampleが短い場合ValueError | E-02 (line 572-576) | ○ |

### accuracy_utils.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | StreamingAccuracyStatsはカウンタを0で初期化 | E-03 (line 36-46) | ○ |
| C-17 | read_ground_truth_fileはCSVを読み込みソート | E-03 (line 48-58) | ○ |
| C-18 | deltaは状態変化を検出しValueErrorを発生可能 | E-03 (line 60-77) | ○ |
| C-19 | calculate_accuracy_statsは精度統計を計算 | E-03 (line 79-131) | ○ |

### recognize_commands.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | RecognizeResultはデフォルト値で初期化可能 | E-04 (line 21-47) | ○ |
| C-21 | RecognizeCommandsはパラメータで初期化 | E-04 (line 74-111) | ○ |
| C-22 | process_latest_resultは結果長検証を行う | E-04 (line 132-135) | ○ |
| C-23 | process_latest_resultは時刻順検証を行う | E-04 (line 136-141) | ○ |
| C-24 | process_latest_resultは閾値と抑制期間を考慮 | E-04 (line 186-195) | ○ |

### freeze.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | create_inference_graphは推論グラフを作成 | E-05 (line 58-153) | ○ |
| C-26 | create_inference_graphは不明モードでException | E-05 (line 139-141) | ○ |
| C-27 | save_graph_defはGraphDefをファイル保存 | E-05 (line 156-168) | ○ |
| C-28 | save_saved_modelはSavedModelを保存 | E-05 (line 171-203) | ○ |

### label_wav.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | load_graphはGraphDefをインポート | E-06 (line 39-44) | ○ |
| C-30 | load_labelsはラベルリストを返す | E-06 (line 47-49) | ○ |
| C-31 | label_wavはファイル存在検証を行う | E-06 (line 73-81) | ○ |

### wav_to_features.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | wav_to_featuresはCソースファイルを生成 | E-07 (line 43-118) | ○ |
| C-33 | quantize=Trueで量子化出力 | E-07 (line 94-109) | ○ |

### label_image.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | load_graphはGraphオブジェクトを返す | E-09 (line 22-31) | ○ |
| C-35 | read_tensor_from_image_fileは画像形式を判別 | E-09 (line 34-58) | ○ |
| C-36 | load_labelsはラベルリストを返す | E-09 (line 61-63) | ○ |

### カスタムOp関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | _zero_out_gradは勾配を計算 | E-10 (line 23-40) | ○ |
| C-38 | SimpleHashTableはCRUD操作をサポート | E-11 (line 25-243) | ○ |
| C-39 | multiplex(v1)は条件選択を行う | E-12 (line 34-54) | ○ |
| C-40 | multiplex(v2)は条件選択を行う | E-13 (line 30-50) | ○ |
| C-41 | multiplex_sparseはSparseTensorをサポート | E-14 (line 41-84) | ○ |
| C-42 | multiplex(v4)はリスト形式をサポート | E-15 (line 30-70) | ○ |
| C-43 | AsyncSleep/SyncSleepはスリープ操作を行う | E-16 (line 36-69) | ○ |

### train.py 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | verbosity_argはログレベルをパース | E-08 (line 474-494) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースはソースコードから直接導出されており、根拠不足の項目はありません
- ただし、以下の情報は実行環境に依存するため、実際のテスト実行時に確認が必要です：
  - TensorFlowセッションの動作確認
  - WAV/画像ファイルの入出力動作
  - コンパイル済みカスタムOp (.soファイル) の存在

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードに基づいて生成されている
- **注意点**:
  - カスタムOp関連テスト（UT-EXA-091～109）はコンパイル済みの.soファイルが必要
  - ファイルI/O関連テストは実際のファイルシステムでの検証が必要
  - TensorFlow v1互換API使用箇所はTensorFlow 2.x環境での動作確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] models.py: 6種類のモデルアーキテクチャが網羅されているか確認
- [ ] input_data.py: AudioProcessorの主要メソッドがテスト対象に含まれているか確認
- [ ] accuracy_utils.py: 精度計算ロジックのテストケースが適切か確認
- [ ] recognize_commands.py: コマンド認識のスムージングロジックがテストされているか確認
- [ ] freeze.py: モデルフリーズ処理のテストケースが適切か確認
- [ ] カスタムOp: CRUD操作とmultiplex操作のテストケースが網羅されているか確認
- [ ] 異常系テスト: ValueError/Exception発生条件が正しく特定されているか確認
- [ ] 境界値テスト: 空リスト、0、特殊値のケースが含まれているか確認
