---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 129
  claims_with_evidence: 129
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：go.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成されたTensorFlow Goバインディングの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードに対応する関数・メソッドが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・メソッド・エラーパスをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：129 / 129、根拠なし：0
- 優先レビュー（高）
  1. **SavedModelロード関連テスト（UT-GO-089〜091）**：実行環境依存
  2. **デバイス間コピーテスト（UT-GO-098〜099）**：GPUデバイスの有無に依存
  3. **ライブラリロードテスト（UT-GO-047〜048）**：外部ファイル依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/go/tensor.go` - Tensor構造体、NewTensor、ReadTensor、Reshape、Value、WriteContentsTo、TypeOf関数
- E-02: `tensorflow/go/session.go` - Session構造体、NewSession、Run、ListDevices、Close、NewPartialRun、PartialRun、Device構造体
- E-03: `tensorflow/go/graph.go` - Graph構造体、NewGraph、WriteTo、Import、ImportWithOptions、Operation、Operations、AddOperation、AddGradients、LoadLibrary
- E-04: `tensorflow/go/operation.go` - Operation構造体、Name、Type、NumOutputs、NumInputs、Device、Output、OutputListSize、Output構造体、DataType、Shape、Consumers、Consumer構造体
- E-05: `tensorflow/go/attrs.go` - Operation.Attr、listAttribute、scalarAttribute、makeCShape
- E-06: `tensorflow/go/shape.go` - Shape構造体、ScalarShape、MakeShape、NumDimensions、Size、IsFullySpecified、ToSlice、String
- E-07: `tensorflow/go/context.go` - Context構造体、ContextOptions、NewContext、ListDevices
- E-08: `tensorflow/go/saved_model.go` - SavedModel構造体、LoadSavedModel、generateSignatures
- E-09: `tensorflow/go/tensor_handle.go` - TensorHandle構造体、NewTensorHandle、DataType、Shape、DeviceName、BackingDeviceName、ToTensor、CopyToDevice
- E-10: `tensorflow/go/signature.go` - Signature構造体、TensorInfo構造体、signatureDefFromProto、tensorInfoFromProto
- E-11: `tensorflow/go/status.go` - status構造体、newStatus、Code、String、Err、statusError
- E-12: `tensorflow/go/version.go` - Version関数
- E-13: `tensorflow/go/op/scope.go` - Scope構造体、NewScope、NewScopeWithGraph、Finalize、AddOperation、SubScope、WithControlDependencies、WithDevice、Err、UpdateErr
- E-14: `tensorflow/go/op/gradients.go` - Gradients関数
- E-15: `tensorflow/go/genop/internal/genop.go` - GenerateFunctionsForRegisteredOps、goType、camelCase、identifier

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-21 | Tensor関連テストケース（NewTensor、ReadTensor、Reshape、Value、WriteContentsTo等） | E-01 | ○ |
| C-22〜C-33 | Session関連テストケース（NewSession、Run、ListDevices、Close、PartialRun等） | E-02 | ○ |
| C-34〜C-48 | Graph関連テストケース（NewGraph、WriteTo、Import、Operation、AddOperation、AddGradients、LoadLibrary等） | E-03 | ○ |
| C-49〜C-62 | Operation・Output・Consumer関連テストケース | E-04 | ○ |
| C-63〜C-71 | Attr関連テストケース（Operation.Attr） | E-05 | ○ |
| C-72〜C-84 | Shape関連テストケース（ScalarShape、MakeShape、NumDimensions、Size、IsFullySpecified、ToSlice、String） | E-06 | ○ |
| C-85〜C-88 | Context関連テストケース（NewContext、ListDevices） | E-07 | ○ |
| C-89〜C-91 | SavedModel関連テストケース（LoadSavedModel） | E-08 | ○ |
| C-92〜C-99 | TensorHandle関連テストケース（NewTensorHandle、DataType、Shape、DeviceName、ToTensor、CopyToDevice） | E-09 | ○ |
| C-100〜C-101 | Signature関連テストケース（signatureDefFromProto、tensorInfoFromProto） | E-10 | ○ |
| C-102〜C-106 | status関連テストケース（newStatus、Code、String、Err） | E-11 | ○ |
| C-107 | Version関連テストケース | E-12 | ○ |
| C-108〜C-119 | op/Scope関連テストケース（NewScope、Finalize、AddOperation、SubScope、WithControlDependencies、WithDevice等） | E-13 | ○ |
| C-120〜C-122 | op/Gradients関連テストケース | E-14 | ○ |
| C-123〜C-129 | genop/internal関連テストケース（GenerateFunctionsForRegisteredOps、goType、camelCase、identifier） | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースはソースコード内の関数・メソッド定義に基づいて生成されています
- 外部依存（SavedModelファイル、ライブラリファイル、GPUデバイス）に関するテストは実行環境に依存します
  - 候補：モックの使用 / テスト用フィクスチャの準備 / 統合テスト環境の構築

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Version、Shape、status関連 - 単純なユーティリティ関数
- **1（中リスク）**: Graph、Operation、Scope関連 - 複雑な状態管理を含む
- **2（高リスク）**: Session.Run、SavedModel.LoadSavedModel、TensorHandle.CopyToDevice - 外部リソースや並行処理を含む

## 6) レビュアーチェックリスト（最小）
- [ ] Tensor生成・変換テスト（UT-GO-001〜021）がデータ型の網羅性を持つか確認
- [ ] Session.Runの並行実行に関するテストが十分か確認
- [ ] Graph.AddOperation/AddGradientsの異常系テストが十分か確認
- [ ] SavedModelロードのエラーハンドリングテストが実行可能か確認
- [ ] TensorHandleのデバイス間コピーテストが環境依存性を考慮しているか確認
- [ ] op/Scopeの名前空間衝突テストが十分か確認
- [ ] genop/internalのコード生成テストが出力検証を含むか確認
