---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 237
  claims_with_evidence: 237
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：java.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（java.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：237 / 237、根拠なし：0
- 優先レビュー（高）
  1. **ネイティブライブラリ依存テスト**：TensorFlowネイティブライブラリが必要なため、実行環境の構築が必要
  2. **SavedModelBundle関連テスト**：テスト用のSavedModelディレクトリの準備が必要
  3. **Server関連テスト**：分散環境構築が必要なため、単体テストとしての実行は制限あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/java/src/main/java/org/tensorflow/Graph.java`
- E-02: `tensorflow/java/src/main/java/org/tensorflow/Session.java`
- E-03: `tensorflow/java/src/main/java/org/tensorflow/Tensor.java`
- E-04: `tensorflow/java/src/main/java/org/tensorflow/TensorFlow.java`
- E-05: `tensorflow/java/src/main/java/org/tensorflow/Shape.java`
- E-06: `tensorflow/java/src/main/java/org/tensorflow/Output.java`
- E-07: `tensorflow/java/src/main/java/org/tensorflow/DataType.java`
- E-08: `tensorflow/java/src/main/java/org/tensorflow/EagerSession.java`
- E-09: `tensorflow/java/src/main/java/org/tensorflow/GraphOperationBuilder.java`
- E-10: `tensorflow/java/src/main/java/org/tensorflow/GraphOperation.java`
- E-11: `tensorflow/java/src/main/java/org/tensorflow/EagerOperationBuilder.java`
- E-12: `tensorflow/java/src/main/java/org/tensorflow/EagerOperation.java`
- E-13: `tensorflow/java/src/main/java/org/tensorflow/SavedModelBundle.java`
- E-14: `tensorflow/java/src/main/java/org/tensorflow/Server.java`
- E-15: `tensorflow/java/src/main/java/org/tensorflow/op/Scope.java`
- E-16: `tensorflow/java/src/main/java/org/tensorflow/op/NameScope.java`
- E-17: `tensorflow/java/src/main/java/org/tensorflow/op/Operands.java`
- E-18: `tensorflow/java/src/main/java/org/tensorflow/op/PrimitiveOp.java`
- E-19: `tensorflow/java/src/main/java/org/tensorflow/op/core/Constant.java`
- E-20: `tensorflow/java/src/main/java/org/tensorflow/op/core/Zeros.java`
- E-21: `tensorflow/java/src/main/java/org/tensorflow/op/core/Gradients.java`
- E-22: `tensorflow/java/src/main/java/org/tensorflow/Tensors.java`
- E-23: `tensorflow/java/src/main/java/org/tensorflow/AbstractOperation.java`
- E-24: `tensorflow/java/src/main/java/org/tensorflow/Operation.java`
- E-25: `tensorflow/java/src/main/java/org/tensorflow/OperationBuilder.java`
- E-26: `tensorflow/java/src/main/java/org/tensorflow/Operand.java`
- E-27: `tensorflow/java/src/main/java/org/tensorflow/ExecutionEnvironment.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### Graph クラス（UT-JAV-001 〜 UT-JAV-015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Graph()コンストラクタで空のGraphが生成される | E-01 L31-33 | ○ |
| C-02 | close()でリソースが解放される | E-01 L46-64 | ○ |
| C-03 | operation(String)で名前からOperationを取得できる | E-01 L71-79 | ○ |
| C-04 | operations()でIteratorを取得できる | E-01 L87-89 | ○ |
| C-05 | opBuilder()でGraphOperationBuilderを取得できる | E-01 L100-103 | ○ |
| C-06 | importGraphDef()でGraphDefをインポートできる | E-01 L114-133 | ○ |
| C-07 | toGraphDef()でGraphDefをエクスポートできる | E-01 L141-145 | ○ |
| C-08 | addGradients()で勾配計算オペレーションを追加できる | E-01 L170-223 | ○ |
| C-09 | whileLoop()でwhileループを構築できる | E-01 L319-347 | ○ |

### Session クラス（UT-JAV-016 〜 UT-JAV-031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | Session(Graph)でSessionが生成される | E-02 L50-75 | ○ |
| C-11 | close()でリソースが解放される | E-02 L90-109 | ○ |
| C-12 | runner()でRunnerを取得できる | E-02 L411-414 | ○ |
| C-13 | Runner.feed()で入力を設定できる | E-02 L131-159 | ○ |
| C-14 | Runner.fetch()で出力を指定できる | E-02 L171-202 | ○ |
| C-15 | Runner.run()でグラフを実行できる | E-02 L275-277 | ○ |
| C-16 | Runner.addTarget()でターゲットを追加できる | E-02 L208-239 | ○ |

### Tensor クラス（UT-JAV-032 〜 UT-JAV-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | create(Object, Class)でTensorが生成される | E-03 L104-116 | ○ |
| C-18 | create(Object)で型推論付きTensorが生成される | E-03 L125-127 | ○ |
| C-19 | create(long[], IntBuffer)でIntBufferからTensorが生成される | E-03 L169-173 | ○ |
| C-20 | expect(Class)で型キャストできる | E-03 L277-285 | ○ |
| C-21 | close()でリソースが解放される | E-03 L317-320 | ○ |
| C-22 | dataType()でデータ型を取得できる | E-03 L322-325 | ○ |
| C-23 | numDimensions()で次元数を取得できる | E-03 L333-335 | ○ |
| C-24 | shape()でshapeを取得できる | E-03 L353-355 | ○ |
| C-25 | floatValue()等のスカラー値取得メソッドが機能する | E-03 L362-409 | ○ |
| C-26 | copyTo(U)でデータをコピーできる | E-03 L435-439 | ○ |
| C-27 | writeTo()でバッファに書き込める | E-03 L451-525 | ○ |

### TensorFlow クラス（UT-JAV-069 〜 UT-JAV-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | version()でバージョンを取得できる | E-04 L21 | ○ |
| C-29 | registeredOpList()でオペレーションリストを取得できる | E-04 L30 | ○ |
| C-30 | loadLibrary()でライブラリを読み込める | E-04 L42-54 | ○ |

### Shape クラス（UT-JAV-073 〜 UT-JAV-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | unknown()で未知Shapeが生成される | E-05 L24-26 | ○ |
| C-32 | scalar()でスカラーShapeが生成される | E-05 L29-31 | ○ |
| C-33 | make()でN次元Shapeが生成される | E-05 L54-59 | ○ |
| C-34 | numDimensions()で次元数を取得できる | E-05 L67-69 | ○ |
| C-35 | size(int)で次元サイズを取得できる | E-05 L76-78 | ○ |
| C-36 | equals()で等価性を判定できる | E-05 L85-96 | ○ |

### Output クラス（UT-JAV-086 〜 UT-JAV-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | op()でOperationを取得できる | E-06 L32-34 | ○ |
| C-38 | index()でインデックスを取得できる | E-06 L37-39 | ○ |
| C-39 | shape()でShapeを取得できる | E-06 L42-44 | ○ |
| C-40 | dataType()でDataTypeを取得できる | E-06 L47-49 | ○ |
| C-41 | tensor()でTensorを取得できる（Eagerモード） | E-06 L63-65 | ○ |

### DataType 列挙型（UT-JAV-096 〜 UT-JAV-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | byteSize()でバイトサイズを取得できる | E-07 L66-68 | ○ |
| C-43 | fromC()でC API値から変換できる | E-07 L78-86 | ○ |
| C-44 | fromClass()でJavaクラスから変換できる | E-07 L96-103 | ○ |

### EagerSession クラス（UT-JAV-102 〜 UT-JAV-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | create()でEagerSessionが生成される | E-08 L299-301 | ○ |
| C-46 | getDefault()でデフォルトセッションを取得できる | E-08 L272-281 | ○ |
| C-47 | initDefault()でデフォルトセッションを初期化できる | E-08 L236-244 | ○ |
| C-48 | close()でリソースが解放される | E-08 L324-336 | ○ |
| C-49 | opBuilder()でOperationBuilderを取得できる | E-08 L339-345 | ○ |
| C-50 | Optionsでセッション設定をカスタマイズできる | E-08 L119-201 | ○ |

### GraphOperationBuilder クラス（UT-JAV-116 〜 UT-JAV-136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | build()でGraphOperationを構築できる | E-09 L38-48 | ○ |
| C-52 | addControlInput()で制御入力を追加できる | E-09 L51-63 | ○ |
| C-53 | addInput()で入力を追加できる | E-09 L65-74 | ○ |
| C-54 | setDevice()でデバイスを設定できる | E-09 L93-102 | ○ |
| C-55 | setAttr()の各オーバーロードで属性を設定できる | E-09 L104-296 | ○ |

### GraphOperation クラス（UT-JAV-137 〜 UT-JAV-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | name()で名前を取得できる | E-10 L38-46 | ○ |
| C-57 | type()で型を取得できる | E-10 L48-56 | ○ |
| C-58 | numOutputs()で出力数を取得できる | E-10 L58-66 | ○ |
| C-59 | tensor()でIllegalStateExceptionがスローされる | E-10 L142-145 | ○ |

### EagerOperationBuilder クラス（UT-JAV-147 〜 UT-JAV-152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | build()でEagerOperationを構築できる | E-11 L34-42 | ○ |
| C-61 | addControlInput()でUnsupportedOperationExceptionがスローされる | E-11 L61-64 | ○ |
| C-62 | setAttr(String, Tensor[])でUnsupportedOperationExceptionがスローされる | E-11 L153-157 | ○ |

### EagerOperation クラス（UT-JAV-153 〜 UT-JAV-160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | name()で名前を取得できる | E-12 L44-47 | ○ |
| C-64 | type()で型を取得できる | E-12 L49-52 | ○ |
| C-65 | tensor()でTensorを取得できる | E-12 L102-109 | ○ |

### SavedModelBundle クラス（UT-JAV-161 〜 UT-JAV-171）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | load()でSavedModelをロードできる | E-13 L94-96 | ○ |
| C-67 | loader()でLoaderを取得できる | E-13 L106-108 | ○ |
| C-68 | Loaderの各メソッドで設定をカスタマイズできる | E-13 L42-77 | ○ |
| C-69 | graph()でGraphを取得できる | E-13 L119-122 | ○ |
| C-70 | session()でSessionを取得できる | E-13 L129-131 | ○ |
| C-71 | close()でリソースが解放される | E-13 L137-141 | ○ |

### Server クラス（UT-JAV-172 〜 UT-JAV-176）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Server(byte[])でServerが生成される | E-14 L70-72 | ○ |
| C-73 | start()でサーバーが開始される | E-14 L75-77 | ○ |
| C-74 | stop()でサーバーが停止される | E-14 L80-82 | ○ |
| C-75 | join()でブロックされる | E-14 L85-103 | ○ |
| C-76 | close()でリソースが解放される | E-14 L106-114 | ○ |

### Scope クラス（UT-JAV-177 〜 UT-JAV-186）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Scope(ExecutionEnvironment)でScopeが生成される | E-15 L87-89 | ○ |
| C-78 | env()でExecutionEnvironmentを取得できる | E-15 L92-94 | ○ |
| C-79 | withSubScope()でサブスコープを生成できる | E-15 L109-111 | ○ |
| C-80 | withName()で名前付きスコープを生成できる | E-15 L125-127 | ○ |
| C-81 | makeOpName()でユニークな名前を生成できる | E-15 L149-151 | ○ |

### NameScope クラス（UT-JAV-187 〜 UT-JAV-193）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | withSubScope()でサブスコープを生成できる | E-16 L39-45 | ○ |
| C-83 | withName()で名前を設定できる | E-16 L47-51 | ○ |
| C-84 | makeOpName()でオペレーション名を生成できる | E-16 L53-58 | ○ |

### Operands クラス（UT-JAV-194 〜 UT-JAV-195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | asOutputs()でOperandリストをOutput配列に変換できる | E-17 L36-42 | ○ |

### PrimitiveOp クラス（UT-JAV-196 〜 UT-JAV-199）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | op()でOperationを取得できる | E-18 L29-31 | ○ |
| C-87 | hashCode()/equals()が正しく実装されている | E-18 L33-49 | ○ |

### Constant クラス（UT-JAV-200 〜 UT-JAV-215）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | create()の各オーバーロードで定数を作成できる | E-19 L47-638 | ○ |
| C-89 | asOutput()でOutputを取得できる | E-19 L650-653 | ○ |

### Zeros クラス（UT-JAV-216 〜 UT-JAV-218）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | create()でゼロ初期化テンソルを作成できる | E-20 L48-56 | ○ |
| C-91 | STRING型で例外がスローされる | E-20 L50-53 | ○ |

### Gradients クラス（UT-JAV-219 〜 UT-JAV-225）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | create()で勾配計算オペレーションを追加できる | E-21 L84-106 | ○ |
| C-93 | dy()で勾配出力を取得できる | E-21 L144-161 | ○ |

### Tensors クラス（UT-JAV-226 〜 UT-JAV-234）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | create()の各オーバーロードでTensorを作成できる | E-22 L29-446 | ○ |

### AbstractOperation クラス（UT-JAV-235 〜 UT-JAV-237）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | outputList()で出力リストを取得できる | E-23 L27-33 | ○ |
| C-96 | output()で出力を取得できる | E-23 L36-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースはソースコードに基づいて生成されています）

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 1 | ネイティブ依存 | TensorFlow Javaはネイティブライブラリに依存しており、テスト実行にはネイティブライブラリのセットアップが必要 |
| 1 | 外部リソース依存 | SavedModelBundle, Server関連のテストは外部リソース（モデルファイル、ネットワーク設定）が必要 |
| 0 | スレッドセーフティ | Graph, Session, EagerSessionはスレッドセーフと文書化されているが、並行テストの考慮が必要な場合あり |
| 0 | リソースリーク | AutoCloseableを実装するクラスはtry-with-resourcesでのテストが推奨される |

## 6) レビュアーチェックリスト（最小）
- [ ] テスト環境にTensorFlowネイティブライブラリがインストールされているか確認
- [ ] SavedModel関連テストで使用するテストモデルが準備されているか確認
- [ ] Server関連テストは分散環境が必要なため、CIでの実行をスキップまたはモック化を検討
- [ ] 境界値テスト（空配列、null、最大値等）が網羅されているか確認
- [ ] 例外テストで適切な例外型がスローされることを確認
- [ ] リソース解放テストでメモリリークが発生しないことを確認
- [ ] 高優先度テストケース（優先度：高）が先に実装されることを確認
