---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 113
  claims_with_evidence: 113
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lite-acceleration 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：113 / 113、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースに根拠が存在
  2. プラットフォーム依存のテストケース（ARM/Apple環境）は実行環境の確認が必要
  3. 共有ライブラリのロードテスト（StableDelegatePlugin）はモックが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/acceleration/configuration/gpu_plugin.h`
- E-02: `tensorflow/lite/acceleration/configuration/gpu_plugin.cc`
- E-03: `tensorflow/lite/acceleration/configuration/proto_to_flatbuffer.h`
- E-04: `tensorflow/lite/acceleration/configuration/proto_to_flatbuffer.cc`
- E-05: `tensorflow/lite/acceleration/configuration/flatbuffer_to_proto.h`
- E-06: `tensorflow/lite/acceleration/configuration/flatbuffer_to_proto.cc`
- E-07: `tensorflow/lite/acceleration/configuration/delegate_registry.h`
- E-08: `tensorflow/lite/acceleration/configuration/hexagon_plugin.cc`
- E-09: `tensorflow/lite/acceleration/configuration/coreml_plugin.cc`
- E-10: `tensorflow/lite/acceleration/configuration/stable_delegate_plugin.h`
- E-11: `tensorflow/lite/acceleration/configuration/stable_delegate_plugin.cc`
- E-12: `tensorflow/lite/acceleration/configuration/delegate_plugin_converter.h`
- E-13: `tensorflow/lite/acceleration/configuration/delegate_plugin_converter.cc`
- E-14: `tensorflow/lite/acceleration/configuration/c/delegate_plugin.h`
- E-15: `tensorflow/lite/acceleration/configuration/c/gpu_plugin.h`
- E-16: `tensorflow/lite/acceleration/configuration/c/nnapi_plugin.h`
- E-17: `tensorflow/lite/acceleration/configuration/c/xnnpack_plugin.h`
- E-18: `tensorflow/lite/acceleration/configuration/c/stable_delegate.h`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GpuPlugin コンストラクタのデフォルト初期化 | E-02 (L86-94) | ○ |
| C-02 | GpuPlugin inference_priority設定 | E-02 (L98-111) | ○ |
| C-03 | GpuPlugin precision_loss_allowed=true時の設定 | E-02 (L108-109) | ○ |
| C-04 | GpuPlugin precision_loss_allowed=false時の設定 | E-02 (L110) | ○ |
| C-05 | GpuPlugin quantized_inference有効化 | E-02 (L113-115) | ○ |
| C-06 | GpuPlugin OpenCLバックエンド強制 | E-02 (L116-117) | ○ |
| C-07 | GpuPlugin OpenGLバックエンド強制 | E-02 (L118-120) | ○ |
| C-08 | GpuPlugin キャッシュ設定 | E-02 (L122-131) | ○ |
| C-09 | GpuPlugin cache_dir空時の挙動 | E-02 (L124) | ○ |
| C-10 | GpuPlugin model_token空時の挙動 | E-02 (L124) | ○ |
| C-11 | GpuPlugin max_delegated_partitions設定 | E-02 (L88-91) | ○ |
| C-12 | GpuPlugin max_delegated_partitions負値時の挙動 | E-02 (L88) | ○ |
| C-13 | GpuPlugin::Create デリゲート生成 | E-02 (L81-84) | ○ |
| C-14 | GpuPlugin::Create 非サポート環境 | E-02 (L152-154) | ○ |
| C-15 | GpuPlugin::GetDelegateErrno | E-02 (L25) | ○ |
| C-16 | GpuPlugin::New ファクトリメソッド | E-02 (L27-30) | ○ |
| C-17 | ConvertInferencePriority AUTO変換 | E-02 (L39-40) | ○ |
| C-18 | ConvertInferencePriority MAX_PRECISION変換 | E-02 (L41-42) | ○ |
| C-19 | ConvertInferencePriority MIN_LATENCY変換 | E-02 (L43-44) | ○ |
| C-20 | ConvertInferencePriority MIN_MEMORY_USAGE変換 | E-02 (L45-46) | ○ |
| C-21 | GetCacheDirImpl compilation_caching_settings優先 | E-02 (L51-54) | ○ |
| C-22 | GetCacheDirImpl gpu_settings代替 | E-02 (L55-58) | ○ |
| C-23 | GetCacheDirImpl 未設定時 | E-02 (L59-61) | ○ |
| C-24 | GetModelTokenImpl compilation_caching_settings優先 | E-02 (L65-69) | ○ |
| C-25 | GetModelTokenImpl gpu_settings代替 | E-02 (L70-73) | ○ |
| C-26 | ConvertExecutionPreference ANY変換 | E-04 (L36-37) | ○ |
| C-27 | ConvertExecutionPreference LOW_LATENCY変換 | E-04 (L38-39) | ○ |
| C-28 | ConvertExecutionPreference LOW_POWER変換 | E-04 (L40-41) | ○ |
| C-29 | ConvertExecutionPreference FORCE_CPU変換 | E-04 (L42-43) | ○ |
| C-30 | ConvertExecutionPreference 不正値ハンドリング | E-04 (L45-47) | ○ |
| C-31 | ConvertDelegate NONE変換 | E-04 (L52-53) | ○ |
| C-32 | ConvertDelegate NNAPI変換 | E-04 (L54-55) | ○ |
| C-33 | ConvertDelegate GPU変換 | E-04 (L56-57) | ○ |
| C-34 | ConvertDelegate HEXAGON変換 | E-04 (L58-59) | ○ |
| C-35 | ConvertDelegate XNNPACK変換 | E-04 (L60-61) | ○ |
| C-36 | ConvertDelegate CORE_ML変換 | E-04 (L66-67) | ○ |
| C-37 | ConvertNNAPIExecutionPreference UNDEFINED変換 | E-04 (L81-82) | ○ |
| C-38 | ConvertNNAPIExecutionPreference NNAPI_LOW_POWER変換 | E-04 (L83-84) | ○ |
| C-39 | ConvertNNAPIExecutionPriority HIGH変換 | E-04 (L105-106) | ○ |
| C-40 | ConvertGPUBackend UNSET変換 | E-04 (L115-116) | ○ |
| C-41 | ConvertGPUBackend OPENCL変換 | E-04 (L117-118) | ○ |
| C-42 | ConvertGPUBackend OPENGL変換 | E-04 (L119-120) | ○ |
| C-43 | ConvertGPUInferenceUsage変換 | E-04 (L127-138) | ○ |
| C-44 | ConvertGPUInferencePriority変換 | E-04 (L140-155) | ○ |
| C-45 | ConvertEdgeTpuPowerState変換 | E-04 (L157-180) | ○ |
| C-46 | ConvertFallbackSettings変換 | E-04 (L182-189) | ○ |
| C-47 | ConvertNNAPISettings変換 | E-04 (L191-213) | ○ |
| C-48 | ConvertGPUSettings変換 | E-04 (L215-228) | ○ |
| C-49 | ConvertHexagonSettings変換 | E-04 (L230-238) | ○ |
| C-50 | ConvertXNNPackSettings変換 | E-04 (L240-246) | ○ |
| C-51 | ConvertCoreMLSettings DEVICES_ALL変換 | E-04 (L253-255) | ○ |
| C-52 | ConvertCoreMLSettings DEVICES_WITH_NEURAL_ENGINE変換 | E-04 (L256-259) | ○ |
| C-53 | ConvertStableDelegateLoaderSettings変換 | E-04 (L270-276) | ○ |
| C-54 | ConvertCPUSettings変換 | E-04 (L278-282) | ○ |
| C-55 | ConvertEdgeTpuDeviceSpec device_paths変換 | E-04 (L287-293) | ○ |
| C-56 | ConvertEdgeTpuDeviceSpec 空device_paths | E-04 (L287) | ○ |
| C-57 | ConvertGoogleEdgeTpuSettings変換 | E-04 (L303-338) | ○ |
| C-58 | ConvertEdgeTpuSettings inactive_power_configs変換 | E-04 (L340-398) | ○ |
| C-59 | ConvertCompilationCachingSettings変換 | E-04 (L400-406) | ○ |
| C-60 | ConvertArmNNSettings変換 | E-04 (L408-413) | ○ |
| C-61 | ConvertMtkNeuronSettings変換 | E-04 (L415-435) | ○ |
| C-62 | ConvertCoralSettings変換 | E-04 (L437-443) | ○ |
| C-63 | ConvertTfliteSettings統合変換 | E-04 (L445-467) | ○ |
| C-64 | ConvertModelFile変換 | E-04 (L469-474) | ○ |
| C-65 | ConvertBenchmarkStoragePaths変換 | E-04 (L476-482) | ○ |
| C-66 | ConvertMinibenchmarkSettings settings_to_test変換 | E-04 (L484-500) | ○ |
| C-67 | ConvertMinibenchmarkSettings 空settings_to_test | E-04 (L488) | ○ |
| C-68 | ConvertFromProto TFLiteSettings | E-04 (L502-507) | ○ |
| C-69 | ConvertFromProto ComputeSettings | E-04 (L509-519) | ○ |
| C-70 | ConvertFromProto MinibenchmarkSettings | E-04 (L521-526) | ○ |
| C-71 | flatbuffer_to_proto ConvertExecutionPreference | E-06 (L23-38) | ○ |
| C-72 | flatbuffer_to_proto ConvertDelegate | E-06 (L40-66) | ○ |
| C-73 | flatbuffer_to_proto ConvertNNAPISettings null文字列 | E-06 (L185-186) | ○ |
| C-74 | flatbuffer_to_proto ConvertGPUSettings | E-06 (L216-238) | ○ |
| C-75 | flatbuffer_to_proto ConvertEdgeTpuDeviceSpec null device_paths | E-06 (L288) | ○ |
| C-76 | flatbuffer_to_proto ConvertEdgeTpuSettings | E-06 (L304-333) | ○ |
| C-77 | flatbuffer_to_proto ConvertGoogleEdgeTpuPriority | E-06 (L361-373) | ○ |
| C-78 | flatbuffer_to_proto ConvertGoogleEdgeTpuTriState | E-06 (L375-385) | ○ |
| C-79 | flatbuffer_to_proto ConvertMtkNeuronSettings | E-06 (L429-478) | ○ |
| C-80 | flatbuffer_to_proto ConvertTfliteSettings 全設定 | E-06 (L480-553) | ○ |
| C-81 | flatbuffer_to_proto ConvertTfliteSettings null設定スキップ | E-06 (L483) | ○ |
| C-82 | flatbuffer_to_proto ConvertBenchmarkEventType | E-06 (L602-620) | ○ |
| C-83 | flatbuffer_to_proto ConvertBenchmarkMetric | E-06 (L622-634) | ○ |
| C-84 | flatbuffer_to_proto ConvertBenchmarkResult | E-06 (L636-659) | ○ |
| C-85 | flatbuffer_to_proto ConvertBenchmarkStage | E-06 (L661-673) | ○ |
| C-86 | flatbuffer_to_proto ConvertBenchmarkError | E-06 (L683-697) | ○ |
| C-87 | flatbuffer_to_proto ConvertBenchmarkEvent | E-06 (L699-715) | ○ |
| C-88 | flatbuffer_to_proto ConvertBestAccelerationDecision | E-06 (L717-728) | ○ |
| C-89 | flatbuffer_to_proto ConvertFromFlatbuffer skip=false | E-06 (L740-765) | ○ |
| C-90 | flatbuffer_to_proto ConvertFromFlatbuffer skip=true | E-06 (L758-761) | ○ |
| C-91 | flatbuffer_to_proto ConvertFromFlatbuffer ComputeSettingsT | E-06 (L767-774) | ○ |
| C-92 | flatbuffer_to_proto ConvertFromFlatbuffer MiniBenchmarkEvent | E-06 (L776-795) | ○ |
| C-93 | HexagonPlugin コンストラクタ設定反映 | E-08 (L49-66) | ○ |
| C-94 | HexagonPlugin settings null時のデフォルト | E-08 (L53) | ○ |
| C-95 | HexagonPlugin::Create ARM環境 | E-08 (L29-41) | ○ |
| C-96 | HexagonPlugin::Create 非ARM環境 | E-08 (L38-40) | ○ |
| C-97 | HexagonPlugin::GetDelegateErrno | E-08 (L42-44) | ○ |
| C-98 | CoreMLPlugin DEVICES_ALL設定 | E-09 (L49-51) | ○ |
| C-99 | CoreMLPlugin DEVICES_WITH_NEURAL_ENGINE設定 | E-09 (L52-54) | ○ |
| C-100 | CoreMLPlugin 不正デバイス設定エラー | E-09 (L55-57) | ○ |
| C-101 | CoreMLPlugin::Create | E-09 (L30-36) | ○ |
| C-102 | CoreMLPlugin::GetDelegateErrno | E-09 (L37-39) | ○ |
| C-103 | StableDelegatePlugin プラグインロード | E-10 (L56-66) | ○ |
| C-104 | StableDelegatePlugin delegate_path null エラー | E-10 (L49-54) | ○ |
| C-105 | StableDelegatePlugin delegate_path 空エラー | E-10 (L51) | ○ |
| C-106 | StableDelegatePlugin ライブラリロード失敗 | E-10 (L58-61) | ○ |
| C-107 | StableDelegatePlugin::Create | E-10 (L69-73) | ○ |
| C-108 | StableDelegatePlugin::GetDelegateErrno | E-10 (L75-77) | ○ |
| C-109 | DelegatePluginViaCApi コンストラクタ | E-13 (L32-34) | ○ |
| C-110 | DelegatePluginViaCApi::Create | E-13 (L35-38) | ○ |
| C-111 | DelegatePluginViaCApi::GetDelegateErrno | E-13 (L40-42) | ○ |
| C-112 | DelegatePluginConverter 関数返却 | E-13 (L49-56) | ○ |
| C-113 | DelegatePluginConverter 返却関数実行 | E-13 (L52-55) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースに対応するソースコードが存在する

## 5) リスクフラグ（レビュー観点）
- 0: プラットフォーム条件コンパイル（`#if defined(__ARM_ARCH)`、`#if defined(__APPLE__)`）のテストは、対象プラットフォームでの実行が必要
- 0: 共有ライブラリのロードテスト（StableDelegatePlugin）はモック/スタブが必要
- 0: FlatBufferBuilderのライフタイム管理に関するテストは注意が必要（一時ポインタの有効期間）

## 6) レビュアーチェックリスト（最小）
- [ ] プラットフォーム固有コード（ARM/Apple/GPU）のテストケースがCI環境で実行可能か確認
- [ ] ConvertFromProto関数群の戻り値ポインタの有効期間に関するテストが適切か確認
- [ ] エラーログ出力のテストケースでログ出力の検証方法が確立されているか確認
- [ ] 共有ライブラリロードのテストでモック/スタブの使用方針が明確か確認
- [ ] 境界値テスト（空文字列、空リスト、負の値）のカバレッジが十分か確認
