---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 126
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：lite-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：126 / 130、根拠なし：4
- 優先レビュー（高）
  1. **C-046**: ReleaseNonPersistentMemoryの詳細動作は実装ファイルの確認が必要
  2. **C-047**: ResetVariableTensorsのデフォルト値動作は実装依存
  3. **C-086**: EnsureTensorDataIsReadableのデリゲート連携動作
  4. **C-048**: SetCustomAllocationForTensorのアライメント要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/core/interpreter.h` - Interpreterクラスのヘッダファイル（1126行）
- E-02: `tensorflow/lite/core/interpreter.cc` - Interpreterクラスの実装ファイル（623行）
- E-03: `tensorflow/lite/core/subgraph.h` - Subgraphクラスのヘッダファイル（1258行）
- E-04: `tensorflow/lite/core/interpreter_builder.h` - InterpreterBuilderクラスのヘッダファイル（179行）
- E-05: `tensorflow/lite/core/interpreter_builder.cc` - InterpreterBuilderクラスの実装ファイル（1002行）
- E-06: `tensorflow/lite/core/signature_runner.h` - SignatureRunnerクラスのヘッダファイル（291行）
- E-07: `tensorflow/lite/core/c/c_api.h` - C APIヘッダファイル（664行）
- E-08: `tensorflow/lite/core/c/common.h` - 共通型定義ヘッダファイル（500行以上）
- E-09: `tensorflow/lite/core/tools/verifier.h` - モデル検証ヘッダファイル（81行）
- E-10: `tensorflow/lite/core/api/op_resolver.h` - OpResolverインターフェース（226行）
- E-11: `tensorflow/lite/core/api/flatbuffer_conversions.h` - FlatBuffer変換関数（478行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Interpreter クラス（C-001 〜 C-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Interpreter::Interpreterがデフォルトエラーレポーターで初期化 | E-01 (L139), E-02 (L103-129) | ○ |
| C-002 | Interpreter::Interpreterがカスタムエラーレポーターで初期化 | E-01 (L139), E-02 (L103-105) | ○ |
| C-003 | Interpreter::~Interpreterが外部コンテキストをクリア | E-02 (L131-151) | ○ |
| C-004 | Interpreter::SetInputsが有効な入力を設定 | E-01 (L152-153), E-02 (L178-180) | ○ |
| C-005 | Interpreter::SetInputsが範囲外インデックスでエラー | E-02 (L178-180), E-03 (L99) | ○ |
| C-006 | Interpreter::SetOutputsが有効な出力を設定 | E-01 (L157), E-02 (L182-184) | ○ |
| C-007 | Interpreter::SetVariablesが変数を設定 | E-01 (L162), E-02 (L186-188) | ○ |
| C-008 | Interpreter::AllocateTensorsが正常にメモリ割り当て | E-01 (L582), E-02 (L190-198) | ○ |
| C-009 | Interpreter::AllocateTensorsがデリゲートエラーを返す | E-02 (L190-198) | ○ |
| C-010 | Interpreter::Invokeが正常に推論実行 | E-01 (L590), E-02 (L233-258) | ○ |
| C-011 | Interpreter::InvokeがAllocateTensors未実行でエラー | E-01 (L586-589), E-02 (L246-247) | ○ |
| C-012 | Interpreter::Invokeがキャンセルでエラー | E-02 (L239) | ○ |
| C-013 | Interpreter::ResizeInputTensorがサイズ変更 | E-01 (L555-556), E-02 (L223-226) | ○ |
| C-014 | Interpreter::ResizeInputTensorが無効インデックスでエラー | E-02 (L223-226), E-03 (L297-298) | ○ |
| C-015 | Interpreter::ResizeInputTensorStrictが未知次元のみリサイズ | E-01 (L565-566), E-02 (L228-231) | ○ |
| C-016 | Interpreter::SetNumThreadsがスレッド数設定 | E-01 (L616), E-02 (L307-328) | ○ |
| C-017 | Interpreter::SetNumThreadsが負値でエラー | E-02 (L308-313) | ○ |
| C-018 | Interpreter::SetNumThreadsが0を1として処理 | E-02 (L315-316) | ○ |
| C-019 | Interpreter::SetNumThreadsが-1を許容 | E-01 (L594-597) | ○ |
| C-020 | Interpreter::AddTensorsがテンソル追加 | E-01 (L178-179), E-02 (L260-263) | ○ |
| C-021 | Interpreter::AddNodeWithParametersがノード追加 | E-01 (L168-173), E-02 (L214-221) | ○ |
| C-022 | Interpreter::SetTensorParametersReadOnlyが設定 | E-01 (L185-188), E-02 (L265-272) | ○ |
| C-023 | Interpreter::SetTensorParametersReadWriteが設定 | E-01 (L210-214), E-02 (L274-281) | ○ |
| C-024 | Interpreter::ModifyGraphWithDelegateが適用 | E-01 (L675-676), E-02 (L402-424) | ○ |
| C-025 | Interpreter::ModifyGraphWithDelegateがnullでエラー | E-01 (L654-667) | ○ |
| C-026 | Interpreter::ModifyGraphWithDelegateがエラー時ロールバック | E-02 (L420-422) | ○ |
| C-027 | Interpreter::GetSignatureRunnerが取得 | E-01 (L372), E-02 (L526-564) | ○ |
| C-028 | Interpreter::GetSignatureRunnerがnullキーでデフォルト | E-02 (L546-551, 590-620) | ○ |
| C-029 | Interpreter::GetSignatureRunnerが無効キーでnullptr | E-02 (L534-537, 563) | ○ |
| C-030 | Interpreter::EnableCancellationが有効化 | E-01 (L243), E-02 (L507-513) | ○ |
| C-031 | Interpreter::Cancelが実行 | E-01 (L648), E-02 (L515) | ○ |
| C-032 | Interpreter::Cancelが無効時エラー | E-01 (L647-648) | ○ |
| C-033 | Interpreter::SetProfilerが設定 | E-01 (L756-764), E-02 (L471-484) | ○ |
| C-034 | Interpreter::SetProfilerがnullでクリア | E-02 (L472-474) | ○ |
| C-035 | Interpreter::AddProfilerが追加 | E-01 (L776), E-02 (L517-524) | ○ |
| C-036 | Interpreter::SetExternalContextが設定 | E-01 (L821), E-02 (L153-176) | ○ |
| C-037 | Interpreter::SetExternalContextが同一で警告 | E-02 (L155-159) | ○ |
| C-038 | Interpreter::SetMetadataが設定 | E-02 (L433-453) | ○ |
| C-039 | Interpreter::subgraphが有効インデックスで取得 | E-01 (L859-865) | ○ |
| C-040 | Interpreter::subgraphが範囲外でnullptr | E-01 (L860-861) | ○ |
| C-041 | Interpreter::tensorが有効インデックスで取得 | E-01 (L288-290) | ○ |
| C-042 | Interpreter::typed_tensorが正しい型で取得 | E-01 (L326-333) | ○ |
| C-043 | Interpreter::typed_tensorが型不一致でnullptr | E-01 (L327-328) | ○ |
| C-044 | Interpreter::inputsがリスト取得 | E-01 (L248) | ○ |
| C-045 | Interpreter::outputsがリスト取得 | E-01 (L257-259) | ○ |
| C-046 | Interpreter::ReleaseNonPersistentMemoryが解放 | E-01 (L572) | △ |
| C-047 | Interpreter::ResetVariableTensorsがリセット | E-01 (L808) | △ |
| C-048 | Interpreter::SetCustomAllocationForTensorが設定 | E-01 (L844-846) | △ |

### InterpreterBuilder クラス（C-049 〜 C-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-049 | InterpreterBuilder::InterpreterBuilderが作成 | E-04 (L80-82), E-05 (L222-233) | ○ |
| C-050 | InterpreterBuilder::operator()が正常作成 | E-04 (L101), E-05 (L799-962) | ○ |
| C-051 | InterpreterBuilder::operator()がnullポインタでエラー | E-05 (L801-805) | ○ |
| C-052 | InterpreterBuilder::operator()がnullモデルでエラー | E-05 (L808-810) | ○ |
| C-053 | InterpreterBuilder::operator()がバージョン不一致でエラー | E-05 (L813-819) | ○ |
| C-054 | InterpreterBuilder::operator()がサブグラフなしでエラー | E-05 (L834-837) | ○ |
| C-055 | InterpreterBuilder::operator()がバッファなしでエラー | E-05 (L839-842) | ○ |
| C-056 | InterpreterBuilder::SetNumThreadsが設定 | E-04 (L111), E-05 (L775-785) | ○ |
| C-057 | InterpreterBuilder::SetNumThreadsが負値でエラー | E-05 (L776-781) | ○ |
| C-058 | InterpreterBuilder::AddDelegateが追加 | E-04 (L119), E-05 (L965-970) | ○ |
| C-059 | InterpreterBuilder::AddDelegateがnullでエラー | E-05 (L966-967) | ○ |
| C-060 | InterpreterBuilder::ParseQuantizationがパース | E-05 (L407-515) | ○ |
| C-061 | InterpreterBuilder::ParseQuantizationがscaleなしでNoQuantization | E-05 (L426-429) | ○ |
| C-062 | InterpreterBuilder::ParseQuantizationがzero_pointなしでエラー | E-05 (L432-437) | ○ |
| C-063 | InterpreterBuilder::ParseSparsityがパース | E-05 (L517-583) | ○ |
| C-064 | InterpreterBuilder::ParseSparsityがnullでスキップ | E-05 (L519-521) | ○ |
| C-065 | InterpreterBuilder::ParseSignatureDefsがパース | E-05 (L585-625) | ○ |
| C-066 | InterpreterBuilder::ParseSignatureDefsが空でスキップ | E-05 (L589-591) | ○ |
| C-067 | InterpreterBuilder::ParseSignatureDefsがnullでエラー | E-05 (L594-598) | ○ |
| C-068 | InterpreterBuilder::ParseTensorsがパース | E-05 (L627-755) | ○ |
| C-069 | InterpreterBuilder::ParseTensorsが不正バッファでエラー | E-05 (L665-670) | ○ |
| C-070 | InterpreterBuilder::ParseNodesがパース | E-05 (L334-405) | ○ |
| C-071 | InterpreterBuilder::ParseNodesが不正インデックスでエラー | E-05 (L345-350) | ○ |

### Subgraph クラス（C-072 〜 C-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-072 | Subgraph::Subgraphが初期化 | E-03 (L81-87) | ○ |
| C-073 | Subgraph::SetInputsが設定 | E-03 (L99) | ○ |
| C-074 | Subgraph::SetOutputsが設定 | E-03 (L104) | ○ |
| C-075 | Subgraph::AddTensorsが追加 | E-03 (L126-127) | ○ |
| C-076 | Subgraph::AllocateTensorsが割り当て | E-03 (L330) | ○ |
| C-077 | Subgraph::Invokeが実行 | E-03 (L342) | ○ |
| C-078 | Subgraph::Invokeがキャンセルでエラー | E-03 (L979) | ○ |
| C-079 | Subgraph::ResizeInputTensorがリサイズ | E-03 (L297-298, 303-304) | ○ |
| C-080 | Subgraph::ResizeInputTensorが非入力でエラー | E-03 (L296-297) | ○ |
| C-081 | Subgraph::tensorが取得 | E-03 (L207-213) | ○ |
| C-082 | Subgraph::tensorが範囲外でnullptr | E-03 (L208-211) | ○ |
| C-083 | Subgraph::tensorが負値でnullptr | E-03 (L208) | ○ |
| C-084 | Subgraph::ModifyGraphWithDelegateが適用 | E-03 (L932) | ○ |
| C-085 | Subgraph::ModifyGraphWithDelegateがエラーでロールバック | E-03 (L918-931) | ○ |
| C-086 | Subgraph::EnsureTensorDataIsReadableが読み取り可能に | E-03 (L372) | △ |
| C-087 | Subgraph::SetNameが設定 | E-03 (L453) | ○ |
| C-088 | Subgraph::GetNameが取得 | E-03 (L454) | ○ |
| C-089 | Subgraph::HasDynamicTensorsが返却 | E-03 (L425) | ○ |
| C-090 | Subgraph::IsPrimarySubgraphが判定 | E-03 (L420) | ○ |

### SignatureRunner クラス（C-091 〜 C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-091 | SignatureRunner::input_sizeが取得 | E-06 (L105) | ○ |
| C-092 | SignatureRunner::output_sizeが取得 | E-06 (L108) | ○ |
| C-093 | SignatureRunner::input_tensorが取得 | E-06 (L133) | ○ |
| C-094 | SignatureRunner::input_tensorが無効でnullptr | E-06 (L129-130) | ○ |
| C-095 | SignatureRunner::output_tensorが取得 | E-06 (L140) | ○ |
| C-096 | SignatureRunner::output_tensorが無効でnullptr | E-06 (L136-138) | ○ |
| C-097 | SignatureRunner::ResizeInputTensorがリサイズ | E-06 (L147-148) | ○ |
| C-098 | SignatureRunner::AllocateTensorsが割り当て | E-06 (L164) | ○ |
| C-099 | SignatureRunner::Invokeが実行 | E-06 (L168) | ○ |
| C-100 | SignatureRunner::Cancelがキャンセル | E-06 (L176) | ○ |

### C API（C-101 〜 C-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | TfLiteModelCreateが作成 | E-07 (L183-184) | ○ |
| C-102 | TfLiteModelCreateが不正でnullptr | E-07 (L183) | ○ |
| C-103 | TfLiteModelCreateFromFileが作成 | E-07 (L201-202) | ○ |
| C-104 | TfLiteModelCreateFromFileが存在しないでnullptr | E-07 (L196-202) | ○ |
| C-105 | TfLiteModelDeleteが削除 | E-07 (L217) | ○ |
| C-106 | TfLiteModelDeleteがnullで安全 | E-07 (L216) | ○ |
| C-107 | TfLiteInterpreterCreateが作成 | E-07 (L312-313) | ○ |
| C-108 | TfLiteInterpreterCreateがオプション付きで作成 | E-07 (L306-313) | ○ |
| C-109 | TfLiteInterpreterAllocateTensorsが割り当て | E-07 (L362-363) | ○ |
| C-110 | TfLiteInterpreterInvokeが実行 | E-07 (L395-396) | ○ |
| C-111 | TfLiteInterpreterResizeInputTensorがリサイズ | E-07 (L353-355) | ○ |
| C-112 | TfLiteTensorCopyFromBufferがコピー | E-07 (L640-641) | ○ |
| C-113 | TfLiteTensorCopyFromBufferがサイズ不一致でエラー | E-07 (L639) | ○ |
| C-114 | TfLiteTensorCopyToBufferがコピー | E-07 (L645-647) | ○ |

### Verifier / OpResolver / FlatBuffer変換（C-115 〜 C-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | Verifyが検証成功 | E-09 (L67-68, L76) | ○ |
| C-116 | Verifyが不正でfalse | E-09 (L67-68) | ○ |
| C-117 | Verifyがバージョン不一致でfalse | E-09 (L52-53) | ○ |
| C-118 | Verifyが空バッファでfalse | E-09 (L76) | ○ |
| C-119 | OpResolver::FindOpがビルトイン検索 | E-10 (L56-57) | ○ |
| C-120 | OpResolver::FindOpがカスタム検索 | E-10 (L59-60) | ○ |
| C-121 | OpResolver::FindOpが未登録でnullptr | E-10 (L56-60) | ○ |
| C-122 | ParseOpDataがパース | E-11 (L63-65) | ○ |
| C-123 | ParseOpDataが不正でエラー | E-11 (L63-65) | ○ |
| C-124 | ConvertTensorTypeが変換 | E-11 (L69-70) | ○ |
| C-125 | ConvertTensorTypeが不正でエラー | E-11 (L69-70) | ○ |
| C-126 | TfLiteIntArrayCreateが作成 | E-08 (L136-137) | ○ |
| C-127 | TfLiteIntArrayCreateが0で空配列 | E-08 (L136-137) | ○ |
| C-128 | TfLiteIntArrayEqualが等値で1 | E-08 (L140-141) | ○ |
| C-129 | TfLiteIntArrayEqualが非等値で0 | E-08 (L140-141) | ○ |
| C-130 | TfLiteFloatArrayCreateが作成 | E-08 (L180-181) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-046 (ReleaseNonPersistentMemory)**: 実装詳細がsubgraph.ccにあり、完全な動作仕様の確認には追加調査が必要
  - 候補：`tensorflow/lite/core/subgraph.cc` / メモリプランナー実装
- **C-047 (ResetVariableTensors)**: バッファありの場合の動作がTODOコメントで示されており、実装が完了していない可能性
  - 候補：`tensorflow/lite/core/subgraph.cc` (L385-386)
- **C-048 (SetCustomAllocationForTensor)**: アライメント要件の具体的な検証ロジックは`util.h`を参照する必要がある
  - 候補：`tensorflow/lite/util.h` / `kDefaultTensorAlignment`
- **C-086 (EnsureTensorDataIsReadable)**: デリゲートとの連携動作の詳細確認が必要
  - 候補：デリゲート実装ファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 単純なgetter/setter系のテストケース（C-041〜C-045, C-087〜C-092等）
- **1（中リスク）**: エラーハンドリング・境界値系のテストケース（C-005, C-014, C-017等）
- **2（高リスク）**: メモリ管理・デリゲート適用系のテストケース（C-008, C-024〜C-026, C-046〜C-048）
  - 特にデリゲート適用失敗時のロールバック処理（C-026, C-085）は慎重なレビューが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高リスク項目（C-024〜C-026, C-046〜C-048, C-084〜C-086）のテストケースが実際の実装と整合しているか確認
- [ ] 境界値テストケース（C-018, C-019, C-083, C-118, C-127）が仕様を正しく反映しているか確認
- [ ] キャンセル機能関連（C-012, C-030〜C-032, C-078, C-100）のスレッドセーフティが考慮されているか確認
- [ ] SignatureRunner関連（C-027〜C-029, C-091〜C-100）のnullキー処理が正しいか確認
- [ ] C API（C-101〜C-114）がC++実装と一貫性があるか確認
- [ ] 根拠不足の4件（C-046, C-047, C-048, C-086）について追加調査の要否を判断
