---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 194
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート: lite-delegates 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：194 / 200、根拠なし：6
- 優先レビュー（高）
  1. **C-150**: AdrenoInfo::GetMaximumWavesCount - 内部実装の詳細が不明
  2. **C-151**: AppleInfo::IsFamilyApple6 - Apple GPUファミリーの判定ロジック
  3. **C-159**: GetGpuInfoFromDeviceDescription - デバイス説明パーサーの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/delegates/utils.h` - GraphPartitionHelper, FP16GraphPartitionHelper, CreateNewTensorWithDifferentType, AcquireSubgraphContext, ReleaseSubgraphContext, MarkSubgraphAsDelegationSkippable
- E-02: `tensorflow/lite/delegates/gpu/api.h` - Dimensions, ObjectDef, TensorObjectDef, InferenceBuilder, InferenceRunner, InferenceOptions関連関数
- E-03: `tensorflow/lite/delegates/gpu/delegate.h` - TfLiteGpuDelegateV2Create, TfLiteGpuDelegateV2Delete, tflite_plugin_create_delegate, tflite_plugin_destroy_delegate
- E-04: `tensorflow/lite/delegates/gpu/common/data_type.h` - DataType enum, SizeOf, ToString, ToCLDataType, ToMetalDataType, ToGlslShaderDataType
- E-05: `tensorflow/lite/delegates/gpu/common/shape.h` - Axis, Layout enum, Shape, StrongShape template, Size, GetAxis, GetAxisIndex, HasAxis
- E-06: `tensorflow/lite/delegates/gpu/common/tensor.h` - Tensor template, TensorRef, MakeZeroTensor
- E-07: `tensorflow/lite/delegates/gpu/common/model.h` - GraphFloat32クラス、RemovePrecedingNode, RemoveFollowingNode, RemoveSimpleNodeKeepInput, RemoveSimpleNodeKeepOutput, ConnectTwoNodes, CheckBatchSizeForAllValues
- E-08: `tensorflow/lite/delegates/gpu/common/model_transformer.h` - TransformStatus, TransformResult, NodeTransformation, SequenceTransformation, ModelTransformer
- E-09: `tensorflow/lite/delegates/gpu/common/model_builder.h` - GetOpsToReplace, BuildModel, BuildModelEnforceIO, BuildFinalModel, BuildFromFlatBuffer, ConvertTfLiteTensorToTensorRef
- E-10: `tensorflow/lite/delegates/gpu/common/object_reader.h` - ObjectReaderクラス
- E-11: `tensorflow/lite/delegates/gpu/common/gpu_info.h` - GpuVendor, GpuApi enum, AdrenoInfo, AppleInfo, MaliInfo, PowerVRInfo, OpenGlInfo, VulkanInfo, OpenClInfo, MetalInfo, GpuInfo
- E-12: `tensorflow/lite/delegates/gpu/common/operations.h` - OperationType enum, 各種Attributes構造体, CalculateOutputShape関数群, CalculateSamePadding関数群
- E-13: `tensorflow/lite/delegates/xnnpack/xnnpack_delegate.h` - TfLiteXNNPackDelegateOptions, TfLiteXNNPackDelegateCreate, TfLiteXNNPackDelegateDelete, WeightsCache関連関数
- E-14: `tensorflow/lite/delegates/xnnpack/weight_cache.h` - XNNPackCacheHeader, PackIdentifier, BufferLocation, WeightCacheBuilder, MMapWeightCacheProvider
- E-15: `tensorflow/lite/delegates/xnnpack/quantization_util.h` - DequantizeInt8, PerChannelDequantizeInt8, DequantizeFloat16

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | GraphPartitionHelper - IsNodeSupportedFnコンストラクタ | E-01 | ○ |
| C-002 | GraphPartitionHelper - supported_node_indicesコンストラクタ | E-01 | ○ |
| C-003 | GraphPartitionHelper::Partition - 正常系 | E-01 | ○ |
| C-004 | GraphPartitionHelper::Partition - 範囲指定 | E-01 | ○ |
| C-005 | GraphPartitionHelper::Partition - 境界値start_node_index=0 | E-01 | ○ |
| C-006 | GraphPartitionHelper::Partition - 境界値end_node_index=max | E-01 | ○ |
| C-007 | GraphPartitionHelper::GetFirstNLargestPartitions - 正常系 | E-01 | ○ |
| C-008 | GraphPartitionHelper::GetFirstNLargestPartitions - パーティション数未満 | E-01 | ○ |
| C-009 | GraphPartitionHelper::GetFirstNLargestPartitions - min_nodes_per_partition | E-01 | ○ |
| C-010 | GraphPartitionHelper::GetNodesOfFirstNLargestPartitions | E-01 | ○ |
| C-011 | GraphPartitionHelper::num_total_nodes | E-01 | ○ |
| C-012 | GraphPartitionHelper::num_supported_nodes | E-01 | ○ |
| C-013 | GraphPartitionHelper::num_partitions | E-01 | ○ |
| C-014 | FP16GraphPartitionHelper::IsNodeSupported - FP16ノード | E-01 | ○ |
| C-015 | FP16GraphPartitionHelper::IsNodeSupported - DEQUANTIZE | E-01 | ○ |
| C-016 | FP16GraphPartitionHelper::GetNodesOfFirstNLargestPartitionsImpl | E-01 | ○ |
| C-017 | CreateNewTensorWithDifferentType - 正常系 | E-01 | ○ |
| C-018 | CreateNewTensorWithDifferentType - 異常系 | E-01 | ○ |
| C-019 | AcquireSubgraphContext - 正常系 | E-01 | ○ |
| C-020 | AcquireSubgraphContext - 異常系 | E-01 | ○ |
| C-021 | ReleaseSubgraphContext - 正常系 | E-01 | ○ |
| C-022 | MarkSubgraphAsDelegationSkippable - 正常系 | E-01 | ○ |
| C-023 | MarkSubgraphAsDelegationSkippable - 異常系 | E-01 | ○ |
| C-024 | Dimensions - デフォルトコンストラクタ | E-02 | ○ |
| C-025 | Dimensions - パラメータ指定コンストラクタ | E-02 | ○ |
| C-026 | Dimensions::d() - 正常系 | E-02 | ○ |
| C-027 | Dimensions::d() - 境界値c=1 | E-02 | ○ |
| C-028 | Dimensions::product() | E-02 | ○ |
| C-029 | Dimensions::operator== - 同一 | E-02 | ○ |
| C-030 | Dimensions::operator== - 異なる | E-02 | ○ |
| C-031 | ObjectDef::operator== | E-02 | ○ |
| C-032 | IsValid(ObjectDef) - 正常系 | E-02 | ○ |
| C-033 | IsValid(ObjectDef) - 異常系 | E-02 | ○ |
| C-034 | IsValid(TensorObjectDef) | E-02 | ○ |
| C-035 | NumElements | E-02 | ○ |
| C-036 | IsValid(TensorObjectDef, TensorObject) | E-02 | ○ |
| C-037 | GetType | E-02 | ○ |
| C-038 | IsObjectPresent | E-02 | ○ |
| C-039 | IsObjectInitialized - 初期化済み | E-02 | ○ |
| C-040 | IsObjectInitialized - 未初期化 | E-02 | ○ |
| C-041 | MakeCpuMemory | E-02 | ○ |
| C-042 | MakeReadableCpuMemory | E-02 | ○ |
| C-043 | InferenceBuilder::inputs | E-02 | ○ |
| C-044 | InferenceBuilder::outputs | E-02 | ○ |
| C-045 | InferenceBuilder::SetInputShape - 正常系 | E-02 | ○ |
| C-046 | InferenceBuilder::SetInputShape - 異常系 | E-02 | ○ |
| C-047 | InferenceBuilder::SetInputObjectDef | E-02 | ○ |
| C-048 | InferenceBuilder::SetOutputObjectDef | E-02 | ○ |
| C-049 | InferenceBuilder::Build | E-02 | ○ |
| C-050 | InferenceRunner::inputs | E-02 | ○ |
| C-051 | InferenceRunner::outputs | E-02 | ○ |
| C-052 | InferenceRunner::SetInputObject | E-02 | ○ |
| C-053 | InferenceRunner::SetOutputObject | E-02 | ○ |
| C-054 | InferenceRunner::Run | E-02 | ○ |
| C-055 | GetPosition | E-02 | ○ |
| C-056 | IsValid(InferenceOptions) - 正常系 | E-02 | ○ |
| C-057 | IsValid(InferenceOptions) - 異常系 | E-02 | ○ |
| C-058 | ResolveAutoPriority | E-02 | ○ |
| C-059 | GetRelativeImportance | E-02 | ○ |
| C-060 | TfLiteGpuDelegateV2Create - デフォルトオプション | E-03 | ○ |
| C-061 | TfLiteGpuDelegateV2Create - カスタムオプション | E-03 | ○ |
| C-062 | TfLiteGpuDelegateV2Delete - 正常系 | E-03 | ○ |
| C-063 | TfLiteGpuDelegateV2Delete - null | E-03 | ○ |
| C-064 | tflite_plugin_create_delegate | E-03 | ○ |
| C-065 | tflite_plugin_destroy_delegate | E-03 | ○ |
| C-066 | SizeOf - FLOAT32 | E-04 | ○ |
| C-067 | SizeOf - FLOAT16 | E-04 | ○ |
| C-068 | SizeOf - INT8 | E-04 | ○ |
| C-069 | ToString(DataType) | E-04 | ○ |
| C-070 | ToCLDataType | E-04 | ○ |
| C-071 | ToMetalDataType | E-04 | ○ |
| C-072 | ToGlslShaderDataType | E-04 | ○ |
| C-073 | ToMetalTextureType | E-04 | ○ |
| C-074 | Shape - デフォルトコンストラクタ | E-05 | ○ |
| C-075 | Shape - Layoutコンストラクタ | E-05 | ○ |
| C-076 | Shape::get<Axis> - 正常系 | E-05 | ○ |
| C-077 | Shape::get<Axis> - 存在しない軸 | E-05 | ○ |
| C-078 | Shape::set<Axis> | E-05 | ○ |
| C-079 | Shape::DimensionsProduct | E-05 | ○ |
| C-080 | Shape::operator== | E-05 | ○ |
| C-081 | StrongShape<BHWC> - コンストラクタ | E-05 | ○ |
| C-082 | StrongShape<BHWC>::ToShape | E-05 | ○ |
| C-083 | StrongShape<BHWC>::Adopt - 正常系 | E-05 | ○ |
| C-084 | StrongShape<BHWC>::Adopt - 非互換 | E-05 | ○ |
| C-085 | StrongShape::LinearIndex | E-05 | ○ |
| C-086 | Size(Layout) | E-05 | ○ |
| C-087 | GetAxis(Layout, int) | E-05 | ○ |
| C-088 | GetAxisIndex(Layout, Axis) | E-05 | ○ |
| C-089 | HasAxis(Layout, Axis) - 存在する | E-05 | ○ |
| C-090 | HasAxis(Layout, Axis) - 存在しない | E-05 | ○ |
| C-091 | MakeZeroTensor | E-06 | ○ |
| C-092 | GraphFloat32::nodes | E-07 | ○ |
| C-093 | GraphFloat32::values | E-07 | ○ |
| C-094 | GraphFloat32::inputs | E-07 | ○ |
| C-095 | GraphFloat32::outputs | E-07 | ○ |
| C-096 | GraphFloat32::NewNode | E-07 | ○ |
| C-097 | GraphFloat32::NewValue | E-07 | ○ |
| C-098 | GraphFloat32::SetProducer - 正常系 | E-07 | ○ |
| C-099 | GraphFloat32::SetProducer - 異常系 | E-07 | ○ |
| C-100 | GraphFloat32::AddConsumer | E-07 | ○ |
| C-101 | GraphFloat32::RemoveProducer | E-07 | ○ |
| C-102 | GraphFloat32::RemoveConsumer | E-07 | ○ |
| C-103 | GraphFloat32::DeleteNode | E-07 | ○ |
| C-104 | GraphFloat32::DeleteValue | E-07 | ○ |
| C-105 | GraphFloat32::FindInputs | E-07 | ○ |
| C-106 | GraphFloat32::FindOutputs | E-07 | ○ |
| C-107 | GraphFloat32::FindProducer | E-07 | ○ |
| C-108 | GraphFloat32::FindConsumers | E-07 | ○ |
| C-109 | GraphFloat32::GetNode - 正常系 | E-07 | ○ |
| C-110 | GraphFloat32::GetNode - 存在しない | E-07 | ○ |
| C-111 | GraphFloat32::GetValue | E-07 | ○ |
| C-112 | GraphFloat32::IsGraphInput | E-07 | ○ |
| C-113 | GraphFloat32::IsGraphOutput | E-07 | ○ |
| C-114 | GraphFloat32::InsertNodeAfter | E-07 | ○ |
| C-115 | GraphFloat32::ReplaceInput | E-07 | ○ |
| C-116 | GraphFloat32::MakeExactCopy | E-07 | ○ |
| C-117 | RemovePrecedingNode | E-07 | ○ |
| C-118 | RemoveFollowingNode | E-07 | ○ |
| C-119 | RemoveSimpleNodeKeepInput | E-07 | ○ |
| C-120 | RemoveSimpleNodeKeepOutput | E-07 | ○ |
| C-121 | ConnectTwoNodes | E-07 | ○ |
| C-122 | CheckBatchSizeForAllValues - 同じ | E-07 | ○ |
| C-123 | CheckBatchSizeForAllValues - 異なる | E-07 | ○ |
| C-124 | ModelTransformer::Apply(SequenceTransformation) - 正常系 | E-08 | ○ |
| C-125 | ModelTransformer::Apply(SequenceTransformation) - INVALID | E-08 | ○ |
| C-126 | ModelTransformer::Apply(NodeTransformation) | E-08 | ○ |
| C-127 | ModelTransformer::last_transformation_message | E-08 | ○ |
| C-128 | GetOpsToReplace - 正常系 | E-09 | ○ |
| C-129 | GetOpsToReplace - 量子化許可 | E-09 | ○ |
| C-130 | GetOpsToReplace - 除外オペレーション | E-09 | ○ |
| C-131 | BuildModel - 正常系 | E-09 | ○ |
| C-132 | BuildModel - 量子化変換マップ | E-09 | ○ |
| C-133 | BuildModelEnforceIO | E-09 | ○ |
| C-134 | BuildFinalModel | E-09 | ○ |
| C-135 | BuildFromFlatBuffer | E-09 | ○ |
| C-136 | ConvertTfLiteTensorToTensorRef | E-09 | ○ |
| C-137 | ObjectReader::ReadNonConstantTensor | E-10 | ○ |
| C-138 | ObjectReader::ReadValue | E-10 | ○ |
| C-139 | ObjectReader::ReadValueByTensorIdx | E-10 | ○ |
| C-140 | ObjectReader::GetNumberOfRuntimeInputs | E-10 | ○ |
| C-141 | ObjectReader::ReadTensor - 正常系 | E-10 | ○ |
| C-142 | ObjectReader::ReadTensor - 範囲外 | E-10 | ○ |
| C-143 | ObjectReader::ReadTensor - スパース | E-10 | ○ |
| C-144 | ObjectReader::AddOutput | E-10 | ○ |
| C-145 | ObjectReader::AddInput | E-10 | ○ |
| C-146 | ObjectReader::VerifyInputsConstsOutputs - 成功 | E-10 | ○ |
| C-147 | ObjectReader::VerifyInputsConstsOutputs - 失敗 | E-10 | ○ |
| C-148 | AdrenoInfo::IsAdreno6xx | E-11 | ○ |
| C-149 | AdrenoInfo::IsBetterThan | E-11 | ○ |
| C-150 | AdrenoInfo::GetMaximumWavesCount | **実装詳細不明** | △ |
| C-151 | AppleInfo::IsFamilyApple6 | **判定ロジック要確認** | △ |
| C-152 | AppleInfo::IsSIMDMatMulSupported | E-11 | ○ |
| C-153 | MaliInfo::IsBifrost | E-11 | ○ |
| C-154 | MaliInfo::IsValhall | E-11 | ○ |
| C-155 | GpuInfo::IsAdreno | E-11 | ○ |
| C-156 | GpuInfo::SupportsFP16 | E-11 | ○ |
| C-157 | GpuInfo::SupportsImages | E-11 | ○ |
| C-158 | GpuInfo::GetComputeUnitsCount | E-11 | ○ |
| C-159 | GetGpuInfoFromDeviceDescription | **パーサー詳細不明** | △ |
| C-160 | OpenClInfo::IsImage2dFromBufferSupported | E-11 | ○ |
| C-161 | TfLiteXNNPackDelegateOptionsDefault | E-13 | ○ |
| C-162 | TfLiteXNNPackDelegateCreate - nullptr | E-13 | ○ |
| C-163 | TfLiteXNNPackDelegateCreate - カスタム | E-13 | ○ |
| C-164 | TfLiteXNNPackDelegateDelete | E-13 | ○ |
| C-165 | TfLiteXNNPackDelegateGetThreadPool - マルチスレッド | E-13 | ○ |
| C-166 | TfLiteXNNPackDelegateGetThreadPool - シングルスレッド | E-13 | ○ |
| C-167 | TfLiteXNNPackDelegateGetOptions | E-13 | ○ |
| C-168 | TfLiteXNNPackDelegateGetFlags | E-13 | ○ |
| C-169 | TfLiteXNNPackDelegateWeightsCacheCreate | E-13 | ○ |
| C-170 | TfLiteXNNPackDelegateWeightsCacheCreateWithSize | E-13 | ○ |
| C-171 | TfLiteXNNPackDelegateWeightsCacheFinalizeSoft | E-13 | ○ |
| C-172 | TfLiteXNNPackDelegateWeightsCacheFinalizeHard | E-13 | ○ |
| C-173 | TfLiteXNNPackDelegateWeightsCacheDelete | E-13 | ○ |
| C-174 | WeightCacheBuilder::Start | E-14 | ○ |
| C-175 | WeightCacheBuilder::IsStarted | E-14 | ○ |
| C-176 | WeightCacheBuilder::Reserve | E-14 | ○ |
| C-177 | WeightCacheBuilder::Append | E-14 | ○ |
| C-178 | WeightCacheBuilder::StopBuildStep | E-14 | ○ |
| C-179 | WeightCacheBuilder::Reset | E-14 | ○ |
| C-180 | MMapWeightCacheProvider::LoadOrStartBuild | E-14 | ○ |
| C-181 | MMapWeightCacheProvider::Load - 正常系 | E-14 | ○ |
| C-182 | MMapWeightCacheProvider::Load - ファイル不存在 | **エラーパス要確認** | △ |
| C-183 | MMapWeightCacheProvider::MapTensorIdentifiers | E-14 | ○ |
| C-184 | MMapWeightCacheProvider::LookUp - 正常系 | E-14 | ○ |
| C-185 | MMapWeightCacheProvider::LookUp - 存在しないキー | E-14 | ○ |
| C-186 | MMapWeightCacheProvider::ReserveSpace | E-14 | ○ |
| C-187 | MMapWeightCacheProvider::LookUpOrInsert | E-14 | ○ |
| C-188 | MMapWeightCacheProvider::OffsetToAddr | E-14 | ○ |
| C-189 | MMapWeightCacheProvider::Release | E-14 | ○ |
| C-190 | IsCompatibleCacheFile - 互換 | E-14 | ○ |
| C-191 | IsCompatibleCacheFile - 非互換 | **バージョン互換性の詳細不明** | △ |
| C-192 | PackIdentifier::operator== | E-14 | ○ |
| C-193 | BufferLocation::IsInvalid | E-14 | ○ |
| C-194 | DequantizeInt8 - 正常系 | E-15 | ○ |
| C-195 | DequantizeInt8 - 境界値 | **実装詳細要確認** | △ |
| C-196 | PerChannelDequantizeInt8 | E-15 | ○ |
| C-197 | DequantizeFloat16 | E-15 | ○ |
| C-198 | CalculateOutputShape(Convolution2D) | E-12 | ○ |
| C-199 | CalculateOutputShape(Pooling2D) | E-12 | ○ |
| C-200 | CalculateSamePadding(Convolution2D) | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-150 (AdrenoInfo::GetMaximumWavesCount)**: Adreno GPUの内部アーキテクチャに依存する値であり、実装の詳細がヘッダファイルからは確認できない
  - 候補: gpu_info.cc / Snapdragon Profilerドキュメント / Qualcomm SDK
- **C-151 (AppleInfo::IsFamilyApple6)**: Apple GPU Familyの判定基準がヘッダからは完全には把握できない
  - 候補: gpu_info.cc / Apple Metal ドキュメント
- **C-159 (GetGpuInfoFromDeviceDescription)**: デバイス説明文字列のパースロジックの詳細
  - 候補: gpu_info.cc の実装
- **C-182 (MMapWeightCacheProvider::Load - ファイル不存在)**: エラーパスの詳細な動作
  - 候補: weight_cache.cc の実装
- **C-191 (IsCompatibleCacheFile - 非互換)**: バージョン互換性チェックの詳細
  - 候補: weight_cache.cc / XNNPackCacheHeader::kVersion の変更履歴
- **C-195 (DequantizeInt8 - 境界値)**: zero_point=0時の特別な処理があるか
  - 候補: quantization_util.cc の実装

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 0 (低) | utils.h関連テスト | ヘッダに詳細な宣言あり |
| 0 (低) | api.h関連テスト | インターフェース定義が明確 |
| 1 (中) | gpu_info.h関連テスト | GPU固有の実装詳細が不明 |
| 1 (中) | weight_cache.h関連テスト | ファイルI/Oのエラーパス |
| 0 (低) | model.h関連テスト | グラフ操作APIが明確 |
| 0 (低) | xnnpack_delegate.h関連テスト | C API宣言が明確 |

## 6) レビュアーチェックリスト（最小）

- [ ] テストケースがヘッダファイルで宣言されているパブリックAPIを網羅しているか確認
- [ ] 境界値テスト（空配列、0値、最大値）が含まれているか確認
- [ ] 異常系テスト（無効な引数、null ポインタ）が含まれているか確認
- [ ] GPU固有のテストケース（C-148〜C-160）でハードウェア依存の前提条件が適切か確認
- [ ] XNNPackウェイトキャッシュ関連テストでファイルシステム依存を確認
- [ ] 量子化関連テスト（C-194〜C-197）で数値精度の検証方法を確認
- [ ] InferenceBuilder/InferenceRunnerテストでリソースリークがないか確認
- [ ] GraphFloat32テストでノード/値の追加・削除順序の整合性を確認
