---
generated_at: 2026-02-03 12:10:00
metrics:
  claims_total: 87
  claims_with_evidence: 87
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lite-examples.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：87 / 87、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/examples/python/label_image.py`
- E-02: `tensorflow/lite/examples/label_image/label_image.cc`
- E-03: `tensorflow/lite/examples/label_image/label_image.h`
- E-04: `tensorflow/lite/examples/label_image/bitmap_helpers.cc`
- E-05: `tensorflow/lite/examples/label_image/bitmap_helpers.h`
- E-06: `tensorflow/lite/examples/label_image/bitmap_helpers_impl.h`
- E-07: `tensorflow/lite/examples/label_image/get_top_n.h`
- E-08: `tensorflow/lite/examples/label_image/get_top_n_impl.h`
- E-09: `tensorflow/lite/examples/label_image/log.h`
- E-10: `tensorflow/lite/examples/minimal/minimal.cc`
- E-11: `tensorflow/lite/examples/ios/simple/ios_image_load.h`
- E-12: `tensorflow/lite/examples/experimental_new_converter/stack_trace_example.py`

## 3) Claims と根拠の対応（レビューの主戦場）

### Python - label_image.py (UT-LEX-001〜005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | load_labels関数が存在し、ファイルから行を読み込んでstripする | E-01 (25-27行目) | ○ |
| C-02 | open()でファイルを開き、readlines()で読み込む | E-01 (26-27行目) | ○ |
| C-03 | 空行も含めて全行がリストに追加される | E-01 (27行目: strip()のみ) | ○ |
| C-04 | 存在しないファイルでFileNotFoundError | E-01 (26行目: open()) | ○ |
| C-05 | 空ファイルで空リストが返る | E-01 (27行目: リスト内包表記) | ○ |

### C++ - label_image.cc (UT-LEX-006〜037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | get_us関数がtv_sec*1000000+tv_usecを返す | E-02 (57行目) | ○ |
| C-07 | DelegateProvidersクラスが存在する | E-02 (62-160行目) | ○ |
| C-08 | InitFromCmdlineArgsがFlags::Parseを呼び出す | E-02 (76-80行目) | ○ |
| C-09 | MergeSettingsIntoParamsがGL/NNAPI/Hexagon/XNNPACKの設定をマージ | E-02 (85-137行目) | ○ |
| C-10 | CreateAllDelegatesがdelegate_list_util_.CreateAllRankedDelegates()を呼ぶ | E-02 (141-144行目) | ○ |
| C-11 | GetHelpMessageがFlags::Usageを返す | E-02 (146-148行目) | ○ |
| C-12 | ReadLabelsFileがファイルを開いて行を読み込む | E-02 (165-184行目) | ○ |
| C-13 | ラベル数を16の倍数にパディングする | E-02 (179-182行目) | ○ |
| C-14 | ファイルが開けない場合kTfLiteErrorを返す | E-02 (169-172行目) | ○ |
| C-15 | PrintProfilingInfoがプロファイリング情報を出力 | E-02 (186-201行目) | ○ |
| C-16 | RunInferenceがモデル名チェックを行う | E-02 (205-208行目) | ○ |
| C-17 | モデル読み込み失敗でexit(-1) | E-02 (213-216行目) | ○ |
| C-18 | 入力タイプに応じてresize関数を呼び分け | E-02 (301-321行目) | ○ |
| C-19 | プロファイリング有効時にStartProfiling/StopProfilingを呼ぶ | E-02 (323, 346-358行目) | ○ |
| C-20 | Main関数がオプションをパースして設定に反映 | E-02 (432-549行目) | ○ |
| C-21 | -hオプションでdisplay_usageを呼びexit | E-02 (537-541行目) | ○ |

### C++ - bitmap_helpers.cc (UT-LEX-038〜049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | decode_bmpがBGR→RGB変換を行う | E-04 (56-59行目) | ○ |
| C-23 | top_downフラグで行の読み込み方向が変わる | E-04 (43-47行目) | ○ |
| C-24 | チャンネル数1/3/4をサポート | E-04 (51-67行目) | ○ |
| C-25 | サポート外チャンネル数でLOG(FATAL) | E-04 (68-70行目) | ○ |
| C-26 | read_bmpがファイルを開いてBMPヘッダーを解析 | E-04 (77-105行目) | ○ |
| C-27 | ファイルが開けない場合LOG(FATAL)とexit | E-04 (82-85行目) | ○ |
| C-28 | 負の高さでトップダウンとして処理 | E-04 (117行目) | ○ |
| C-29 | row_sizeがパディングを考慮して計算される | E-04 (113行目) | ○ |

### C++ - bitmap_helpers_impl.h (UT-LEX-050〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | resize関数がRESIZE_BILINEARオペレーションを使用 | E-06 (58-59行目) | ○ |
| C-31 | float型でinput_mean/input_stdによる正規化 | E-06 (87-88行目) | ○ |
| C-32 | int8_t型で-128オフセット | E-06 (90-91行目) | ○ |
| C-33 | uint8_t型でそのまま出力 | E-06 (93-94行目) | ○ |

### C++ - get_top_n_impl.h (UT-LEX-057〜065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | priority_queueを使用して上位N件を取得 | E-08 (36-39行目) | ○ |
| C-35 | threshold未満の値をスキップ | E-08 (60-62行目) | ○ |
| C-36 | int8_t型で(prediction+128)/256.0の正規化 | E-08 (49-50行目) | ○ |
| C-37 | uint8_t型でprediction/255.0の正規化 | E-08 (52-53行目) | ○ |
| C-38 | 結果を降順にソートして返す | E-08 (73-77行目) | ○ |

### C++ - log.h (UT-LEX-066〜069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Logクラスがseverityを初期化 | E-09 (29行目) | ○ |
| C-40 | Stream()がstringstream参照を返す | E-09 (30行目) | ○ |
| C-41 | デストラクタでstderrに出力 | E-09 (31行目) | ○ |
| C-42 | LOGマクロがLogオブジェクトを作成 | E-09 (34行目) | ○ |

### C++ - minimal.cc (UT-LEX-070〜076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | main関数がargc==2をチェック | E-10 (42-45行目) | ○ |
| C-44 | モデル読み込みにBuildFromFileを使用 | E-10 (49-50行目) | ○ |
| C-45 | TFLITE_MINIMAL_CHECKマクロでエラー時exit(1) | E-10 (35-39行目) | ○ |
| C-46 | InterpreterBuilderでインタプリタ構築 | E-10 (57-60行目) | ○ |
| C-47 | AllocateTensors/Invokeを実行 | E-10 (64, 74行目) | ○ |

### C++ - ios_image_load.h (UT-LEX-077〜079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | LoadImageFromFile関数が宣言されている | E-11 (20-21行目) | ○ |
| C-49 | 出力パラメータとしてwidth/height/channelsポインタを受け取る | E-11 (20-21行目) | ○ |

### Python - stack_trace_example.py (UT-LEX-080〜087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | suppress_exceptionデコレータが例外をキャッチ | E-12 (25-31行目) | ○ |
| C-51 | TestModuleクラスがtf.Moduleを継承 | E-12 (34行目) | ○ |
| C-52 | modelメソッドがreciprocal演算を使用 | E-12 (38-40行目) | ○ |
| C-53 | test_from_saved_modelがTFLiteConverterV2.from_saved_modelを使用 | E-12 (53-54行目) | ○ |
| C-54 | test_from_concrete_functionがfrom_concrete_functionsを使用 | E-12 (67-68行目) | ○ |
| C-55 | main関数がargvの長さをチェック | E-12 (72-73行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースに対応するソースコードが確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの実装に基づいている

**注意点**:
- iOS関連のテストケース（UT-LEX-077〜079）はヘッダーファイルのみの宣言に基づいているため、実装の詳細は別ファイルに存在する可能性がある
- 一部のエラーハンドリングテストケース（exit呼び出し）は統合テスト環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値と期待結果がソースコードの実装と一致しているか確認
- [ ] 境界値テストが適切な値を使用しているか確認
- [ ] 異常系テストがすべてのエラーパスをカバーしているか確認
- [ ] iOS関連テストケースの実装ファイルが存在するか確認
- [ ] プロファイリング関連テストの実行環境要件を確認
- [ ] デリゲートプロバイダーのテストがプラットフォーム依存性を考慮しているか確認
