---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 158
  claims_with_evidence: 142
  claims_without_evidence: 16
confidence_derived: 0.90
---

# 根拠レポート：lite-experimental 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：142 / 158、根拠なし：16
- 優先レビュー（高）
  1. **microfrontend内部実装の詳細**：C言語実装の内部ロジックが複雑で完全な網羅が困難
  2. **shlo ops各演算の境界値テスト**：数学的な境界条件の網羅性が不完全
  3. **acceleration mini_benchmark プロセス間通信**：別プロセスでの実行検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/experimental/acceleration/compatibility/gpu_compatibility.h` - GPUCompatibilityListクラス定義
- E-02: `tensorflow/lite/experimental/acceleration/compatibility/devicedb.h` - UpdateVariablesFromDatabase関数宣言
- E-03: `tensorflow/lite/experimental/acceleration/compatibility/canonicalize_value.h` - 正規化関数宣言
- E-04: `tensorflow/lite/experimental/acceleration/mini_benchmark/validator.h` - Validatorクラス定義
- E-05: `tensorflow/lite/experimental/acceleration/mini_benchmark/validator_runner.h` - ValidatorRunnerクラス定義
- E-06: `tensorflow/lite/experimental/acceleration/mini_benchmark/blocking_validator_runner.h` - BlockingValidatorRunnerクラス定義
- E-07: `tensorflow/lite/experimental/acceleration/mini_benchmark/fb_storage.h` - FileStorage/FlatbufferStorageクラス定義
- E-08: `tensorflow/lite/experimental/acceleration/mini_benchmark/file_lock.h` - FileLockクラス定義
- E-09: `tensorflow/lite/experimental/acceleration/mini_benchmark/jpeg_header_parser.h` - JPEG解析関数宣言
- E-10: `tensorflow/lite/experimental/acceleration/mini_benchmark/libjpeg_decoder.h` - LibjpegDecoderクラス定義
- E-11: `tensorflow/lite/experimental/acceleration/mini_benchmark/model_modifier/embedder.h` - Embedderクラス定義
- E-12: `tensorflow/lite/experimental/resource/resource_variable.h` - ResourceVariableクラス定義
- E-13: `tensorflow/lite/experimental/resource/static_hashtable.h` - StaticHashtableクラス定義
- E-14: `tensorflow/lite/experimental/resource/cache_buffer.h` - CacheBufferクラス定義
- E-15: `tensorflow/lite/experimental/shlo/tensor.h` - Tensorクラス定義
- E-16: `tensorflow/lite/experimental/shlo/shape.h` - Shapeクラス定義
- E-17: `tensorflow/lite/experimental/shlo/ops/abs.h` - AbsOp定義
- E-18: `tensorflow/lite/experimental/shlo/ops/compare.h` - CompareOp定義
- E-19: `tensorflow/lite/experimental/genai/genai_ops.h` - GenAIオペレータ登録関数宣言
- E-20: `tensorflow/lite/experimental/ml_adjacent/algo/resize.h` - リサイズアルゴリズム宣言
- E-21: `tensorflow/lite/experimental/ml_adjacent/algo/crop.h` - クロップアルゴリズム宣言
- E-22: `tensorflow/lite/experimental/ml_adjacent/lib.h` - ml_adjacent基本型・インターフェース定義
- E-23: `tensorflow/lite/experimental/microfrontend/lib/frontend.h` - オーディオフロントエンド関数宣言
- E-24: `tensorflow/lite/experimental/microfrontend/lib/filterbank.h` - フィルターバンク関数宣言

## 3) Claims と根拠の対応（レビューの主戦場）

### acceleration/compatibility モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GPUCompatibilityList::Create の正常系テスト | E-01 | ○ |
| C-02 | GPUCompatibilityList::Create の異常系テスト | E-01 | ○ |
| C-03 | GPUCompatibilityList::Create の境界値テスト | E-01 | ○ |
| C-04 | GPUCompatibilityList::Includes の正常系テスト（サポート） | E-01 | ○ |
| C-05 | GPUCompatibilityList::Includes の正常系テスト（非サポート） | E-01 | ○ |
| C-06 | GPUCompatibilityList::GetStatus テスト | E-01 | ○ |
| C-07 | GPUCompatibilityList::GetBestOptionsFor テスト | E-01 | ○ |
| C-08 | GPUCompatibilityList::CalculateVariables テスト | E-01 | ○ |
| C-09 | GPUCompatibilityList::IsValidFlatbuffer テスト | E-01 | ○ |
| C-10 | GPUCompatibilityList ステータス変換テスト | E-01 | ○ |
| C-11 | UpdateVariablesFromDatabase テスト | E-02 | ○ |
| C-12 | CanonicalizeValue 大文字変換テスト | E-03 | ○ |
| C-13 | CanonicalizeValue スペース変換テスト | E-03 | ○ |
| C-14 | CanonicalizeValue ハイフン変換テスト | E-03 | ○ |
| C-15 | CanonicalizeValue 空文字列テスト | E-03 | ○ |
| C-16 | CanonicalizeValueWithKey テスト | E-03 | ○ |

### acceleration/mini_benchmark モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Validator コンストラクタテスト | E-04 | ○ |
| C-18 | Validator::RunValidation 正常系テスト | E-04 | ○ |
| C-19 | Validator::RunValidation 異常系テスト | E-04 | ○ |
| C-20 | Validator タイムスタンプ取得テスト | E-04 | ○ |
| C-21 | ValidatorRunner コンストラクタテスト | E-05 | ○ |
| C-22 | ValidatorRunner::Init テスト | E-05 | ○ |
| C-23 | ValidatorRunner::TriggerMissingValidation テスト | E-05 | ○ |
| C-24 | ValidatorRunner::GetSuccessfulResults テスト | E-05 | ○ |
| C-25 | ValidatorRunner::GetAndFlushEventsToLog テスト | E-05 | ○ |
| C-26 | BlockingValidatorRunner テスト | E-06 | ○ |
| C-27 | FileStorage::ReadFileIntoBuffer テスト | E-07 | ○ |
| C-28 | FileStorage::AppendDataToFile テスト | E-07 | ○ |
| C-29 | FlatbufferStorage::Read テスト | E-07 | ○ |
| C-30 | FlatbufferStorage::Append テスト | E-07 | ○ |
| C-31 | FileLock::TryLock テスト | E-08 | ○ |
| C-32 | ReadJpegHeader テスト | E-09 | ○ |
| C-33 | BuildImageWithNewHeader テスト | E-09 | ○ |
| C-34 | LibjpegDecoder::Create テスト | E-10 | ○ |
| C-35 | LibjpegDecoder::DecodeImage テスト | E-10 | ○ |
| C-36 | Embedder テスト | E-11 | ○ |

### resource モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | ResourceVariable コンストラクタテスト | E-12 | ○ |
| C-38 | ResourceVariable::AssignFrom テスト | E-12 | ○ |
| C-39 | ResourceVariable::GetTensor テスト | E-12 | ○ |
| C-40 | ResourceVariable::IsInitialized テスト | E-12 | ○ |
| C-41 | ResourceVariable::GetMemoryUsage テスト | E-12 | ○ |
| C-42 | CreateResourceVariableIfNotAvailable テスト | E-12 | ○ |
| C-43 | GetResourceVariable テスト | E-12 | ○ |
| C-44 | IsBuiltinResource テスト | E-12 | ○ |
| C-45 | StaticHashtable コンストラクタテスト | E-13 | ○ |
| C-46 | StaticHashtable::Lookup テスト | E-13 | ○ |
| C-47 | StaticHashtable::Import テスト | E-13 | ○ |
| C-48 | StaticHashtable::Size テスト | E-13 | ○ |
| C-49 | StaticHashtable::CheckKeyAndValueTypes テスト | E-13 | ○ |
| C-50 | CacheBuffer テスト | E-14 | ○ |

### shlo モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Tensor::shape テスト | E-15 | ○ |
| C-52 | Tensor::IsQuantized テスト | E-15 | ○ |
| C-53 | Tensor::Rank テスト | E-15 | ○ |
| C-54 | Tensor::NumElements テスト | E-15 | ○ |
| C-55 | Tensor::GetDataAs テスト | E-15 | ○ |
| C-56 | Shape コンストラクタテスト | E-16 | ○ |
| C-57 | Shape::Dimensions テスト | E-16 | ○ |
| C-58 | Shape::Rank テスト | E-16 | ○ |
| C-59 | Shape::NumElements テスト | E-16 | ○ |
| C-60 | ComputeStrides テスト | E-16 | ○ |
| C-61 | AbsOp テスト | E-17 | ○ |
| C-62 | CompareOp テスト | E-18 | ○ |

### genai モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Register_KV_CACHE テスト | E-19 | ○ |
| C-64 | Register_EXTERNAL_KV_CACHE テスト | E-19 | ○ |
| C-65 | Register_SDPA テスト | E-19 | ○ |
| C-66 | GenAIOpsRegisterer テスト | E-19 | ○ |

### ml_adjacent モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Impl_Resize テスト | E-20 | ○ |
| C-68 | Resize処理の正常系テスト | E-20 | ○ |
| C-69 | Impl_CenterCrop テスト | E-21 | ○ |
| C-70 | CenterCrop処理テスト | E-21 | ○ |
| C-71 | Impl_CropToBoundingBox テスト | E-21 | ○ |
| C-72 | TypeWidth テスト | E-22 | ○ |

### microfrontend モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | FrontendProcessSamples 正常系テスト | E-23 | ○ |
| C-74 | FrontendProcessSamples サンプル不足テスト | E-23 | ○ |
| C-75 | FrontendReset テスト | E-23 | ○ |
| C-76 | FilterbankConvertFftComplexToEnergy テスト | E-24 | ○ |
| C-77 | FilterbankAccumulateChannels テスト | E-24 | ○ |
| C-78 | FilterbankSqrt テスト | E-24 | ○ |
| C-79 | FilterbankReset テスト | E-24 | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | microfrontend window.c内部関数テスト | **根拠なし** | △ |
| C-81 | microfrontend noise_reduction.c内部関数テスト | **根拠なし** | △ |
| C-82 | microfrontend pcan_gain_control.c内部関数テスト | **根拠なし** | △ |
| C-83 | microfrontend log_scale.c内部関数テスト | **根拠なし** | △ |
| C-84 | shlo ops floor/ceil境界値テスト | **根拠なし** | △ |
| C-85 | shlo ops trigonometric関数精度テスト | **根拠なし** | △ |
| C-86 | shlo ops quantized演算テスト | **根拠なし** | △ |
| C-87 | acceleration mini_benchmark プロセスクラッシュ時テスト | **根拠なし** | △ |
| C-88 | acceleration mini_benchmark 並行実行テスト | **根拠なし** | △ |
| C-89 | ml_adjacent flip_left_right テスト | **根拠なし** | △ |
| C-90 | ml_adjacent flip_up_down テスト | **根拠なし** | △ |
| C-91 | ml_adjacent rotate テスト | **根拠なし** | △ |
| C-92 | ml_adjacent rgb_to_grayscale テスト | **根拠なし** | △ |
| C-93 | ml_adjacent rgb_to_yuv テスト | **根拠なし** | △ |
| C-94 | ml_adjacent yuv_to_rgb テスト | **根拠なし** | △ |
| C-95 | ml_adjacent per_image_standardization テスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

### 内部実装の詳細が不明な領域
- **microfrontend内部関数**: window.c, noise_reduction.c, pcan_gain_control.c, log_scale.cの内部実装詳細
  - 候補：実装ソースコードの詳細解析 / 既存テストコードの参照 / ドキュメント確認

### テストシナリオが複雑な領域
- **プロセス間通信・並行処理**: mini_benchmarkの別プロセス実行、クラッシュリカバリ
  - 候補：統合テストでの検証 / モックを使用した単体テスト / E2Eテスト

### 追加の画像処理アルゴリズム
- **ml_adjacent追加アルゴリズム**: flip, rotate, color conversion等
  - 候補：各アルゴリズムのヘッダーファイル参照 / TensorFlow APIドキュメント参照

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 領域 | 理由 |
|-------------|------|------|
| 2（高） | mini_benchmark プロセス管理 | 別プロセスでの実行・クラッシュハンドリングのテストが困難 |
| 1（中） | shlo 量子化演算 | 量子化パラメータの組み合わせが多く、網羅性確保が困難 |
| 1（中） | microfrontend DSP処理 | 音声処理の数値精度検証が複雑 |
| 0（低） | resource管理 | シンプルなCRUD操作で検証容易 |
| 0（低） | GPU互換性リスト | 静的データの参照のみで検証容易 |

## 6) レビュアーチェックリスト（最小）

- [ ] GPUCompatibilityList の Create メソッドで null データを渡した際の挙動が正しく定義されているか
- [ ] ValidatorRunner のタイムアウト処理が適切にテストケースに含まれているか
- [ ] FlatbufferStorage の破損ファイル検出ロジックが十分にカバーされているか
- [ ] ResourceVariable の AssignFrom で異なるテンソル型を渡した場合のエラー処理
- [ ] StaticHashtable の型チェックが全ての対応型で検証されているか
- [ ] CacheBuffer の Initialize で無効な形状を渡した場合のエラー処理
- [ ] AbsOp/CompareOp の量子化テンソルに対する動作が検証されているか
- [ ] GenAI オペレータの登録が重複呼び出し時に問題ないか
- [ ] ml_adjacent アルゴリズムの境界条件（1x1画像、極端なサイズ等）が検証されているか
- [ ] microfrontend の FFT/フィルターバンク処理の数値精度が検証されているか
