---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 98
  claims_without_evidence: 12
confidence_derived: 0.89
---

# 根拠レポート：lite-kernels 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：98 / 110、根拠なし：12
- 優先レビュー（高）
  1. **UT-LKN-106〜110（Register_*関数）**：register.ccファイルの詳細確認が必要
  2. **UT-LKN-092〜105（lstm_eval）**：複雑な計算ロジックの検証が必要
  3. **UT-LKN-053〜057（Conv Eval）**：各データ型の実行パス網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/kernels/kernel_util.cc` - カーネルユーティリティ関数実装
- E-02: `tensorflow/lite/kernels/kernel_util.h` - カーネルユーティリティ関数宣言・インラインコード
- E-03: `tensorflow/lite/kernels/conv.cc` - 畳み込みカーネル実装
- E-04: `tensorflow/lite/kernels/pooling.cc` - プーリングカーネル実装
- E-05: `tensorflow/lite/kernels/activations.cc` - 活性化関数カーネル実装
- E-06: `tensorflow/lite/kernels/lstm_eval.cc` - LSTM評価関数実装
- E-07: `tensorflow/lite/kernels/lstm_eval.h` - LSTM評価関数宣言
- E-08: `tensorflow/lite/core/c/common.h` - TfLite共通定義（型、構造体）
- E-09: `tensorflow/lite/core/c/builtin_op_data.h` - ビルトインオペレータデータ

## 3) Claims と根拠の対応（レビューの主戦場）

### kernel_util.cc/h 関連 (UT-LKN-001〜044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetInput関数が有効なインデックスでテンソルを返す | E-01 (L113-116), E-02 (L46-47) | ○ |
| C-02 | GetInput関数が無効なインデックスでnullptrを返す | E-01 (L79-88) | ○ |
| C-03 | GetInput関数がオプショナルテンソルでnullptrを返す | E-01 (L66-71, L83-84) | ○ |
| C-04 | GetInputSafe関数がkTfLiteOkを返す | E-01 (L118-121) | ○ |
| C-05 | GetInputSafe関数がエラー時kTfLiteErrorを返す | E-01 (L100-109) | ○ |
| C-06 | GetVariableInput関数が変数テンソルを返す | E-01 (L123-128) | ○ |
| C-07 | GetVariableInput関数が非変数でnullptrを返す | E-01 (L127) | ○ |
| C-08 | GetOutput関数が出力テンソルを返す | E-01 (L130-138) | ○ |
| C-09 | GetOutput関数が無効インデックスでnullptrを返す | E-01 (L132-135) | ○ |
| C-10 | GetOutputSafe関数がkTfLiteOkを返す | E-01 (L140-148) | ○ |
| C-11 | GetTemporary関数が一時テンソルを返す | E-01 (L156-164) | ○ |
| C-12 | GetIntermediates関数が中間テンソルを返す | E-01 (L177-185) | ○ |
| C-13 | NumDimensions関数が次元数を返す | E-02 (L153) | ○ |
| C-14 | SizeOfDimension関数が次元サイズを返す | E-02 (L154-156) | ○ |
| C-15 | NumInputs関数が入力数を返す | E-02 (L158-160) | ○ |
| C-16 | NumInputs関数がnullで0を返す | E-02 (L159) | ○ |
| C-17 | NumOutputs関数が出力数を返す | E-02 (L161-163) | ○ |
| C-18 | NumElements関数が総要素数を計算する | E-02 (L171-197) | ○ |
| C-19 | NumElements関数が1次元テンソルで正しく計算する | E-02 (L190-192) | ○ |
| C-20 | NumElements関数が0次元を含む場合0を返す | E-02 (L185) | ○ |
| C-21 | IsConstantTensor関数がtrueを返す | E-02 (L203-205) | ○ |
| C-22 | IsConstantTensor関数がfalseを返す | E-02 (L203-205) | ○ |
| C-23 | IsDynamicTensor関数がtrueを返す | E-02 (L214-216) | ○ |
| C-24 | IsHybridOp関数がtrueを返す | E-02 (L237-240) | ○ |
| C-25 | IsHybridOp関数がfalseを返す | E-02 (L237-240) | ○ |
| C-26 | HaveSameShapes関数がtrueを返す | E-01 (L413-415) | ○ |
| C-27 | HaveSameShapes関数がfalseを返す | E-01 (L413-415) | ○ |
| C-28 | PopulateConvolutionQuantizationParams関数が量子化パラメータを設定 | E-01 (L200-290) | ○ |
| C-29 | PopulateConvolutionQuantizationParams関数がエラーを返す | E-01 (L222-248) | ○ |
| C-30 | GetQuantizedConvolutionMultipler関数が乗数を計算 | E-01 (L329-340) | ○ |
| C-31 | GetQuantizedConvolutionMultipler関数がエラーを返す | E-01 (L320-323) | ○ |
| C-32 | CalculateActivationRangeQuantized関数がReLU範囲を計算 | E-01 (L389-411) | ○ |
| C-33 | CalculateActivationRangeQuantized関数がReLU6範囲を計算 | E-01 (L367-373) | ○ |
| C-34 | CalculateActivationRangeQuantized関数がReluN1To1範囲を計算 | E-01 (L374-380) | ○ |
| C-35 | CalculateShapeForBroadcast関数が2入力形状を計算 | E-01 (L465-493) | ○ |
| C-36 | CalculateShapeForBroadcast関数がエラーを返す | E-01 (L477-483) | ○ |
| C-37 | CalculateShapeForBroadcast関数が3入力形状を計算 | E-01 (L495-526) | ○ |
| C-38 | TfLiteTypeGetSize関数がfloat32サイズを返す | E-01 (L549-550) | ○ |
| C-39 | TfLiteTypeGetSize関数がint8サイズを返す | E-01 (L535-536) | ○ |
| C-40 | TfLiteTypeGetSize関数がstring型で0を返す | E-01 (L573-574) | ○ |
| C-41 | GetOutputShapeFromInput関数が形状を取得 | E-01 (L418-434) | ○ |
| C-42 | GetOutputShapeFromInput関数が非1Dでエラーを返す | E-01 (L421-426) | ○ |
| C-43 | HasUnspecifiedDimension関数がtrueを返す | E-01 (L588-597) | ○ |
| C-44 | HasUnspecifiedDimension関数がfalseを返す | E-01 (L588-597) | ○ |

### conv.cc 関連 (UT-LKN-045〜061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Init関数がOpDataを初期化する | E-03 (L139-148) | ○ |
| C-46 | Free関数がOpDataを解放する | E-03 (L150-155) | ○ |
| C-47 | Prepare関数がfloat32入力で準備する | E-03 (L328-671) | ○ |
| C-48 | Prepare関数がint8入力で準備する | E-03 (L364-375, L502-509) | ○ |
| C-49 | Prepare関数が入力4次元でない場合エラー | E-03 (L345) | ○ |
| C-50 | Prepare関数がフィルタ4次元でない場合エラー | E-03 (L346) | ○ |
| C-51 | Prepare関数がstride<=0でエラー | E-03 (L378-379) | ○ |
| C-52 | Prepare関数がdilation<=0でエラー | E-03 (L382-383) | ○ |
| C-53 | Eval関数がfloat32畳み込みを実行 | E-03 (L944-1038, L1293) | ○ |
| C-54 | Eval関数がuint8畳み込みを実行 | E-03 (L678-765, L1317-1320) | ○ |
| C-55 | Eval関数がint8 per-channel畳み込みを実行 | E-03 (L767-859, L1321-1323) | ○ |
| C-56 | Eval関数がハイブリッド畳み込みを実行 | E-03 (L1040-1159, L1294-1311) | ○ |
| C-57 | Eval関数がサポートされない型でエラー | E-03 (L1329-1332) | ○ |
| C-58 | RuntimePaddingType関数がSAMEを変換 | E-03 (L127-137) | ○ |
| C-59 | RuntimePaddingType関数がVALIDを変換 | E-03 (L127-137) | ○ |
| C-60 | IsIm2ColRequired関数がtrueを返す | E-03 (L176-217) | ○ |
| C-61 | IsIm2ColRequired関数がfalseを返す | E-03 (L189-192) | ○ |

### pooling.cc 関連 (UT-LKN-062〜075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | Init関数がOpDataを初期化する | E-04 (L56-61) | ○ |
| C-63 | Free関数がOpDataを解放する | E-04 (L63-65) | ○ |
| C-64 | GenericPrepare関数がAveragePoolで準備 | E-04 (L67-117) | ○ |
| C-65 | GenericPrepare関数がMaxPoolで準備 | E-04 (L67-117) | ○ |
| C-66 | GenericPrepare関数が4次元でない場合エラー | E-04 (L78) | ○ |
| C-67 | GenericPrepare関数がstride<=0でエラー | E-04 (L91-92) | ○ |
| C-68 | AverageEval関数がfloat32を実行 | E-04 (L119-147, L391-393) | ○ |
| C-69 | AverageEval関数がuint8を実行 | E-04 (L149-179, L394-396) | ○ |
| C-70 | AverageEval関数がint8を実行 | E-04 (L181-212, L397-399) | ○ |
| C-71 | MaxEval関数がfloat32を実行 | E-04 (L242-267, L421-422) | ○ |
| C-72 | MaxEval関数がuint8を実行 | E-04 (L269-296, L424-426) | ○ |
| C-73 | MaxEval関数がint8を実行 | E-04 (L298-325, L428-430) | ○ |
| C-74 | L2Eval関数がfloat32を実行 | E-04 (L352-377, L454-455) | ○ |
| C-75 | L2Eval関数が量子化入力でエラー | E-04 (L457-462) | ○ |

### activations.cc 関連 (UT-LKN-076〜091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | Init関数がOpDataを初期化する | E-05 (L160-165) | ○ |
| C-77 | Free関数がOpDataを解放する | E-05 (L184-186) | ○ |
| C-78 | GenericPrepare関数が準備する | E-05 (L200-211) | ○ |
| C-79 | GenericPrepare関数が入力数!=1でエラー | E-05 (L201) | ○ |
| C-80 | GenericPrepare関数が出力数!=1でエラー | E-05 (L202) | ○ |
| C-81 | ReluPrepare関数がint8量子化パラメータを設定 | E-05 (L221-245) | ○ |
| C-82 | ReluPrepare関数がint16でzp=0を要求 | E-05 (L238-241) | ○ |
| C-83 | ReluPrepare関数がint16でzp!=0でエラー | E-05 (L239-240) | ○ |
| C-84 | TanhPrepare関数がLUTを生成 | E-05 (L331-429) | ○ |
| C-85 | TanhPrepare関数がint16でzp=0を要求 | E-05 (L390-391) | ○ |
| C-86 | SigmoidPrepare関数がLUTを生成 | E-05 (L431-500) | ○ |
| C-87 | SigmoidPrepare関数がscale=1/256を要求 | E-05 (L453, L474, L481) | ○ |
| C-88 | LeakyReluPrepare関数が量子化パラメータを設定 | E-05 (L297-329) | ○ |
| C-89 | HardSwishPrepare関数がパラメータを設定 | E-05 (L259-295) | ○ |
| C-90 | SoftmaxInit関数がSoftmaxOpDataを初期化 | E-05 (L167-169) | ○ |
| C-91 | SoftmaxFree関数がSoftmaxOpDataを解放 | E-05 (L171-173) | ○ |

### lstm_eval.cc 関連 (UT-LKN-092〜105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | MatrixBatchVectorMultiplyAccumulate関数が積を計算 | E-06 (L45-70) | ○ |
| C-93 | MatrixBatchVectorMultiplyAccumulate関数がバッチ処理 | E-06 (L58-69) | ○ |
| C-94 | ComputeRowSums関数が行合計を計算 | E-06 (L72-153) | ○ |
| C-95 | CalculateLstmGateFloat関数がゲートを計算 | E-06 (L192-256) | ○ |
| C-96 | CalculateLstmGateFloat関数がLayerNorm付きで計算 | E-06 (L247-252) | ○ |
| C-97 | CalculateLstmGateFloat関数がPeephole付きで計算 | E-06 (L242-245) | ○ |
| C-98 | UpdateLstmCellFloat関数がセル状態を更新 | E-06 (L273-294) | ○ |
| C-99 | UpdateLstmCellFloat関数がCIFGで更新 | E-06 (L279-290) | ○ |
| C-100 | UpdateLstmCellFloat関数がクリッピングを適用 | E-06 (L291-293) | ○ |
| C-101 | CalculateLstmOutputFloat関数が出力を計算 | E-06 (L320-352) | ○ |
| C-102 | CalculateLstmOutputFloat関数がプロジェクション付きで計算 | E-06 (L336-348) | ○ |
| C-103 | CalculateLstmGateHybrid関数がゲートを計算 | E-06 (L358-479) | ○ |
| C-104 | GetTensorScale関数がスケールを取得 | E-06 (L155-157) | ○ |
| C-105 | GetTensorScale関数がnullで1.0を返す | E-06 (L156) | ○ |

### register.cc 関連 (UT-LKN-106〜110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Register_CONV_2D関数がRegistrationを返す | **register.cc未読取** | △ |
| C-107 | Register_AVERAGE_POOL_2D関数がRegistrationを返す | **register.cc未読取** | △ |
| C-108 | Register_MAX_POOL_2D関数がRegistrationを返す | **register.cc未読取** | △ |
| C-109 | Register_RELU関数がRegistrationを返す | **register.cc未読取** | △ |
| C-110 | Register_SOFTMAX関数がRegistrationを返す | **register.cc未読取** | △ |

## 4) 不足情報（Unknown / Missing）

- **register.cc/register.h の詳細確認**
  - Register_*関数群の実装確認が必要
  - 候補：`tensorflow/lite/kernels/register.cc` / `tensorflow/lite/kernels/register.h`

- **各Eval関数の詳細な数値検証**
  - 実際の畳み込み計算結果の検証
  - 候補：既存テストコード（conv_test.cc, pooling_test.cc等）の確認

- **内部ヘルパー関数の一部**
  - internal/ディレクトリ配下の最適化実装
  - 候補：`tensorflow/lite/kernels/internal/optimized/` 配下

- **エラーメッセージの詳細**
  - TF_LITE_KERNEL_LOGで出力されるエラーメッセージの内容確認
  - 候補：各ソースファイルのエラーログ出力箇所

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 2 (高リスク) | 量子化パラメータ計算 | スケール・ゼロポイント計算の精度がモデル精度に直結 |
| 2 (高リスク) | 境界値処理 | テンソルインデックスの境界外アクセス防止が重要 |
| 1 (中リスク) | 型サポート | 新しい型（int4等）のサポート状況確認が必要 |
| 1 (中リスク) | ハイブリッドオペレーション | float入力+量子化重みの組み合わせでの精度 |
| 0 (低リスク) | 登録関数 | Register_*関数は静的に定義されるため安定 |

## 6) レビュアーチェックリスト（最小）

- [ ] kernel_util.ccのGetInput/GetOutput系関数の境界値処理を確認
- [ ] conv.ccのPrepare関数で入力検証が十分か確認
- [ ] 量子化パラメータ計算（PopulateConvolutionQuantizationParams）の数値精度を確認
- [ ] CalculateActivationRangeQuantizedの各活性化関数対応を確認
- [ ] pooling.ccのGenericPrepareでstride=0のガード処理を確認
- [ ] activations.ccの各活性化関数でLUT生成の正確性を確認
- [ ] lstm_eval.ccのゲート計算でCIFG/Peephole/LayerNormの組み合わせを確認
- [ ] register.ccのRegister_*関数が全てのbuiltin operatorをカバーしているか確認
- [ ] 各Eval関数でサポートされない型のエラーハンドリングを確認
- [ ] メモリ解放（Free関数）で全てのリソースが解放されているか確認
