---
generated_at: 2026-02-03 12:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lite-nnapi 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tensorflow/lite/nnapi/nnapi_implementation.h` - NnApi構造体定義、NnApiImplementation関数宣言
- E-02: `tensorflow/lite/nnapi/nnapi_implementation.cc` - NnApiImplementation関数実装、LoadNnApi関数、LoadFunction関数、CalculateAndroidSdkVersion関数、CreateNnApiFromSupportLibrary関数
- E-03: `tensorflow/lite/nnapi/nnapi_implementation_disabled.cc` - 無効化版NnApiImplementation、CreateNnApiFromSupportLibrary
- E-04: `tensorflow/lite/nnapi/nnapi_handler.h` - NnApiHandlerクラス宣言、各種テンプレートメソッド
- E-05: `tensorflow/lite/nnapi/nnapi_handler.cc` - NnApiHandler::Instance、Reset、SetAndroidSdkVersion、SetDeviceName、SetNnapiSupportedDevice等
- E-06: `tensorflow/lite/nnapi/nnapi_util.h` - GetDeviceNamesList、GetStringDeviceNamesList関数宣言
- E-07: `tensorflow/lite/nnapi/nnapi_util.cc` - GetDeviceNamesList、GetStringDeviceNamesList、SimpleJoin関数実装
- E-08: `tensorflow/lite/nnapi/sl/include/SupportLibrary.h` - NnApiSupportLibrary構造体、loadNnApiSupportLibrary宣言
- E-09: `tensorflow/lite/nnapi/sl/SupportLibrary.cc` - loadNnApiSupportLibrary実装
- E-10: `tensorflow/lite/nnapi/NeuralNetworksShim.h` - NNAPIExists、loadLibrary、loadFunction、ASharedMemory_create関数
- E-11: `tensorflow/lite/nnapi/NeuralNetworksTypes.h` - NNAPI型定義、エラーコード、Feature Level定義

## 3) Claims と根拠の対応（レビューの主戦場）

### nnapi_implementation.cc 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NNAPIライブラリが存在する場合にNnApiポインタが返却されること | E-02 (LoadNnApi関数 line 175-434) | ○ |
| C-02 | 同一プロセス内で同じインスタンスが返却されること | E-02 (static変数によるシングルトン) | ○ |
| C-03 | NNAPIライブラリが存在しない場合にnnapi_existsがfalseであること | E-02 (line 216: nnapi_exists = libneuralnetworks != nullptr) | ○ |
| C-04 | Android SDK 27以上でNNAPIがロードされること | E-02 (line 181-186) | ○ |
| C-05 | Android SDK 26の場合にNNAPIがロードされないこと | E-02 (line 181: if sdk < 27) | ○ |
| C-06 | Android SDK 27の場合にNNAPIがロードされること | E-02 (line 181: >= 27 check) | ○ |
| C-07 | Isolated processの場合にNNAPIが無効化されること | E-02 (line 189-193: IsIsolatedProcess check) | ○ |
| C-08 | 存在する関数が正常にロードされること | E-02 (LoadFunction line 73-82) | ○ |
| C-09 | ハンドルがnullptrの場合にnullptrが返却されること | E-02 (LoadFunction line 74-76) | ○ |
| C-10 | 存在しない必須関数の場合にエラーログが出力されること | E-02 (line 78-80: NNAPI_LOG) | ○ |
| C-11 | オプショナル関数が存在しない場合にログなしでnullptrが返却されること | E-02 (LoadFunction optional parameter) | ○ |
| C-12 | NNAPI 1.0のみの場合にSDK 27が返却されること | E-02 (CalculateAndroidSdkVersion line 107-132) | ○ |
| C-13 | NNAPI 1.1の場合にSDK 28が返却されること | E-02 (line 120-121) | ○ |
| C-14 | NNAPI 1.2の場合にSDK 29が返却されること | E-02 (line 122-124) | ○ |
| C-15 | NNAPI 1.3の場合にSDK 30が返却されること | E-02 (line 125-127) | ○ |
| C-16 | NNAPI 1.4の場合にSDK 31が返却されること | E-02 (line 128-131) | ○ |
| C-17 | サポートライブラリからNnApiが正常に生成されること | E-02 (CreateNnApiFromSupportLibrary line 438-558) | ○ |
| C-18 | feature levelが正しく設定されること | E-02 (line 443-444) | ○ |
| C-19 | ANeuralNetworksCompilation_createがnullptrであること | E-02 (line 467) | ○ |
| C-20 | ANeuralNetworksExecution_startComputeがnullptrであること | E-02 (line 478) | ○ |

### nnapi_implementation_disabled.cc 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 無効化版でnnapi_existsがfalseであること | E-03 (line 21-24: static const NnApi nnapi = {}) | ○ |
| C-22 | 無効化版でも空のNnApiが返却されること | E-03 (line 26-31) | ○ |

### nnapi_handler.cc 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | シングルトンインスタンスが返却されること | E-05 (Instance line 42-48) | ○ |
| C-24 | Resetでオリジナルの動作に戻ること | E-05 (Reset line 50-53) | ○ |
| C-25 | SDKバージョンが正しく設定されること | E-05 (SetAndroidSdkVersion line 55-91) | ○ |
| C-26 | SDK 29未満の場合に未サポート関数がnullptrになること | E-05 (line 64-87) | ○ |
| C-27 | SDK 28未満の場合にrelaxComputationFloat32toFloat16がnullptrになること | E-05 (line 88-90) | ○ |
| C-28 | デバイス名が正しく設定されること | E-05 (SetDeviceName line 93-97) | ○ |
| C-29 | 既存のデバイス名が上書きされること | E-05 (line 94: delete[] nnapi_device_name_) | ○ |
| C-30 | デバイス名を取得するスタブが設定されること | E-05 (GetDeviceNameReturnsName line 99-102) | ○ |
| C-31 | サポートデバイスが正しく設定されること | E-05 (SetNnapiSupportedDevice line 104-155) | ○ |
| C-32 | デバイス数が2として設定されること | E-05 (line 109: GetDeviceCountReturnsCount<2>) | ○ |
| C-33 | devIndex=0でnnapi-referenceが返却されること | E-05 (line 119-122) | ○ |
| C-34 | devIndex=1で設定したデバイスが返却されること | E-05 (line 116-118) | ○ |
| C-35 | devIndex>1の場合にBAD_DATAが返却されること | E-05 (line 112-114) | ○ |
| C-36 | テンプレート引数で指定した値がGetDeviceCountから返却されること | E-04 (GetDeviceCountReturns line 52-58) | ○ |
| C-37 | デバイス数が正しく設定されること | E-04 (GetDeviceCountReturnsCount line 60-66) | ○ |
| C-38 | テンプレート引数で指定した値がModelCreateから返却されること | E-04 (ModelCreateReturns line 107-113) | ○ |
| C-39 | Compilationポインタが設定されること | E-04 (CompilationCreateReturns line 184-192) | ○ |
| C-40 | Executionポインタが設定されること | E-04 (ExecutionCreateReturns line 217-226) | ○ |
| C-41 | compilationがnullptrの場合に1が返却されること | E-04 (line 222) | ○ |
| C-42 | オリジナルのNnApiコピーが返却されること | E-05 (NnApiPassthroughInstance line 36-39) | ○ |

### nnapi_util.cc 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | デバイス名リストが返却されること | E-07 (GetDeviceNamesList line 46-70) | ○ |
| C-44 | カスタムNnApiを使用してデバイス一覧を取得できること | E-07 (line 50-70) | ○ |
| C-45 | ANeuralNetworks_getDeviceCountがnullptrの場合に空リストが返却されること | E-07 (line 55) | ○ |
| C-46 | デバイス数が0の場合に空リストが返却されること | E-07 (line 60 loop condition) | ○ |
| C-47 | 複数デバイスの場合に全デバイス名が返却されること | E-07 (line 60-66 for loop) | ○ |
| C-48 | カンマ区切りのデバイス名文字列が返却されること | E-07 (GetStringDeviceNamesList line 72-78) | ○ |
| C-49 | デバイスがない場合に空文字列が返却されること | E-07 (SimpleJoin空vector処理) | ○ |
| C-50 | デバイスが1つの場合にカンマなしの文字列が返却されること | E-07 (SimpleJoin line 34条件) | ○ |
| C-51 | 複数要素がセパレータで結合されること | E-07 (SimpleJoin line 29-42) | ○ |
| C-52 | 空のvectorの場合に空文字列が返却されること | E-07 (line 33 begin==end) | ○ |
| C-53 | 1要素のvectorの場合にセパレータなしで返却されること | E-07 (line 34 it != begin条件) | ○ |
| C-54 | nullptr要素がスキップされること | E-07 (line 37-39 if (*it)) | ○ |

### SupportLibrary.cc 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ライブラリ名から正常にロードできること | E-09 (loadNnApiSupportLibrary(string) line 34-48) | ○ |
| C-56 | 存在しないライブラリの場合にnullptrが返却されること | E-09 (line 37-41) | ○ |
| C-57 | ハンドルから正常にロードできること | E-09 (loadNnApiSupportLibrary(void*) line 50-90) | ○ |
| C-58 | ANeuralNetworks_getSLDriverImplシンボルがない場合にnullptrが返却されること | E-09 (line 55-59) | ○ |
| C-59 | getSlDriverImplがnullptrを返す場合にnullptrが返却されること | E-09 (line 62-66) | ○ |
| C-60 | Feature Level 5の場合にNnApiSupportLibraryが返却されること | E-09 (line 76-78) | ○ |
| C-61 | Feature Level 6の場合にNnApiSupportLibraryが返却されること | E-09 (line 80-82) | ○ |
| C-62 | Feature Level 7の場合にNnApiSupportLibraryが返却されること | E-09 (line 84-86) | ○ |
| C-63 | Feature Level 5未満の場合にnullptrが返却されること | E-09 (line 68-74) | ○ |
| C-64 | Feature Level 7超過の場合にnullptrが返却されること | E-09 (line 69 > FEATURE_LEVEL_7条件) | ○ |

### SupportLibrary.h 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Feature Levelが正しく返却されること | E-08 (getFeatureLevel line 67) | ○ |
| C-66 | FL5ドライバポインタが返却されること | E-08 (getFL5 line 69) | ○ |
| C-67 | FL6ドライバポインタが返却されること | E-08 (getFL6 line 70-73) | ○ |
| C-68 | Feature Level 5でgetFL6を呼ぶとアサーション失敗すること | E-08 (TFLITE_CHECK_GE line 71) | ○ |
| C-69 | FL7ドライバポインタが返却されること | E-08 (getFL7 line 74-77) | ○ |
| C-70 | Feature Level 6以下でgetFL7を呼ぶとアサーション失敗すること | E-08 (TFLITE_CHECK_GE line 75) | ○ |
| C-71 | デストラクタでlibHandleがクローズされること | E-08 (~NnApiSupportLibrary line 58-63) | ○ |
| C-72 | libHandleがnullptrの場合にデストラクタが安全に実行されること | E-08 (line 59: if != nullptr check) | ○ |

### NeuralNetworksShim.h 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | NNAPIが利用可能な場合にtrueが返却されること | E-10 (NNAPIExists line 82-85) | ○ |
| C-74 | NNAPIが利用不可の場合にfalseが返却されること | E-10 (line 83-84) | ○ |
| C-75 | Androidでライブラリがロードされること | E-10 (loadLibrary line 41-52) | ○ |
| C-76 | 非Androidでnullptrが返却されること | E-10 (line 43-51 #ifdef __ANDROID__) | ○ |
| C-77 | 存在する関数がロードされること | E-10 (loadFunction line 71-80) | ○ |
| C-78 | ライブラリハンドルがnullptrの場合にnullptrが返却されること | E-10 (line 73 if check) | ○ |
| C-79 | 共有メモリが作成されること | E-10 (ASharedMemory_create line 56-64) | ○ |
| C-80 | libandroid.soがロードできない場合に-1が返却されること | E-10 (line 62: fn != nullptr ? fn(...) : -1) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコード根拠が存在するため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード解析に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがモジュール内の主要な公開関数を網羅しているか確認
- [ ] 境界値テストが適切に設計されているか確認（SDK version 26/27、Feature Level 5-7）
- [ ] 異常系テストがnullptr、存在しないリソース、無効なパラメータをカバーしているか確認
- [ ] シングルトンパターンのテストが含まれているか確認
- [ ] プラットフォーム依存（Android/非Android）のテストが含まれているか確認
- [ ] NNAPI無効化ビルドのテストが含まれているか確認
