---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：lite-profiling 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの関数・メソッド定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・関数・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-PRF-091~098 (ATraceProfiler)**: Android固有の動作でテスト環境に依存
  2. **UT-PRF-099~104 (SignpostProfiler)**: Apple固有の動作でテスト環境に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/profiling/time.h` - NowMicros, SleepForMicros関数宣言
- E-02: `tensorflow/lite/profiling/time.cc` - NowMicros, SleepForMicros関数実装
- E-03: `tensorflow/lite/profiling/profile_buffer.h` - ProfileBuffer クラス定義
- E-04: `tensorflow/lite/profiling/profile_buffer.cc` - ProfileBuffer メソッド実装
- E-05: `tensorflow/lite/profiling/memory_info.h` - MemoryUsage構造体、GetMemoryUsage関数宣言
- E-06: `tensorflow/lite/profiling/memory_info.cc` - MemoryUsage、GetMemoryUsage実装
- E-07: `tensorflow/lite/profiling/memory_usage_monitor.h` - MemoryUsageMonitor クラス定義
- E-08: `tensorflow/lite/profiling/memory_usage_monitor.cc` - MemoryUsageMonitor実装
- E-09: `tensorflow/lite/profiling/profile_summarizer.h` - ProfileSummarizerクラス定義
- E-10: `tensorflow/lite/profiling/profile_summarizer.cc` - ProfileSummarizer実装
- E-11: `tensorflow/lite/profiling/profile_summary_formatter.h` - フォーマッタクラス定義
- E-12: `tensorflow/lite/profiling/profile_summary_formatter.cc` - フォーマッタ実装
- E-13: `tensorflow/lite/profiling/root_profiler.h` - RootProfilerクラス定義
- E-14: `tensorflow/lite/profiling/root_profiler.cc` - RootProfiler実装
- E-15: `tensorflow/lite/profiling/buffered_profiler.h` - BufferedProfilerクラス定義
- E-16: `tensorflow/lite/profiling/noop_profiler.h` - NoopProfilerクラス定義
- E-17: `tensorflow/lite/profiling/atrace_profiler.h` - MaybeCreateATraceProfiler宣言
- E-18: `tensorflow/lite/profiling/atrace_profiler.cc` - ATraceProfiler実装
- E-19: `tensorflow/lite/profiling/signpost_profiler.h` - MaybeCreateSignpostProfiler宣言
- E-20: `tensorflow/lite/profiling/signpost_profiler.mm` - SignpostProfiler実装
- E-21: `tensorflow/lite/profiling/platform_profiler.h` - MaybeCreatePlatformProfiler宣言
- E-22: `tensorflow/lite/profiling/platform_profiler.cc` - MaybeCreatePlatformProfiler実装
- E-23: `tensorflow/lite/profiling/subgraph_tensor_profiler.h` - SubgraphTensorProfilerクラス定義
- E-24: `tensorflow/lite/profiling/subgraph_tensor_profiler.cc` - SubgraphTensorProfiler実装
- E-25: `tensorflow/lite/profiling/model_runtime_info.h` - GenerateModelRuntimeInfo宣言
- E-26: `tensorflow/lite/profiling/model_runtime_info.cc` - GenerateModelRuntimeInfo実装
- E-27: `tensorflow/lite/profiling/memory_latency_logger.h` - MemoryLatencyLoggerクラス定義
- E-28: `tensorflow/lite/profiling/memory_latency_logger.cc` - MemoryLatencyLogger実装
- E-29: `tensorflow/lite/profiling/telemetry/profiler.h` - TelemetryProfilerクラス定義
- E-30: `tensorflow/lite/profiling/telemetry/profiler.cc` - TelemetryProfiler実装
- E-31: `tensorflow/lite/profiling/telemetry/telemetry.h` - Telemetry関数宣言
- E-32: `tensorflow/lite/profiling/telemetry/telemetry.cc` - Telemetry関数実装
- E-33: `tensorflow/lite/profiling/telemetry/telemetry_status.h` - TelemetryStatusCode構造体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-PRF-001~004) | time::NowMicros, SleepForMicrosのテストケース | E-01, E-02 | ○ |
| C-02 (UT-PRF-005~024) | ProfileBufferクラスのテストケース | E-03, E-04 | ○ |
| C-03 (UT-PRF-025~030) | MemoryUsage、GetMemoryUsageのテストケース | E-05, E-06 | ○ |
| C-04 (UT-PRF-031~042) | MemoryUsageMonitorクラスのテストケース | E-07, E-08 | ○ |
| C-05 (UT-PRF-043~054) | ProfileSummarizerクラスのテストケース | E-09, E-10 | ○ |
| C-06 (UT-PRF-055~063) | ProfileSummaryFormatterクラス群のテストケース | E-11, E-12 | ○ |
| C-07 (UT-PRF-064~075) | RootProfilerクラスのテストケース | E-13, E-14 | ○ |
| C-08 (UT-PRF-076~087) | BufferedProfilerクラスのテストケース | E-15 | ○ |
| C-09 (UT-PRF-088~090) | NoopProfilerクラスのテストケース | E-16 | ○ |
| C-10 (UT-PRF-091~098) | ATraceProfilerのテストケース | E-17, E-18 | ○ |
| C-11 (UT-PRF-099~104) | SignpostProfilerのテストケース | E-19, E-20 | ○ |
| C-12 (UT-PRF-105~107) | MaybeCreatePlatformProfilerのテストケース | E-21, E-22 | ○ |
| C-13 (UT-PRF-108~113) | SubgraphTensorProfilerクラスのテストケース | E-23, E-24 | ○ |
| C-14 (UT-PRF-114~120) | GenerateModelRuntimeInfoのテストケース | E-25, E-26 | ○ |
| C-15 (UT-PRF-121~126) | MemoryLatencyLoggerクラスのテストケース | E-27, E-28 | ○ |
| C-16 (UT-PRF-127~137) | TelemetryProfilerクラスのテストケース | E-29, E-30 | ○ |
| C-17 (UT-PRF-138~144) | Telemetry関数群のテストケース | E-31, E-32 | ○ |
| C-18 (UT-PRF-145~150) | TelemetryStatusCodeのテストケース | E-33 | ○ |
| C-19 (UT-PRF-091~092) | ATraceProfilerのdlopen動作 | E-18 | △ |
| C-20 (UT-PRF-099~100) | SignpostProfilerのos_log動作 | E-20 | △ |

## 4) 不足情報（Unknown / Missing）
- **プラットフォーム固有の動作検証**
  - ATraceProfilerはAndroid環境でのみ完全にテスト可能
  - SignpostProfilerはmacOS/iOS環境でのみ完全にテスト可能
  - 候補：モックを使用したプラットフォーム抽象化テスト / 実機テスト / エミュレータテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - time, memory_info, profile_buffer: 基本的なユーティリティ機能で複雑な依存関係なし
- **1: 中リスク** - profile_summarizer, profile_summary_formatter: Interpreterへの依存があり、モック必要
- **1: 中リスク** - memory_usage_monitor: マルチスレッド動作のテストが必要
- **1: 中リスク** - telemetry系: C API構造体との連携テストが必要
- **2: 高リスク** - atrace_profiler, signpost_profiler, platform_profiler: プラットフォーム固有でテスト環境の準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値・期待結果がソースコードの実装と整合しているか確認
- [ ] 境界値テストが適切なパラメータ範囲をカバーしているか確認
- [ ] 異常系テストがエラーハンドリングを網羅しているか確認
- [ ] プラットフォーム固有のテストケース（Android/iOS）の実行方法を確認
- [ ] マルチスレッド関連のテストケース（MemoryUsageMonitor）で競合状態がカバーされているか確認
- [ ] モックが必要なテストケース（Interpreter依存）の実装方針を確認
- [ ] telemetry系のC API連携テストの方針を確認
