---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：lite-python単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **C-043 InterpreterWithCustomOps初期化**：カスタムオペレータ登録の実行時動作は実環境依存
  2. **C-058 _quantize量子化実行**：実際の量子化結果はモデルとデータ依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/python/interpreter.py` - Interpreter、Delegate、SignatureRunnerクラス定義
- E-02: `tensorflow/lite/python/lite.py` - TFLiteConverter、Optimize、TargetSpec、QuantizationModeクラス定義
- E-03: `tensorflow/lite/python/convert.py` - OpsSet、convert関数、build_conversion_flags関数
- E-04: `tensorflow/lite/python/util.py` - ユーティリティ関数群（get_tensor_name、freeze_graph等）
- E-05: `tensorflow/lite/python/analyzer.py` - ModelAnalyzerクラス
- E-06: `tensorflow/lite/python/optimize/calibrator.py` - Calibratorクラス
- E-07: `tensorflow/lite/python/authoring/authoring.py` - _Compatible、compatible関数
- E-08: `tensorflow/lite/python/convert_phase.py` - Component、SubComponent、ConverterError、convert_phase
- E-09: `tensorflow/lite/python/tflite_convert.py` - CLI変換関数群
- E-10: `tensorflow/lite/python/lite_constants.py` - 定数定義
- E-11: `tensorflow/lite/python/metrics/metrics_interface.py` - TFLiteMetricsInterface抽象クラス

## 3) Claims と根拠の対応（レビューの主戦場）

### interpreter.py関連（C-001 〜 C-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Delegate.__init__で有効なライブラリロード | E-01（65-116行目） | ○ |
| C-002 | CPython以外でRuntimeError | E-01（81-83行目） | ○ |
| C-003 | 無効ライブラリでValueError | E-01（115-116行目） | ○ |
| C-004 | _get_native_delegate_pointer | E-01（126-134行目） | ○ |
| C-005 | load_delegate正常系 | E-01（137-182行目） | ○ |
| C-006 | load_delegate異常系 | E-01（179-181行目） | ○ |
| C-007 | SignatureRunner.__init__正常系 | E-01（202-226行目） | ○ |
| C-008 | SignatureRunner interpreter None | E-01（210-211行目） | ○ |
| C-009 | SignatureRunner signature_key None | E-01（212-213行目） | ○ |
| C-010 | SignatureRunner無効なsignature_key | E-01（218-219行目） | ○ |
| C-011 | SignatureRunner.__call__正常系 | E-01（228-266行目） | ○ |
| C-012 | SignatureRunner入力数不正 | E-01（241-244行目） | ○ |
| C-013 | SignatureRunner無効な入力名 | E-01（248-250行目） | ○ |
| C-014 | get_input_details | E-01（268-298行目） | ○ |
| C-015 | get_output_details | E-01（300-312行目） | ○ |
| C-016 | Interpreter.__init__ model_path | E-01（483-501行目） | ○ |
| C-017 | Interpreter.__init__ model_content | E-01（502-522行目） | ○ |
| C-018 | 両方指定ValueError | E-01（525-526行目） | ○ |
| C-019 | 両方未指定ValueError | E-01（523-524行目） | ○ |
| C-020 | num_threads 0以下 | E-01（480-481行目） | ○ |
| C-021 | num_threads非整数 | E-01（478-479行目） | ○ |
| C-022 | 無効op_resolver_type | E-01（473-475行目） | ○ |
| C-023 | allocate_tensors | E-01（552-554行目） | ○ |
| C-024 | allocate_tensors RuntimeError | E-01（568-582行目） | ○ |
| C-025 | get_input_details | E-01（718-747行目） | ○ |
| C-026 | get_output_details | E-01（796-807行目） | ○ |
| C-027 | set_tensor | E-01（749-765行目） | ○ |
| C-028 | resize_tensor_input | E-01（767-794行目） | ○ |
| C-029 | resize_tensor_input RuntimeError | E-01（790行目） | ○ |
| C-030 | invoke | E-01（973-986行目） | ○ |
| C-031 | invoke RuntimeError | E-01（985行目） | ○ |
| C-032 | get_tensor | E-01（906-921行目） | ○ |
| C-033 | tensor | E-01（923-971行目） | ○ |
| C-034 | get_signature_list | E-01（809-834行目） | ○ |
| C-035 | get_signature_runner正常系 | E-01（859-904行目） | ○ |
| C-036 | get_signature_runner None単一 | E-01（896-903行目） | ○ |
| C-037 | get_signature_runner None複数 | E-01（897-901行目） | ○ |
| C-038 | get_tensor_details | E-01（690-716行目） | ○ |
| C-039 | get_tensor_details無効index | E-01（704-708行目） | ○ |
| C-040 | num_subgraphs | E-01（686-688行目） | ○ |
| C-041 | reset_all_variables | E-01（988-989行目） | ○ |
| C-042 | OpResolverType | E-01（315-357行目） | ○ |
| C-043 | InterpreterWithCustomOps | E-01（1014-1039行目） | △ |

### lite.py関連（C-044 〜 C-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-044 | Optimize Enum | E-02（112-167行目） | ○ |
| C-045 | RepresentativeDataset | E-02（171-192行目） | ○ |
| C-046 | TargetSpec デフォルト | E-02（195-241行目） | ○ |
| C-047 | TargetSpec カスタム | E-02（219-235行目） | ○ |
| C-048 | is_post_training_int8_quantization | E-02（299-321行目） | ○ |
| C-049 | is_post_training_float16_quantization | E-02（384-389行目） | ○ |
| C-050 | is_post_training_dynamic_range_quantization | E-02（374-382行目） | ○ |
| C-051 | is_quantization_aware_trained_model | E-02（593-611行目） | ○ |
| C-052 | activations_type | E-02（398-405行目） | ○ |
| C-053 | bias_type | E-02（407-416行目） | ○ |
| C-054 | converter_flags | E-02（418-483行目） | ○ |
| C-055 | _validate_int8_required | E-02（487-520行目） | ○ |
| C-056 | TFLiteConverterBase.__init__ | E-02（614-700行目） | ○ |
| C-057 | _grappler_config | E-02（701-724行目） | ○ |
| C-058 | _quantize | E-02（726-789行目） | △ |
| C-059 | _optimize_tflite_model | E-02（1127-1190行目） | ○ |
| C-060 | _validate_inference_input_output_types | E-02（1270-1295行目） | ○ |
| C-061 | _validate_inference_input_output_types異常 | E-02（1279-1294行目） | ○ |
| C-062 | convert | E-02（1456-1503行目） | ○ |
| C-063 | TFLiteSavedModelConverterV2.convert | E-02（1542-1590行目） | ○ |
| C-064 | TFLiteKerasModelConverterV2.convert | E-02（1593-1598行目） | ○ |

### convert.py関連（C-065 〜 C-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-065 | OpsSet Enum | E-03（151-198行目） | ○ |
| C-066 | OpsSet.get_options | E-03（195-198行目） | ○ |
| C-067 | convert_tensor_tf_type_to_tflite_type正常 | E-03（64-103行目） | ○ |
| C-068 | convert_tensor_tf_type_to_tflite_type異常 | E-03（97-102行目） | ○ |
| C-069 | convert_inference_tf_type_to_tflite_type正常 | E-03（108-136行目） | ○ |
| C-070 | convert_inference_tf_type_to_tflite_type異常 | E-03（130-135行目） | ○ |
| C-071 | mlir_quantize | E-03（201-265行目） | ○ |
| C-072 | mlir_sparsify | E-03（268-278行目） | ○ |
| C-073 | register_custom_opdefs | E-03（281-291行目） | ○ |
| C-074 | convert正常 | E-03（294-348行目） | ○ |
| C-075 | convert異常 | E-03（325-348行目） | ○ |
| C-076 | build_model_flags | E-03（351-394行目） | ○ |
| C-077 | build_conversion_flags正常 | E-03（397-723行目） | ○ |
| C-078 | build_conversion_flags異常 | E-03（596-598行目） | ○ |
| C-079 | StableHLO排他チェック | E-03（627-630行目） | ○ |
| C-080 | convert_graphdef_with_arrays | E-03（726-795行目） | ○ |

### util.py関連（C-081 〜 C-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-081 | get_tensor_name正常 | E-04（109-127行目） | ○ |
| C-082 | get_tensor_name異常 | E-04（119-121行目） | ○ |
| C-083 | get_tensors_from_tensor_names正常 | E-04（130-170行目） | ○ |
| C-084 | get_tensors_from_tensor_names無効名 | E-04（167-169行目） | ○ |
| C-085 | get_tensors_from_tensor_names非文字列 | E-04（154-158行目） | ○ |
| C-086 | set_tensor_shapes正常 | E-04（173-201行目） | ○ |
| C-087 | set_tensor_shapes無効テンソル | E-04（191-193行目） | ○ |
| C-088 | set_tensor_shapes互換性エラー | E-04（196-201行目） | ○ |
| C-089 | get_grappler_config | E-04（204-217行目） | ○ |
| C-090 | run_graph_optimizations | E-04（220-259行目） | ○ |
| C-091 | freeze_graph | E-04（273-311行目） | ○ |
| C-092 | is_frozen_graph True | E-04（314-329行目） | ○ |
| C-093 | is_frozen_graph False | E-04（326-328行目） | ○ |
| C-094 | convert_bytes_to_c_source | E-04（421-538行目） | ○ |
| C-095 | convert_bytes_to_c_sourceライセンス付き | E-04（465-481行目） | ○ |
| C-096 | modify_model_io_type | E-04（635-738行目） | ○ |

### analyzer.py関連（C-097 〜 C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-097 | analyze model_path | E-05（63-107行目） | ○ |
| C-098 | analyze model_content | E-05（93-96行目） | ○ |
| C-099 | analyze gpu_compatibility | E-05（106-107行目） | ○ |
| C-100 | analyze両方未指定 | E-05（87-88行目） | ○ |

### calibrator.py関連（C-101 〜 C-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | add_intermediate_tensors | E-06（38-40行目） | ○ |
| C-102 | Calibrator.__init__正常 | E-06（49-84行目） | ○ |
| C-103 | Calibrator.__init__ None | E-06（67-68行目） | ○ |
| C-104 | Calibrator.__init__無効モデル | E-06（80-81行目） | ○ |
| C-105 | calibrate | E-06（248-259行目） | ○ |
| C-106 | calibrate_and_quantize | E-06（154-205行目） | ○ |
| C-107 | _feed_tensors辞書 | E-06（116-121行目） | ○ |
| C-108 | _feed_tensorsタプル | E-06（102-115行目） | ○ |
| C-109 | _feed_tensorsリスト | E-06（122-124行目） | ○ |
| C-110 | _feed_tensors無効形式 | E-06（125-132行目） | ○ |
| C-111 | _feed_tensorsタプル不正 | E-06（103-108行目） | ○ |

### authoring.py関連（C-112 〜 C-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | CompatibilityError | E-07（54-56行目） | ○ |
| C-113 | _Compatible.__init__ | E-07（62-91行目） | ○ |
| C-114 | _Compatible.__call__互換 | E-07（107-133行目） | ○ |
| C-115 | _Compatible.__call__非互換 | E-07（128-129行目） | ○ |
| C-116 | raise_exception=True | E-07（240-241行目） | ○ |
| C-117 | get_compatibility_log正常 | E-07（248-260行目） | ○ |
| C-118 | get_compatibility_log未チェック | E-07（258-259行目） | ○ |
| C-119 | get_concrete_function | E-07（135-137行目） | ○ |
| C-120 | compatible target=None | E-07（296-299行目） | ○ |
| C-121 | compatible targetあり | E-07（300-301行目） | ○ |

### convert_phase.py関連（C-122 〜 C-129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | Component Enum | E-08（26-35行目） | ○ |
| C-123 | SubComponent Enum | E-08（42-123行目） | ○ |
| C-124 | ConverterError.__init__ | E-08（126-132行目） | ○ |
| C-125 | append_error | E-08（134-136行目） | ○ |
| C-126 | _parse_error_message | E-08（138-162行目） | ○ |
| C-127 | convert_phase正常 | E-08（165-200行目） | ○ |
| C-128 | convert_phase無効component | E-08（178-179行目） | ○ |
| C-129 | convert_phase不一致 | E-08（182-184行目） | ○ |

### tflite_convert.py関連（C-130 〜 C-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | _parse_array | E-09（39-42行目） | ○ |
| C-131 | _parse_array None | E-09（40-42行目） | ○ |
| C-132 | _parse_array空文字列 | E-09（41行目） | ○ |
| C-133 | _parse_set | E-09（45-48行目） | ○ |
| C-134 | _parse_inference_type FLOAT | E-09（51-72行目） | ○ |
| C-135 | _parse_inference_type INT8 | E-09（66-67行目） | ○ |
| C-136 | _parse_inference_type無効 | E-09（70-72行目） | ○ |
| C-137 | _get_tflite_converter graph_def | E-09（136-138行目） | ○ |
| C-138 | _get_tflite_converter saved_model | E-09（139-143行目） | ○ |
| C-139 | _get_tflite_converter keras | E-09（144-146行目） | ○ |
| C-140 | _get_tflite_converter入力なし | E-09（147-149行目） | ○ |
| C-141 | _convert_tf1_model | E-09（154-262行目） | ○ |
| C-142 | _convert_tf2_model saved_model | E-09（265-292行目） | ○ |
| C-143 | _convert_tf2_model keras | E-09（280-282行目） | ○ |
| C-144 | _check_tf1_flags input_arrays | E-09（329-332行目） | ○ |
| C-145 | _check_tf1_flags形状数不一致 | E-09（337-338行目） | ○ |
| C-146 | _check_tf2_flags | E-09（368-379行目） | ○ |

### その他（C-147 〜 C-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | increase_counter_debugger_creation | E-11（23-24行目） | ○ |
| C-148 | increase_counter_interpreter_creation | E-11（26-28行目） | ○ |
| C-149 | set_converter_param | E-11（38-40行目） | ○ |
| C-150 | 定数値 | E-10（22-48行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-043 InterpreterWithCustomOps**: カスタムオペレータ登録関数の実際の動作検証には、対応する共有ライブラリとカスタムOp実装が必要
  - 候補：カスタムOpテスト用のモックライブラリ / 実際のカスタムOp実装サンプル / C++側の登録関数ドキュメント
- **C-058 _quantize量子化実行**: 量子化結果の精度検証には、実際のモデルとキャリブレーションデータが必要
  - 候補：量子化前後のモデル比較 / 精度検証用テストデータセット / 既存の量子化テストケース参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 定数定義、Enum値確認、インターフェース定義（C-044, C-042, C-065, C-122, C-147-150）
- **1（中リスク）**: ユーティリティ関数、テンソル操作、設定生成（C-081-096, C-014-015, C-046-047）
- **2（高リスク）**: 変換・量子化コア機能、バリデーションロジック（C-055, C-058, C-062-064, C-074-075, C-106）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（Interpreter.invoke、convert、calibrate_and_quantize）の入力・期待結果が妥当か
- [ ] 異常系テストケースで適切な例外タイプとメッセージが期待されているか
- [ ] 境界値テストケース（空リスト、None、無効インデックス）が網羅されているか
- [ ] 量子化関連テストケースで必要な前提条件（representative_dataset等）が明記されているか
- [ ] CLIツール（tflite_convert）のフラグ組み合わせテストが十分か
- [ ] カスタムオペレータ関連のテストケースに実環境依存の注意事項があるか
