---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lite-schema単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **テストケースの妥当性**：ソースコードから抽出したメソッド・関数に基づき作成
  2. **境界値テストの網羅性**：追加の境界値パターンが必要な場合あり
  3. **異常系テストの網羅性**：実行環境依存のエラーパターンは一部省略

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/schema/upgrade_schema.py` - スキーマアップグレードスクリプト（Python）
- E-02: `tensorflow/lite/schema/builtin_ops_list/generator.h` - ビルトインオペレータリスト生成ヘッダ
- E-03: `tensorflow/lite/schema/builtin_ops_list/generator.cc` - ビルトインオペレータリスト生成実装
- E-04: `tensorflow/lite/schema/builtin_ops_header/generator.h` - ビルトインオペレータヘッダ生成ヘッダ
- E-05: `tensorflow/lite/schema/builtin_ops_header/generator.cc` - ビルトインオペレータヘッダ生成実装
- E-06: `tensorflow/compiler/mlir/lite/schema/schema_utils.h` - スキーマユーティリティヘッダ
- E-07: `tensorflow/compiler/mlir/lite/schema/schema_utils.cc` - スキーマユーティリティ実装
- E-08: `tensorflow/compiler/mlir/lite/schema/schema_conversion_utils.h` - スキーマ変換ユーティリティヘッダ
- E-09: `tensorflow/compiler/mlir/lite/schema/schema_conversion_utils.cc` - スキーマ変換ユーティリティ実装

## 3) Claims と根拠の対応（レビューの主戦場）

### upgrade_schema.py - Converterクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Converter.__init__の初期化テスト | E-01 (line 73-100) | ○ |
| C-02 | Converter.__init__のflatcパス不存在テスト | E-01 (line 76-82) | ○ |
| C-03 | Converter._Readのバイナリ読み込みテスト | E-01 (line 102-145) | ○ |
| C-04 | Converter._Readのtflite読み込みテスト | E-01 (line 128) | ○ |
| C-05 | Converter._ReadのJSON読み込みテスト | E-01 (line 141-142) | ○ |
| C-06 | Converter._Readの拡張子バリデーションテスト | E-01 (line 143-144) | ○ |
| C-07 | Converter._Readのflatc失敗テスト | E-01 (line 136-137) | ○ |
| C-08 | Converter._Readのファイル不存在テスト | E-01 (line 139-140) | ○ |
| C-09 | Converter._WriteのJSON出力テスト | E-01 (line 160-161) | ○ |
| C-10 | Converter._Writeのバイナリ出力テスト | E-01 (line 162-173) | ○ |
| C-11 | Converter._Writeのtflite出力テスト | E-01 (line 162) | ○ |
| C-12 | Converter._Writeの拡張子バリデーションテスト | E-01 (line 174-175) | ○ |
| C-13 | Converter._Writeのflatc失敗テスト | E-01 (line 170-171) | ○ |
| C-14 | Converter._Upgrade0To1の正常系テスト | E-01 (line 177-191) | ○ |
| C-15 | Converter._Upgrade0To1の空データテスト | E-01 (line 187-191) | ○ |
| C-16 | Converter._Upgrade1To2の正常系テスト | E-01 (line 193-263) | ○ |
| C-17 | CONVOLUTION->CONV_2D変換テスト | E-01 (line 213-214) | ○ |
| C-18 | DEPTHWISE_CONVOLUTION変換テスト | E-01 (line 215) | ○ |
| C-19 | PoolOptions変換テスト | E-01 (line 240) | ○ |
| C-20 | builtin_code型バリデーションテスト | E-01 (line 257-261) | ○ |
| C-21 | Converter._Upgrade2To3の正常系テスト | E-01 (line 265-289) | ○ |
| C-22 | 空data_buffer処理テスト | E-01 (line 283-287) | ○ |
| C-23 | tensors不在時処理テスト | E-01 (line 277-278) | ○ |
| C-24 | _PerformUpgradeの増分アップグレードテスト | E-01 (line 291-302) | ○ |
| C-25 | _PerformUpgradeの最新版処理テスト | E-01 (line 300) | ○ |
| C-26 | Convertメソッドの変換フローテスト | E-01 (line 304-336) | ○ |
| C-27 | bin->json変換テスト | E-01 (line 304-333) | ○ |
| C-28 | json->bin変換テスト | E-01 (line 304-333) | ○ |
| C-29 | デフォルトバージョン処理テスト | E-01 (line 326-327) | ○ |
| C-30 | version=0処理テスト | E-01 (line 328-329) | ○ |
| C-31 | スキーマ不適合エラーテスト | E-01 (line 335-336) | ○ |
| C-32 | TemporaryDirectoryResourceテスト | E-01 (line 52-58) | ○ |

### builtin_ops_list/generator.cc

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | IsValidInputEnumName有効列挙名テスト | E-03 (line 47-72) | ○ |
| C-34 | IsValidInputEnumName数字入り列挙名テスト | E-03 (line 62) | ○ |
| C-35 | IsValidInputEnumName小文字検証テスト | E-03 (line 62) | ○ |
| C-36 | IsValidInputEnumName連続アンダースコアテスト | E-03 (line 52-56) | ○ |
| C-37 | IsValidInputEnumName空文字列テスト | E-03 (line 50-68) | ○ |
| C-38 | IsValidInputEnumNameアンダースコアのみテスト | E-03 (line 52-68) | ○ |
| C-39 | IsValidInputEnumName単一単語テスト | E-03 (line 47-72) | ○ |
| C-40 | GenerateHeaderヘッダ生成テスト | E-03 (line 74-103) | ○ |
| C-41 | GenerateHeader CUSTOM除外テスト | E-03 (line 91-92) | ○ |
| C-42 | GenerateHeader DELEGATE除外テスト | E-03 (line 93) | ○ |
| C-43 | GenerateHeader PLACEHOLDER除外テスト | E-03 (line 92) | ○ |
| C-44 | GenerateHeader列挙名検証失敗テスト | E-03 (line 82-85) | ○ |

### builtin_ops_header/generator.cc

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | IsValidInputEnumName有効列挙名テスト | E-05 (line 70-95) | ○ |
| C-46 | IsValidInputEnumName小文字検証テスト | E-05 (line 85) | ○ |
| C-47 | ConstantizeVariableName正常変換テスト | E-05 (line 97-112) | ○ |
| C-48 | ConstantizeVariableName単一単語テスト | E-05 (line 97-112) | ○ |
| C-49 | ConstantizeVariableName数字入りテスト | E-05 (line 97-112) | ○ |
| C-50 | ConstantizeVariableName空文字列テスト | E-05 (line 98) | ○ |
| C-51 | GenerateHeaderヘッダ生成テスト | E-05 (line 114-137) | ○ |
| C-52 | GenerateHeader演算子定数出力テスト | E-05 (line 127-134) | ○ |
| C-53 | GenerateHeader列挙名検証失敗テスト | E-05 (line 120-123) | ○ |

### schema_utils.cc

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | GetBuiltinCode(OperatorCode*)正常テスト | E-07 (line 49-56) | ○ |
| C-55 | GetBuiltinCode v3互換性テスト | E-07 (line 27-47) | ○ |
| C-56 | GetBuiltinCode 127超コードテスト | E-07 (line 41-47) | ○ |
| C-57 | GetBuiltinCode nullptr検証テスト | E-07 (line 51) | ○ |
| C-58 | GetBuiltinCode(OperatorCodeT*)正常テスト | E-07 (line 58-64) | ○ |
| C-59 | GetBuiltinCode最大値選択テスト | E-07 (line 53-55, 62-63) | ○ |
| C-60 | TensorTypeGetSize FLOAT32テスト | E-07 (line 68-70) | ○ |
| C-61 | TensorTypeGetSize FLOAT16テスト | E-07 (line 71-73) | ○ |
| C-62 | TensorTypeGetSize INT32テスト | E-07 (line 74-76) | ○ |
| C-63 | TensorTypeGetSize UINT8テスト | E-07 (line 77-79) | ○ |
| C-64 | TensorTypeGetSize INT64テスト | E-07 (line 80-82) | ○ |
| C-65 | TensorTypeGetSize BOOLテスト | E-07 (line 83-84) | ○ |
| C-66 | TensorTypeGetSize INT16テスト | E-07 (line 85-87) | ○ |
| C-67 | TensorTypeGetSize COMPLEX64テスト | E-07 (line 88-90) | ○ |
| C-68 | TensorTypeGetSize INT8テスト | E-07 (line 91-93) | ○ |
| C-69 | TensorTypeGetSize FLOAT64テスト | E-07 (line 94-96) | ○ |
| C-70 | TensorTypeGetSize COMPLEX128テスト | E-07 (line 97-99) | ○ |
| C-71 | TensorTypeGetSize UINT64テスト | E-07 (line 100-102) | ○ |
| C-72 | TensorTypeGetSize UINT32テスト | E-07 (line 103-105) | ○ |
| C-73 | TensorTypeGetSize UINT16テスト | E-07 (line 106-108) | ○ |
| C-74 | TensorTypeGetSize未サポート型テスト | E-07 (line 109-110) | ○ |

### schema_conversion_utils.cc

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | ConvertBuiltinCodeToDeprecatedBuiltinCode小コードテスト | E-09 (line 21-27) | ○ |
| C-76 | ConvertBuiltinCodeToDeprecatedBuiltinCode大コードテスト | E-09 (line 23-26) | ○ |
| C-77 | ConvertBuiltinCodeToDeprecatedBuiltinCode境界値テスト | E-09 (line 23) | ○ |
| C-78 | CreateOperatorCode正常テスト | E-09 (line 38-53) | ○ |
| C-79 | CreateOperatorCode小コード設定テスト | E-09 (line 44-48) | ○ |
| C-80 | CreateOperatorCode大コード設定テスト | E-09 (line 44-48) | ○ |
| C-81 | CreateOperatorCodeカスタム演算子テスト | E-09 (line 50) | ○ |
| C-82 | CreateOperatorCodeバージョン設定テスト | E-09 (line 42) | ○ |
| C-83 | CreateOperatorCodeDirect正常テスト | E-09 (line 55-66) | ○ |
| C-84 | CreateOperatorCodeDirect nullカスタムコードテスト | E-09 (line 58) | ○ |
| C-85 | CreateOperatorCodeDirect大コードテスト | E-09 (line 59-63) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードの実装に基づいて作成されています

注意点：
- `schema_generated.h`および`conversion_metadata_generated.h`はFlatBuffersから自動生成されたファイルであり、直接的なテスト対象外としています
- `schema_utils.h`および`schema_conversion_utils.h`（tensorflow/lite/schema/配下）はヘッダリダイレクトのみであり、実装は`tensorflow/compiler/mlir/lite/schema/`配下に存在します

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコード解析に基づき作成されている
- **1（中リスク）**: 外部依存（flatc、ファイルシステム）を伴うテストは実行環境により結果が異なる可能性がある
- **1（中リスク）**: スキーマバージョン間の互換性テストは実際のモデルファイルでの検証が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースNo.1-32（upgrade_schema.py）：Pythonテストフレームワーク（pytest等）での実行可能性を確認
- [ ] テストケースNo.33-53（builtin_ops_list/header generators）：C++テストフレームワーク（googletest）での実行可能性を確認
- [ ] テストケースNo.54-74（schema_utils.cc）：OperatorCode構造体のモック作成方法を確認
- [ ] テストケースNo.75-85（schema_conversion_utils.cc）：FlatBufferBuilderのセットアップ手順を確認
- [ ] 境界値テスト：追加すべき境界値パターンがないか確認
- [ ] 異常系テスト：環境依存のエラーパターンで追加すべきものがないか確認
