---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 175
  claims_with_evidence: 168
  claims_without_evidence: 7
confidence_derived: 0.96
---

# 根拠レポート：lite-toco 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の関数定義・宣言が根拠として存在するか
2. **根拠との整合性**：テストケースの入力・出力がソースコードの関数シグネチャと矛盾していないか
3. **網羅性**：主要な公開関数・クラスのテストケースが網羅されているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 168 / 175 = 0.96
- 状態「○」：ソースコード内に関数定義/宣言が確認できた
- 状態「△」：関数の詳細実装が未確認、または推測に基づく

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：168 / 175、根拠なし：7
- 優先レビュー（高）
  1. **C-135/C-136 Cluster関連**：実装ファイルの詳細未確認
  2. **C-131〜C-134 conversion_log_util**：ログユーティリティの詳細実装未確認
  3. **C-174/C-175 ConvertOperator**：テンプレート関数の動作推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/toco/tooling_util.h` - 主要ユーティリティ関数宣言
- E-02: `tensorflow/lite/toco/tooling_util.cc` - 主要ユーティリティ関数実装
- E-03: `tensorflow/lite/toco/model.h` - Model, Shape, Array, Operatorクラス定義
- E-04: `tensorflow/lite/toco/import_tensorflow.h` - TensorFlowインポート関数宣言
- E-05: `tensorflow/lite/toco/export_tensorflow.h` - TensorFlowエクスポート関数宣言
- E-06: `tensorflow/lite/toco/toco_convert.h` - Convert関数宣言
- E-07: `tensorflow/lite/toco/toco_tooling.h` - Import/Transform/Export関数宣言
- E-08: `tensorflow/lite/toco/tflite/export.h` - TFLiteエクスポート関数・クラス宣言
- E-09: `tensorflow/lite/toco/tflite/import.h` - TFLiteインポート関数宣言
- E-10: `tensorflow/lite/toco/tflite/operator.h` - BaseOperatorクラス・関数宣言
- E-11: `tensorflow/lite/toco/tflite/types.h` - DataType/DataBuffer/Padding変換関数宣言
- E-12: `tensorflow/lite/toco/graph_transformations/graph_transformations.h` - GraphTransformationクラス・マクロ定義
- E-13: `tensorflow/lite/toco/graph_transformations/lstm_utils.h` - LSTM補助関数宣言
- E-14: `tensorflow/lite/toco/graph_transformations/quantization_util.h` - 量子化ユーティリティ関数宣言
- E-15: `tensorflow/lite/toco/allocate_transient_arrays.h` - メモリ割り当て関数宣言
- E-16: `tensorflow/lite/toco/dump_graphviz.h` - Graphvizダンプ関数宣言
- E-17: `tensorflow/lite/toco/args.h` - コマンドライン引数クラス定義
- E-18: `tensorflow/lite/toco/toco_cmdline_flags.h` - Tocoフラグパース関数宣言
- E-19: `tensorflow/lite/toco/model_cmdline_flags.h` - Modelフラグパース関数宣言
- E-20: `tensorflow/lite/toco/logging/conversion_log_util.h` - ログユーティリティ関数宣言
- E-21: `tensorflow/lite/toco/tensorflow_graph_matching/cluster.h` - Cluster基底クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### tooling_util.cc 関連（UT-TOC-001〜UT-TOC-059, UT-TOC-142〜UT-TOC-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-04 | FindLongestCommonPrefix関数のテスト | E-01, E-02 | ○ |
| C-05〜C-06 | LogName関数のテスト | E-01, E-02 | ○ |
| C-07〜C-09 | ArrayDataTypeName関数のテスト | E-01, E-02 | ○ |
| C-10〜C-13 | IsInputArray/IsOutputArray関数のテスト | E-01, E-02 | ○ |
| C-14〜C-16 | IsArrayConsumed関数のテスト | E-01, E-02 | ○ |
| C-17〜C-20 | CountTrueOutputs/CountOpsWithInput関数のテスト | E-01, E-02 | ○ |
| C-21〜C-23 | DeleteArrayIfUnused/DeleteOpAndArrays関数のテスト | E-01, E-02 | ○ |
| C-24〜C-30 | FindOpWithOutput/FindOpWithInput/ReplaceArrayUsage関数のテスト | E-01, E-02 | ○ |
| C-31〜C-34 | OperatorTypeName/HelpfulOperatorTypeName/OperatorSupportsFusedActivation関数のテスト | E-01, E-02 | ○ |
| C-35〜C-44 | Shape操作関数のテスト | E-01, E-02 | ○ |
| C-45〜C-51 | 配列チェック関数のテスト | E-01, E-02 | ○ |
| C-52〜C-59 | ユーティリティ関数のテスト | E-01, E-02 | ○ |
| C-142〜C-175 | 追加ユーティリティ関数のテスト | E-01, E-02 | ○ |

### import/export TensorFlow関連（UT-TOC-060〜UT-TOC-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60〜C-62 | ImportTensorFlowGraphDef関数のテスト | E-04 | ○ |
| C-63〜C-64 | ExportTensorFlowGraphDef関数のテスト | E-05 | ○ |

### toco_convert/toco_tooling関連（UT-TOC-065〜UT-TOC-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65〜C-66 | Convert関数のテスト | E-06 | ○ |
| C-67〜C-71 | Import/Transform/Export関数のテスト | E-07 | ○ |

### tflite export/import関連（UT-TOC-072〜UT-TOC-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72〜C-78 | tflite::Export関数・OperatorKeyクラスのテスト | E-08 | ○ |
| C-79〜C-82 | tflite::Import関数のテスト | E-09 | ○ |
| C-83〜C-90 | BaseOperator関連関数のテスト | E-10 | ○ |
| C-91〜C-98 | DataType/DataBuffer/Padding/ActivationFunction変換のテスト | E-11 | ○ |

### graph_transformations関連（UT-TOC-099〜UT-TOC-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99〜C-103 | RunGraphTransformationsWithStatus/GraphTransformationsSet関数のテスト | E-12 | ○ |
| C-104〜C-106 | AllocateTransientArrays/RoundUpToNextMultipleOf関数のテスト | E-15 | ○ |
| C-107 | DumpGraphviz関数のテスト | E-16 | ○ |
| C-120〜C-124 | LSTM補助関数のテスト | E-13 | ○ |
| C-125〜C-130 | 量子化ユーティリティ関数のテスト | E-14 | ○ |

### args/cmdline_flags関連（UT-TOC-108〜UT-TOC-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108〜C-113 | Arg<T>クラスのテスト | E-17 | ○ |
| C-114〜C-116 | ParseTocoFlagsFromCommandLineFlags関数のテスト | E-18 | ○ |
| C-117〜C-119 | ParseModelFlagsFromCommandLineFlags関数のテスト | E-19 | ○ |

### 根拠不足項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | SanitizeErrorMessage関数のテスト | E-20 | △ |
| C-132 | PopulateConversionLog関数のテスト | E-20 | △ |
| C-133 | GetOperatorNames関数のテスト | E-20 | △ |
| C-134 | CountOperatorsByType関数のテスト | E-20 | △ |
| C-135 | Cluster::SetGraphDefInfo関数のテスト | E-21 | △ |
| C-136 | Cluster::FindClusterInputsAndOutputs関数のテスト | E-21 | △ |
| C-174〜C-175 | ConvertOperator関数のテスト | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **conversion_log_util.cc**：ヘッダーファイルで宣言は確認できたが、実装ファイルの詳細確認が不十分
  - 候補：`tensorflow/lite/toco/logging/conversion_log_util.cc` を詳細解析
- **cluster.cc**：Clusterクラスの実装詳細が未確認
  - 候補：`tensorflow/lite/toco/tensorflow_graph_matching/cluster.cc` を詳細解析
- **ConvertOperatorテンプレート関数**：ヘッダーでインライン定義されているが、全パターンの動作確認が推測に基づく
  - 候補：既存テストコード参照（tooling_util_test.cc）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：tooling_util関連のテストケース - ソースコードで関数定義が明確に確認できる
- **0（低リスク）**：tflite export/import関連 - ヘッダーでの宣言が明確
- **1（中リスク）**：conversion_log_util関連 - ヘッダー宣言のみで実装詳細未確認
- **1（中リスク）**：Cluster関連 - 抽象クラスのため派生クラスでの動作確認が必要な可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（金額計算、認証等）に該当するものがないか確認（本モジュールは該当なし）
- [ ] 量子化関連テストケース（C-125〜C-130）の入力値・期待結果が数学的に正しいか確認
- [ ] 境界値テストの網羅性確認（特にShape操作関連）
- [ ] 異常系テストで適切な例外/エラーが期待されているか確認
- [ ] GraphTransformation派生クラスのテストケースが必要か検討（現状は基底クラスのみ）
- [ ] conversion_log_util、Cluster関連の実装詳細を確認し、テストケースの妥当性を検証
