---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lite-tools 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/lite/tools/flatbuffer_utils.py` - FlatBuffer操作ユーティリティ
- E-02: `tensorflow/lite/tools/visualize.py` - TFLiteモデル可視化ツール
- E-03: `tensorflow/lite/tools/convert_image_to_csv.py` - 画像CSV変換ツール
- E-04: `tensorflow/lite/tools/command_line_flags.h` - コマンドラインフラグヘッダー
- E-05: `tensorflow/lite/tools/command_line_flags.cc` - コマンドラインフラグ実装
- E-06: `tensorflow/lite/tools/model_loader.h` - モデルローダーヘッダー
- E-07: `tensorflow/lite/tools/model_loader.cc` - モデルローダー実装
- E-08: `tensorflow/lite/tools/tool_params.h` - ツールパラメータヘッダー
- E-09: `tensorflow/lite/tools/tool_params.cc` - ツールパラメータ実装
- E-10: `tensorflow/lite/tools/gen_op_registration.h` - Op登録生成ヘッダー
- E-11: `tensorflow/lite/tools/gen_op_registration.cc` - Op登録生成実装
- E-12: `tensorflow/lite/tools/utils.h` - ユーティリティヘッダー
- E-13: `tensorflow/lite/tools/utils.cc` - ユーティリティ実装
- E-14: `tensorflow/lite/tools/list_flex_ops.h` - Flex Opsリストヘッダー
- E-15: `tensorflow/lite/tools/signature/signature_def_utils.py` - 署名定義ユーティリティ
- E-16: `tensorflow/lite/tools/optimize/python/modify_model_interface_lib.py` - モデルインターフェース変更ライブラリ
- E-17: `tensorflow/lite/tools/optimize/debugging/python/debugger.py` - 量子化デバッガー
- E-18: `tensorflow/lite/tools/benchmark/benchmark_model.h` - ベンチマークモデルヘッダー

## 3) Claims と根拠の対応（レビューの主戦場）

### flatbuffer_utils.py 関連テストケース（No.1-39）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | convert_bytearray_to_objectの正常系テスト | E-01 (L39-42) | ○ |
| C-02 | convert_bytearray_to_objectの空バイト配列テスト | E-01 (L39-42) | ○ |
| C-03 | convert_bytearray_to_objectの不正バイト配列テスト | E-01 (L39-42) | ○ |
| C-04 | read_modelの正常系テスト | E-01 (L45-62) | ○ |
| C-05 | read_modelのファイル存在チェックテスト | E-01 (L58-59) | ○ |
| C-06 | read_modelの空パステスト | E-01 (L58-59) | ○ |
| C-07 | read_model_from_bytearrayの正常系テスト | E-01 (L65-94) | ○ |
| C-08 | read_model_from_bytearrayの大容量モデルテスト | E-01 (L79-92) | ○ |
| C-09 | read_model_with_mutable_tensorsテスト | E-01 (L97-116) | ○ |
| C-10 | convert_object_to_bytearrayの正常系テスト | E-01 (L119-127) | ○ |
| C-11 | convert_object_to_bytearrayのextra_bufferテスト | E-01 (L119-127) | ○ |
| C-12 | write_modelの正常系テスト | E-01 (L130-148) | ○ |
| C-13 | write_modelの書き込み権限テスト | E-01 (L141) | ○ |
| C-14 | strip_stringsのdescription削除テスト | E-01 (L151-171) | ○ |
| C-15 | strip_stringsのサブグラフ処理テスト | E-01 (L166-169) | ○ |
| C-16 | strip_stringsのsignatureDefs削除テスト | E-01 (L171) | ○ |
| C-17 | type_to_nameの正常系テスト | E-01 (L174-179) | ○ |
| C-18 | type_to_nameの不正入力テスト | E-01 (L178-179) | ○ |
| C-19 | randomize_weightsの正常系テスト | E-01 (L182-230) | ○ |
| C-20 | randomize_weightsの再現性テスト | E-01 (L193) | ○ |
| C-21 | randomize_weightsのスキップ機能テスト | E-01 (L188-199) | ○ |
| C-22 | randomize_weightsの空モデルテスト | E-01 (L196) | ○ |
| C-23 | rename_custom_opsテスト | E-01 (L233-244) | ○ |
| C-24 | opcode_to_nameの正常系テスト | E-01 (L247-262) | ○ |
| C-25 | opcode_to_nameの不正opコードテスト | E-01 (L261-262) | ○ |
| C-26 | xxd_output_to_bytesの正常系テスト | E-01 (L265-301) | ○ |
| C-27 | xxd_output_to_bytesのファイルエラーテスト | E-01 (L283) | ○ |
| C-28 | xxd_output_to_objectテスト | E-01 (L304-318) | ○ |
| C-29 | byte_swap_buffer_contentテスト | E-01 (L321-330) | ○ |
| C-30 | byte_swap_string_contentテスト | E-01 (L333-349) | ○ |
| C-31 | byte_swap_tflite_model_objテスト | E-01 (L352-407) | ○ |
| C-32 | byte_swap_tflite_model_objのNull処理テスト | E-01 (L360-361) | ○ |
| C-33 | byte_swap_tflite_bufferテスト | E-01 (L410-432) | ○ |
| C-34 | byte_swap_tflite_bufferのNull処理テスト | E-01 (L423-424) | ○ |
| C-35 | count_resource_variablesテスト | E-01 (L435-456) | ○ |
| C-36 | count_resource_variablesのゼロカウントテスト | E-01 (L447-448) | ○ |
| C-37 | get_options_asの正常系テスト | E-01 (L462-517) | ○ |
| C-38 | get_options_asの型エラーテスト | E-01 (L481-484) | ○ |
| C-39 | get_options_asのオプションなしテスト | E-01 (L512-513) | ○ |

### visualize.py 関連テストケース（No.40-68）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | TensorTypeToNameの正常系テスト | E-02 (L215-220) | ○ |
| C-41 | TensorTypeToNameの不正入力テスト | E-02 (L220) | ○ |
| C-42 | BuiltinCodeToNameの正常系テスト | E-02 (L223-228) | ○ |
| C-43 | BuiltinCodeToNameの不正コードテスト | E-02 (L228) | ○ |
| C-44 | NameListToStringの正常系テスト | E-02 (L231-240) | ○ |
| C-45 | NameListToStringの文字列パススルーテスト | E-02 (L233-234) | ○ |
| C-46 | NameListToStringのNull処理テスト | E-02 (L237) | ○ |
| C-47 | OpCodeMapperの初期化テスト | E-02 (L243-258) | ○ |
| C-48 | OpCodeMapperのマッピングテスト | E-02 (L253-258) | ○ |
| C-49 | OpCodeMapperの不正インデックステスト | E-02 (L254-255) | ○ |
| C-50 | DataSizeMapperのサイズ表示テスト | E-02 (L261-268) | ○ |
| C-51 | DataSizeMapperのNull処理テスト | E-02 (L267-268) | ○ |
| C-52 | TensorMapperのHTML生成テスト | E-02 (L271-294) | ○ |
| C-53 | TensorMapperのNull処理テスト | E-02 (L278-280) | ○ |
| C-54 | QuantizationMapperの正常系テスト | E-02 (L297-315) | ○ |
| C-55 | QuantizationMapperの空辞書テスト | E-02 (L299-300) | ○ |
| C-56 | GenerateGraphのテスト | E-02 (L318-375) | ○ |
| C-57 | GenerateTableHtmlの正常系テスト | E-02 (L378-413) | ○ |
| C-58 | GenerateTableHtmlの空リストテスト | E-02 (L400-412) | ○ |
| C-59 | CamelCaseToSnakeCaseの変換テスト | E-02 (L416-419) | ○ |
| C-60 | CamelCaseToSnakeCaseのパススルーテスト | E-02 (L416-419) | ○ |
| C-61 | FlatbufferToDictの辞書変換テスト | E-02 (L422-451) | ○ |
| C-62 | FlatbufferToDictのnumpy保持テスト | E-02 (L443-447) | ○ |
| C-63 | CreateDictFromFlatbufferテスト | E-02 (L454-457) | ○ |
| C-64 | create_htmlのTFLiteファイルテスト | E-02 (L460-566) | ○ |
| C-65 | create_htmlのJSONファイルテスト | E-02 (L483-484) | ○ |
| C-66 | create_htmlのファイルエラーテスト | E-02 (L477-478) | ○ |
| C-67 | create_htmlの拡張子エラーテスト | E-02 (L485-486) | ○ |
| C-68 | create_htmlのオブジェクト入力テスト | E-02 (L487-488) | ○ |

### convert_image_to_csv.py 関連テストケース（No.69-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | get_imageの正常系テスト | E-03 (L44-64) | ○ |
| C-70 | get_imageのグレースケールテスト | E-03 (L60) | ○ |
| C-71 | get_imageのファイルエラーテスト | E-03 (L87-88) | ○ |
| C-72 | array_to_int_csvの正常系テスト | E-03 (L67-78) | ○ |
| C-73 | array_to_int_csvの空配列テスト | E-03 (L76) | ○ |

### command_line_flags 関連テストケース（No.74-88）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Flag::CreateFlagのint32テスト | E-04 (L77-82), E-05 (L121) | ○ |
| C-75 | Flag::CreateFlagのboolテスト | E-04 (L77-82), E-05 (L124) | ○ |
| C-76 | Flag::CreateFlagのstringテスト | E-04 (L77-82), E-05 (L125) | ○ |
| C-77 | Flag::Parseの正常系テスト | E-05 (L129-137) | ○ |
| C-78 | Flag::Parseのパースエラーテスト | E-05 (L76-84) | ○ |
| C-79 | Flag::Parseのbool trueテスト | E-05 (L86-96) | ○ |
| C-80 | Flag::Parseのbool 1テスト | E-05 (L94) | ○ |
| C-81 | Flag::GetTypeNameテスト | E-05 (L139-154) | ○ |
| C-82 | Flags::Parseの複数フラグテスト | E-05 (L156-259) | ○ |
| C-83 | Flags::Parseの位置引数テスト | E-05 (L201-214) | ○ |
| C-84 | Flags::Parseの必須チェックテスト | E-05 (L241-248) | ○ |
| C-85 | Flags::Parseのヘルプ処理テスト | E-05 (L258) | ○ |
| C-86 | Flags::Parseの未知引数処理テスト | E-05 (L251-257) | ○ |
| C-87 | Flags::Usageテスト | E-05 (L261-322) | ○ |
| C-88 | Flags::ArgsToStringテスト | E-05 (L324-331) | ○ |

### model_loader 関連テストケース（No.89-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | ModelLoader::Initの正常系テスト | E-07 (L32-44) | ○ |
| C-90 | ModelLoader::Initの重複初期化テスト | E-07 (L33-35) | ○ |
| C-91 | ModelLoader::Initの初期化失敗テスト | E-07 (L37-38) | ○ |
| C-92 | PathModelLoader::InitInternalの正常系テスト | E-07 (L46-53) | ○ |
| C-93 | PathModelLoader::InitInternalの空パステスト | E-07 (L47-49) | ○ |
| C-94 | BufferModelLoader::InitInternalの正常系テスト | E-07 (L55-66) | ○ |
| C-95 | BufferModelLoader::InitInternalのnullバッファテスト | E-07 (L56-62) | ○ |
| C-96 | BufferModelLoader::InitInternalのサイズゼロテスト | E-07 (L56) | ○ |
| C-97 | MmapModelLoader::InitInternalの正常系テスト | E-07 (L70-94) | ○ |
| C-98 | MmapModelLoader::InitInternalの無効fdテスト | E-07 (L71-77) | ○ |
| C-99 | PipeModelLoader::InitInternalの正常系テスト | E-07 (L96-129) | ○ |
| C-100 | PipeModelLoader::InitInternalの無効パイプテスト | E-07 (L97-100) | ○ |
| C-101 | CreateModelLoaderFromPathのfdパーステスト | E-07 (L140-151) | ○ |
| C-102 | CreateModelLoaderFromPathのpipeパーステスト | E-07 (L153-168) | ○ |
| C-103 | CreateModelLoaderFromPathのbufferパーステスト | E-07 (L170-181) | ○ |
| C-104 | CreateModelLoaderFromPathのパス判定テスト | E-07 (L182) | ○ |
| C-105 | CreateModelLoaderFromPathのfdパースエラーテスト | E-07 (L143-148) | ○ |
| C-106 | CreateModelLoaderFromPathの空パステスト | E-07 (L136-137) | ○ |

### tool_params 関連テストケース（No.107-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | ToolParam::Createテスト | E-08 (L37-43) | ○ |
| C-108 | ToolParam::AsTypedの正常系テスト | E-08 (L45-49) | ○ |
| C-109 | ToolParam::AsTypedの型不一致テスト | E-09 (L27-30) | ○ |
| C-110 | TypedToolParam::Setテスト | E-08 (L92-95) | ○ |
| C-111 | TypedToolParam::Getテスト | E-08 (L97) | ○ |
| C-112 | TypedToolParam::Cloneテスト | E-08 (L104-106) | ○ |
| C-113 | ToolParams::AddParamテスト | E-08 (L116-118) | ○ |
| C-114 | ToolParams::RemoveParamテスト | E-08 (L120) | ○ |
| C-115 | ToolParams::HasParamのtrueテスト | E-08 (L122-124) | ○ |
| C-116 | ToolParams::HasParamのfalseテスト | E-08 (L122-124) | ○ |
| C-117 | ToolParams::GetParamの正常系テスト | E-08 (L128-132) | ○ |
| C-118 | ToolParams::GetParamの不在テスト | E-08 (L130) | ○ |
| C-119 | ToolParams::Set(ToolParams)テスト | E-09 (L56-62) | ○ |
| C-120 | ToolParams::Mergeテスト | E-09 (L64-73) | ○ |
| C-121 | ToolParams::Mergeの上書きテスト | E-09 (L69-70) | ○ |

### gen_op_registration 関連テストケース（No.122-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | NormalizeCustomOpNameのCamelCase変換テスト | E-11 (L27-32) | ○ |
| C-123 | NormalizeCustomOpNameの小文字変換テスト | E-11 (L30) | ○ |
| C-124 | ReadOpsFromModelのビルトインOp読み込みテスト | E-11 (L34-58) | ○ |
| C-125 | ReadOpsFromModelのカスタムOp読み込みテスト | E-11 (L50-55) | ○ |
| C-126 | ReadOpsFromModelのバージョン範囲テスト | E-11 (L47-55) | ○ |
| C-127 | ReadOpsFromModelのnullモデルテスト | E-11 (L37) | ○ |

### utils 関連テストケース（No.128-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | CreateRandomTensorDataのFLOAT32テスト | E-13 (L90-95, L106-109) | ○ |
| C-129 | CreateRandomTensorDataのINT8テスト | E-13 (L151-155) | ○ |
| C-130 | CreateRandomTensorDataの範囲指定テスト | E-13 (L97-99) | ○ |
| C-131 | CreateRandomTensorDataのSTRING型テスト | E-13 (L157-160) | ○ |
| C-132 | GetDataRangesForTypeのFLOAT32テスト | E-13 (L180-185) | ○ |
| C-133 | GetDataRangesForTypeのUINT8テスト | E-13 (L190-192) | ○ |
| C-134 | TfLiteTensorToFloat32Arrayの正常系テスト | E-13 (L199-211) | ○ |
| C-135 | TfLiteTensorToFloat32Arrayのnullエラーテスト | E-13 (L69-71) | ○ |
| C-136 | TfLiteTensorToFloat32Arrayのサイズ不一致テスト | E-13 (L77-78) | ○ |
| C-137 | TfLiteTensorToInt64Arrayテスト | E-13 (L213-234) | ○ |

### signature_def_utils.py 関連テストケース（No.138-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | set_signature_defsの正常系テスト | E-15 (L24-47) | ○ |
| C-139 | set_signature_defsの不正モデルテスト | E-15 (L35-38) | ○ |
| C-140 | get_signature_defsの正常系テスト | E-15 (L50-74) | ○ |
| C-141 | get_signature_defsの署名なしテスト | E-15 (L57-58) | ○ |
| C-142 | clear_signature_defsテスト | E-15 (L77-94) | ○ |

### modify_model_interface_lib.py 関連テストケース（No.143-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | _parse_type_to_intの正常系テスト | E-16 (L22-44) | ○ |
| C-144 | _parse_type_to_intの不正型テスト | E-16 (L36-39) | ○ |
| C-145 | modify_model_interfaceの正常系テスト | E-16 (L47-75) | ○ |
| C-146 | modify_model_interfaceの変更失敗テスト | E-16 (L70-74) | ○ |

### debugger.py 関連テストケース（No.147-155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | QuantizationDebugOptions.__init__の正常系テスト | E-17 (L60-117) | ○ |
| C-148 | QuantizationDebugOptions.__init__のキー重複テスト | E-17 (L112-113) | ○ |
| C-149 | QuantizationDebugger.__init__の正常系テスト | E-17 (L129-191) | ○ |
| C-150 | QuantizationDebugger.__init__の非デバッグモデルテスト | E-17 (L221-222) | ○ |
| C-151 | QuantizationDebugger.runテスト | E-17 (L326-330) | ○ |
| C-152 | get_nondebug_quantized_modelの正常系テスト | E-17 (L247-259) | ○ |
| C-153 | get_nondebug_quantized_modelのコンバーターなしテスト | E-17 (L235-237) | ○ |
| C-154 | get_debug_quantized_modelテスト | E-17 (L261-273) | ○ |
| C-155 | layer_statistics_dumpテスト | E-17 (L524-549) | ○ |

### benchmark_model.h 関連テストケース（No.156-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | BenchmarkResultsの初期化テスト | E-18 (L44-61) | ○ |
| C-157 | BenchmarkResults::inference_time_usテスト | E-18 (L64-66) | ○ |
| C-158 | BenchmarkResults::throughput_MB_per_secondテスト | E-18 (L72-76) | ○ |
| C-159 | BenchmarkListeners::AddListenerテスト | E-18 (L123-125) | ○ |
| C-160 | BenchmarkListeners::RemoveListenersテスト | E-18 (L128-131) | ○ |
| C-161 | BenchmarkModel::Runテスト | E-18 (L195-196) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースにソースコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠あり
- 一部のテストケースは実行時の動作確認が必要（例：ファイルI/O、メモリ操作）

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値・期待結果がソースコードと整合しているか確認
- [ ] 境界値テストが適切に網羅されているか確認
- [ ] 異常系テストで想定される例外が正しいか確認
- [ ] テスト優先度が適切に設定されているか確認
- [ ] Python/C++の両方の言語でテストケースがカバーされているか確認
