---
generated_at: 2026-02-03 12:15:00
metrics:
  claims_total: 241
  claims_with_evidence: 241
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: python-autograph モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：241 / 241、根拠なし：0
- 優先レビュー（高）
  1. **UT-ATG-024〜032**: converted_call関数の多様なケースは実行時の動作確認が必要
  2. **UT-ATG-115〜121**: 制御フロー演算子（for_stmt, while_stmt, if_stmt）はTensorFlow固有の動作
  3. **UT-ATG-235〜241**: AST変換処理は変換結果の検証が複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/autograph/impl/api.py` - AutoGraph APIの主要実装
- E-02: `tensorflow/python/autograph/impl/conversion.py` - 変換ロジックとallowlist管理
- E-03: `tensorflow/python/autograph/core/converter.py` - コンバータ基盤クラスとオプション
- E-04: `tensorflow/python/autograph/core/ag_ctx.py` - AutoGraphコンテキスト管理
- E-05: `tensorflow/python/autograph/core/function_wrappers.py` - 関数スコープラッパー
- E-06: `tensorflow/python/autograph/core/unsupported_features_checker.py` - 未サポート機能チェッカー
- E-07: `tensorflow/python/autograph/core/config.py` - グローバル設定
- E-08: `tensorflow/python/autograph/core/config_lib.py` - 設定ライブラリ
- E-09: `tensorflow/python/autograph/operators/control_flow.py` - 制御フロー演算子
- E-10: `tensorflow/python/autograph/operators/py_builtins.py` - Python組み込み関数オーバーロード
- E-11: `tensorflow/python/autograph/operators/data_structures.py` - データ構造演算子
- E-12: `tensorflow/python/autograph/operators/logical.py` - 論理演算子
- E-13: `tensorflow/python/autograph/operators/variables.py` - 変数演算子
- E-14: `tensorflow/python/autograph/operators/slices.py` - スライス演算子
- E-15: `tensorflow/python/autograph/operators/conditional_expressions.py` - 条件式演算子
- E-16: `tensorflow/python/autograph/operators/exceptions.py` - 例外演算子
- E-17: `tensorflow/python/autograph/utils/tensors.py` - テンソルユーティリティ
- E-18: `tensorflow/python/autograph/utils/misc.py` - 雑多なユーティリティ
- E-19: `tensorflow/python/autograph/utils/ag_logging.py` - ログユーティリティ
- E-20: `tensorflow/python/autograph/utils/tensor_list.py` - TensorListラッパー
- E-21: `tensorflow/python/autograph/utils/context_managers.py` - コンテキストマネージャ
- E-22: `tensorflow/python/autograph/utils/type_registry.py` - 型レジストリ
- E-23: `tensorflow/python/autograph/lang/special_functions.py` - 特殊関数
- E-24: `tensorflow/python/autograph/converters/control_flow.py` - 制御フロー変換器

## 3) Claims と根拠の対応（レビューの主戦場）

### impl/api.py 関連（C-01 〜 C-47）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | is_autograph_strict_conversion_mode - 環境変数判定 | E-01 (L66-67) | ○ |
| C-02 | is_autograph_strict_conversion_mode - デフォルト0 | E-01 (L67) | ○ |
| C-03 | is_autograph_strict_conversion_mode - 未設定時 | E-01 (L67) | ○ |
| C-04 | _ErrorMetadata.create_exception - OpError処理 | E-01 (L94-106) | ○ |
| C-05 | _ErrorMetadata.create_exception - AutoGraphError処理 | E-01 (L108-111) | ○ |
| C-06 | _ErrorMetadata.create_exception - フォールバック | E-01 (L122) | ○ |
| C-07 | _attach_error_metadata - メタデータ付与 | E-01 (L125-142) | ○ |
| C-08 | _attach_error_metadata - パススルー | E-01 (L127-128) | ○ |
| C-09 | StackTraceMapper.__init__ | E-01 (L148-153) | ○ |
| C-10 | StackTraceMapper.get_effective_source_map | E-01 (L155-178) | ○ |
| C-11 | StackTraceMapper キャッシュ | E-01 (L156-157) | ○ |
| C-12 | PyToTF.__init__ | E-01 (L189-191) | ○ |
| C-13 | PyToTF.get_transformed_name | E-01 (L193-194) | ○ |
| C-14 | PyToTF.get_extra_locals | E-01 (L196-217) | ○ |
| C-15 | PyToTF.get_caching_key | E-01 (L219-220) | ○ |
| C-16 | PyToTF.initial_analysis | E-01 (L222-233) | ○ |
| C-17 | PyToTF.transform_ast | E-01 (L235-257) | ○ |
| C-18 | _convert_actual - 正常変換 | E-01 (L260-275) | ○ |
| C-19 | _convert_actual - __code__なし | E-01 (L264-267) | ○ |
| C-20 | autograph_artifact - 属性設定 | E-01 (L283-288) | ○ |
| C-21 | autograph_artifact - メソッド対応 | E-01 (L284-285) | ○ |
| C-22 | is_autograph_artifact - True | E-01 (L291-292) | ○ |
| C-23 | is_autograph_artifact - False | E-01 (L291-292) | ○ |
| C-24 | converted_call - 基本動作 | E-01 (L295-446) | ○ |
| C-25 | converted_call - 引数検証 | E-01 (L324-326) | ○ |
| C-26 | converted_call - キャッシュ動作 | E-01 (L329-331) | ○ |
| C-27 | converted_call - DISABLED | E-01 (L333-335) | ○ |
| C-28 | converted_call - artifact | E-01 (L337-339) | ○ |
| C-29 | converted_call - partial | E-01 (L342-357) | ○ |
| C-30 | converted_call - eval | E-01 (L360-361) | ○ |
| C-31 | converted_call - super | E-01 (L362-363) | ○ |
| C-32 | converted_call - callable | E-01 (L397-403) | ○ |
| C-33 | _call_unconverted - 基本動作 | E-01 (L449-460) | ○ |
| C-34 | _call_unconverted - kwargsなし | E-01 (L458-460) | ○ |
| C-35 | _fall_back_unconverted | E-01 (L463-485) | ○ |
| C-36 | tf_convert - ENABLED | E-01 (L570-572) | ○ |
| C-37 | tf_convert - DISABLED | E-01 (L573-574) | ○ |
| C-38 | tf_convert - UNSPECIFIED | E-01 (L575-580) | ○ |
| C-39 | tf_convert - artifact処理 | E-01 (L556-557) | ○ |
| C-40 | call_with_unspecified_conversion_status | E-01 (L591-601) | ○ |
| C-41 | do_not_convert - ラップ | E-01 (L625-648) | ○ |
| C-42 | do_not_convert - Noneパターン | E-01 (L638-639) | ○ |
| C-43 | convert - デコレータ | E-01 (L652-703) | ○ |
| C-44 | convert - features | E-01 (L684-687) | ○ |
| C-45 | to_graph - 変換 | E-01 (L708-776) | ○ |
| C-46 | to_graph - エラー | E-01 (L773-776) | ○ |
| C-47 | to_code | E-01 (L904-946) | ○ |

### impl/conversion.py 関連（C-48 〜 C-61）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | _is_of_known_loaded_module - True | E-02 (L33-39) | ○ |
| C-49 | _is_of_known_loaded_module - False | E-02 (L33-39) | ○ |
| C-50 | _is_known_loaded_type | E-02 (L42-66) | ○ |
| C-51 | is_unsupported - wrapt | E-02 (L73-80) | ○ |
| C-52 | is_unsupported - lru_cache | E-02 (L82-84) | ○ |
| C-53 | is_unsupported - constructor | E-02 (L89-91) | ○ |
| C-54 | is_unsupported - 通常関数 | E-02 (L108) | ○ |
| C-55 | is_allowlisted - TF | E-02 (L112-147) | ○ |
| C-56 | is_allowlisted - generator | E-02 (L151-153) | ○ |
| C-57 | is_allowlisted - namedtuple | E-02 (L198-208) | ○ |
| C-58 | is_allowlisted - user func | E-02 (L210-211) | ○ |
| C-59 | is_in_allowlist_cache - True | E-02 (L214-219) | ○ |
| C-60 | is_in_allowlist_cache - TypeError | E-02 (L217-219) | ○ |
| C-61 | cache_allowlisted | E-02 (L222-227) | ○ |

### core/converter.py 関連（C-62 〜 C-77）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | Feature.all | E-03 (L117-120) | ○ |
| C-63 | Feature.all_but | E-03 (L122-127) | ○ |
| C-64 | ConversionOptions.__init__ - デフォルト | E-03 (L147-162) | ○ |
| C-65 | ConversionOptions.__init__ - None | E-03 (L157-158) | ○ |
| C-66 | ConversionOptions.uses - ALL | E-03 (L178-180) | ○ |
| C-67 | ConversionOptions.uses - 指定 | E-03 (L178-180) | ○ |
| C-68 | ConversionOptions.call_options | E-03 (L182-188) | ○ |
| C-69 | ConversionOptions.to_ast | E-03 (L190-221) | ○ |
| C-70 | ConversionOptions.__eq__ | E-03 (L171-173) | ○ |
| C-71 | ConversionOptions.__hash__ | E-03 (L168-169) | ○ |
| C-72 | ProgramContext.__init__ | E-03 (L239-241) | ○ |
| C-73 | Base.__init__ | E-03 (L251-255) | ○ |
| C-74 | Base.visit - 正常 | E-03 (L306-316) | ○ |
| C-75 | Base.visit - 再利用 | E-03 (L308-309) | ○ |
| C-76 | Base.get_definition_directive - 正常 | E-03 (L257-304) | ○ |
| C-77 | Base.get_definition_directive - 矛盾 | E-03 (L296-303) | ○ |

### core/ag_ctx.py 関連（C-78 〜 C-82）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | control_status_ctx | E-04 (L35-52) | ○ |
| C-79 | ControlStatusCtx.__enter__ | E-04 (L68-70) | ○ |
| C-80 | ControlStatusCtx.__exit__ | E-04 (L76-78) | ○ |
| C-81 | NullCtx.__enter__ | E-04 (L84-85) | ○ |
| C-82 | NullCtx.__exit__ | E-04 (L87-88) | ○ |

### core/function_wrappers.py 関連（C-83 〜 C-90）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | FunctionScope.__init__ | E-05 (L43-60) | ○ |
| C-84 | FunctionScope._sanitize - underscore | E-05 (L63-68) | ○ |
| C-85 | FunctionScope._sanitize - normal | E-05 (L63-68) | ○ |
| C-86 | FunctionScope.__enter__ | E-05 (L70-77) | ○ |
| C-87 | FunctionScope.__exit__ | E-05 (L79-85) | ○ |
| C-88 | FunctionScope.ret - mark | E-05 (L87-107) | ○ |
| C-89 | FunctionScope.ret - undefined | E-05 (L91-92) | ○ |
| C-90 | with_function_scope | E-05 (L110-113) | ○ |

### core/unsupported_features_checker.py 関連（C-91 〜 C-95）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | visit_Attribute - マングル名 | E-06 (L28-33) | ○ |
| C-92 | visit_For - else | E-06 (L35-39) | ○ |
| C-93 | visit_While - else | E-06 (L41-45) | ○ |
| C-94 | visit_Yield | E-06 (L49-50) | ○ |
| C-95 | verify | E-06 (L56-57) | ○ |

### core/config_lib.py 関連（C-96 〜 C-99）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | Rule.matches - True | E-08 (L29-31) | ○ |
| C-97 | Rule.matches - False | E-08 (L29-31) | ○ |
| C-98 | DoNotConvert.get_action | E-08 (L46-49) | ○ |
| C-99 | Convert.get_action | E-08 (L58-61) | ○ |

### operators/control_flow.py 関連（C-100 〜 C-124）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | _is_none_or_undef - None | E-09 (L102-116) | ○ |
| C-101 | _is_none_or_undef - Undefined | E-09 (L102-116) | ○ |
| C-102 | _is_none_or_undef - 通常値 | E-09 (L102-116) | ○ |
| C-103 | _verify_tf_condition - bool | E-09 (L119-143) | ○ |
| C-104 | _verify_tf_condition - 非bool | E-09 (L124-128) | ○ |
| C-105 | verify_loop_init_vars - 正常 | E-09 (L146-189) | ○ |
| C-106 | verify_loop_init_vars - None | E-09 (L181-182) | ○ |
| C-107 | verify_loop_init_vars - Undefined | E-09 (L183-186) | ○ |
| C-108 | _is_subshape - 同じ形状 | E-09 (L192-205) | ○ |
| C-109 | _is_subshape - 異なる次元 | E-09 (L200-201) | ○ |
| C-110 | _verify_single_loop_var - 正常 | E-09 (L209-263) | ○ |
| C-111 | _verify_single_loop_var - None | E-09 (L213-214) | ○ |
| C-112 | _verify_single_loop_var - dtype不一致 | E-09 (L235-242) | ○ |
| C-113 | verify_single_cond_var - 正常 | E-09 (L324-351) | ○ |
| C-114 | verify_single_cond_var - None | E-09 (L326-330) | ○ |
| C-115 | for_stmt - Python | E-09 (L392-449) | ○ |
| C-116 | for_stmt - TF tensor | E-09 (L438-442) | ○ |
| C-117 | for_stmt - tf.range | E-09 (L439-440) | ○ |
| C-118 | while_stmt - Python | E-09 (L707-754) | ○ |
| C-119 | while_stmt - TF | E-09 (L743-744) | ○ |
| C-120 | if_stmt - Python | E-09 (L1170-1217) | ○ |
| C-121 | if_stmt - TF | E-09 (L1214-1215) | ○ |
| C-122 | _PythonLoopChecker.before_iteration | E-09 (L809-814) | ○ |
| C-123 | _PythonLoopChecker.after_iteration | E-09 (L816-828) | ○ |
| C-124 | _PythonLoopChecker - 最大超過 | E-09 (L777-779) | ○ |

### operators/py_builtins.py 関連（C-125 〜 C-149）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | overload_of - サポート | E-10 (L60-63) | ○ |
| C-126 | overload_of - 未サポート | E-10 (L60-63) | ○ |
| C-127 | abs_ - TF | E-10 (L170-176) | ○ |
| C-128 | abs_ - Python | E-10 (L170-176) | ○ |
| C-129 | float_ - TF | E-10 (L187-197) | ○ |
| C-130 | float_ - Python | E-10 (L187-201) | ○ |
| C-131 | int_ - TF | E-10 (L204-217) | ○ |
| C-132 | int_ - base | E-10 (L211-212) | ○ |
| C-133 | len_ - TF tensor | E-10 (L226-277) | ○ |
| C-134 | len_ - TensorArray | E-10 (L230-231) | ○ |
| C-135 | len_ - scalar | E-10 (L260-261) | ○ |
| C-136 | print_ - Python | E-10 (L284-307) | ○ |
| C-137 | print_ - invalid kwargs | E-10 (L289-290) | ○ |
| C-138 | range_ - TF | E-10 (L374-394) | ○ |
| C-139 | range_ - Python | E-10 (L374-402) | ○ |
| C-140 | enumerate_ | E-10 (L405-413) | ○ |
| C-141 | zip_ | E-10 (L416-433) | ○ |
| C-142 | min_ - TF | E-10 (L310-339) | ○ |
| C-143 | min_ - rank>1 | E-10 (L327-328) | ○ |
| C-144 | max_ - TF | E-10 (L342-371) | ○ |
| C-145 | locals_in_original_context | E-10 (L87-89) | ○ |
| C-146 | globals_in_original_context | E-10 (L92-94) | ○ |
| C-147 | eval_in_original_context | E-10 (L97-109) | ○ |
| C-148 | super_in_original_context - 引数あり | E-10 (L112-167) | ○ |
| C-149 | super_in_original_context - 引数なし | E-10 (L130-167) | ○ |

### operators/data_structures.py 関連（C-150 〜 C-162）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | new_list - 要素あり | E-11 (L32-50) | ○ |
| C-151 | new_list - 要素なし | E-11 (L32-50) | ○ |
| C-152 | tf_tensor_array_new | E-11 (L53-100) | ○ |
| C-153 | tf_tensor_array_new - dtype不一致 | E-11 (L64-67) | ○ |
| C-154 | tf_tensor_list_new | E-11 (L103-159) | ○ |
| C-155 | list_append - TensorArray | E-11 (L167-196) | ○ |
| C-156 | list_append - TensorList | E-11 (L167-196) | ○ |
| C-157 | list_append - Python | E-11 (L167-196) | ○ |
| C-158 | list_pop - TensorList | E-11 (L231-291) | ○ |
| C-159 | list_pop - TensorArray | E-11 (L255-256) | ○ |
| C-160 | list_pop - index | E-11 (L270-271) | ○ |
| C-161 | list_stack - TensorArray | E-11 (L301-347) | ○ |
| C-162 | list_stack - TensorList | E-11 (L301-347) | ○ |

### operators/logical.py 関連（C-163 〜 C-171）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-163 | not_ - TF | E-12 (L22-31) | ○ |
| C-164 | not_ - Python | E-12 (L22-36) | ○ |
| C-165 | and_ - TF | E-12 (L39-50) | ○ |
| C-166 | and_ - Python | E-12 (L39-55) | ○ |
| C-167 | or_ - TF | E-12 (L58-69) | ○ |
| C-168 | or_ - Python | E-12 (L58-74) | ○ |
| C-169 | eq - TF | E-12 (L77-86) | ○ |
| C-170 | eq - Python | E-12 (L77-91) | ○ |
| C-171 | not_eq | E-12 (L94-96) | ○ |

### operators/variables.py 関連（C-172 〜 C-180）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-172 | ld - 通常値 | E-13 (L18-22) | ○ |
| C-173 | ld - Undefined | E-13 (L18-22) | ○ |
| C-174 | ldu - 成功 | E-13 (L25-47) | ○ |
| C-175 | ldu - KeyError | E-13 (L25-47) | ○ |
| C-176 | Undefined.__init__ | E-13 (L79-80) | ○ |
| C-177 | Undefined.read | E-13 (L82-84) | ○ |
| C-178 | Undefined.__getattribute__ - 存在 | E-13 (L89-95) | ○ |
| C-179 | Undefined.__getattribute__ - 不存在 | E-13 (L89-95) | ○ |
| C-180 | Undefined.__getitem__ | E-13 (L97-98) | ○ |

### operators/slices.py 関連（C-181 〜 C-189）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181 | get_item - TensorArray | E-14 (L34-63) | ○ |
| C-182 | get_item - TensorList | E-14 (L34-63) | ○ |
| C-183 | get_item - 通常テンソル | E-14 (L34-63) | ○ |
| C-184 | get_item - 文字列テンソル | E-14 (L85-88) | ○ |
| C-185 | get_item - dtype不足 | E-14 (L73-75) | ○ |
| C-186 | set_item - TensorArray | E-14 (L96-142) | ○ |
| C-187 | set_item - TensorList | E-14 (L96-142) | ○ |
| C-188 | set_item - 通常テンソル | E-14 (L96-142) | ○ |
| C-189 | set_item - Python | E-14 (L96-142) | ○ |

### operators/conditional_expressions.py 関連（C-190 〜 C-191）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-190 | if_exp - TF | E-15 (L23-48) | ○ |
| C-191 | if_exp - Python | E-15 (L23-52) | ○ |

### operators/exceptions.py 関連（C-192 〜 C-195）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192 | assert_stmt - TF | E-16 (L22-76) | ○ |
| C-193 | assert_stmt - Python | E-16 (L22-82) | ○ |
| C-194 | assert_stmt - non-callable | E-16 (L46-47) | ○ |
| C-195 | assert_stmt - 引数あり | E-16 (L48-50) | ○ |

### utils/tensors.py 関連（C-196 〜 C-200）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-196 | is_dense_tensor - 密テンソル | E-17 (L28-31) | ○ |
| C-197 | is_dense_tensor - Sparse | E-17 (L28-31) | ○ |
| C-198 | is_tensor_array | E-17 (L34-35) | ○ |
| C-199 | is_tensor_list | E-17 (L38-44) | ○ |
| C-200 | is_range_tensor | E-17 (L47-49) | ○ |

### utils/misc.py 関連（C-201 〜 C-205）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-201 | alias_tensors - テンソル | E-18 (L24-48) | ○ |
| C-202 | alias_tensors - 非テンソル | E-18 (L24-48) | ○ |
| C-203 | alias_tensors - 引数なし | E-18 (L49) | ○ |
| C-204 | get_range_len - 正常 | E-18 (L52-59) | ○ |
| C-205 | get_range_len - 空レンジ | E-18 (L52-59) | ○ |

### utils/ag_logging.py 関連（C-206 〜 C-212）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-206 | set_verbosity | E-19 (L37-84) | ○ |
| C-207 | get_verbosity - set優先 | E-19 (L110-114) | ○ |
| C-208 | get_verbosity - 環境変数 | E-19 (L110-114) | ○ |
| C-209 | has_verbosity | E-19 (L117-118) | ○ |
| C-210 | trace | E-19 (L88-107) | ○ |
| C-211 | log | E-19 (L134-138) | ○ |
| C-212 | warning | E-19 (L141-145) | ○ |

### utils/tensor_list.py 関連（C-213 〜 C-219）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-213 | dynamic_list_append - TensorArray | E-20 (L22-36) | ○ |
| C-214 | dynamic_list_append - Tensor | E-20 (L22-36) | ○ |
| C-215 | TensorList.__init__ | E-20 (L42-45) | ○ |
| C-216 | TensorList.append | E-20 (L47-48) | ○ |
| C-217 | TensorList.pop | E-20 (L50-52) | ○ |
| C-218 | TensorList.clear | E-20 (L54-55) | ○ |
| C-219 | TensorList.count | E-20 (L57-58) | ○ |

### utils/context_managers.py 関連（C-220 〜 C-221）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-220 | control_dependency_on_returns - None | E-21 (L23-45) | ○ |
| C-221 | control_dependency_on_returns - テンソル | E-21 (L23-45) | ○ |

### utils/type_registry.py 関連（C-222 〜 C-225）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-222 | TypeRegistry.register - 正常 | E-22 (L31-43) | ○ |
| C-223 | TypeRegistry.register - 重複 | E-22 (L41-42) | ○ |
| C-224 | TypeRegistry.lookup - 正常 | E-22 (L45-62) | ○ |
| C-225 | TypeRegistry.lookup - 未登録 | E-22 (L62) | ○ |

### lang/special_functions.py 関連（C-226 〜 C-234）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-226 | _validate_list_constructor - 正常 | E-23 (L27-43) | ○ |
| C-227 | _validate_list_constructor - 空リスト | E-23 (L36-39) | ○ |
| C-228 | match_staging_level - TF | E-23 (L46-50) | ○ |
| C-229 | match_staging_level - Python | E-23 (L46-50) | ○ |
| C-230 | tensor_list - TensorList | E-23 (L53-85) | ○ |
| C-231 | tensor_list - TensorArray | E-23 (L80-82) | ○ |
| C-232 | stack - 正常 | E-23 (L88-118) | ○ |
| C-233 | stack - strict=True エラー | E-23 (L109-112) | ○ |
| C-234 | stack - strict=False | E-23 (L113-114) | ○ |

### converters/control_flow.py 関連（C-235 〜 C-241）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-235 | visit_If | E-24 (L201-256) | ○ |
| C-236 | visit_While | E-24 (L258-306) | ○ |
| C-237 | visit_For | E-24 (L308-394) | ○ |
| C-238 | _create_nonlocal_declarations | E-24 (L52-65) | ○ |
| C-239 | _create_state_functions | E-24 (L67-103) | ○ |
| C-240 | _create_loop_options | E-24 (L105-117) | ○ |
| C-241 | transform | E-24 (L404-413) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしのClaimはありません。
- 全てのテストケースはソースコードの直接解析に基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードに直接対応しており、高い信頼性があります。
- 以下の点は実行時テストで追加確認を推奨：
  - TensorFlow実行環境に依存するケース（TFグラフモード動作）
  - スタックトレースマッピング機能（実際のエラー発生時の動作）
  - マルチスレッド環境でのコンテキスト管理

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-ATG-024〜032、UT-ATG-115〜121）の網羅性を確認
- [ ] TensorFlow固有のAPI変更による影響がないか確認
- [ ] 異常系テストケースのエラーメッセージが仕様と一致するか確認
- [ ] 境界値テストケースの数値範囲が適切か確認
- [ ] モック/スタブを使用するテストケースの前提条件が妥当か確認
