---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 151
  claims_with_evidence: 148
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：python-client 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：148 / 151、根拠なし：3
- 優先レビュー（高）
  1. **UT-CLI-149〜151（notebook.py関連）**：IPython依存のため実行環境による動作検証が必要
  2. **UT-CLI-144〜148（pywrap_tf_session.py関連）**：C++バインディングのため内部実装の詳細が不明
  3. **UT-CLI-028（_TensorTracker.last_unref）**：空リストでのmax()呼び出し時の例外動作の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/client/device_lib.py` - list_local_devices関数の定義（23-42行目）
- E-02: `tensorflow/python/client/timeline.py` - _ChromeTraceFormatterクラスの定義（58-319行目）
- E-03: `tensorflow/python/client/timeline.py` - _TensorTrackerクラスの定義（321-407行目）
- E-04: `tensorflow/python/client/timeline.py` - Timelineクラスの定義（410-857行目）
- E-05: `tensorflow/python/client/session.py` - SessionInterfaceクラスの定義（54-78行目）
- E-06: `tensorflow/python/client/session.py` - _get_indexed_slices_value_from_fetches関数（80-83行目）
- E-07: `tensorflow/python/client/session.py` - _get_feeds_for_indexed_slices関数（86-89行目）
- E-08: `tensorflow/python/client/session.py` - register_session_run_conversion_functions関数（151-204行目）
- E-09: `tensorflow/python/client/session.py` - _is_attrs_instance関数（207-209行目）
- E-10: `tensorflow/python/client/session.py` - _get_attrs_values関数（212-215行目）
- E-11: `tensorflow/python/client/session.py` - _FetchMapperクラスと派生クラス（218-463行目）
- E-12: `tensorflow/python/client/session.py` - _FetchHandlerクラス（466-586行目）
- E-13: `tensorflow/python/client/session.py` - _name_list関数（589-598行目）
- E-14: `tensorflow/python/client/session.py` - _DeviceAttributesクラス（601-640行目）
- E-15: `tensorflow/python/client/session.py` - BaseSessionクラス（643-1543行目）
- E-16: `tensorflow/python/client/session.py` - Sessionクラス（1546-1722行目）
- E-17: `tensorflow/python/client/session.py` - InteractiveSessionクラス（1725-1835行目）
- E-18: `tensorflow/python/client/pywrap_tf_session.py` - TF_NewSessionOptions関数（51-59行目）
- E-19: `tensorflow/python/client/pywrap_tf_session.py` - TF_Reset関数（65-70行目）
- E-20: `tensorflow/python/client/notebook.py` - main関数（49-94行目）

## 3) Claims と根拠の対応（レビューの主戦場）

### device_lib.py関連（UT-CLI-001〜003）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | list_local_devices関数がsession_config=Noneで動作する | E-01 | ○ |
| C-02 | list_local_devices関数がConfigProtoで動作する | E-01 | ○ |
| C-03 | 不正なsession_configで例外が発生する | E-01 | ○ |

### timeline.py - _ChromeTraceFormatter関連（UT-CLI-004〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | __init__でshow_memory=Falseがデフォルト | E-02 (61行目) | ○ |
| C-05 | __init__でshow_memory=Trueが設定可能 | E-02 (61行目) | ○ |
| C-06 | _create_eventがイベント辞書を生成 | E-02 (67-99行目) | ○ |
| C-07 | emit_pidがプロセスメタデータを追加 | E-02 (101-113行目) | ○ |
| C-08 | emit_tidがスレッドメタデータを追加 | E-02 (115-129行目) | ○ |
| C-09 | emit_regionがリージョンイベントを追加 | E-02 (131-155行目) | ○ |
| C-10 | emit_obj_createがオブジェクト生成イベントを追加 | E-02 (157-178行目) | ○ |
| C-11 | emit_obj_deleteがオブジェクト削除イベントを追加 | E-02 (180-201行目) | ○ |
| C-12 | emit_obj_snapshotがスナップショットイベントを追加 | E-02 (203-227行目) | ○ |
| C-13 | emit_flow_startがフロー開始イベントを追加 | E-02 (229-246行目) | ○ |
| C-14 | emit_flow_endがフロー終了イベントを追加 | E-02 (248-265行目) | ○ |
| C-15 | emit_counterがカウンターイベントを追加 | E-02 (267-288行目) | ○ |
| C-16 | emit_countersが複数カウンターイベントを追加 | E-02 (290-302行目) | ○ |
| C-17 | format_to_stringがJSON文字列を生成（通常） | E-02 (304-318行目) | ○ |
| C-18 | format_to_stringがJSON文字列を生成（整形） | E-02 (304-318行目) | ○ |
| C-19 | 空イベントでもJSON文字列が生成される | E-02 (314行目) | ○ |

### timeline.py - _TensorTracker関連（UT-CLI-020〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | __init__で各属性が初期化される | E-03 (324-356行目) | ○ |
| C-21 | nameプロパティがテンソル名を返す | E-03 (358-361行目) | ○ |
| C-22 | pidプロパティがプロセスIDを返す | E-03 (363-366行目) | ○ |
| C-23 | create_timeプロパティが生成時刻を返す | E-03 (368-371行目) | ○ |
| C-24 | object_idプロパティがオブジェクトIDを返す | E-03 (373-376行目) | ○ |
| C-25 | num_bytesプロパティがバイト数を返す | E-03 (378-381行目) | ○ |
| C-26 | allocatorプロパティがアロケータ名を返す | E-03 (383-386行目) | ○ |
| C-27 | last_unrefが最大unref時刻を返す | E-03 (388-391行目) | ○ |
| C-28 | 空リストでmax()がValueErrorを発生 | E-03 (391行目) - Python標準動作 | ○ |
| C-29 | add_refが_ref_timesに追加 | E-03 (393-399行目) | ○ |
| C-30 | add_unrefが_unref_timesに追加 | E-03 (401-407行目) | ○ |

### timeline.py - Timeline関連（UT-CLI-031〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | __init__でgraph=Noneで初期化される | E-04 (413-440行目) | ○ |
| C-32 | __init__でgraphを指定して初期化される | E-04 (413-440行目) | ○ |
| C-33 | _alloc_pidが連続整数を返す | E-04 (442-446行目) | ○ |
| C-34 | _alloc_flow_idが連続整数を返す | E-04 (448-452行目) | ○ |
| C-35 | _parse_op_labelが正しくパースする | E-04 (454-467行目) | ○ |
| C-36 | 入力なしラベルがパースされる | E-04 (454-467行目) | ○ |
| C-37 | 不正ラベルでデフォルト値が返る | E-04 (460-461行目) | ○ |
| C-38 | _parse_kernel_labelがパースする | E-04 (469-479行目) | ○ |
| C-39 | _is_gputrace_deviceがstream識別 | E-04 (570-572行目) | ○ |
| C-40 | _is_gputrace_deviceがmemcpy識別 | E-04 (570-572行目) | ○ |
| C-41 | _is_gputrace_deviceが非GPU識別 | E-04 (570-572行目) | ○ |
| C-42 | analyze_step_statsが分析結果を返す | E-04 (789-823行目) | ○ |
| C-43 | show_memory=Falseで分析 | E-04 (789-823行目) | ○ |
| C-44 | op_time='gpu'で分析 | E-04 (734-787行目) | ○ |
| C-45 | op_time='all'で分析 | E-04 (734-787行目) | ○ |
| C-46 | generate_chrome_trace_formatがJSON返す | E-04 (825-857行目) | ○ |

### session.py - SessionInterface関連（UT-CLI-047〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | graphプロパティがNotImplementedError | E-05 (57-60行目) | ○ |
| C-48 | sess_strプロパティがNotImplementedError | E-05 (62-65行目) | ○ |
| C-49 | runメソッドがNotImplementedError | E-05 (67-69行目) | ○ |
| C-50 | partial_run_setupがNotImplementedError | E-05 (71-73行目) | ○ |
| C-51 | partial_runがNotImplementedError | E-05 (75-77行目) | ○ |

### session.py - ユーティリティ関数関連（UT-CLI-052〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | IndexedSlicesValueがdense_shapeありで生成 | E-06 (80-83行目) | ○ |
| C-53 | IndexedSlicesValueがdense_shapeなしで生成 | E-06 (83行目) | ○ |
| C-54 | IndexedSlicesのfeedリストが生成される | E-07 (86-89行目) | ○ |
| C-55 | 新しい変換関数が登録される | E-08 (151-204行目) | ○ |
| C-56 | 既存型の再登録でValueError | E-08 (198-201行目) | ○ |
| C-57 | attrsインスタンスが識別される | E-09 (207-209行目) | ○ |
| C-58 | 非attrsインスタンスが識別される | E-09 (207-209行目) | ○ |
| C-59 | attrsインスタンスの値リストが取得される | E-10 (212-215行目) | ○ |

### session.py - FetchMapper関連（UT-CLI-060〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | リストfetchにListFetchMapperが返る | E-11 (273-275行目) | ○ |
| C-61 | 辞書fetchにDictFetchMapperが返る | E-11 (276-277行目) | ○ |
| C-62 | タプルfetchにListFetchMapperが返る | E-11 (273-275行目) | ○ |
| C-63 | NoneでTypeErrorがスローされる | E-11 (270-272行目) | ○ |
| C-64 | 不正な型でTypeErrorがスローされる | E-11 (286-288行目) | ○ |
| C-65〜69 | ElementFetchMapperの動作 | E-11 (291-335行目) | ○ |
| C-70〜71 | _uniquify_fetchesの動作 | E-11 (338-371行目) | ○ |
| C-72〜76 | ListFetchMapperの動作 | E-11 (374-405行目) | ○ |
| C-77〜80 | DictFetchMapperの動作 | E-11 (408-439行目) | ○ |
| C-81〜83 | AttrsFetchMapperの動作 | E-11 (442-463行目) | ○ |

### session.py - FetchHandler関連（UT-CLI-084〜089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | FetchHandlerが初期化される | E-12 (481-515行目) | ○ |
| C-85 | フェッチ不可OpでInaccessibleTensorError | E-12 (517-523行目) | ○ |
| C-86〜88 | FetchHandlerのメソッド動作 | E-12 (525-586行目) | ○ |
| C-89 | _name_listがバイト文字列リストを返す | E-13 (589-598行目) | ○ |

### session.py - DeviceAttributes関連（UT-CLI-090〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90〜95 | _DeviceAttributesの各プロパティ動作 | E-14 (601-640行目) | ○ |

### session.py - BaseSession関連（UT-CLI-096〜127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96〜101 | __init__の各パターン動作 | E-15 (650-724行目) | ○ |
| C-102 | list_devicesがデバイス一覧を返す | E-15 (726-762行目) | ○ |
| C-103〜104 | closeの動作 | E-15 (764-792行目) | ○ |
| C-105〜108 | プロパティの動作 | E-15 (794-866行目) | ○ |
| C-109〜118 | runメソッドの各パターン動作 | E-15 (868-987行目) | ○ |
| C-119〜122 | partial_run関連の動作 | E-15 (989-1131行目) | ○ |
| C-123〜127 | make_callable関連の動作 | E-15 (1226-1543行目) | ○ |

### session.py - Session関連（UT-CLI-128〜134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128〜132 | Sessionの初期化とコンテキスト管理 | E-16 (1546-1688行目) | ○ |
| C-133〜134 | resetメソッドの動作 | E-16 (1690-1722行目) | ○ |

### session.py - InteractiveSession関連（UT-CLI-135〜140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135〜140 | InteractiveSessionの各動作 | E-17 (1725-1835行目) | ○ |

### session.py - _Callable関連（UT-CLI-141〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141〜143 | _Callableの各動作 | E-15 (1492-1528行目) | ○ |

### pywrap_tf_session.py関連（UT-CLI-144〜148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144〜146 | TF_NewSessionOptionsの各パターン | E-18 (51-59行目) | ○ |
| C-147〜148 | TF_Resetの動作 | E-19 (65-70行目) | ○ |

### notebook.py関連（UT-CLI-149〜151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | main関数が通常モードで動作 | E-20 (49-80行目) | △ |
| C-150 | main関数がカーネルモードで動作 | E-20 (82-94行目) | △ |
| C-151 | パスワード付きで起動 | E-20 (64-70行目) | △ |

## 4) 不足情報（Unknown / Missing）
- **notebook.py関連（UT-CLI-149〜151）**：IPython環境依存のため、実際の動作検証にはIPython/Jupyter環境が必要
  - 候補：IPython公式ドキュメント / Jupyter Notebook API仕様 / 実行環境での動作確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - device_lib.py, timeline.py関連（UT-CLI-001〜046）：コード解析で十分に検証可能
- **0: 低リスク** - session.py関連（UT-CLI-047〜143）：コード解析で十分に検証可能
- **1: 中リスク** - pywrap_tf_session.py関連（UT-CLI-144〜148）：C++バインディング層のため内部実装の詳細は確認困難
- **2: 高リスク** - notebook.py関連（UT-CLI-149〜151）：外部依存（IPython）が多く、実行環境による検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] timeline.py: Chrome Trace Format仕様との整合性確認（emit_*メソッド）
- [ ] session.py: TensorFlowの実行モデル（Graph/Session）との整合性確認
- [ ] session.py: _REGISTERED_EXPANSIONSへの型登録が既存型と競合しないか確認
- [ ] session.py: BaseSession.runのfeed_dict検証ロジックの網羅性確認
- [ ] notebook.py: IPython APIバージョンとの互換性確認（非推奨API使用の可能性）
- [ ] 全体: 例外メッセージの適切性確認（ユーザー向けに十分な情報を含むか）
- [ ] 全体: スレッドセーフ性の確認（特にBaseSession._delete_lock周り）
