---
generated_at: 2026-02-03 16:30:00
metrics:
  claims_total: 137
  claims_with_evidence: 137
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：python-distribute.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：137 / 137、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/distribute/distribute_lib.py` - 分散戦略の中核ライブラリ
- E-02: `tensorflow/python/distribute/mirrored_strategy.py` - MirroredStrategy実装
- E-03: `tensorflow/python/distribute/values.py` - 分散値クラス群
- E-04: `tensorflow/python/distribute/cross_device_ops.py` - クロスデバイス操作
- E-05: `tensorflow/python/distribute/device_util.py` - デバイスユーティリティ
- E-06: `tensorflow/python/distribute/reduce_util.py` - リダクションユーティリティ
- E-07: `tensorflow/python/distribute/input_lib.py` - 分散入力ライブラリ
- E-08: `tensorflow/python/distribute/collective_util.py` - 集合通信ユーティリティ
- E-09: `tensorflow/python/distribute/multi_worker_util.py` - マルチワーカーユーティリティ
- E-10: `tensorflow/python/distribute/coordinator/cluster_coordinator.py` - クラスタコーディネータ
- E-11: `tensorflow/python/distribute/distribute_utils.py` - 分散ユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### distribute_lib.py関連（C-01〜C-35）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UpdateContext.__init__でreplica_idが設定される | E-01 (行259-261) | ○ |
| C-02 | UpdateContext.__enter__でreplica_idが現在の値として設定される | E-01 (行263-265) | ○ |
| C-03 | UpdateContext.__exit__で元のreplica_idが復元される | E-01 (行267-269) | ○ |
| C-04 | get_update_replica_id()がNoneを返す（コンテキスト外） | E-01 (行246-251) | ○ |
| C-05 | get_update_replica_id()が現在のreplica_idを返す（コンテキスト内） | E-01 (行246-251) | ○ |
| C-06 | get_replica_context()がReplicaContextを返す | E-01 (行453-498) | ○ |
| C-07 | get_replica_context()がStrategy scope内でNoneを返す | E-01 (行453-498) | ○ |
| C-08 | in_cross_replica_context()がFalseを返す（scope外） | E-01 (行517-539) | ○ |
| C-09 | in_cross_replica_context()がTrueを返す（scope内） | E-01 (行517-539) | ○ |
| C-10 | get_strategy()がデフォルト戦略を返す | E-01 (行542-559) | ○ |
| C-11 | get_strategy()が現在の戦略を返す | E-01 (行542-559) | ○ |
| C-12 | has_strategy()がFalseを返す（scope外） | E-01 (行562-575) | ○ |
| C-13 | has_strategy()がTrueを返す（scope内） | E-01 (行562-575) | ○ |
| C-14 | experimental_set_strategy()が戦略を設定する | E-01 (行583-629) | ○ |
| C-15 | experimental_set_strategy(None)が戦略をクリアする | E-01 (行583-629) | ○ |
| C-16 | experimental_set_strategy()がscope内でエラー | E-01 (行623-625) | ○ |
| C-17 | InputContext.__init__でデフォルト値が設定される | E-01 (行840-871) | ○ |
| C-18 | InputContext.__init__で指定値が設定される | E-01 (行857-871) | ○ |
| C-19 | get_per_replica_batch_sizeが正しく計算する | E-01 (行888-906) | ○ |
| C-20 | get_per_replica_batch_sizeが割り切れない場合エラー | E-01 (行902-905) | ○ |
| C-21 | get_per_replica_batch_sizeが0を処理できる | E-01 (行888-906) | ○ |
| C-22 | ValueContext.__init__でデフォルト値が設定される | E-01 (行950-961) | ○ |
| C-23 | ValueContext.replica_id_in_sync_groupが値を返す | E-01 (行968-971) | ○ |
| C-24 | ValueContext.num_replicas_in_syncが値を返す | E-01 (行963-966) | ○ |
| C-25 | StrategyBase.__init__がextendedを設定する | E-01 (行1176-1201) | ○ |
| C-26 | StrategyBase.scope()がコンテキストマネージャを返す | E-01 (行1223-1316) | ○ |
| C-27 | StrategyBase.run()が関数を各レプリカで実行する | E-01 (行1557-1673) | ○ |
| C-28 | StrategyBase.run()が不正な引数でエラー | E-01 (行1664-1666) | ○ |
| C-29 | StrategyBase.reduce()がSUM集約を行う | E-01 (行1675-1869) | ○ |
| C-30 | StrategyBase.reduce()がMEAN集約を行う | E-01 (行1675-1869) | ○ |
| C-31 | StrategyBase.reduce()が不正なreduce_opでエラー | E-01 (行1803-1805) | ○ |
| C-32 | experimental_distribute_datasetがDistributedDatasetを返す | E-01 (行1349-1468) | ○ |
| C-33 | distribute_datasets_from_functionがDistributedDatasetを返す | E-01 (行1470-1547) | ○ |
| C-34 | experimental_local_resultsがタプルを返す | E-01 (行1894-1912) | ○ |
| C-35 | num_replicas_in_syncがレプリカ数を返す | E-01 (行1919-1922) | ○ |

### mirrored_strategy.py関連（C-36〜C-49）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | MirroredStrategy.__init__でデフォルトデバイスが設定される | E-02 (行285-290) | ○ |
| C-37 | MirroredStrategy.__init__で指定デバイスが設定される | E-02 (行285-290) | ○ |
| C-38 | cross_device_opsが設定される | E-02 (行285-290) | ○ |
| C-39 | _is_device_list_single_workerがローカルでTrue | E-02 (行54-91) | ○ |
| C-40 | _is_device_list_single_workerがリモートでFalse | E-02 (行54-91) | ○ |
| C-41 | _is_device_list_single_workerが混在でエラー | E-02 (行76-83) | ○ |
| C-42 | _infer_num_gpus_per_workerがGPU数を返す | E-02 (行143-180) | ○ |
| C-43 | _infer_num_gpus_per_workerが不整合でエラー | E-02 (行170-172) | ○ |
| C-44 | all_local_devicesが利用可能GPUを返す | E-02 (行183-187) | ○ |
| C-45 | all_local_devicesが指定数を返す | E-02 (行183-187) | ○ |
| C-46 | all_local_devicesがCPUにフォールバック | E-02 (行187) | ○ |
| C-47 | MirroredExtended._initialize_strategyがデバイスを設定 | E-02 (行358-371) | ○ |
| C-48 | 重複デバイスでAssertionError | E-02 (行363-364) | ○ |
| C-49 | 空デバイスでAssertionError | E-02 (行361) | ○ |

### values.py関連（C-50〜C-62）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | DistributedValues.__init__でvaluesがタプル化される | E-03 (行136-138) | ○ |
| C-51 | DistributedValues._get()がreplica context内で値を返す | E-03 (行140-146) | ○ |
| C-52 | DistributedValues._get()がcross-replica contextで処理する | E-03 (行140-146) | ○ |
| C-53 | _primaryが最初の値を返す | E-03 (行168-171) | ○ |
| C-54 | _devicesがデバイスタプルを返す | E-03 (行173-175) | ○ |
| C-55 | PerReplica.__init__でPerReplicaが作成される | E-03 (行356-368) | ○ |
| C-56 | PerReplica.valuesがvaluesを返す | E-03 (行365-368) | ○ |
| C-57 | DistributedDelegate.__getattr__が属性を委譲する | E-03 (行200-224) | ○ |
| C-58 | DistributedDelegate.__add__が加算を行う | E-03 (行241-242) | ○ |
| C-59 | DistributedDelegate.__mul__が乗算を行う | E-03 (行253-254) | ○ |
| C-60 | apply_aggregation_replica_contextがSUM集約を行う | E-03 (行107-130) | ○ |
| C-61 | apply_aggregation_replica_contextがMEAN集約を行う | E-03 (行107-130) | ○ |
| C-62 | apply_aggregation_replica_contextがDistributedValuesでエラー | E-03 (行110-112) | ○ |

### cross_device_ops.py関連（C-63〜C-79）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | CrossDeviceOps.reduceが集約を行う | E-04 (行275-321) | ○ |
| C-64 | CrossDeviceOps.reduceが単一値で同一値を返す | E-04 (行311-316) | ○ |
| C-65 | CrossDeviceOps._gatherが連結を行う | E-04 (行323-367) | ○ |
| C-66 | CrossDeviceOps._gatherがIndexedSlicesでエラー | E-04 (行348-350) | ○ |
| C-67 | CrossDeviceOps.batch_reduceがバッチ集約を行う | E-04 (行400〜) | ○ |
| C-68 | validate_destinationsが有効な入力を受け付ける | E-04 (行69-81) | ○ |
| C-69 | validate_destinationsが無効な入力でエラー | E-04 (行77-78) | ○ |
| C-70 | validate_destinationsが空でエラー | E-04 (行80-81) | ○ |
| C-71 | check_destinationsが有効でTrueを返す | E-04 (行52-66) | ○ |
| C-72 | check_destinationsが空でFalseを返す | E-04 (行52-66) | ○ |
| C-73 | simple_broadcastがブロードキャストを行う | E-04 (行201-216) | ○ |
| C-74 | simple_broadcastが単一デバイスで値を返す | E-04 (行206-209) | ○ |
| C-75 | _simple_reduceがSUM集約を行う | E-04 (行219-236) | ○ |
| C-76 | _simple_reduceがMEAN集約を行う | E-04 (行231-233) | ○ |
| C-77 | _simple_reduceが空でエラー | E-04 (行223-224) | ○ |
| C-78 | _simple_gatherが連結を行う | E-04 (行239-248) | ○ |
| C-79 | _simple_gatherが空でエラー | E-04 (行242-243) | ○ |

### device_util.py関連（C-80〜C-88）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | canonicalizeがデバイス文字列を正規化する | E-05 (行24-73) | ○ |
| C-81 | canonicalizeがデフォルト値をマージする | E-05 (行66-69) | ○ |
| C-82 | canonicalizeがLogicalDeviceを処理する | E-05 (行45-46) | ○ |
| C-83 | canonicalize_without_job_and_taskがjob/taskなしで正規化 | E-05 (行76-102) | ○ |
| C-84 | resolveが現在のデバイスでresolveする | E-05 (行105-107) | ○ |
| C-85 | currentが現在のデバイス文字列を返す | E-05 (行136-145) | ○ |
| C-86 | get_host_for_deviceがホストCPUを返す | E-05 (行148-157) | ○ |
| C-87 | local_devices_from_num_gpusがGPU文字列を返す | E-05 (行160-163) | ○ |
| C-88 | local_devices_from_num_gpusが0GPUでCPUを返す | E-05 (行162-163) | ○ |

### reduce_util.py関連（C-89〜C-91）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | ReduceOp.from_variable_aggregationがSUMを変換する | E-06 (行36-47) | ○ |
| C-90 | ReduceOp.from_variable_aggregationがMEANを変換する | E-06 (行36-47) | ○ |
| C-91 | ReduceOp.from_variable_aggregationが未対応でエラー | E-06 (行44-46) | ○ |

### input_lib.py関連（C-92〜C-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | InputWorkers.__init__でワーカーデバイスペアが設定される | E-07 (行125-149) | ○ |
| C-93 | InputWorkers.num_workersがワーカー数を返す | E-07 (行151-153) | ○ |
| C-94 | InputWorkers.worker_devicesがデバイスを返す | E-07 (行155-157) | ○ |
| C-95 | compute_devices_for_workerがデバイスを返す | E-07 (行159-160) | ○ |
| C-96 | DistributedIteratorBase.__init__がイテレータを初期化する | E-07 (行234-257) | ○ |
| C-97 | DistributedIteratorBase.__init__が空ワーカーでエラー | E-07 (行249-250) | ○ |
| C-98 | __next__が次の要素を返す | E-07 (行262-266) | ○ |
| C-99 | __next__が終端でStopIteration | E-07 (行265-266) | ○ |
| C-100 | get_next_as_optionalがOptionalを返す | E-07 (行271-300) | ○ |
| C-101 | get_iterator_spec_from_datasetが仕様を返す | E-07 (行78-116) | ○ |

### collective_util.py関連（C-102〜C-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | Options.__init__でデフォルト値が設定される | E-08 (行120-135) | ○ |
| C-103 | Options.__init__で指定値が設定される | E-08 (行120-135) | ○ |
| C-104 | 負のbytes_per_packでエラー | E-08 (行124-126) | ○ |
| C-105 | 無効なimplementationでエラー | E-08 (行129-132) | ○ |
| C-106 | Options.mergeがマージを行う | E-08 (行139-160) | ○ |
| C-107 | Options.mergeがNoneでselfのコピーを返す | E-08 (行152-153) | ○ |

### multi_worker_util.py関連（C-108〜C-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | normalize_cluster_specがdictを変換する | E-09 (行22-42) | ○ |
| C-109 | normalize_cluster_specがClusterSpecをそのまま返す | E-09 (行22-42) | ○ |
| C-110 | normalize_cluster_specが無効な型でエラー | E-09 (行38-41) | ○ |
| C-111 | is_chiefがchiefでTrueを返す | E-09 (行108-145) | ○ |
| C-112 | is_chiefがworker0（chiefなし）でTrueを返す | E-09 (行143-144) | ○ |
| C-113 | is_chiefがworker1でFalseを返す | E-09 (行108-145) | ○ |
| C-114 | is_chiefがevaluatorでTrueを返す | E-09 (行138-139) | ○ |
| C-115 | worker_countがワーカー数を返す | E-09 (行211-229) | ○ |
| C-116 | worker_countがevaluator数を返す | E-09 (行224) | ○ |
| C-117 | worker_countがpsでエラー | E-09 (行217-218) | ○ |
| C-118 | id_in_clusterがchiefで0を返す | E-09 (行232-267) | ○ |
| C-119 | id_in_clusterがworkerでオフセットIDを返す | E-09 (行259-260) | ○ |
| C-120 | collective_leaderがchiefを返す | E-09 (行148-179) | ○ |
| C-121 | collective_leaderがworker0を返す | E-09 (行178-179) | ○ |
| C-122 | coordination_leaderがps0を返す | E-09 (行182-208) | ○ |

### coordinator/cluster_coordinator.py関連（C-123〜C-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | Closure.__init__でClosureが初期化される | E-10 (行193-240) | ○ |
| C-124 | Closure.__init__がcallableでない場合エラー | E-10 (行197-199) | ○ |
| C-125 | build_output_remote_valueがRemoteValueを構築する | E-10 (行242-249) | ○ |
| C-126 | build_output_remote_valueが2回呼び出しでエラー | E-10 (行247-249) | ○ |
| C-127 | execute_onがワーカー上で実行する | E-10 (行265-292) | ○ |
| C-128 | mark_cancelledがキャンセルをマークする | E-10 (行259-263) | ○ |
| C-129 | ClosureInputError.__init__が例外をラップする | E-10 (行79-102) | ○ |
| C-130 | ClosureAbortedError.__init__が例外をラップする | E-10 (行105-127) | ○ |

### distribute_utils.py関連（C-131〜C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | regroupがPerReplicaを作成する | E-11 (行58-154) | ○ |
| C-132 | regroupが同一オブジェクトでそのまま返す | E-11 (行111-133) | ○ |
| C-133 | regroupがネスト構造を処理する | E-11 (行71-96) | ○ |
| C-134 | select_replicaが指定レプリカの値を選択する | E-11 (行157-170) | ○ |
| C-135 | assert_mirroredがMirroredでエラーなし | E-11 (行179-188) | ○ |
| C-136 | assert_mirroredが非MirroredでTypeError | E-11 (行183-186) | ○ |
| C-137 | get_loss_reductionがSUMを返す | E-11 (行39-55) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースはソースコードの解析に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコード根拠に基づいて作成されており、主要なクラス・メソッド・関数をカバーしています
- テストケースはTensorFlowの分散学習フレームワークの主要コンポーネントをカバー:
  - 分散戦略（Strategy）の基本API
  - MirroredStrategy実装
  - 分散値（DistributedValues）の処理
  - クロスデバイス操作
  - 入力データの分散処理
  - マルチワーカー環境のユーティリティ

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースが対象メソッドの仕様を正しく反映しているか確認
- [ ] 正常系・異常系・境界値のテスト観点が適切にカバーされているか確認
- [ ] テスト優先度（高/中/低）が適切に設定されているか確認
- [ ] 入力値と期待結果の組み合わせが妥当か確認
- [ ] 実際のテスト実装時に必要な追加テストケースがないか検討
