---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：python-feature_column 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の関数/メソッド定義、バリデーションロジック、エラーハンドリングなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-063（shared_embedding_columns_v2 eager実行時エラー）**：eager実行モードでの動作確認が必要
  2. **C-082（concatenate_context_input）**：詳細な動作仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/feature_column/feature_column_v2.py` 820-914行（numeric_column関数定義）
- E-02: `tensorflow/python/feature_column/feature_column_v2.py` 920-1001行（bucketized_column関数定義）
- E-03: `tensorflow/python/feature_column/feature_column_v2.py` 1007-1073行（categorical_column_with_hash_bucket関数定義）
- E-04: `tensorflow/python/feature_column/feature_column_v2.py` 1189-1319行（categorical_column_with_vocabulary_file_v2関数定義）
- E-05: `tensorflow/python/feature_column/feature_column_v2.py` 1325-1438行（categorical_column_with_vocabulary_list関数定義）
- E-06: `tensorflow/python/feature_column/feature_column_v2.py` 1444-1516行（categorical_column_with_identity関数定義）
- E-07: `tensorflow/python/feature_column/feature_column_v2.py` 436-515行（embedding_column関数定義）
- E-08: `tensorflow/python/feature_column/feature_column_v2.py` 1520-1561行（indicator_column関数定義）
- E-09: `tensorflow/python/feature_column/feature_column_v2.py` 1567-1639行（weighted_categorical_column関数定義）
- E-10: `tensorflow/python/feature_column/feature_column_v2.py` 1649-1773行（crossed_column関数定義）
- E-11: `tensorflow/python/feature_column/feature_column_v2.py` 370-432行（make_parse_example_spec_v2関数定義）
- E-12: `tensorflow/python/feature_column/feature_column_v2.py` 188-320行（StateManager / _StateManagerImpl クラス定義）
- E-13: `tensorflow/python/feature_column/feature_column_v2.py` 1962-2109行（FeatureTransformationCache クラス定義）
- E-14: `tensorflow/python/feature_column/feature_column_v2.py` 2206-2329行（NumericColumn クラス定義）
- E-15: `tensorflow/python/feature_column/feature_column_v2.py` 2332-2486行（BucketizedColumn クラス定義）
- E-16: `tensorflow/python/feature_column/feature_column_v2.py` 2974-3083行（HashedCategoricalColumn クラス定義）
- E-17: `tensorflow/python/feature_column/feature_column_v2.py` 2489-2758行（EmbeddingColumn クラス定義）
- E-18: `tensorflow/python/feature_column/feature_column_v2.py` 680-814行（shared_embedding_columns_v2関数定義）
- E-19: `tensorflow/python/feature_column/feature_column.py` 145-214行（input_layer関数定義）
- E-20: `tensorflow/python/feature_column/feature_column.py` 283-416行（linear_model関数定義）
- E-21: `tensorflow/python/feature_column/feature_column.py` 2193-2235行（_normalize_feature_columns関数定義）
- E-22: `tensorflow/python/feature_column/sequence_feature_column.py` 104-149行（sequence_categorical_column_with_identity関数定義）
- E-23: `tensorflow/python/feature_column/sequence_feature_column.py` 155-196行（sequence_categorical_column_with_hash_bucket関数定義）
- E-24: `tensorflow/python/feature_column/sequence_feature_column.py` 202-266行（sequence_categorical_column_with_vocabulary_file関数定義）
- E-25: `tensorflow/python/feature_column/sequence_feature_column.py` 272-333行（sequence_categorical_column_with_vocabulary_list関数定義）
- E-26: `tensorflow/python/feature_column/sequence_feature_column.py` 339-397行（sequence_numeric_column関数定義）
- E-27: `tensorflow/python/feature_column/sequence_feature_column.py` 413-506行（SequenceNumericColumn クラス定義）
- E-28: `tensorflow/python/feature_column/sequence_feature_column.py` 53-99行（concatenate_context_input関数定義）
- E-29: `tensorflow/python/feature_column/serialization.py` 50-95行（serialize_feature_column関数定義）
- E-30: `tensorflow/python/feature_column/serialization.py` 100-154行（deserialize_feature_column関数定義）
- E-31: `tensorflow/python/feature_column/serialization.py` 157-198行（serialize_feature_columns, deserialize_feature_columns関数定義）
- E-32: `tensorflow/python/feature_column/utils.py` 26-48行（sequence_length_from_sparse_tensor関数定義）
- E-33: `tensorflow/python/feature_column/utils.py` 51-61行（assert_string_or_int, assert_key_is_string関数定義）
- E-34: `tensorflow/python/feature_column/utils.py` 64-120行（check_default_value関数定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | numeric_column正常系：有効なkeyと形状でNumericColumnが作成される | E-01 | ○ |
| C-002 | numeric_column正常系：多次元形状でNumericColumnが作成される | E-01 | ○ |
| C-003 | numeric_column正常系：normalizer_fnが適用される | E-01, E-14 | ○ |
| C-004 | numeric_column異常系：不正なdtypeでエラー | E-01 (899-901行) | ○ |
| C-005 | numeric_column異常系：shapeに負の値でエラー | E-01 (2968-2970行 _check_shape) | ○ |
| C-006 | numeric_column異常系：呼び出し不可なnormalizer_fnでエラー | E-01 (904-906行) | ○ |
| C-007 | numeric_column異常系：keyが非文字列でエラー | E-33 (57-61行) | ○ |
| C-008 | bucketized_column正常系：BucketizedColumnが作成される | E-02 | ○ |
| C-009 | bucketized_column異常系：NumericColumn以外でエラー | E-02 (987-990行) | ○ |
| C-010 | bucketized_column異常系：空のboundariesでエラー | E-02 (994-995行) | ○ |
| C-011 | bucketized_column異常系：ソートされていないboundariesでエラー | E-02 (998-1000行) | ○ |
| C-012 | bucketized_column異常系：多次元source_columnでエラー | E-02 (991-993行) | ○ |
| C-013 | categorical_column_with_hash_bucket正常系：作成される | E-03 | ○ |
| C-014 | categorical_column_with_hash_bucket異常系：hash_bucket_size=Noneでエラー | E-03 (1062-1063行) | ○ |
| C-015 | categorical_column_with_hash_bucket異常系：hash_bucket_size<=0でエラー | E-03 (1065-1068行) | ○ |
| C-016 | categorical_column_with_hash_bucket異常系：不正なdtypeでエラー | E-03 (1071行), E-33 | ○ |
| C-017 | categorical_column_with_vocabulary_file_v2正常系：作成される | E-04 | ○ |
| C-018 | categorical_column_with_vocabulary_file_v2正常系：num_oov_bucketsが設定される | E-04 | ○ |
| C-019 | categorical_column_with_vocabulary_file_v2異常系：空vocabulary_fileでエラー | E-04 (1277-1278行) | ○ |
| C-020 | categorical_column_with_vocabulary_file_v2異常系：両方指定でエラー | E-04 (1302-1306行) | ○ |
| C-021 | categorical_column_with_vocabulary_file_v2異常系：負のnum_oov_bucketsでエラー | E-04 (1307-1309行) | ○ |
| C-022 | categorical_column_with_vocabulary_list正常系：作成される | E-05 | ○ |
| C-023 | categorical_column_with_vocabulary_list異常系：空リストでエラー | E-05 (1405-1408行) | ○ |
| C-024 | categorical_column_with_vocabulary_list異常系：重複キーでエラー | E-05 (1409-1412行) | ○ |
| C-025 | categorical_column_with_identity正常系：作成される | E-06 | ○ |
| C-026 | categorical_column_with_identity正常系：default_valueが設定される | E-06 | ○ |
| C-027 | categorical_column_with_identity異常系：num_buckets<=0でエラー | E-06 (1506-1508行) | ○ |
| C-028 | categorical_column_with_identity異常系：default_value範囲外でエラー | E-06 (1509-1513行) | ○ |
| C-029 | embedding_column正常系：作成される | E-07 | ○ |
| C-030 | embedding_column正常系：combinerが設定される | E-07 | ○ |
| C-031 | embedding_column異常系：dimension<=0でエラー | E-07 (492-493行) | ○ |
| C-032 | embedding_column異常系：dimension=Noneでエラー | E-07 (492-493行) | ○ |
| C-033 | embedding_column異常系：ckpt_to_load_fromのみでエラー | E-07 (494-496行) | ○ |
| C-034 | embedding_column異常系：呼び出し不可initializerでエラー | E-07 (498-501行) | ○ |
| C-035 | indicator_column正常系：作成される | E-08 | ○ |
| C-036 | indicator_column異常系：CategoricalColumn以外でエラー | E-08 (1556-1560行) | ○ |
| C-037 | weighted_categorical_column正常系：作成される | E-09 | ○ |
| C-038 | weighted_categorical_column異常系：不正dtypeでエラー | E-09 (1634-1635行) | ○ |
| C-039 | crossed_column正常系：作成される | E-10 | ○ |
| C-040 | crossed_column異常系：hash_bucket_size<=0でエラー | E-10 (1753-1755行) | ○ |
| C-041 | crossed_column異常系：keys長<=1でエラー | E-10 (1756-1758行) | ○ |
| C-042 | crossed_column異常系：HashedCategoricalColumn含むでエラー | E-10 (1766-1771行) | ○ |
| C-043 | make_parse_example_spec_v2正常系：解析仕様生成 | E-11 | ○ |
| C-044 | make_parse_example_spec_v2異常系：FeatureColumn以外でエラー | E-11 (423-425行) | ○ |
| C-045 | StateManager.create_variable正常系：変数作成 | E-12 (212-261行) | ○ |
| C-046 | StateManager.create_variable異常系：重複変数でエラー | E-12 (235-236行) | ○ |
| C-047 | StateManager.get_variable正常系：変数取得 | E-12 (263-272行) | ○ |
| C-048 | StateManager.get_variable異常系：存在しない変数でエラー | E-12 (270-272行) | ○ |
| C-049 | FeatureTransformationCache.get正常系：変換済みテンソル取得 | E-13 (2006-2060行) | ○ |
| C-050 | FeatureTransformationCache.get正常系：文字列キーで生feature取得 | E-13 (2034-2037行) | ○ |
| C-051 | FeatureTransformationCache.get異常系：存在しないキーでエラー | E-13 (2039-2040行) | ○ |
| C-052 | NumericColumn.transform_feature正常系：float32キャスト | E-14 (2238-2245行) | ○ |
| C-053 | NumericColumn.transform_feature正常系：normalizer_fn適用 | E-14 (2243-2244行) | ○ |
| C-054 | NumericColumn.transform_feature異常系：SparseTensorでエラー | E-14 (2239-2242行) | ○ |
| C-055 | BucketizedColumn.transform_feature正常系：バケット化 | E-15 (2374-2378行) | ○ |
| C-056 | BucketizedColumn.get_dense_tensor正常系：one-hot取得 | E-15 (2400-2403行) | ○ |
| C-057 | HashedCategoricalColumn.transform_feature正常系：ハッシュ変換 | E-16 (3002-3038行) | ○ |
| C-058 | HashedCategoricalColumn.transform_feature異常系：非SparseTensorでエラー | E-16 (3004-3005行) | ○ |
| C-059 | EmbeddingColumn.get_dense_tensor正常系：埋め込みルックアップ | E-17 (2635-2663行) | ○ |
| C-060 | EmbeddingColumn.get_dense_tensor異常系：SequenceCategoricalColumnでエラー | E-17 (2650-2659行) | ○ |
| C-061 | EmbeddingColumn.get_sequence_dense_tensor正常系：シーケンス埋め込み | E-17 (2685-2702行) | ○ |
| C-062 | shared_embedding_columns_v2正常系：共有埋め込み作成 | E-18 | ○ |
| C-063 | shared_embedding_columns_v2異常系：eager実行時エラー | E-18 (755-757行) | △ |
| C-064 | shared_embedding_columns_v2異常系：異なる型でエラー | E-18 (786-791行) | ○ |
| C-065 | input_layer正常系：密テンソル返却 | E-19 | ○ |
| C-066 | input_layer異常系：非DenseColumnでエラー | E-19 (95-99行, feature_column.py) | ○ |
| C-067 | linear_model正常系：線形予測テンソル返却 | E-20 | ○ |
| C-068 | linear_model正常系：unitsパラメータ反映 | E-20 | ○ |
| C-069 | linear_model異常系：不正なカラムでエラー | E-20 (590-593行, feature_column.py) | ○ |
| C-070 | _normalize_feature_columns正常系：リスト正規化 | E-21 (2209-2210行) | ○ |
| C-071 | _normalize_feature_columns異常系：空リストでエラー | E-21 (2189-2190行) | ○ |
| C-072 | _normalize_feature_columns異常系：重複名でエラー | E-21 (2191-2200行) | ○ |
| C-073 | sequence_categorical_column_with_identity正常系：作成 | E-22 | ○ |
| C-074 | sequence_categorical_column_with_identity異常系：num_buckets<=0でエラー | E-06経由 | ○ |
| C-075 | sequence_categorical_column_with_hash_bucket正常系：作成 | E-23 | ○ |
| C-076 | sequence_categorical_column_with_vocabulary_file正常系：作成 | E-24 | ○ |
| C-077 | sequence_categorical_column_with_vocabulary_list正常系：作成 | E-25 | ○ |
| C-078 | sequence_numeric_column正常系：作成 | E-26 | ○ |
| C-079 | sequence_numeric_column異常系：不正dtypeでエラー | E-26 (385-387行) | ○ |
| C-080 | sequence_numeric_column異常系：非callableでエラー | E-26 (388-390行) | ○ |
| C-081 | SequenceNumericColumn.get_sequence_dense_tensor正常系 | E-27 (458-487行) | ○ |
| C-082 | concatenate_context_input正常系：コンテキスト連結 | E-28 | △ |
| C-083 | concatenate_context_input異常系：sequence_input rank!=3でエラー | E-28 (73-77行) | ○ |
| C-084 | concatenate_context_input異常系：context_input rank!=2でエラー | E-28 (83-87行) | ○ |
| C-085 | serialize_feature_column正常系：シリアライズ | E-29 | ○ |
| C-086 | serialize_feature_column正常系：文字列パススルー | E-29 (90-91行) | ○ |
| C-087 | serialize_feature_column異常系：非FeatureColumnでエラー | E-29 (94-95行) | ○ |
| C-088 | deserialize_feature_column正常系：デシリアライズ | E-30 | ○ |
| C-089 | deserialize_feature_column正常系：文字列パススルー | E-30 (125-126行) | ○ |
| C-090 | deserialize_feature_column異常系：不正形式でエラー | E-30 (_class_and_config... 305-307行) | ○ |
| C-091 | serialize_feature_columns正常系：リストシリアライズ | E-31 (157-173行) | ○ |
| C-092 | deserialize_feature_columns正常系：リストデシリアライズ | E-31 (176-198行) | ○ |
| C-093 | sequence_length_from_sparse_tensor正常系：長さ計算 | E-32 | ○ |
| C-094 | assert_string_or_int正常系：型アサーション | E-33 (51-54行) | ○ |
| C-095 | assert_string_or_int異常系：float型でエラー | E-33 (52-54行) | ○ |
| C-096 | assert_key_is_string正常系：文字列key | E-33 (57-58行) | ○ |
| C-097 | assert_key_is_string異常系：非文字列keyでエラー | E-33 (58-61行) | ○ |
| C-098 | check_default_value正常系：タプル返却 | E-34 | ○ |
| C-099 | check_default_value正常系：None返却 | E-34 (90-91行) | ○ |
| C-100 | check_default_value異常系：形状不整合でエラー | E-34 (103-107行) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-063（shared_embedding_columns_v2 eager実行時エラー）**
  - eager実行モードでの具体的な挙動は、実行環境に依存するため詳細な動作確認が必要
  - 候補：実行環境でのテスト / TensorFlow公式ドキュメント参照
- **C-082（concatenate_context_input）**
  - 関数の詳細な動作仕様について、追加の確認が必要
  - 候補：sequence_feature_column.py の実装詳細 / 既存テストコード参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストケース全体の構成と網羅性
- **1（中リスク）**: eager実行モード関連のテスト（C-063）、concat系関数のテスト（C-082）
- **2（高リスク）**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] 各FeatureColumn関数の主要な正常系テストケースが含まれているか確認
- [ ] 各関数のバリデーションエラー（ValueError, TypeError）に対応するテストケースが含まれているか確認
- [ ] 境界値テスト（空リスト、0以下の値、None等）が適切に含まれているか確認
- [ ] シーケンス系Feature Column（sequence_*）のテストケースが網羅されているか確認
- [ ] シリアライズ/デシリアライズ機能のテストケースが含まれているか確認
- [ ] StateManager, FeatureTransformationCache等の内部クラスのテストケースが含まれているか確認
