---
generated_at: 2026-02-03 12:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：python-framework 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **UT-PFW-106〜109（config.py TensorFloat-32関連）**：設定の内部状態に依存するため、実行時の確認が必要
  2. **UT-PFW-114〜117（デバイス設定関連）**：実際のハードウェア環境に依存
  3. **UT-PFW-121〜122（決定論的実行）**：グローバル状態の変更を伴うため慎重に確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/framework/tensor.py` - Tensor、TensorSpec、BoundedTensorSpec、DenseSpecクラス定義
- E-02: `tensorflow/python/framework/dtypes.py` - DType クラスとas_dtype関数定義
- E-03: `tensorflow/python/framework/tensor_shape.py` - Dimension、TensorShapeクラス定義
- E-04: `tensorflow/python/framework/ops.py` - convert_to_tensor、EagerTensor、SymbolicTensor関連処理
- E-05: `tensorflow/python/framework/errors_impl.py` - OpError及び各種例外クラス定義
- E-06: `tensorflow/python/framework/sparse_tensor.py` - SparseTensor、SparseTensorSpecクラス定義
- E-07: `tensorflow/python/framework/constant_op.py` - constant関数、convert_to_eager_tensor関数定義
- E-08: `tensorflow/python/framework/indexed_slices.py` - IndexedSlices、IndexedSlicesSpecクラス定義
- E-09: `tensorflow/python/framework/config.py` - TensorFlow設定関連関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

### tensor.py 関連（UT-PFW-001〜025, 136〜145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Tensor.dtypeがDTypeを返す | E-01: L263-265 `@property def dtype(self): return self._dtype` | ○ |
| C-002 | Tensor.shapeがTensorShapeを返す | E-01: L271-296 `@property def shape(self) -> tensor_shape.TensorShape` | ○ |
| C-003 | get_shapeがshapeのエイリアス | E-01: L359-437 `def get_shape(self): return self.shape` | ○ |
| C-004 | set_shapeで互換shapeを設定可能 | E-01: L439-575 `def set_shape(self, shape)` | ○ |
| C-005 | set_shapeで不正shapeにValueError | E-01: L555-557 `Raises: ValueError` | ○ |
| C-006 | Eager実行でTensorイテレート可能 | E-01: L321-326 `def __iter__(self)` | ○ |
| C-007 | Graph実行でイテレーション禁止 | E-01: L322-323 `if not context.executing_eagerly(): self._disallow_iteration()` | ○ |
| C-008 | Graph実行でbool変換禁止 | E-01: L641-659 `def __bool__(self): self._disallow_bool_casting()` | ○ |
| C-009 | eval()でセッション内評価 | E-01: L671-695 `def eval(self, feed_dict=None, session=None)` | ○ |
| C-010 | セッション未設定でValueError | E-01: L71-108 `_eval_using_default_session()` | ○ |
| C-011 | ref()で参照オブジェクト取得 | E-01: L701-740 `def ref(self): return object_identity.Reference(self)` | ○ |
| C-012 | TF2でTensorハッシュ禁止 | E-01: L607-613 `def __hash__(self)` | ○ |
| C-013 | TensorSpec初期化 | E-01: L852-866 `def __init__(self, shape, dtype=dtypes.float32, name=None)` | ○ |
| C-014 | TensorSpec.is_compatible_with | E-01: L983-995 | ○ |
| C-015 | TensorSpec互換性チェック（False） | E-01: L883-886 | ○ |
| C-016 | TensorSpec.from_tensor | E-01: L1139-1160 | ○ |
| C-017 | TensorSpec.from_spec | E-01: L1125-1137 | ○ |
| C-018 | BoundedTensorSpec初期化 | E-01: L1281-1329 | ○ |
| C-019 | BoundedTensorSpec minimum=NoneでError | E-01: L1302-1303 `if minimum is None: raise ValueError` | ○ |
| C-020 | BoundedTensorSpec maximum=NoneでError | E-01: L1304-1305 `if maximum is None: raise ValueError` | ○ |
| C-021 | get_op_name関数 | E-01: L819-842 | ○ |
| C-022 | get_op_nameコロンなし | E-01: L839-842 | ○ |
| C-023 | get_op_name空文字列でError | E-01: L832-834 | ○ |
| C-024 | sanitize_spec_name | E-01: L794-816 | ○ |
| C-025 | sanitize_spec_name空文字列 | E-01: L807-808 | ○ |

### dtypes.py 関連（UT-PFW-026〜037, 146〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-026 | DType初期化 | E-02: L73-81 `def __init__(self, type_enum, handle_data=None)` | ○ |
| C-027 | DType.base_dtype | E-02: L96-108 | ○ |
| C-028 | DType.real_dtype | E-02: L110-119 | ○ |
| C-029 | DType.min | E-02: L126-148 | ○ |
| C-030 | DType.min quantized型でError | E-02: L134-138 | ○ |
| C-031 | DType.max | E-02: L150-172 | ○ |
| C-032 | DType.is_compatible_with | E-02: L194-214 | ○ |
| C-033 | DType.__eq__ | E-02: L264-275 | ○ |
| C-034 | DType.__eq__ None | E-02: L266-267 | ○ |
| C-035 | as_dtype文字列変換 | E-02: L885-945 | ○ |
| C-036 | as_dtype numpy変換 | E-02: L923-927 | ○ |
| C-037 | as_dtype無効型でError | E-02: L944-945 | ○ |
| C-146 | DType.as_numpy_dtype | E-02: L121-124 | ○ |
| C-147 | DType._is_ref_dtype True | E-02: L83-86 | ○ |
| C-148 | DType._is_ref_dtype False | E-02: L83-86 | ○ |
| C-149 | DType.limits | E-02: L174-192 | ○ |
| C-150 | DType.limits 未定義でError | E-02: L185-188 | ○ |

### tensor_shape.py 関連（UT-PFW-038〜065, 123〜135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-038 | Dimension正整数初期化 | E-03: L204-225 | ○ |
| C-039 | Dimension None初期化 | E-03: L210-211 | ○ |
| C-040 | Dimension負数でError | E-03: L207-208, L224-225 | ○ |
| C-041 | Dimension.is_compatible_with同値 | E-03: L276-290 | ○ |
| C-042 | Dimension.is_compatible_with None | E-03: L289 | ○ |
| C-043 | Dimension.merge_with | E-03: L306-341 | ○ |
| C-044 | Dimension.merge_with不正でError | E-03: L337 | ○ |
| C-045 | Dimension.__add__ | E-03: L343-372 | ○ |
| C-046 | Dimension.__add__ 未知 | E-03: L369-370 | ○ |
| C-047 | TensorShapeリスト初期化 | E-03: L820-861 | ○ |
| C-048 | TensorShape None初期化 | E-03: L831-832 | ○ |
| C-049 | TensorShape.rank | E-03: L892-897 | ○ |
| C-050 | TensorShape.rank None | E-03: L896-897 | ○ |
| C-051 | TensorShape.__len__ | E-03: L918-922 | ○ |
| C-052 | TensorShape.__len__ 未知でError | E-03: L920-921 | ○ |
| C-053 | TensorShape.is_compatible_with | E-03: L1324-1370 | ○ |
| C-054 | TensorShape部分未知との互換性 | E-03: L1366-1369 | ○ |
| C-055 | TensorShape.is_fully_defined True | E-03: L1417-1420 | ○ |
| C-056 | TensorShape.is_fully_defined False | E-03: L1419-1420 | ○ |
| C-057 | TensorShape.merge_with | E-03: L998-1048 | ○ |
| C-058 | TensorShape.merge_with不正でError | E-03: L1047-1048 | ○ |
| C-059 | TensorShape.concatenate | E-03: L1058-1079 | ○ |
| C-060 | TensorShape.as_list | E-03: L1431-1442 | ○ |
| C-061 | TensorShape.as_list未知でError | E-03: L1440-1441 | ○ |
| C-062 | TensorShape.num_elements | E-03: L991-996 | ○ |
| C-063 | TensorShape.num_elements None | E-03: L995-996 | ○ |
| C-064 | unknown_shape関数 | E-03: L1553-1573 | ○ |
| C-065 | unknown_shape rank指定 | E-03: L1571-1573 | ○ |
| C-123 | as_dimension | E-03: L728-744 | ○ |
| C-124 | as_dimension Dimension | E-03: L741-742 | ○ |
| C-125 | as_shape | E-03: L1545-1550 | ○ |
| C-126 | as_shape TensorShape | E-03: L1547-1548 | ○ |
| C-127 | dimension_value | E-03: L106-136 | ○ |
| C-128 | dimension_value整数 | E-03: L136 | ○ |
| C-129 | dimension_at_index | E-03: L139-185 | ○ |
| C-130 | TensorShape.with_rank | E-03: L1109-1127 | ○ |
| C-131 | TensorShape.with_rank不正でError | E-03: L1126-1127 | ○ |
| C-132 | TensorShape.with_rank_at_least | E-03: L1129-1146 | ○ |
| C-133 | TensorShape.with_rank_at_least不足でError | E-03: L1143-1144 | ○ |
| C-134 | TensorShape.assert_is_fully_defined | E-03: L1422-1429 | ○ |
| C-135 | TensorShape.assert_is_fully_defined Error | E-03: L1428-1429 | ○ |

### ops.py 関連（UT-PFW-066〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-066 | convert_to_tensorリスト変換 | E-04: L742-759 | ○ |
| C-067 | convert_to_tensor numpy変換 | E-04: L742-759 | ○ |
| C-068 | convert_to_tensor dtype指定 | E-04: L752-758 | ○ |
| C-069 | convert_to_tensor不正dtype | E-04: L757-758 | ○ |
| C-070 | convert_n_to_tensor | E-04: L766-810 | ○ |
| C-071 | convert_to_tensor_or_composite | E-04: L846-909 | ○ |
| C-072 | EagerTensor.numpy | E-04: L416-441 | ○ |
| C-073 | EagerTensor.__len__ | E-04: L358-366 | ○ |
| C-074 | EagerTensor.__len__ スカラーでError | E-04: L360-361 | ○ |
| C-075 | pack_eager_tensors | E-04: L682-738 | ○ |
| C-076 | pack_eager_tensors空リストでError | E-04: L694-696 | ○ |
| C-077 | pack_eager_tensors dtype不一致でError | E-04: L708-711 | ○ |

### errors_impl.py 関連（UT-PFW-078〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-078 | OpError初期化 | E-05: L66-88 | ○ |
| C-079 | OpError.message | E-05: L96-99 | ○ |
| C-080 | InvalidArgumentError | E-05: L270-287 | ○ |
| C-081 | NotFoundError | E-05: L303-315 | ○ |
| C-082 | exception_type_from_error_code | E-05: L525-527 | ○ |

### sparse_tensor.py 関連（UT-PFW-083〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-083 | SparseTensor初期化 | E-06: L118-154 | ○ |
| C-084 | SparseTensor.get_shape | E-06: L156-162 | ○ |
| C-085 | SparseTensor.with_values | E-06: L183-206 | ○ |
| C-086 | SparseTensor.set_shape | E-06: L232-287 | ○ |
| C-087 | SparseTensor.set_shape不正でError | E-06: L286-287 | ○ |
| C-088 | SparseTensorSpec初期化 | E-06: L386-395 | ○ |
| C-089 | SparseTensorSpec.from_value | E-06: L504-515 | ○ |
| C-090 | is_sparse True | E-06: L563-576 | ○ |
| C-091 | is_sparse False | E-06: L563-576 | ○ |

### constant_op.py 関連（UT-PFW-092〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-092 | constant基本 | E-07: L177-277 | ○ |
| C-093 | constant dtype指定 | E-07: L204-209 | ○ |
| C-094 | constant shape展開 | E-07: L210-221 | ○ |
| C-095 | constant_v1 verify_shape | E-07: L111-174 | ○ |
| C-096 | constant_v1 verify_shape不正でError | E-07: L307-309 | ○ |
| C-097 | convert_to_eager_tensor | E-07: L75-108 | ○ |
| C-098 | convert_to_eager_tensor dtype不一致でError | E-07: L98-100 | ○ |
| C-099 | is_constant True | E-07: L329-334 | ○ |
| C-100 | is_constant False | E-07: L329-334 | ○ |

### indexed_slices.py 関連（UT-PFW-101〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | IndexedSlices初期化 | E-08: L98-102 | ○ |
| C-102 | IndexedSlices.shape | E-08: L119-129 | ○ |
| C-103 | IndexedSlices.__neg__ | E-08: L162-163 | ○ |
| C-104 | IndexedSlicesSpec初期化 | E-08: L212-236 | ○ |
| C-105 | convert_to_tensor_or_indexed_slices | E-08: L277-299 | ○ |

### config.py 関連（UT-PFW-106〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | tensor_float_32_execution_enabled | E-09: L31-41 | ○ |
| C-107 | enable_tensor_float_32_execution | E-09: L50-105 | ○ |
| C-108 | get_intra_op_parallelism_threads | E-09: L108-119 | ○ |
| C-109 | set_intra_op_parallelism_threads | E-09: L122-133 | ○ |
| C-110 | list_physical_devices | E-09: L428-470 | ○ |
| C-111 | list_physical_devices フィルタ | E-09: L453-454 | ○ |
| C-112 | list_logical_devices | E-09: L473-509 | ○ |
| C-113 | get_visible_devices | E-09: L512-542 | ○ |
| C-114 | set_visible_devices | E-09: L545-578 | △ |
| C-115 | set_visible_devices RuntimeError | E-09: L576 | △ |
| C-116 | get_memory_growth | E-09: L712-738 | ○ |
| C-117 | set_memory_growth | E-09: L741-766 | △ |
| C-118 | get_device_policy | E-09: L316-341 | ○ |
| C-119 | set_device_policy | E-09: L344-387 | ○ |
| C-120 | set_device_policy無効でError | E-09: L383-387 | ○ |
| C-121 | enable_op_determinism | E-09: L944-1105 | ○ |
| C-122 | is_op_determinism_enabled | E-09: L1113-1115 | ○ |

## 4) 不足情報（Unknown / Missing）
- **デバイス設定関連テスト（UT-PFW-114, 115, 117）**：実際のデバイスが必要なため、CI環境での自動テストには制限がある可能性
  - 候補：モック実装 / 統合テスト環境 / デバイス仮想化

## 5) リスクフラグ（レビュー観点）
- **リスク 0（低リスク）**: 大部分のテストケース。ソースコードに明確な根拠あり
- **リスク 1（中リスク）**: デバイス設定・メモリ設定関連（UT-PFW-106〜122）。実行環境依存の可能性あり
- **リスク 0（低リスク）**: エラー処理・例外処理関連。明確なエラーコードとの対応あり

## 6) レビュアーチェックリスト（最小）
- [ ] 全150件のテストケースがソースコードの対応する関数/メソッドを正しく参照しているか確認
- [ ] 「正常系」「異常系」「境界値」の観点が適切に網羅されているか確認
- [ ] 優先度「高」のテストケースが重要なビジネスロジック（型変換、shape検証、エラー処理）をカバーしているか確認
- [ ] デバイス設定関連テスト（△マーク）の実行可能性を確認
- [ ] テストID（UT-PFW-xxx）が連番で漏れがないか確認
- [ ] 入力値と期待結果が具体的で再現可能か確認
