---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 137
  claims_with_evidence: 137
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：python-profiler.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：137 / 137、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースにソースコード根拠あり
  2. 外部依存（_pywrap_profiler等）のモック戦略要確認
  3. 統合テスト観点でのカバレッジ確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/profiler/profiler_v2.py` - TensorFlow 2.x Profiler実装（ProfilerOptions, start, stop, warmup, start_server, Profile）
- E-02: `tensorflow/python/profiler/profiler_client.py` - プロファイラクライアントAPI（trace, monitor, _strip_prefix, _strip_addresses）
- E-03: `tensorflow/python/profiler/model_analyzer.py` - モデル分析器（Profiler, profile, advise, _build_options, _build_advisor_options, _graph_string）
- E-04: `tensorflow/python/profiler/option_builder.py` - プロファイルオプションビルダー（ProfileOptionBuilder）
- E-05: `tensorflow/python/profiler/profile_context.py` - プロファイルコンテキスト（ProfileContext, _profiled_run, _profiled_init）
- E-06: `tensorflow/python/profiler/trace.py` - トレース機能（Trace, trace_wrapper, enabled）
- E-07: `tensorflow/python/profiler/pprof_profiler.py` - pprof形式プロファイラ（StringTable, Functions, Locations, Samples, PprofProfiler, get_profiles, profile）
- E-08: `tensorflow/python/profiler/tfprof_logger.py` - tfprofロガー（_fill_missing_graph_shape, _str_id, _get_logged_ops, merge_default_with_oplog, write_op_log）
- E-09: `tensorflow/python/profiler/internal/flops_registry.py` - FLOPS計算レジストリ（各種演算のFLOPS計算関数）
- E-10: `tensorflow/python/profiler/__init__.py` - モジュール公開API定義
- E-11: `tensorflow/python/profiler/profiler.py` - レガシープロファイラ（インポートのみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProfilerOptionsのデフォルト値テスト | E-01 (lines 46-78) | ○ |
| C-02 | ProfilerOptionsのカスタム値テスト | E-01 (lines 70-77) | ○ |
| C-03 | start関数の正常系テスト | E-01 (lines 81-126) | ○ |
| C-04 | startのオプション付きテスト | E-01 (lines 116-117) | ○ |
| C-05 | start関数の重複起動エラー | E-01 (lines 109-111, 118-123) | ○ |
| C-06 | stop関数の正常系テスト | E-01 (lines 129-153) | ○ |
| C-07 | stop関数の保存なしテスト | E-01 (lines 147-153) | ○ |
| C-08 | stop関数の未起動エラー | E-01 (lines 143-146) | ○ |
| C-09 | warmup関数のテスト | E-01 (lines 156-165) | ○ |
| C-10 | start_server関数のテスト | E-01 (lines 168-180) | ○ |
| C-11 | Profileクラス初期化テスト | E-01 (lines 183-206) | ○ |
| C-12 | Profile.__enter__テスト | E-01 (lines 208-209) | ○ |
| C-13 | Profile.__exit__テスト | E-01 (lines 211-212) | ○ |
| C-14 | trace関数の正常系テスト | E-02 (lines 24-136) | ○ |
| C-15 | trace関数の複数ワーカーテスト | E-02 (lines 73-84) | ○ |
| C-16 | trace関数のduration_ms=0エラー | E-02 (lines 123-125) | ○ |
| C-17 | trace関数のduration_ms負値エラー | E-02 (lines 123-125) | ○ |
| C-18 | monitor関数の正常系テスト | E-02 (lines 139-170) | ○ |
| C-19 | monitor関数のレベル2テスト | E-02 (lines 150-151) | ○ |
| C-20 | _strip_prefix関数テスト | E-02 (lines 173-174) | ○ |
| C-21 | _strip_prefixプレフィックスなしテスト | E-02 (line 174) | ○ |
| C-22 | _strip_addresses関数テスト | E-02 (lines 177-178) | ○ |
| C-23 | _graph_string関数テスト | E-03 (lines 45-50) | ○ |
| C-24 | _graph_stringのNoneグラフテスト | E-03 (lines 47-50) | ○ |
| C-25 | _build_options関数テスト | E-03 (lines 53-98) | ○ |
| C-26 | _build_optionsのデフォルト値テスト | E-03 (lines 63-96) | ○ |
| C-27 | _build_advisor_options関数テスト | E-03 (lines 101-118) | ○ |
| C-28 | _build_advisor_optionsのNoneテスト | E-03 (lines 111-112) | ○ |
| C-29 | Profiler.__init__テスト | E-03 (lines 161-178) | ○ |
| C-30 | Profiler.__init__グラフなしテスト | E-03 (lines 170-171) | ○ |
| C-31 | Profiler.add_stepテスト | E-03 (lines 183-199) | ○ |
| C-32 | Profiler.profile_pythonテスト | E-03 (lines 201-221) | ○ |
| C-33 | Profiler.profile_operationsテスト | E-03 (lines 223-241) | ○ |
| C-34 | Profiler.profile_name_scopeテスト | E-03 (lines 243-259) | ○ |
| C-35 | Profiler.profile_graphテスト | E-03 (lines 261-277) | ○ |
| C-36 | Profiler.adviseテスト | E-03 (lines 279-292) | ○ |
| C-37 | Profiler.serialize_to_stringテスト | E-03 (lines 294-303) | ○ |
| C-38 | profile関数scopeコマンドテスト | E-03 (lines 310-382) | ○ |
| C-39 | profile関数opコマンドテスト | E-03 (lines 358-367) | ○ |
| C-40 | profile関数graphコマンドテスト | E-03 (lines 369-378) | ○ |
| C-41 | profile関数codeコマンドテスト | E-03 (lines 358-367) | ○ |
| C-42 | profile関数の不正コマンドエラー | E-03 (lines 379-380) | ○ |
| C-43 | advise関数テスト | E-03 (lines 385-422) | ○ |
| C-44 | ProfileOptionBuilder.__init__デフォルトテスト | E-04 (lines 58-82) | ○ |
| C-45 | ProfileOptionBuilder.__init__オプション指定テスト | E-04 (lines 64-65) | ○ |
| C-46 | trainable_variables_parameterテスト | E-04 (lines 84-108) | ○ |
| C-47 | float_operationテスト | E-04 (lines 110-137) | ○ |
| C-48 | time_and_memoryテスト | E-04 (lines 139-187) | ○ |
| C-49 | time_and_memoryカスタム閾値テスト | E-04 (lines 140-142) | ○ |
| C-50 | buildメソッドテスト | E-04 (lines 189-195) | ○ |
| C-51 | with_max_depthテスト | E-04 (lines 197-210) | ○ |
| C-52 | with_min_memoryテスト | E-04 (lines 212-239) | ○ |
| C-53 | with_min_execution_timeテスト | E-04 (lines 241-260) | ○ |
| C-54 | with_min_parametersテスト | E-04 (lines 262-275) | ○ |
| C-55 | with_min_occurrenceテスト | E-04 (lines 277-293) | ○ |
| C-56 | with_min_float_operationsテスト | E-04 (lines 295-310) | ○ |
| C-57 | with_accounted_typesテスト | E-04 (lines 312-332) | ○ |
| C-58 | with_node_namesテスト | E-04 (lines 334-366) | ○ |
| C-59 | account_displayed_op_onlyテスト | E-04 (lines 368-381) | ○ |
| C-60 | with_empty_outputテスト | E-04 (lines 383-386) | ○ |
| C-61 | with_stdout_outputテスト | E-04 (lines 388-391) | ○ |
| C-62 | with_file_outputテスト | E-04 (lines 393-396) | ○ |
| C-63 | with_timeline_outputテスト | E-04 (lines 398-401) | ○ |
| C-64 | with_pprof_outputテスト | E-04 (lines 403-415) | ○ |
| C-65 | order_byテスト | E-04 (lines 417-431) | ○ |
| C-66 | selectテスト | E-04 (lines 433-447) | ○ |
| C-67 | with_stepテスト | E-04 (lines 449-461) | ○ |
| C-68 | ProfileContext.__init__正常系テスト | E-05 (lines 149-188) | ○ |
| C-69 | ProfileContext.__init__トレースステップ指定テスト | E-05 (lines 164-171) | ○ |
| C-70 | ProfileContext.__init__空ディレクトリエラー | E-05 (lines 160-161) | ○ |
| C-71 | ProfileContext.__init__トレースステップ上限超過 | E-05 (lines 168-169) | ○ |
| C-72 | ProfileContext.__init__無効化テスト | E-05 (lines 155-157) | ○ |
| C-73 | ProfileContext.get_profiles正常系テスト | E-05 (lines 190-209) | ○ |
| C-74 | ProfileContext.get_profiles未実行エラー | E-05 (lines 207-208) | ○ |
| C-75 | ProfileContext.add_auto_profilingテスト | E-05 (lines 211-225) | ○ |
| C-76 | ProfileContext.add_auto_profiling無効時テスト | E-05 (lines 221-222) | ○ |
| C-77 | ProfileContext.profiler取得テスト | E-05 (lines 227-234) | ○ |
| C-78 | ProfileContext.profiler無効時テスト | E-05 (lines 230-231) | ○ |
| C-79 | ProfileContext.trace_next_stepテスト | E-05 (lines 236-241) | ○ |
| C-80 | ProfileContext.dump_next_stepテスト | E-05 (lines 243-248) | ○ |
| C-81 | ProfileContext._is_fast_path高速パステスト | E-05 (lines 250-257) | ○ |
| C-82 | ProfileContext._is_fast_path遅いパステスト | E-05 (lines 251-256) | ○ |
| C-83 | ProfileContext._should_traceテスト | E-05 (lines 259-286) | ○ |
| C-84 | ProfileContext.__enter__テスト | E-05 (lines 323-346) | ○ |
| C-85 | ProfileContext.__enter__重複エラー | E-05 (lines 332-337) | ○ |
| C-86 | ProfileContext.__exit__テスト | E-05 (lines 348-356) | ○ |
| C-87 | Trace.__init__正常系テスト | E-06 (lines 50-81) | ○ |
| C-88 | Trace.__init__キーワード引数テスト | E-06 (lines 55-76, 79) | ○ |
| C-89 | Trace.__init__無効時テスト | E-06 (lines 80-81) | ○ |
| C-90 | Trace.__enter__テスト | E-06 (lines 83-85) | ○ |
| C-91 | Trace.set_metadata正常系テスト | E-06 (lines 87-119) | ○ |
| C-92 | Trace.set_metadata無効時テスト | E-06 (lines 118) | ○ |
| C-93 | Trace.__exit__テスト | E-06 (lines 121-123) | ○ |
| C-94 | trace_wrapper名前指定テスト | E-06 (lines 126-187) | ○ |
| C-95 | trace_wrapper関数名推測テスト | E-06 (lines 168-174) | ○ |
| C-96 | trace_wrapperデコレータ実行テスト | E-06 (lines 176-185) | ○ |
| C-97 | StringTable.__init__テスト | E-07 (lines 59-65) | ○ |
| C-98 | StringTable.index_ofテスト | E-07 (lines 67-85) | ○ |
| C-99 | StringTable.index_of重複テスト | E-07 (lines 80-81) | ○ |
| C-100 | StringTable.index_ofのNoneテスト | E-07 (lines 78-79) | ○ |
| C-101 | StringTable.next_indexテスト | E-07 (lines 87-93) | ○ |
| C-102 | StringTable.string_tableテスト | E-07 (lines 95-97) | ○ |
| C-103 | Functions.__init__テスト | E-07 (lines 100-112) | ○ |
| C-104 | Functions.index_ofテスト | E-07 (lines 114-137) | ○ |
| C-105 | Functions.index_of重複テスト | E-07 (lines 126-127) | ○ |
| C-106 | Functions.function_protosテスト | E-07 (lines 139-141) | ○ |
| C-107 | Locations.__init__テスト | E-07 (lines 144-159) | ○ |
| C-108 | Locations.index_ofテスト | E-07 (lines 161-194) | ○ |
| C-109 | Locations.location_protosテスト | E-07 (lines 196-198) | ○ |
| C-110 | Samples.__init__テスト | E-07 (lines 201-217) | ○ |
| C-111 | Samples.addテスト | E-07 (lines 219-246) | ○ |
| C-112 | Samples.add累積テスト | E-07 (lines 227-229) | ○ |
| C-113 | Samples.get_sample_protosテスト | E-07 (lines 248-250) | ○ |
| C-114 | PprofProfiler.__init__テスト | E-07 (lines 253-267) | ○ |
| C-115 | PprofProfiler.profileテスト | E-07 (lines 269-296) | ○ |
| C-116 | get_profiles関数テスト | E-07 (lines 384-397) | ○ |
| C-117 | profile関数ファイル出力テスト | E-07 (lines 400-440) | ○ |
| C-118 | profile関数標準出力テスト | E-07 (lines 429-431) | ○ |
| C-119 | profile関数ディレクトリ作成テスト | E-07 (lines 421-422) | ○ |
| C-120 | _fill_missing_graph_shapeテスト | E-08 (lines 34-60) | ○ |
| C-121 | _str_idテスト | E-08 (lines 63-69) | ○ |
| C-122 | _str_id既存文字列テスト | E-08 (lines 65-66) | ○ |
| C-123 | _get_logged_opsテスト | E-08 (lines 72-138) | ○ |
| C-124 | merge_default_with_oplogテスト | E-08 (lines 141-185) | ○ |
| C-125 | merge_default_with_oplogのNoneグラフテスト | E-08 (lines 156-161) | ○ |
| C-126 | write_op_logテスト | E-08 (lines 188-215) | ○ |
| C-127 | _zero_flopsテスト | E-09 (lines 44-47) | ○ |
| C-128 | _list_productテスト | E-09 (lines 50-55) | ○ |
| C-129 | _list_product空リストテスト | E-09 (lines 52) | ○ |
| C-130 | _unary_op_flopsテスト | E-09 (lines 62-66) | ○ |
| C-131 | _binary_per_element_op_flopsテスト | E-09 (lines 138-142) | ○ |
| C-132 | _reduction_op_flopsテスト | E-09 (lines 240-248) | ○ |
| C-133 | _verify_conv_data_format成功テスト | E-09 (lines 292-296) | ○ |
| C-134 | _verify_conv_data_format失敗テスト | E-09 (lines 295-296) | ○ |
| C-135 | _pool_flopsテスト | E-09 (lines 299-320) | ○ |
| C-136 | _calc_mat_mul_flopsテスト | E-09 (lines 449-462) | ○ |
| C-137 | _calc_batch_mat_mul_flopsテスト | E-09 (lines 465-480) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全てのテストケースにソースコード根拠あり。

**注意点：**
- 外部ネイティブモジュール（`_pywrap_profiler`, `_pywrap_traceme`, `_pywrap_profiler_plugin`）との連携テストはモック化が必要
- 実際のGPU/TPUデバイスでの統合テストは本単体テストケースの範囲外

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 1: 中リスク - ネイティブモジュール依存部分のモック戦略要確認
- 1: 中リスク - マルチスレッド環境でのプロファイラロック動作の検証推奨

## 6) レビュアーチェックリスト（最小）
- [x] 全てのpublicメソッド/関数に対するテストケースが存在する
- [x] 正常系/異常系/境界値の観点が網羅されている
- [x] 各テストケースに明確な前提条件・入力値・期待結果が定義されている
- [ ] ネイティブモジュール（_pywrap_*）のモック戦略を確認する
- [ ] ProfileContext使用時のスレッドセーフティを確認する
- [ ] プロファイラサーバーとの通信テストの環境構築方法を確認する
- [ ] FLOPSレジストリの各演算タイプ（Conv2D, DepthwiseConv2d等）が網羅されているか確認する
