---
generated_at: 2026-02-03 12:15:00
metrics:
  claims_total: 163
  claims_with_evidence: 158
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：python-saved_model 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：158 / 163、根拠なし：5
- 優先レビュー（高）
  1. **UT-SVM-075**：OSSでexperimental_image_formatが無効化されるテストケース - コード内のis_oss変数がTrue固定のため確認必要
  2. **UT-SVM-076**：experimental_sharding_callbackの型検証 - ShardingCallback型の詳細確認必要
  3. **UT-SVM-145**：循環依存検出 - 循環依存のシナリオ詳細確認必要
  4. **UT-SVM-160**：ネストした呼び出しでValueError - 実装ではValueErrorだがテストシナリオの詳細確認必要
  5. **UT-SVM-141**：wrap_cached_variablesのキャッシュなし時動作 - 条件分岐の詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/saved_model/save.py` - SavedModel保存ロジック
- E-02: `tensorflow/python/saved_model/load.py` - SavedModelロードロジック
- E-03: `tensorflow/python/saved_model/builder_impl.py` - SavedModelBuilder実装
- E-04: `tensorflow/python/saved_model/loader_impl.py` - SavedModelLoader実装
- E-05: `tensorflow/python/saved_model/save_options.py` - SaveOptions定義
- E-06: `tensorflow/python/saved_model/load_options.py` - LoadOptions定義
- E-07: `tensorflow/python/saved_model/signature_def_utils_impl.py` - SignatureDef構築ユーティリティ
- E-08: `tensorflow/python/saved_model/utils_impl.py` - TensorInfo構築ユーティリティ
- E-09: `tensorflow/python/saved_model/fingerprinting.py` - Fingerprintクラス
- E-10: `tensorflow/python/saved_model/fingerprinting_utils.py` - Fingerprintユーティリティ
- E-11: `tensorflow/python/saved_model/revived_types.py` - 型登録・復元ロジック
- E-12: `tensorflow/python/saved_model/function_serialization.py` - 関数シリアライズ
- E-13: `tensorflow/python/saved_model/function_deserialization.py` - 関数デシリアライズ
- E-14: `tensorflow/python/saved_model/path_helpers.py` - パスヘルパー関数
- E-15: `tensorflow/python/saved_model/save_context.py` - SaveContext管理

## 3) Claims と根拠の対応（レビューの主戦場）

### save.py関連 (UT-SVM-001 〜 UT-SVM-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | save関数がTrackableオブジェクトを正常に保存 | E-01 (L1241-1434) | ○ |
| C-02 | signatures指定時の保存動作 | E-01 (L1404-1414) | ○ |
| C-03 | SaveOptions適用動作 | E-01 (L1462-1463) | ○ |
| C-04 | 非Trackableオブジェクト拒否 | E-01 (L1582-1587) | ○ |
| C-05 | 既存ディレクトリ検証 | E-03 (L100-107) | ○ |
| C-06 | tf.function内呼び出し禁止 | E-01 (L1576-1580) | ○ |
| C-07 | save_and_return_nodesの戻り値 | E-01 (L1437-1523) | ○ |
| C-08 | experimental_skip_checkpoint動作 | E-01 (L1471-1479) | ○ |
| C-09 | export_meta_graphの動作 | E-01 (L1526-1565) | ○ |
| C-10 | _AugmentedGraphView初期化 | E-01 (L100-130) | ○ |
| C-11 | set_signature動作 | E-01 (L131-148) | ○ |
| C-12 | list_children動作 | E-01 (L185-203) | ○ |
| C-13 | list_dependencies動作 | E-01 (L222-251) | ○ |
| C-14 | 非Trackable依存検出 | E-01 (L244-250) | ○ |
| C-15 | _SaveableView初期化 | E-01 (L269-301) | ○ |
| C-16 | map_resources動作 | E-01 (L390-430) | ○ |
| C-17 | fill_object_graph_proto動作 | E-01 (L358-388) | ○ |
| C-18 | _gen_save_and_restore_functions動作 | E-01 (L450-491) | ○ |
| C-19 | _to_safe_name_scope正常動作 | E-01 (L501-518) | ○ |
| C-20 | _to_safe_name_scope不正文字処理 | E-01 (L517-518) | ○ |
| C-21 | _verify_opsホワイトリスト | E-01 (L1063-1101) | ○ |
| C-22 | _verify_opsホワイトリスト違反検出 | E-01 (L1093-1101) | ○ |

### load.py関連 (UT-SVM-023 〜 UT-SVM-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | load関数の基本動作 | E-02 (L820-913) | ○ |
| C-24 | tags指定によるMetaGraph選択 | E-02 (L1029-1035) | ○ |
| C-25 | LoadOptions適用 | E-02 (L1010) | ○ |
| C-26 | 存在しないディレクトリエラー | E-02 (L1044-1049) | ○ |
| C-27 | 不一致tagsエラー | E-02 (L1029-1035) | ○ |
| C-28 | load_partial動作 | E-02 (L916-1008) | ○ |
| C-29 | TF1 SavedModelでのフィルタ制限 | E-02 (L1066-1068) | ○ |
| C-30 | is_tf2_saved_model TF2判定 | E-02 (L1111-1145) | ○ |
| C-31 | is_tf2_saved_model TF1判定 | E-02 (L1144-1145) | ○ |
| C-32 | Loader初期化 | E-02 (L149-223) | ○ |
| C-33 | get動作 | E-02 (L615-618) | ○ |
| C-34 | _load_nodes動作 | E-02 (L501-546) | ○ |
| C-35 | _restore_checkpoint動作 | E-02 (L548-599) | ○ |
| C-36 | _recreate_variable動作 | E-02 (L765-808) | ○ |
| C-37 | _recreate_function動作 | E-02 (L719-757) | ○ |
| C-38 | _WrapperFunction分散変数処理 | E-02 (L104-146) | ○ |

### builder_impl.py関連 (UT-SVM-039 〜 UT-SVM-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | _SavedModelBuilder初期化 | E-03 (L94-115) | ○ |
| C-40 | 既存非空ディレクトリ検証 | E-03 (L100-105) | ○ |
| C-41 | add_meta_graph動作 | E-03 (L234-304) | ○ |
| C-42 | 変数未保存時エラー | E-03 (L271-274) | ○ |
| C-43 | add_meta_graph_and_variables動作 | E-03 (L306-397) | ○ |
| C-44 | 二重保存防止 | E-03 (L349-352) | ○ |
| C-45 | save動作 | E-03 (L399-471) | ○ |
| C-46 | as_text保存 | E-03 (L435-439) | ○ |
| C-47 | _validate_signature_def_map有効 | E-03 (L190-220) | ○ |
| C-48 | 不正TensorInfo検出 | E-03 (L209-212) | ○ |
| C-49 | 予約キー検出 | E-03 (L213-220) | ○ |
| C-50 | _validate_tensor_info有効 | E-03 (L159-188) | ○ |
| C-51 | None検出 | E-03 (L172-175) | ○ |
| C-52 | encoding未設定検出 | E-03 (L176-181) | ○ |
| C-53 | get_asset_filename_to_add新規 | E-03 (L717-753) | ○ |
| C-54 | 重複ファイル名処理 | E-03 (L740-750) | ○ |
| C-55 | copy_assets_to_destination_dir動作 | E-03 (L806-839) | ○ |

### loader_impl.py関連 (UT-SVM-056 〜 UT-SVM-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | parse_saved_model pb形式 | E-04 (L76-123) | ○ |
| C-57 | parse_saved_model pbtxt形式 | E-04 (L111-117) | ○ |
| C-58 | ファイル不在エラー | E-04 (L118-122) | ○ |
| C-59 | parse_saved_model_with_debug_info動作 | E-04 (L46-72) | ○ |
| C-60 | maybe_saved_model_directory True | E-04 (L232-254) | ○ |
| C-61 | maybe_saved_model_directory False | E-04 (L250-254) | ○ |
| C-62 | contains_saved_model PathLike対応 | E-04 (L257-275) | ○ |
| C-63 | get_asset_tensors動作 | E-04 (L126-166) | ○ |
| C-64 | get_init_op動作 | E-04 (L210-214) | ○ |
| C-65 | get_train_op動作 | E-04 (L217-222) | ○ |
| C-66 | SavedModelLoader初期化 | E-04 (L348-360) | ○ |
| C-67 | get_meta_graph_def_from_tags動作 | E-04 (L377-405) | ○ |
| C-68 | 不一致tagsエラー | E-04 (L399-404) | ○ |
| C-69 | load動作 | E-04 (L485-516) | ○ |
| C-70 | load_graph動作 | E-04 (L407-432) | ○ |
| C-71 | restore_variables動作 | E-04 (L434-462) | ○ |
| C-72 | saver必須検証 | E-04 (L458-462) | ○ |

### save_options.py関連 (UT-SVM-073 〜 UT-SVM-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | SaveOptionsデフォルト初期化 | E-05 (L116-223) | ○ |
| C-74 | SaveOptionsオプション設定 | E-05 (L116-223) | ○ |
| C-75 | experimental_image_format OSS制限 | E-05 (L207-211) | △ |
| C-76 | 不正sharding_callback検出 | E-05 (L213-222) | △ |
| C-77 | VariablePolicy.from_obj None変換 | E-05 (L79-90) | ○ |
| C-78 | VariablePolicy.from_obj 文字列変換 | E-05 (L86-89) | ○ |
| C-79 | VariablePolicy.from_obj 不正値検出 | E-05 (L90) | ○ |
| C-80 | _validate_namespace_whitelist有効 | E-05 (L226-244) | ○ |
| C-81 | _validate_namespace_whitelist型検証 | E-05 (L230-235) | ○ |

### load_options.py関連 (UT-SVM-082 〜 UT-SVM-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | LoadOptionsデフォルト初期化 | E-06 (L34-125) | ○ |
| C-83 | LoadOptionsオプション設定 | E-06 (L34-125) | ○ |

### signature_def_utils_impl.py関連 (UT-SVM-084 〜 UT-SVM-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | build_signature_def動作 | E-07 (L37-79) | ○ |
| C-85 | defaults設定 | E-07 (L63-78) | ○ |
| C-86 | 空inputs動作 | E-07 (L55-57) | ○ |
| C-87 | regression_signature_def動作 | E-07 (L89-130) | ○ |
| C-88 | regression examples必須 | E-07 (L106-107) | ○ |
| C-89 | regression examples型検証 | E-07 (L108-110) | ○ |
| C-90 | classification_signature_def動作 | E-07 (L140-193) | ○ |
| C-91 | classification examples必須 | E-07 (L159-160) | ○ |
| C-92 | classification出力必須 | E-07 (L164-166) | ○ |
| C-93 | predict_signature_def動作 | E-07 (L203-234) | ○ |
| C-94 | predict inputs必須 | E-07 (L220-221) | ○ |
| C-95 | predict outputs必須 | E-07 (L222-223) | ○ |
| C-96 | is_valid_signature有効判定 | E-07 (L300-306) | ○ |
| C-97 | is_valid_signature None判定 | E-07 (L302-303) | ○ |
| C-98 | op_signature_def動作 | E-07 (L375-390) | ○ |
| C-99 | load_op_from_signature_def動作 | E-07 (L393-420) | ○ |
| C-100 | 不正キー検出 | E-07 (L415-420) | ○ |

### utils_impl.py関連 (UT-SVM-101 〜 UT-SVM-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | build_tensor_info動作 | E-08 (L44-68) | ○ |
| C-102 | SparseTensor対応 | E-08 (L81-84) | ○ |
| C-103 | eager mode禁止 | E-08 (L65-67) | ○ |
| C-104 | CompositeTensor対応 | E-08 (L73-76, L90-99) | ○ |
| C-105 | build_tensor_info_from_op動作 | E-08 (L102-140) | ○ |
| C-106 | build_tensor_info_from_op eager mode禁止 | E-08 (L134-136) | ○ |
| C-107 | get_tensor_from_tensor_info動作 | E-08 (L146-187) | ○ |
| C-108 | SparseTensor取得 | E-08 (L172-176) | ○ |
| C-109 | 不正encoding検出 | E-08 (L184-187) | ○ |
| C-110 | get_element_from_tensor_info動作 | E-08 (L190-208) | ○ |

### fingerprinting.py関連 (UT-SVM-111 〜 UT-SVM-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | Fingerprint初期化 | E-09 (L45-69) | ○ |
| C-112 | from_proto proto変換 | E-09 (L71-87) | ○ |
| C-113 | from_proto bytes変換 | E-09 (L74-75) | ○ |
| C-114 | from_proto無効proto検出 | E-09 (L84-87) | ○ |
| C-115 | __eq__等価判定 | E-09 (L89-101) | ○ |
| C-116 | __eq__非等価判定 | E-09 (L89-101) | ○ |
| C-117 | singleprint計算 | E-09 (L120-148) | ○ |
| C-118 | singleprint無効値検出 | E-09 (L141-148) | ○ |
| C-119 | read_fingerprint動作 | E-09 (L151-178) | ○ |
| C-120 | read_fingerprintファイル不在 | E-09 (L173-174) | ○ |

### fingerprinting_utils.py関連 (UT-SVM-121 〜 UT-SVM-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | write_fingerprint動作 | E-10 (L35-66) | ○ |
| C-122 | singleprint_from_saved_model_proto動作 | E-10 (L69-85) | ○ |
| C-123 | singleprint_from_saved_model_proto無効SavedModel | E-10 (L82-85) | ○ |
| C-124 | singleprint_from_fingerprint_proto動作 | E-10 (L88-104) | ○ |
| C-125 | to_proto動作 | E-10 (L144-151) | ○ |

### revived_types.py関連 (UT-SVM-126 〜 UT-SVM-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | VersionedTypeRegistration初期化 | E-11 (L29-73) | ○ |
| C-127 | to_proto動作 | E-11 (L74-84) | ○ |
| C-128 | should_load True判定 | E-11 (L90-101) | ○ |
| C-129 | should_load False判定 | E-11 (L90-101) | ○ |
| C-130 | register_revived_type動作 | E-11 (L109-136) | ○ |
| C-131 | 空versions検出 | E-11 (L123-124) | ○ |
| C-132 | serialize登録済み型 | E-11 (L139-146) | ○ |
| C-133 | serialize未登録型 | E-11 (L146) | ○ |
| C-134 | deserialize登録済みproto | E-11 (L149-166) | ○ |
| C-135 | deserialize未登録proto | E-11 (L166) | ○ |

### function_serialization.py関連 (UT-SVM-136 〜 UT-SVM-141)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | serialize_concrete_function動作 | E-12 (L62-85) | ○ |
| C-137 | 未登録capture検出 | E-12 (L68-75) | ○ |
| C-138 | serialize_bare_concrete_function動作 | E-12 (L120-131) | ○ |
| C-139 | serialize_function動作 | E-12 (L134-142) | ○ |
| C-140 | wrap_cached_variablesキャッシュあり | E-12 (L145-220) | ○ |
| C-141 | wrap_cached_variablesキャッシュなし | E-12 (L186-187) | △ |

### function_deserialization.py関連 (UT-SVM-142 〜 UT-SVM-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | recreate_function動作 | E-13 (L269-356) | ○ |
| C-143 | setup_bare_concrete_function動作 | E-13 (L208-224) | ○ |
| C-144 | load_function_def_library動作 | E-13 (L359-501) | ○ |
| C-145 | 循環依存検出 | E-13 (L582-585) | △ |
| C-146 | _list_all_concrete_functions動作 | E-13 (L262-263) | ○ |
| C-147 | fix_node_def動作 | E-13 (L599-636) | ○ |

### path_helpers.py関連 (UT-SVM-148 〜 UT-SVM-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | get_or_create_variables_dir動作 | E-14 (L23-27) | ○ |
| C-149 | get_variables_path動作 | E-14 (L36-40) | ○ |
| C-150 | get_or_create_assets_dir動作 | E-14 (L43-49) | ○ |
| C-151 | get_assets_dir動作 | E-14 (L52-55) | ○ |
| C-152 | get_or_create_debug_dir動作 | E-14 (L58-64) | ○ |
| C-153 | get_saved_model_pb_path動作 | E-14 (L73-76) | ○ |
| C-154 | get_saved_model_pbtxt_path動作 | E-14 (L67-70) | ○ |

### save_context.py関連 (UT-SVM-155 〜 UT-SVM-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | enter_save_context動作 | E-15 (L34-36) | ○ |
| C-156 | exit_save_context動作 | E-15 (L38-40) | ○ |
| C-157 | options取得成功 | E-15 (L29-32) | ○ |
| C-158 | options取得コンテキスト外エラー | E-15 (L30-31) | ○ |
| C-159 | save_contextコンテキストマネージャ | E-15 (L48-56) | ○ |
| C-160 | save_contextネスト禁止 | E-15 (L50-51) | △ |
| C-161 | in_save_context True判定 | E-15 (L59-61) | ○ |
| C-162 | in_save_context False判定 | E-15 (L59-61) | ○ |
| C-163 | get_save_options動作 | E-15 (L64-66) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SVM-075**: `is_oss`変数がソースコード内でTrue固定のため、この条件分岐がどのようにテストされるか確認が必要
  - 候補：内部ビルド設定 / テストモック / 環境変数
- **UT-SVM-076**: `ShardingCallback`の具体的な型定義と検証ロジックの詳細確認が必要
  - 候補：`tensorflow/python/checkpoint/sharding/sharding_util.py`
- **UT-SVM-141**: `wrap_cached_variables`のキャッシュなし判定条件の詳細確認が必要
  - 候補：テスト実行時の具体的な入力パターン
- **UT-SVM-145**: 循環依存の具体的なシナリオと検出方法の詳細確認が必要
  - 候補：`_sort_function_defs`関数の依存グラフ構築ロジック
- **UT-SVM-160**: ネストした呼び出し時のValueError発生条件の詳細確認が必要
  - 候補：スレッドローカル変数の状態管理

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: UT-SVM-001〜009 - SavedModel保存/ロードのコア機能。失敗すると主要機能が動作しない
- **2（高リスク）**: UT-SVM-023〜027 - SavedModelロードのコア機能。失敗すると保存されたモデルが利用不可
- **2（高リスク）**: UT-SVM-035 - チェックポイント復元。失敗すると変数値が復元されない
- **1（中リスク）**: UT-SVM-084〜100 - SignatureDef構築。サービング互換性に影響
- **1（中リスク）**: UT-SVM-136〜147 - 関数シリアライズ/デシリアライズ。@tf.functionの保存/復元に影響
- **0（低リスク）**: UT-SVM-148〜163 - パスヘルパーとコンテキスト管理。他のテストでカバーされる補助機能

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のテストケース（save/load基本機能）がすべてのエッジケースをカバーしているか
- [ ] 異常系テストケースで適切な例外がスローされることを確認
- [ ] 境界値テストケース（空値、Noneなど）が網羅されているか
- [ ] TF1とTF2の互換性に関するテストケースが適切か
- [ ] 分散環境固有の動作（_WrapperFunction等）のテストカバレッジ
- [ ] Fingerprint機能のエンドツーエンドテストの有無確認
