---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：python-tools.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/tools/freeze_graph.py` - グラフフリーズツール（行59-543）
- E-02: `tensorflow/python/tools/optimize_for_inference_lib.py` - 推論最適化ライブラリ（行101-1009）
- E-03: `tensorflow/python/tools/optimize_for_inference.py` - 推論最適化CLI（行74-178）
- E-04: `tensorflow/python/tools/saved_model_utils.py` - SavedModelユーティリティ（行27-128）
- E-05: `tensorflow/python/tools/strip_unused_lib.py` - 未使用ノード削除ライブラリ（行29-122）
- E-06: `tensorflow/python/tools/strip_unused.py` - 未使用ノード削除CLI（行51-105）
- E-07: `tensorflow/python/tools/inspect_checkpoint.py` - チェックポイント検査（行30-207）
- E-08: `tensorflow/python/tools/saved_model_cli.py` - SavedModel CLI（行237-1395）
- E-09: `tensorflow/python/tools/selective_registration_header_lib.py` - 選択的登録ヘッダ生成（行44-249）
- E-10: `tensorflow/python/tools/saved_model_aot_compile.py` - AOTコンパイルヘルパー（行76-525）
- E-11: `tensorflow/python/tools/import_pb_to_tensorboard.py` - TensorBoardインポート（行40-91）
- E-12: `tensorflow/python/tools/module_util.py` - モジュールユーティリティ（行21-48）
- E-13: `tensorflow/python/tools/grpc_tpu_worker.py` - TPU Workerサービス（行39-133）
- E-14: `tensorflow/python/tools/grpc_tpu_worker_service.py` - TPU Workerサービス設定（行29-106）
- E-15: `tensorflow/python/tools/api/generator/create_python_api.py` - Python API生成（行67-855）
- E-16: `tensorflow/python/tools/api/generator2/extractor/extractor.py` - APIエクスポート抽出（行44-364）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | freeze_graph_with_def_protos: チェックポイントからグラフの変数を定数に変換 | E-01 (行74-252) | ○ |
| C-02 | freeze_graph_with_def_protos: チェックポイント不存在でValueError | E-01 (行125-130) | ○ |
| C-03 | freeze_graph_with_def_protos: output_node_names空でValueError | E-01 (行132-135) | ○ |
| C-04 | freeze_graph_with_def_protos: clear_devicesでデバイス指定削除 | E-01 (行139-145) | ○ |
| C-05 | _has_no_variables: 変数検出機能 | E-01 (行59-71) | ○ |
| C-06 | _has_no_variables: 変数なし検出機能 | E-01 (行59-71) | ○ |
| C-07 | _parse_input_graph_proto: バイナリGraphDef読込 | E-01 (行255-268) | ○ |
| C-08 | _parse_input_graph_proto: テキストGraphDef読込 | E-01 (行255-268) | ○ |
| C-09 | _parse_input_graph_proto: ファイル不存在でIOError | E-01 (行259-260) | ○ |
| C-10 | freeze_graph: SavedModelからグラフフリーズ | E-01 (行302-383) | ○ |
| C-11 | optimize_for_inference: グラフ最適化基本機能 | E-02 (行101-148) | ○ |
| C-12 | ensure_graph_is_valid: グラフ検証正常系 | E-02 (行192-214) | ○ |
| C-13 | ensure_graph_is_valid: 重複ノード名検出 | E-02 (行205-209) | ○ |
| C-14 | ensure_graph_is_valid: 不正入力参照検出 | E-02 (行210-214) | ○ |
| C-15 | node_name_from_input: ポート除去機能 | E-02 (行217-224) | ○ |
| C-16 | node_name_from_input: 制御依存プレフィックス除去 | E-02 (行219-220) | ○ |
| C-17 | node_from_map: ノード取得機能 | E-02 (行227-245) | ○ |
| C-18 | node_from_map: 存在しないノードでValueError | E-02 (行243-244) | ○ |
| C-19 | values_from_const: 定数値抽出機能 | E-02 (行248-267) | ○ |
| C-20 | values_from_const: 非定数ノードでValueError | E-02 (行260-264) | ○ |
| C-21 | fold_batch_norms: BatchNorm融合機能 | E-02 (行277-522) | ○ |
| C-22 | fold_batch_norms: 重複ノード名でValueError | E-02 (行300-305) | ○ |
| C-23 | fuse_resize_and_conv: Resize+Conv融合機能 | E-02 (行525-649) | ○ |
| C-24 | convert_placeholder_to_const: Placeholder変換機能 | E-02 (行652-733) | ○ |
| C-25 | strtobool: 'True'でTrue返却 | E-02 (行151-163) | ○ |
| C-26 | strtobool: 'false'でFalse返却 | E-02 (行151-163) | ○ |
| C-27 | strtobool: 不正値でFalse返却 | E-02 (行157-163) | ○ |
| C-28 | fuse_decomposed_batch_norm: 分解BatchNorm融合 | E-02 (行749-1008) | ○ |
| C-29 | read_saved_model: SavedModel読込基本機能 | E-04 (行27-74) | ○ |
| C-30 | read_saved_model: 存在しないディレクトリでIOError | E-04 (行49-51) | ○ |
| C-31 | read_saved_model: pbtxt形式読込 | E-04 (行63-70) | ○ |
| C-32 | get_saved_model_tag_sets: タグセット取得 | E-04 (行77-91) | ○ |
| C-33 | get_meta_graph_def: MetaGraphDef取得 | E-04 (行94-127) | ○ |
| C-34 | get_meta_graph_def: 存在しないタグセットでRuntimeError | E-04 (行125-127) | ○ |
| C-35 | get_meta_graph_def: 空タグセット処理 | E-04 (行114-115) | ○ |
| C-36 | strip_unused: 未使用ノード削除基本機能 | E-05 (行29-86) | ○ |
| C-37 | strip_unused: テンソル名でValueError | E-05 (行48-51) | ○ |
| C-38 | strip_unused: 存在しない入力ノードでKeyError | E-05 (行81-82) | ○ |
| C-39 | strip_unused_from_files: ファイルベース処理 | E-05 (行89-121) | ○ |
| C-40 | strip_unused_from_files: ファイル不存在で-1返却 | E-05 (行94-96) | ○ |
| C-41 | strip_unused_from_files: 出力ノード未指定で-1返却 | E-05 (行98-100) | ○ |
| C-42 | print_tensors_in_checkpoint_file: テンソル情報表示 | E-07 (行54-112) | ○ |
| C-43 | print_tensors_in_checkpoint_file: 特定テンソル値表示 | E-07 (行85-95) | ○ |
| C-44 | print_tensors_in_checkpoint_file: 全テンソル値表示 | E-07 (行73-82) | ○ |
| C-45 | print_tensors_in_checkpoint_file: 存在しないテンソル | E-07 (行86-88) | ○ |
| C-46 | _count_total_params: パラメータカウント | E-07 (行30-51) | ○ |
| C-47 | _count_total_params: 除外パターン付きカウント | E-07 (行35-48) | ○ |
| C-48 | parse_numpy_printoption: printoption設定 | E-07 (行115-145) | ○ |
| C-49 | parse_numpy_printoption: 不正フォーマットエラー | E-07 (行129-130) | ○ |
| C-50 | parse_numpy_printoption: 存在しないオプションエラー | E-07 (行133-134) | ○ |
| C-51 | get_signature_def_map: SignatureDefマップ取得 | E-08 (行598-614) | ○ |
| C-52 | preprocess_inputs_arg_string: 入力引数パース | E-08 (行764-808) | ○ |
| C-53 | preprocess_inputs_arg_string: 変数名付き入力パース | E-08 (行793-796) | ○ |
| C-54 | preprocess_inputs_arg_string: 不正フォーマットエラー | E-08 (行802-806) | ○ |
| C-55 | preprocess_input_exprs_arg_string: Python式評価 | E-08 (行811-846) | ○ |
| C-56 | preprocess_input_exprs_arg_string: 不正式エラー | E-08 (行838-842) | ○ |
| C-57 | preprocess_input_examples_arg_string: tf.Example作成 | E-08 (行849-878) | ○ |
| C-58 | preprocess_input_examples_arg_string: 非リスト入力エラー | E-08 (行871-874) | ○ |
| C-59 | _create_example_string: float特徴量Example作成 | E-08 (行881-904) | ○ |
| C-60 | _create_example_string: int特徴量Example作成 | E-08 (行897-899) | ○ |
| C-61 | _create_example_string: 非リスト特徴量エラー | E-08 (行885-887) | ○ |
| C-62 | scan_meta_graph_def: 拒否op検出 | E-08 (行625-646) | ○ |
| C-63 | scan_meta_graph_def: 拒否opなし検出 | E-08 (行643-646) | ○ |
| C-64 | _sanitize_nonempty_str_list: 文字列トリム | E-08 (行237-248) | ○ |
| C-65 | _sanitize_nonempty_str_list: 空リストエラー | E-08 (行246-247) | ○ |
| C-66 | _get_op_denylist_set: 拒否リストセット作成 | E-08 (行617-622) | ○ |
| C-67 | _get_op_denylist_set: 空文字列処理 | E-08 (行619-621) | ○ |
| C-68 | get_ops_and_kernels: op/kernel情報取得 | E-09 (行110-138) | ○ |
| C-69 | get_ops_and_kernels: テキスト形式op取得 | E-09 (行126-127) | ○ |
| C-70 | get_header_from_ops_and_kernels: ヘッダ生成 | E-09 (行141-223) | ○ |
| C-71 | get_header_from_ops_and_kernels: 全op含むヘッダ | E-09 (行165-168) | ○ |
| C-72 | get_ops_from_nodedef: NodeDefからop取得 | E-09 (行68-86) | ○ |
| C-73 | get_ops_from_nodedef: 許可リストop処理 | E-09 (行82-83) | ○ |
| C-74 | freeze_model: モデルフリーズ機能 | E-10 (行204-305) | ○ |
| C-75 | freeze_model: 不正signature_defエラー | E-10 (行231-236) | ○ |
| C-76 | freeze_model: 空出力エラー | E-10 (行238-241) | ○ |
| C-77 | aot_compile_cpu_meta_graph_def: AOTコンパイル | E-10 (行308-410) | ○ |
| C-78 | aot_compile_cpu_meta_graph_def: XLAなしエラー | E-10 (行357-358) | ○ |
| C-79 | _parse_tensor_name: テンソル名パース | E-10 (行76-83) | ○ |
| C-80 | _parse_tensor_name: コロンなし名前処理 | E-10 (行82-83) | ○ |
| C-81 | _get_variable_nodes_from_graph_def: 変数ノード取得 | E-10 (行139-177) | ○ |
| C-82 | import_to_tensorboard: TensorBoardインポート | E-11 (行40-61) | ○ |
| C-83 | get_parent_dir: 親ディレクトリ取得 | E-12 (行21-22) | ○ |
| C-84 | get_parent_dir_for_name: モジュール名から親ディレクトリ | E-12 (行25-47) | ○ |
| C-85 | get_parent_dir_for_name: 空モジュール名処理 | E-12 (行36-38) | ○ |
| C-86 | get_parent_dir_for_name: 存在しないモジュール処理 | E-12 (行40-45) | ○ |
| C-87 | get_metadata: メタデータ取得機能 | E-13 (行39-45) | ○ |
| C-88 | get_host_ip: ホストIP取得機能 | E-13 (行48-53) | ○ |
| C-89 | setup_env_vars: 環境変数設定機能 | E-13 (行56-97) | ○ |
| C-90 | create_systemd_service_file: サービスファイル作成 | E-14 (行61-64) | ○ |
| C-91 | move_file_to_systemd: ファイル移動機能 | E-14 (行67-76) | ○ |
| C-92 | get_sys_path: sys.path取得 | E-14 (行29-30) | ○ |
| C-93 | get_canonical_import: 最適インポート選択 | E-15 (行72-96) | ○ |
| C-94 | _ModuleInitCodeBuilder.add_import: インポート追加 | E-15 (行130-174) | ○ |
| C-95 | _ModuleInitCodeBuilder.add_import: 重複シンボルエラー | E-15 (行123-128, 67-69) | ○ |
| C-96 | _ModuleInitCodeBuilder.build: ビルド機能 | E-15 (行213-273) | ○ |
| C-97 | get_module: パスからモジュール名変換 | E-15 (行523-536) | ○ |
| C-98 | Parser.process_file: ファイルからエクスポート抽出 | E-16 (行68-77) | ○ |
| C-99 | Parser.process: コンテンツからエクスポート抽出 | E-16 (行79-92) | ○ |
| C-100 | Parser._add_exported_symbol: 不正シンボル名エラー | E-16 (行322-328) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースにソースコードの根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されています

## 6) レビュアーチェックリスト（最小）
- [ ] freeze_graph関連のテストケース（UT-PYT-001〜010）が実際のグラフフリーズ機能を網羅しているか確認
- [ ] optimize_for_inference関連のテストケース（UT-PYT-011〜028）がバッチ正規化融合などの最適化を網羅しているか確認
- [ ] saved_model_cli関連のテストケース（UT-PYT-051〜067）が全コマンドをカバーしているか確認
- [ ] AOTコンパイル関連のテストケース（UT-PYT-074〜081）がXLA依存の機能を正しくテストしているか確認
- [ ] TPU Worker関連のテストケース（UT-PYT-087〜092）がGCP環境依存のテストであることを考慮してレビュー
