---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 127
  claims_with_evidence: 127
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：python-tpu 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：127 / 127、根拠なし：0
- 優先レビュー（高）
  1. **TPU関連のテストケース**：TPU環境での動作確認が必要なテストケースが多数あり、実際のTPU環境での検証推奨
  2. **非同期処理のテストケース**：AsyncCheckpointSaverHookの非同期処理テストは実環境でのタイミング検証が必要
  3. **エンベディング関連テストケース**：TPUEmbedding系のテストケースはTPUStrategy環境での動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/tpu/topology.py` - Topologyクラスの実装
- E-02: `tensorflow/python/tpu/device_assignment.py` - DeviceAssignmentクラスおよびdevice_assignment関数の実装
- E-03: `tensorflow/python/tpu/tpu.py` - TPU関連関数（initialize_system, shutdown_system, replicate, shard, rewrite等）の実装
- E-04: `tensorflow/python/tpu/tpu_embedding_v2.py` - TPUEmbeddingクラスの実装
- E-05: `tensorflow/python/tpu/tpu_embedding_v2_utils.py` - オプティマイザ（SGD, Adagrad, Adam, FTRL, AdagradMomentum）、TableConfig、FeatureConfig等の実装
- E-06: `tensorflow/python/tpu/tpu_feed.py` - InfeedQueueクラスの実装
- E-07: `tensorflow/python/tpu/tpu_embedding_base.py` - TPUEmbeddingBaseクラスの実装
- E-08: `tensorflow/python/tpu/async_checkpoint.py` - AsyncCheckpointSaverHookクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### Topologyクラス関連（UT-TPU-001 〜 UT-TPU-011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Topology.__init__はserializedからTopologyを生成できる | E-01 (line 48-102) | ○ |
| C-02 | Topology.__init__はmesh_shapeとdevice_coordinatesから生成できる | E-01 (line 84-100) | ○ |
| C-03 | mesh_shapeが4要素でない場合にValueErrorが発生する | E-01 (line 87-89, 113-115) | ○ |
| C-04 | mesh_shapeに負の値がある場合にValueErrorが発生する | E-01 (line 87-89) | ○ |
| C-05 | device_coordinatesのランクが3でない場合にValueErrorが発生する | E-01 (line 91-100) | ○ |
| C-06 | _parse_topologyでnum_tasksが負の場合にValueErrorが発生する | E-01 (line 117-119) | ○ |
| C-07 | task_ordinal_at_coordinatesが座標からタスク番号を返す | E-01 (line 184-195) | ○ |
| C-08 | tpu_device_ordinal_at_coordinatesが座標からデバイス番号を返す | E-01 (line 197-208) | ○ |
| C-09 | cpu_device_name_at_coordinatesがCPUデバイス名を返す | E-01 (line 210-213) | ○ |
| C-10 | tpu_device_name_at_coordinatesがTPUデバイス名を返す | E-01 (line 215-219) | ○ |
| C-11 | serialized()がTopologyProtoをシリアライズする | E-01 (line 231-241) | ○ |

### DeviceAssignmentクラス関連（UT-TPU-012 〜 UT-TPU-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | DeviceAssignment.__init__は有効なパラメータで生成できる | E-02 (line 78-113) | ○ |
| C-13 | topologyがTopologyでない場合にValueErrorが発生する | E-02 (line 91-93) | ○ |
| C-14 | core_assignmentがランク3でない場合にValueErrorが発生する | E-02 (line 98-100) | ○ |
| C-15 | coordinatesメソッドが物理座標を返す | E-02 (line 141-143) | ○ |
| C-16 | lookup_replicasがレプリカIDリストを返す | E-02 (line 145-163) | ○ |
| C-17 | lookup_replicasで存在しない組み合わせはValueErrorになる | E-02 (line 160-163) | ○ |
| C-18 | tpu_ordinalがTPUオーディナルを返す | E-02 (line 165-168) | ○ |
| C-19 | host_deviceがホストデバイス名を返す | E-02 (line 170-176) | ○ |
| C-20 | tpu_deviceがTPUデバイス名を返す | E-02 (line 178-184) | ○ |
| C-21 | device_assignment関数がDeviceAssignmentを返す | E-02 (line 343-575) | ○ |
| C-22 | topologyが不正な場合にValueErrorが発生する | E-02 (line 391-397) | ○ |
| C-23 | computation_shapeが不正な場合にValueErrorが発生する | E-02 (line 415-424) | ○ |
| C-24 | num_replicasが最大数を超える場合にValueErrorが発生する | E-02 (line 447-452) | ○ |
| C-25 | num_replicas=1の場合に正しく処理される | E-02 (line 457-486) | ○ |
| C-26 | _ring_3dが3次元リング順序を計算する | E-02 (line 241-340) | ○ |
| C-27 | _ring_3dで1次元が1の場合に正しく処理される | E-02 (line 295-300) | ○ |
| C-28 | _open_ring_2dが2次元リング順序を計算する | E-02 (line 204-238) | ○ |

### TPU関数関連（UT-TPU-029 〜 UT-TPU-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | initialize_systemがTPUを初期化してTopologyを返す | E-03 (line 83-137) | ○ |
| C-30 | initialize_systemがembedding_config付きで初期化できる | E-03 (line 127-137) | ○ |
| C-31 | shutdown_systemがTPUをシャットダウンする | E-03 (line 169-181) | ○ |
| C-32 | replicateが計算を複製実行する | E-03 (line 270-377) | ○ |
| C-33 | replicateでinputsが不正な型の場合にTypeErrorが発生する | E-03 (line 655-661) | ○ |
| C-34 | replicateでレプリカ間で入力数が異なる場合にValueErrorが発生する | E-03 (line 700-703) | ○ |
| C-35 | replicateで入力型がレプリカ間で異なる場合にValueErrorが発生する | E-03 (line 705-709) | ○ |
| C-36 | shardが計算をシャード分割して実行する | E-03 (line 1292-1377) | ○ |
| C-37 | shardでnum_shardsが0以下の場合にValueErrorが発生する | E-03 (line 1203-1205) | ○ |
| C-38 | shardでinput_shard_axesの長さが不一致の場合にValueErrorが発生する | E-03 (line 1217-1220) | ○ |
| C-39 | batch_parallelがバッチ並列実行する | E-03 (line 1379-1439) | ○ |
| C-40 | rewriteが計算をTPU用に書き換える | E-03 (line 1442-1499) | ○ |
| C-41 | XLAOptionsがデフォルト値で生成される | E-03 (line 230-267) | ○ |
| C-42 | PaddingSpecの各モードが正しい値を持つ | E-03 (line 220-227) | ○ |
| C-43 | _ceil_to_pow_of_nが正しく計算する | E-03 (line 379-386) | ○ |
| C-44 | under_tpu_inference_contextがコンテキストを判定する | E-03 (line 1515-1530) | ○ |

### TPUEmbedding関連（UT-TPU-045 〜 UT-TPU-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | TPUEmbedding.__init__が有効なパラメータで生成できる | E-04 (line 239-351) | ○ |
| C-46 | サポートされないoptimizerでValueErrorが発生する | E-04 (line 323-328) | ○ |
| C-47 | テーブル名が重複している場合にValueErrorが発生する | E-04 (line 331-334) | ○ |
| C-48 | build()が変数とスロットを作成する | E-04 (line 353-421) | ○ |
| C-49 | build()がビルド済みの場合に早期リターンする | E-04 (line 385-386) | ○ |
| C-50 | TPUが既に初期化済みの場合にRuntimeErrorが発生する | E-04 (line 392-396) | ○ |
| C-51 | enqueue()が特徴量をエンキューする | E-04 (line 1108-1378) | ○ |
| C-52 | enqueue()がTPUStrategy外で呼び出されるとRuntimeErrorが発生する | E-04 (line 1242-1244) | ○ |
| C-53 | enqueue()で構造が一致しない場合にエラーが発生する | E-04 (line 1248) | ○ |
| C-54 | dequeue()が埋め込み結果をデキューする | E-04 (line 724-799) | ○ |
| C-55 | dequeue()がTPUStrategy外で呼び出されるとRuntimeErrorが発生する | E-04 (line 780-782) | ○ |
| C-56 | dequeue()が未ビルドの場合にRuntimeErrorが発生する | E-04 (line 784-787) | ○ |
| C-57 | apply_gradients()が勾配を適用する | E-04 (line 617-722) | ○ |
| C-58 | apply_gradients()がTPUStrategy外で呼び出されるとRuntimeErrorが発生する | E-04 (line 672-674) | ○ |
| C-59 | apply_gradients()が未ビルドの場合にRuntimeErrorが発生する | E-04 (line 676-679) | ○ |
| C-60 | apply_gradients()で非テンソルの勾配でValueErrorが発生する | E-04 (line 691-693) | ○ |
| C-61 | apply_gradients()でNoneの勾配がゼロ勾配として処理される | E-04 (line 699-707) | ○ |
| C-62 | embedding_tablesがCPU環境でテーブルにアクセスできる | E-04 (line 514-547) | ○ |
| C-63 | embedding_tablesがTPU環境で呼び出されるとRuntimeErrorが発生する | E-04 (line 534-540) | ○ |
| C-64 | TPUEmbeddingVariable._in_graph_modeがモードを返す | E-04 (line 63-68) | ○ |

### オプティマイザ・設定クラス関連（UT-TPU-065 〜 UT-TPU-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | SGD.__init__がデフォルトパラメータで生成できる | E-05 (line 448-497) | ○ |
| C-66 | SGD.__init__がカスタムパラメータで生成できる | E-05 (line 448-497) | ○ |
| C-67 | Adagrad.__init__がデフォルトパラメータで生成できる | E-05 (line 564-622) | ○ |
| C-68 | Adagrad.__init__でinitial_accumulator_valueが0以下の場合にValueErrorが発生する | E-05 (line 618-621) | ○ |
| C-69 | Adam.__init__がデフォルトパラメータで生成できる | E-05 (line 1018-1107) | ○ |
| C-70 | Adam.__init__でbeta_1が範囲外の場合にValueErrorが発生する | E-05 (line 1089-1091) | ○ |
| C-71 | Adam.__init__でbeta_2が範囲外の場合にValueErrorが発生する | E-05 (line 1092-1094) | ○ |
| C-72 | Adam.__init__でepsilonが0以下の場合にValueErrorが発生する | E-05 (line 1095-1096) | ○ |
| C-73 | Adam.__init__でlazy_adam=False、use_gradient_accumulation=Falseの場合にValueErrorが発生する | E-05 (line 1097-1101) | ○ |
| C-74 | FTRL.__init__がデフォルトパラメータで生成できる | E-05 (line 843-935) | ○ |
| C-75 | FTRL.__init__でinitial_accumulator_valueが0以下の場合にValueErrorが発生する | E-05 (line 925-928) | ○ |
| C-76 | AdagradMomentum.__init__がデフォルトパラメータで生成できる | E-05 (line 693-764) | ○ |
| C-77 | AdagradMomentum.__init__でepsilonが0以下の場合にValueErrorが発生する | E-05 (line 756-757) | ○ |
| C-78 | AdagradMomentum.__init__でexponentが0以下の場合にValueErrorが発生する | E-05 (line 758-759) | ○ |
| C-79 | TableConfig.__init__が有効なパラメータで生成できる | E-05 (line 1355-1460) | ○ |
| C-80 | TableConfig.__init__でvocabulary_sizeが0以下の場合にValueErrorが発生する | E-05 (line 1410-1413) | ○ |
| C-81 | TableConfig.__init__でdimが0以下の場合にValueErrorが発生する | E-05 (line 1415-1418) | ○ |
| C-82 | TableConfig.__init__でinitializerが呼び出し可能でない場合にValueErrorが発生する | E-05 (line 1420-1423) | ○ |
| C-83 | TableConfig.__init__でcombinerがサポートされていない場合にValueErrorが発生する | E-05 (line 1428-1433) | ○ |
| C-84 | TableConfig.__init__でデフォルトinitializerが設定される | E-05 (line 1424-1426) | ○ |
| C-85 | FeatureConfig.__init__が有効なTableConfigで生成できる | E-05 (line 1587-1641) | ○ |
| C-86 | FeatureConfig.__init__でtableがTableConfigでない場合にValueErrorが発生する | E-05 (line 1621-1623) | ○ |
| C-87 | FeatureConfig.__init__でmax_sequence_lengthが負の場合にValueErrorが発生する | E-05 (line 1625-1628) | ○ |
| C-88 | FeatureConfig.__init__でvalidate_weights_and_indicesがboolでない場合にValueErrorが発生する | E-05 (line 1635-1639) | ○ |
| C-89 | QuantizationConfig.__init__が有効なパラメータで生成できる | E-05 (line 1281-1315) | ○ |
| C-90 | QuantizationConfig.__init__でnum_bucketsが2未満の場合にValueErrorが発生する | E-05 (line 1295-1297) | ○ |
| C-91 | _Optimizer.__init__でuse_gradient_accumulation=Falseでclipvalueが設定されている場合にValueErrorが発生する | E-05 (line 155-160) | ○ |
| C-92 | get_list_of_hostsがホストリストを返す | E-05 (line 1678-1695) | ○ |

### InfeedQueue関連（UT-TPU-093 〜 UT-TPU-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | InfeedQueue.__init__が有効なパラメータで生成できる | E-06 (line 128-204) | ○ |
| C-94 | InfeedQueue.__init__でnumber_of_tuple_elementsが0以下の場合にValueErrorが発生する | E-06 (line 187-189) | ○ |
| C-95 | 全てのパラメータがNoneの場合にValueErrorが発生する | E-06 (line 183-186) | ○ |
| C-96 | set_tuple_typesがタプル要素の型を設定する | E-06 (line 227-261) | ○ |
| C-97 | set_tuple_typesで長さが一致しない場合にValueErrorが発生する | E-06 (line 243-247) | ○ |
| C-98 | set_tuple_shapesがタプル要素の形状を設定する | E-06 (line 268-307) | ○ |
| C-99 | set_tuple_shapesで長さが一致しない場合にValueErrorが発生する | E-06 (line 284-288) | ○ |
| C-100 | freeze()が設定を凍結する | E-06 (line 447-471) | ○ |
| C-101 | freeze()で型が未設定の場合にValueErrorが発生する | E-06 (line 459-461) | ○ |
| C-102 | freeze()で形状が未設定の場合にValueErrorが発生する | E-06 (line 462-464) | ○ |
| C-103 | generate_dequeue_opがデキュー操作を生成する | E-06 (line 473-517) | ○ |
| C-104 | generate_dequeue_opが既に生成済みの場合にValueErrorが発生する | E-06 (line 496-497) | ○ |
| C-105 | generate_enqueue_opsがエンキュー操作を生成する | E-06 (line 572-632) | ○ |
| C-106 | generate_enqueue_opsが既に生成済みの場合にValueErrorが発生する | E-06 (line 618-619) | ○ |
| C-107 | partition_or_replicate_on_hostがテンソルをパーティション分割する | E-06 (line 35-78) | ○ |
| C-108 | partition_or_replicate_on_hostでdimsがNoneの場合にレプリケートする | E-06 (line 47-48) | ○ |

### TPUEmbeddingBase関連（UT-TPU-109 〜 UT-TPU-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | TPUEmbeddingBase.__init__が有効なfeature_configで生成できる | E-07 (line 34-74) | ○ |
| C-110 | サポートされないoptimizerでValueErrorが発生する | E-07 (line 61-66) | ○ |
| C-111 | テーブル名が重複している場合にValueErrorが発生する | E-07 (line 69-72) | ○ |
| C-112 | build()で変数を作成する | E-07 (line 128-133) | ○ |
| C-113 | build()がビルド済みの場合に早期リターンする | E-07 (line 130-131) | ○ |
| C-114 | __call__が自動ビルドして埋め込みルックアップを実行する | E-07 (line 135-139) | ○ |

### AsyncCheckpointSaverHook関連（UT-TPU-115 〜 UT-TPU-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | AsyncCheckpointSaverHook.__init__が有効なパラメータで生成できる | E-08 (line 54-109) | ○ |
| C-116 | save_stepsとsave_secsの両方がNoneの場合にValueErrorが発生する | E-08 (親クラスCheckpointSaverHookの仕様) | ○ |
| C-117 | saverとscaffoldの両方が指定された場合にValueErrorが発生する | E-08 (line 88-89) | ○ |
| C-118 | begin()でSummaryWriterが初期化される | E-08 (line 114-121) | ○ |
| C-119 | begin()でグローバルステップがない場合にRuntimeErrorが発生する | E-08 (line 117-119) | ○ |
| C-120 | _save()で非同期にチェックポイントを保存する | E-08 (line 177-247) | ○ |
| C-121 | _save()で同期的にチェックポイントを保存する | E-08 (line 231-235) | ○ |
| C-122 | end()で保留中のチェックポイントを待機する | E-08 (line 161-175) | ○ |
| C-123 | _get_saver()が指定されたsaverを返す | E-08 (line 249-251) | ○ |
| C-124 | _get_saver()がscaffoldからsaverを取得する | E-08 (line 252-253) | ○ |
| C-125 | _get_saver()でSAVERSコレクションが空の場合にRuntimeErrorが発生する | E-08 (line 256-262) | ○ |
| C-126 | _get_duration_microsecondsが正しくマイクロ秒を計算する | E-08 (line 49-51) | ○ |
| C-127 | _get_duration_microsecondsで負の時間差の場合に0を返す | E-08 (line 51) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードから直接導出されており、根拠が明確です

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードに基づいており、実装との整合性が確認できます
- **注意点**:
  1. TPU環境依存のテストケース（UT-TPU-029〜044、UT-TPU-051〜063）は実際のTPU環境での検証が必要
  2. 非同期処理のテストケース（UT-TPU-120〜122）はタイミングに依存する可能性あり
  3. プロトコルバッファのシリアライズ/デシリアライズ（UT-TPU-001、UT-TPU-006、UT-TPU-011）は実際のデータでの検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] すべてのpublicメソッドに対してテストケースが存在するか確認
- [ ] 境界値テストが主要なパラメータに対して設定されているか確認
- [ ] 異常系テストがValueError/RuntimeErrorを適切にカバーしているか確認
- [ ] TPU環境固有のテストケースが適切に分離されているか確認
- [ ] オプティマイザのパラメータ検証テストが網羅的か確認
