---
generated_at: 2026-02-03 12:30:00
metrics:
  claims_total: 68
  claims_with_evidence: 65
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：security.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：65 / 68、根拠なし：3
- 優先レビュー（高）
  1. **UT-SEC-020**：_create_dtype_wrapper関数のテスト内容確認
  2. **UT-SEC-041**：DomainRange<bool>特殊化の詳細検証
  3. **UT-SEC-058**：EmptyFunctionDefGeneratorの境界値テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/security/fuzzing/python_fuzzing.py` - Python用ファジングヘルパークラス定義
- E-02: `tensorflow/security/fuzzing/py/annotation_types.py` - 型アノテーション用ラッパークラス定義
- E-03: `tensorflow/security/fuzzing/cc/fuzz_session.h` - C++ファジングセッションテンプレートクラス
- E-04: `tensorflow/security/fuzzing/cc/fuzz_domains.h` - C++ファジングドメインヘルパー
- E-05: `tensorflow/security/fuzzing/cc/core/framework/tensor_domains.h` - テンソルドメイン定義ヘッダー
- E-06: `tensorflow/security/fuzzing/cc/core/framework/tensor_domains.cc` - テンソルドメイン実装
- E-07: `tensorflow/security/fuzzing/cc/core/framework/tensor_shape_domains.h` - テンソル形状ドメインヘッダー
- E-08: `tensorflow/security/fuzzing/cc/core/framework/tensor_shape_domains.cc` - テンソル形状ドメイン実装
- E-09: `tensorflow/security/fuzzing/cc/core/framework/datatype_domains.h` - データ型ドメインヘッダー
- E-10: `tensorflow/security/fuzzing/cc/core/framework/datatype_domains.cc` - データ型ドメイン実装
- E-11: `tensorflow/security/fuzzing/cc/base64_fuzz.cc` - Base64ファジングテスト
- E-12: `tensorflow/security/fuzzing/cc/status_fuzz.cc` - Statusファジングテスト
- E-13: `tensorflow/security/fuzzing/cc/parseURI_fuzz.cc` - URIパースファジングテスト
- E-14: `tensorflow/security/fuzzing/cc/stringprintf_fuzz.cc` - Printf形式ファジングテスト
- E-15: `tensorflow/security/fuzzing/cc/checkpoint_reader_fuzz.cc` - チェックポイント読込ファジングテスト
- E-16: `tensorflow/security/fuzzing/cc/core/function/runtime_client_fuzz.cc` - ランタイムクライアントファジングテスト
- E-17: `tensorflow/security/fuzzing/cc/ops/string_ops_fuzz.cc` - 文字列操作ファジングテスト
- E-18: `tensorflow/security/fuzzing/abs_fuzz.py` - Python Absオペレーションファジング
- E-19: `tensorflow/security/fuzzing/add_fuzz.py` - Python Addオペレーションファジング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FuzzingHelper.__init__で正常に初期化される | E-01 (line 48-54) | ○ |
| C-02 | get_boolでブール値が消費される | E-01 (line 56-62) | ○ |
| C-03 | get_intで指定範囲の整数が返される | E-01 (line 64-74) | ○ |
| C-04 | get_intで最小値=最大値の境界値テスト | E-01 (line 64-74) | ○ |
| C-05 | get_intでデフォルト最小値のテスト | E-01 (line 20-21, 64-74) | ○ |
| C-06 | get_floatで浮動小数点が返される | E-01 (line 76-86) | ○ |
| C-07 | get_floatで境界値テスト | E-01 (line 76-86) | ○ |
| C-08 | get_int_listで整数リストが返される | E-01 (line 88-105) | ○ |
| C-09 | get_int_listで空リストの境界値 | E-01 (line 88-105) | ○ |
| C-10 | get_float_listで浮動小数点リストが返される | E-01 (line 107-118) | ○ |
| C-11 | get_int_or_float_listで型選択 | E-01 (line 120-135) | ○ |
| C-12 | get_tf_dtypeで有効な型が返される | E-01 (line 137-156) | ○ |
| C-13 | get_tf_dtypeで許可リスト制限 | E-01 (line 137-156) | ○ |
| C-14 | get_tf_dtypeで無効な型エラー | E-01 (line 149-152) | ○ |
| C-15 | get_stringで文字列が返される | E-01 (line 158-167) | ○ |
| C-16 | get_random_numeric_tensorでテンソル生成 | E-01 (line 169-216) | ○ |
| C-17 | get_random_numeric_tensorでOOM防止エラー | E-01 (line 195-198) | ○ |
| C-18 | get_random_numeric_tensorで非サポート型エラー | E-01 (line 209-213) | ○ |
| C-19 | get_random_numeric_tensorで空形状テスト | E-01 (line 169-216) | ○ |
| C-20 | _create_dtype_wrapperで型が生成される | E-02 (line 23-24) | △ |
| C-21 | DTypeAnnotation基底クラス確認 | E-02 (line 19-20) | ○ |
| C-22 | Float32ラッパー検証 | E-02 (line 44) | ○ |
| C-23 | Int32ラッパー検証 | E-02 (line 51) | ○ |
| C-24 | FuzzSession初期化 | E-03 (line 98) | ○ |
| C-25 | InitIfNeeded初回呼び出し | E-03 (line 114-138) | ○ |
| C-26 | InitIfNeeded冪等性 | E-03 (line 115-117) | ○ |
| C-27 | RunInputs実行 | E-03 (line 145-147) | ○ |
| C-28 | RunInputsWithStatusでStatus取得 | E-03 (line 150-153) | ○ |
| C-29 | Fuzzエントリポイント | E-03 (line 157-164) | ○ |
| C-30 | AnyTensorテンプレート | E-03 (line 66-79) | ○ |
| C-31 | AnyErrorCode生成 | E-04 (line 24-31) | ○ |
| C-32 | AnyErrorCodeフィルタリング | E-04 (line 29) | ○ |
| C-33 | AnyValidNumericTensor形状指定 | E-05 (line 31-34) | ○ |
| C-34 | AnyValidNumericTensor空形状 | E-05 (line 31-34) | ○ |
| C-35 | AnySmallValidNumericTensor | E-05 (line 46-47), E-06 (line 128-136) | ○ |
| C-36 | AnyValidStringTensor | E-05 (line 49-51), E-06 (line 138-144) | ○ |
| C-37 | AnyValidTensorShape | E-07 (line 31-34) | ○ |
| C-38 | AnyValidTensorShape次元境界 | E-07 (line 31-34) | ○ |
| C-39 | AnyValidDataType | E-09 (line 25) | ○ |
| C-40 | DomainRange範囲生成 | E-06 (line 43-50) | ○ |
| C-41 | DomainRange<bool>特殊化 | E-06 (line 52-55) | △ |
| C-42 | StatusOrAnyTensor | E-06 (line 58-71) | ○ |
| C-43 | FilterInvalid | E-06 (line 101-108) | ○ |
| C-44 | StatusOrAnyNumericTensor非サポート型 | E-06 (line 96-98) | ○ |
| C-45 | AnyStatusOrTensorShape | E-08 (line 35-45) | ○ |
| C-46 | AnyValidDataType網羅性 | E-10 (line 23-32) | ○ |
| C-47 | Base64ラウンドトリップ | E-11 (line 30-39) | ○ |
| C-48 | Status生成テスト | E-12 (line 34-44) | ○ |
| C-49 | URIパース正常系 | E-13 (line 29-42) | ○ |
| C-50 | URIパース異常系 | E-13 (line 34-36) | ○ |
| C-51 | Printf書式検証 | E-14 (line 27-47) | ○ |
| C-52 | チェックポイント作成 | E-15 (line 52-86) | ○ |
| C-53 | GetDataTypeSizeサイズ取得 | E-15 (line 88-100) | ○ |
| C-54 | GetDataTypeSize特殊型 | E-15 (line 91-96) | ○ |
| C-55 | チェックポイント読込正常系 | E-15 (line 102-133) | ○ |
| C-56 | チェックポイント読込異常系 | E-15 (line 115) | ○ |
| C-57 | EmptyFunctionDefGenerator正常系 | E-16 (line 39-68) | ○ |
| C-58 | EmptyFunctionDefGenerator境界値 | E-16 (line 47-52) | △ |
| C-59 | FuzzRuntimeClient初期化 | E-16 (line 88-102) | ○ |
| C-60 | CreateFunctionInnerFuzz | E-16 (line 75-78) | ○ |
| C-61 | CreateFunctionOuterFuzz | E-16 (line 80-82) | ○ |
| C-62 | StringSplitグラフ構築 | E-17 (line 27-34) | ○ |
| C-63 | StringSplit実行 | E-17 (line 36-52) | ○ |
| C-64 | StringSplitV2実行 | E-17 (line 60-89) | ○ |
| C-65 | StringUpper実行 | E-17 (line 96-116) | ○ |
| C-66 | Abs操作ファジング | E-18 (line 23-32) | ○ |
| C-67 | Add操作ファジング | E-19 (line 23-37) | ○ |
| C-68 | Add形状不一致エラー | E-19 (line 36-37) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-20**: `_create_dtype_wrapper`関数は動的に型を生成するため、返り値の詳細な検証が困難
  - 候補：Python型システムのドキュメント / type()関数の仕様
- **C-41**: `DomainRange<bool>`特殊化はmin/maxパラメータを無視するため、テストの意図確認が必要
  - 候補：fuzztest::Arbitrary<bool>()の動作仕様
- **C-58**: `EmptyFunctionDefGenerator`で出力>入力の場合のConstノード追加ロジックの境界値検証
  - 候補：FunctionDefHelper::Createの仕様書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ファジングヘルパー関数の基本動作テスト（C-01〜C-19）
- **1: 中リスク** - 型アノテーションラッパーのテスト（C-20〜C-23）
- **1: 中リスク** - C++ファジングフレームワークのテンプレートクラステスト（C-24〜C-32）
- **0: 低リスク** - ドメイン生成関数のテスト（C-33〜C-46）
- **1: 中リスク** - 各種ファジングテストの正常系・異常系（C-47〜C-68）

## 6) レビュアーチェックリスト（最小）
- [ ] FuzzingHelperの各メソッドがatheirisライブラリと正しく連携しているか確認
- [ ] get_random_numeric_tensorのOOM防止ロジック（max_size > 8）が適切か確認
- [ ] FuzzSessionのInitIfNeeded()の冪等性が保証されているか確認
- [ ] AnyValidDataType()でサポートされている型リストが最新か確認
- [ ] checkpoint_reader_fuzzのメモリ制限（1GB）が適切か確認
- [ ] Python型アノテーションラッパーが全てのTensorFlow dtypeをカバーしているか確認
