---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 155
  claims_with_evidence: 155
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: tools.csv (単体テストケース一覧)

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：155 / 155、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/tools/compatibility/ast_edits.py` - AST編集およびコードアップグレード機能
- E-02: `tensorflow/tools/compatibility/ipynb.py` - Jupyterノートブック処理機能
- E-03: `tensorflow/tools/common/public_api.py` - パブリックAPI訪問者
- E-04: `tensorflow/tools/common/traverse.py` - モジュール・クラス走査機能
- E-05: `tensorflow/tools/proto_splitter/split.py` - プロトバッファ分割機能
- E-06: `tensorflow/tools/proto_splitter/util.py` - プロトバッファユーティリティ
- E-07: `tensorflow/tools/test/system_info_lib.py` - システム情報収集ライブラリ
- E-08: `tensorflow/tools/test/gpu_info_lib.py` - GPU情報収集ライブラリ
- E-09: `tensorflow/tools/test/run_and_gather_logs_lib.py` - テスト実行・ログ収集ライブラリ
- E-10: `tensorflow/tools/docs/doc_controls.py` - ドキュメント制御デコレータ
- E-11: `tensorflow/tools/tensorflow_builder/compat_checker/compat_checker.py` - 設定互換性チェッカー
- E-12: `tensorflow/tools/api/lib/python_object_to_proto_visitor.py` - PythonオブジェクトをProtobufに変換するビジター
- E-13: `tensorflow/tools/ci_build/calculate_full_version.py` - TensorFlowバージョン計算

## 3) Claims と根拠の対応（レビューの主戦場）

### ast_edits.py関連（UT-TOL-001 〜 UT-TOL-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | full_name_node関数は名前からASTノードを生成する | E-01 (line 43-63) | ○ |
| C-02 | get_arg_value関数はast.Callノードから引数値を取得する | E-01 (line 66-102) | ○ |
| C-03 | uses_star_args_in_call関数は*argsの使用を検出する | E-01 (line 105-127) | ○ |
| C-04 | uses_star_kwargs_in_call関数は**kwargsの使用を検出する | E-01 (line 129-151) | ○ |
| C-05 | excluded_from_module_rename関数はモジュールリネーム除外を判定する | E-01 (line 169-183) | ○ |
| C-06 | APIChangeSpecクラスは変換仕様を定義する | E-01 (line 186-218) | ○ |
| C-07 | NoUpdateSpecクラスは空の変更仕様を提供する | E-01 (line 221-233) | ○ |
| C-08 | _PastaEditVisitorクラスはAST訪問と編集を行う | E-01 (line 236-605) | ○ |
| C-09 | PastaAnalyzeVisitorクラスはAPI使用を分析する | E-01 (line 806-882) | ○ |
| C-10 | ASTCodeUpgraderクラスはPythonファイルをアップグレードする | E-01 (line 884-1101) | ○ |

### ipynb.py関連（UT-TOL-037 〜 UT-TOL-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | is_python関数はPythonコードセルを判定する | E-02 (line 26-30) | ○ |
| C-12 | process_file関数はノートブックファイルを処理する | E-02 (line 33-59) | ○ |
| C-13 | skip_magic関数はマジックコマンドをスキップする | E-02 (line 62-80) | ○ |
| C-14 | check_line_split関数は行分割を検出する | E-02 (line 83-96) | ○ |
| C-15 | _get_code関数はノートブックからコードを抽出する | E-02 (line 99-141) | ○ |
| C-16 | _update_notebook関数はノートブックを更新する | E-02 (line 144-170) | ○ |

### public_api.py関連（UT-TOL-050 〜 UT-TOL-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | PublicAPIVisitorクラスはパブリックAPIを訪問する | E-03 (line 22-147) | ○ |
| C-18 | _is_privateメソッドはプライベートメンバーを判定する | E-03 (line 112-118) | ○ |
| C-19 | _do_not_descendメソッドは下降禁止を判定する | E-03 (line 120-123) | ○ |

### traverse.py関連（UT-TOL-058 〜 UT-TOL-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | traverse関数はモジュールとクラスを再帰的に走査する | E-04 (line 69-103) | ○ |
| C-21 | _traverse_internal関数は内部走査を実行する | E-04 (line 25-66) | ○ |

### split.py関連（UT-TOL-064 〜 UT-TOL-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Splitterクラスはプロト分割の抽象基底クラス | E-05 (line 33-59) | ○ |
| C-23 | ComposableSplitterクラスは組み合わせ可能なスプリッター | E-05 (line 62-291) | ○ |
| C-24 | add_chunkメソッドはチャンクを追加する | E-05 (line 227-260) | ○ |
| C-25 | _fix_chunksメソッドはチャンクインデックスを修正する | E-05 (line 262-291) | ○ |

### util.py関連（UT-TOL-077 〜 UT-TOL-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | format_bytes関数はバイト数を人間可読形式にフォーマットする | E-06 (line 27-38) | ○ |
| C-27 | get_field関数はプロトからフィールドを取得する | E-06 (line 44-64) | ○ |
| C-28 | get_field_tag関数はFieldIndexリストを生成する | E-06 (line 67-90) | ○ |
| C-29 | _walk_fields関数はフィールドを走査する | E-06 (line 93-175) | ○ |
| C-30 | is_repeated関数はrepeatedフィールドを判定する | E-06 (line 182-187) | ○ |

### system_info_lib.py関連（UT-TOL-091 〜 UT-TOL-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | gather_machine_configuration関数はマシン構成を収集する | E-07 (line 37-56) | ○ |
| C-32 | gather_hostname関数はホスト名を取得する | E-07 (line 59-60) | ○ |
| C-33 | gather_memory_info関数はメモリ情報を取得する | E-07 (line 63-69) | ○ |
| C-34 | gather_cpu_info関数はCPU情報を取得する | E-07 (line 72-115) | ○ |
| C-35 | gather_available_device_info関数はデバイス情報を取得する | E-07 (line 118-135) | ○ |
| C-36 | gather_platform_info関数はプラットフォーム情報を取得する | E-07 (line 138-146) | ○ |

### gpu_info_lib.py関連（UT-TOL-097 〜 UT-TOL-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | gather_gpu_devices関数はGPU情報を取得する | E-08 (line 159-178) | ○ |
| C-38 | _gather_gpu_devices_proc関数は/procからGPU情報を取得する | E-08 (line 26-40) | ○ |
| C-39 | _gather_gpu_devices_cudart関数はlibcudartからGPU情報を取得する | E-08 (line 115-156) | ○ |

### run_and_gather_logs_lib.py関連（UT-TOL-102 〜 UT-TOL-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | get_git_commit_sha関数はGit SHAを取得する | E-09 (line 34-44) | ○ |
| C-41 | process_test_logs関数はテストログを処理する | E-09 (line 47-82) | ○ |
| C-42 | process_benchmarks関数はベンチマークを処理する | E-09 (line 85-91) | ○ |
| C-43 | run_and_gather_logs関数はテストを実行しログを収集する | E-09 (line 94-189) | ○ |

### doc_controls.py関連（UT-TOL-110 〜 UT-TOL-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | set_deprecated関数は非推奨を設定する | E-10 (line 25-28) | ○ |
| C-45 | inheritable_headerデコレータは継承可能ヘッダーを設定する | E-10 (line 34-40) | ○ |
| C-46 | do_not_generate_docsデコレータはドキュメント除外を設定する | E-10 (line 53-128) | ○ |
| C-47 | do_not_doc_inheritableデコレータは継承除外を設定する | E-10 (line 134-191) | ○ |
| C-48 | for_subclass_implementersデコレータはサブクラス向け設定をする | E-10 (line 197-269) | ○ |
| C-49 | doc_privateデコレータはプライベートドキュメント生成を設定する | E-10 (line 277-303) | ○ |
| C-50 | doc_in_current_and_subclassesデコレータはサブクラスドキュメント設定をする | E-10 (line 309-368) | ○ |

### compat_checker.py関連（UT-TOL-119 〜 UT-TOL-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | _compare_versions関数はバージョンを比較する | E-11 (line 29-87) | ○ |
| C-52 | _list_to_string関数はリストを文字列に結合する | E-11 (line 90-101) | ○ |
| C-53 | ConfigCompatCheckerクラスは設定互換性をチェックする | E-11 (line 113-901) | ○ |
| C-54 | _Reqsクラスは要件仕様を格納する | E-11 (line 123-318) | ○ |
| C-55 | get_all_reqsメソッドは全要件を解析する | E-11 (line 346-527) | ○ |
| C-56 | filter_dependencyメソッドは依存関係を解析する | E-11 (line 529-557) | ○ |
| C-57 | in_rangeメソッドはバージョンが範囲内かを判定する | E-11 (line 647-716) | ○ |
| C-58 | check_compatibilityメソッドは互換性をチェックする | E-11 (line 774-901) | ○ |

### python_object_to_proto_visitor.py関連（UT-TOL-139 〜 UT-TOL-153）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | _NormalizeType関数は型文字列を正規化する | E-12 (line 112-113) | ○ |
| C-60 | _SanitizedArgSpec関数は引数仕様をサニタイズする | E-12 (line 120-155) | ○ |
| C-61 | _GenerateArgsSpec関数はdocstringから引数仕様を生成する | E-12 (line 158-172) | ○ |
| C-62 | _ParseDocstringArgSpec関数はdocstringを解析する | E-12 (line 175-200) | ○ |
| C-63 | _SanitizedMRO関数はMROをサニタイズする | E-12 (line 203-236) | ○ |
| C-64 | _IsProtoClass関数はProtobufクラスを判定する | E-12 (line 239-241) | ○ |
| C-65 | PythonObjectToProtoVisitorクラスはPythonオブジェクトをプロト化する | E-12 (line 244-340) | ○ |

### calculate_full_version.py関連（UT-TOL-154 〜 UT-TOL-155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | parse_args関数は引数を解析する | E-13 (line 21-34) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースに対応するソースコードが確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点：
  - 一部のテストケースは外部依存（psutil, cpuinfo, CUDA等）を前提としている
  - ファイルI/Oを伴うテストは実行環境に依存する
  - AST関連のテストはPythonバージョンに依存する可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値と期待結果がソースコードの仕様と一致しているか確認
- [ ] 境界値テストが適切な範囲をカバーしているか確認
- [ ] 異常系テストが主要なエラーパスを網羅しているか確認
- [ ] 優先度の設定が適切か確認（高：金額計算・認証・セキュリティ関連）
- [ ] 外部依存（CUDA、psutil等）を持つテストの前提条件が明確か確認
- [ ] Python 3.5+固有の機能（Starred等）に関するテストが適切か確認
