# 帳票設計書 1-TFLite変換レポート（HTML）

## 概要

本ドキュメントは、TensorFlow LiteモデルへのTOCO変換プロセスの結果をHTMLレポートとして出力する帳票の設計を定義する。変換前後のオペレータプロファイル、変換ステータス、グラフのDOT表現などを含むレポートの仕様を記載する。

### 本帳票の処理概要

TFLite変換レポート（HTML）は、TensorFlowモデルをTensorFlow Lite形式に変換した際の変換結果を視覚的に確認可能なHTMLレポートとして出力する帳票である。

**業務上の目的・背景**：TensorFlowモデルをモバイルや組み込みデバイス向けのTFLite形式に変換する際、変換が正しく行われたか、どのオペレータが使用されているか、変換前後でモデル構造がどのように変化したかを把握することが不可欠である。本帳票は、変換プロセスの透明性を確保し、変換エラーやサポートされていないオペレータの検出を容易にするために存在する。

**帳票の利用シーン**：モデル開発者がTFLiteコンバータを使用してモデル変換を行った後、変換結果の詳細を確認する場面で利用される。特に、変換時にエラーやワーニングが発生した場合の原因調査、およびデプロイ前の変換品質の検証に用いられる。

**主要な出力内容**：
1. 変換ステータス（Success / Fail）の表示
2. 変換前後のオペレータ数（Total Ops）
3. Built-in / Custom / Select Opsの内訳カウント
4. 変換前オペレータプロファイル（オペレータ名、入力テンソル型）
5. 変換後オペレータプロファイル（オペレータ名、サポート種別）
6. 変換前後のグラフDOT表現
7. ポストトレーニング量子化の有効/無効状態
8. TOCOログ情報（エラーログまたは成功メッセージ）

**帳票の出力タイミング**：TFLiteコンバータ（TOCO）がモデル変換を完了した直後に、`gen_conversion_log_html`関数が呼び出されることで自動的にHTML帳票が生成される。

**帳票の利用者**：MLエンジニア、モデル開発者、デプロイ担当者

## 帳票種別

レポート（変換結果サマリー）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIツール / Python API | N/A（プログラム実行） | TFLiteConverterの変換実行後に自動生成 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（ブラウザ表示） |
| 向き | N/A |
| ファイル名 | `toco_conversion_summary.html`（固定名）、日付時刻付きのパスも使用可能（例: `2019-01-01-10:05.toco_report.html`） |
| 出力方法 | ローカルファイル出力 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A（HTML形式のため該当しない）

### Excel固有設定

N/A（HTML形式のため該当しない）

## 帳票レイアウト

### レイアウト概要

Bootstrapフレームワークを使用したレスポンシブHTMLレイアウト。ページヘッダー、変換サマリーセクション、オペレータプロファイルテーブル、グラフ可視化セクションで構成される。

```
+---------------------------------------------+
|         ページヘッダー                        |
|  "Tensorflow Conversion Tooling & Logging"   |
+---------------------------------------------+
|         変換サマリー部                        |
|  [変換ステータス] [オペレータ数] [量子化状態]   |
+---------------------------------------------+
|         変換前オペレータプロファイル            |
|  テーブル: オペレータ名 | 入力テンソル型        |
+---------------------------------------------+
|         変換後オペレータプロファイル            |
|  テーブル: オペレータ名 | サポート種別          |
+---------------------------------------------+
|         グラフ可視化（DOT形式）               |
|  変換前グラフ | 変換後グラフ                   |
+---------------------------------------------+
|         TOCOログ情報                         |
+---------------------------------------------+
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 変換ステータス | Success/Failのラベル表示 | `toco_err_log`の有無で判定 | Bootstrap labelタグ（Success: 緑、Fail: 赤） |
| 2 | 変換前Total Ops | 変換前のオペレータ総数 | `toco_conversion_log_before.model_size` | 数値 |
| 3 | 変換後Total Ops | 変換後のオペレータ総数 | `toco_conversion_log_after.model_size` | 数値 |
| 4 | Built-in Ops数 | ビルトインオペレータの合計数 | `toco_conversion_log_after.built_in_ops` | 数値 |
| 5 | Select Ops数 | Selectオペレータの合計数 | `toco_conversion_log_after.select_ops` | 数値 |
| 6 | Custom Ops数 | カスタムオペレータの合計数 | `toco_conversion_log_after.custom_ops` | 数値 |
| 7 | 量子化状態 | ポストトレーニング量子化の有効/無効 | `post_training_quant_enabled` | "is"/"isn't" |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 変換前オペレータ名 | 変換前モデルのオペレータ名一覧 | `toco_conversion_log_before.op_list` | テキスト | 自動 |
| 2 | 入力テンソル型 | 各オペレータの入力テンソル型・形状 | `toco_conversion_log_before.op_signatures` | "shape:[...],type:..."形式 | 自動 |
| 3 | 変換後オペレータ名 | 変換後モデルのオペレータ名一覧 | `toco_conversion_log_after.op_list` | テキスト | 自動 |
| 4 | サポート種別 | BUILT-IN / CUSTOM OP / SELECT OP | `built_in_ops`, `custom_ops`で判定 | テキスト | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | グラフDOT（変換前） | 変換前のグラフのDOT表現 | `toco_tf_graph.dot`ファイル | DOT形式テキスト |
| 2 | グラフDOT（変換後） | 変換後のグラフのDOT表現 | `toco_tflite_graph.dot`ファイル | DOT形式テキスト |
| 3 | TOCOログ | 変換時のログ情報 | `toco_err_logs`またはSuccess情報 | HTMLエスケープ済みテキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| conversion_log_dir | 変換ログファイルが格納されたディレクトリ | Yes |
| quantization_enabled | ポストトレーニング量子化の有効フラグ | Yes |
| tflite_graph_path | 変換済みTFLiteモデルのファイルパス | Yes |
| toco_log_before.pb | 変換前のTocoConversionLogプロトバッファ | Yes |
| toco_log_after.pb | 変換後のTocoConversionLogプロトバッファ | Yes |
| toco_tf_graph.dot | 変換前グラフのDOTファイル | Yes |
| toco_tflite_graph.dot | 変換後グラフのDOTファイル | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | オペレータ表示順 | 元データの出現順（op_listの順序） |

### 改ページ条件

HTML形式のためブラウザスクロールにより表示。改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。ファイルベースのProtocol Buffersデータを使用する。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A（ファイルベース） | N/A | N/A |

### テーブル別参照項目詳細

#### 入力ファイル: TocoConversionLog（Protocol Buffers）

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| op_list | オペレータ名一覧 | N/A | repeated string |
| built_in_ops | ビルトインOps数 | values()の合計 | map<string, int32> |
| custom_ops | カスタムOps数 | values()の合計 | map<string, int32> |
| select_ops | Select Ops数 | values()の合計 | map<string, int32> |
| op_signatures | 入力テンソル型情報 | N/A | repeated string |
| model_size | オペレータ総数 | N/A | int32 |
| toco_err_logs | エラーログ | N/A | string |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Built-in Ops数 | `sum(toco_conversion_log_after.built_in_ops.values())` | N/A | gen_html.py 行150-151 |
| Select Ops数 | `sum(toco_conversion_log_after.select_ops.values())` | N/A | gen_html.py 行152-153 |
| Custom Ops数 | `sum(toco_conversion_log_after.custom_ops.values())` | N/A | gen_html.py 行154-155 |
| 入力テンソル型表示 | `get_input_type_from_signature(op_signature)` | N/A | "shape:[...],type:..."形式に変換 |
| オペレータ種別判定 | `get_operator_type(op_name, conversion_log)` | N/A | BUILT-IN / CUSTOM OP / SELECT OP |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[gen_conversion_log_html呼び出し] --> B[HTMLテンプレート読み込み]
    B --> C[toco_log_before.pb読み込み・パース]
    C --> D[toco_log_after.pb読み込み・パース]
    D --> E[DOTファイル読み込み]
    E --> F[HTMLGenerator.generate呼び出し]
    F --> G[HTMLプレースホルダ辞書作成]
    G --> H[変換ステータス判定]
    H --> I[オペレータプロファイルHTML行生成]
    I --> J[テンプレート内マーカー置換]
    J --> K{全マーカー置換完了?}
    K -->|Yes| L[HTMLファイル書き出し]
    K -->|No| M[RuntimeError送出]
    L --> N[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| IOError | HTMLテンプレートファイルが存在しない | `File '{path}' does not exist.` | テンプレートファイルの配置を確認 |
| IOError | 変換ログファイルが存在しない | `Failed to generate HTML: file '{path}' doesn't exist.` | 変換ログディレクトリ内のファイルを確認 |
| RuntimeError | HTMLマーカーの置換に失敗 | `Could not populate marker text '{marker}'` | テンプレートHTMLのマーカーが正しいか確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | オペレータ数: 数十〜数千 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 1（変換プロセスごとに1レポート） |

## セキュリティ考慮事項

- HTMLテンプレートにユーザーデータを埋め込む際、`html_escape`関数でHTMLエスケープ処理を行い、XSSを防止している（gen_html.py 行33-34）
- TOCOエラーログについてはHTMLエスケープを適用しており、呼び出し元で適切に匿名化されていることが前提（gen_html.py 行185）
- 生成されたHTMLファイルはローカルディスクに保存されるため、ファイルシステムのアクセス権限で保護する

## 備考

- テンプレートHTMLはBootstrap 3.3.5を使用したレスポンシブデザイン
- CDN経由でBootstrap CSSを読み込むため、レポート閲覧時にインターネット接続が必要
- 変換前後のグラフはDOT形式で埋め込まれ、ブラウザ上でのグラフ可視化にはGraphvizなどの外部ツールが必要な場合がある

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、変換ログのProtocol Buffersメッセージ定義を理解することが重要。これにより帳票に表示されるデータの構造と型が把握できる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | toco_conversion_log.proto | `tensorflow/lite/toco/logging/toco_conversion_log.proto` | TocoConversionLogメッセージの全フィールド定義（op_list, built_in_ops, custom_ops, select_ops, op_signatures, model_size, toco_err_logs）を理解する |

**読解のコツ**: Protocol Buffers定義ファイルであり、各フィールドの型（repeated, map, optional）に注意する。特にop_listはrepeated string、built_in_opsはmap型であることを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となる`gen_conversion_log_html`関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gen_html.py | `tensorflow/lite/toco/logging/gen_html.py` | `gen_conversion_log_html`関数（行204-265）が変換レポート生成の起点。引数の検証、ファイル読み込み、HTMLGenerator呼び出しの流れを把握する |

**主要処理フロー**:
1. **行222**: テンプレートHTMLファイルのパスを取得（resource_loader使用）
2. **行227-242**: 変換ログファイル（before/after）とDOTファイルの存在確認
3. **行244-246**: HTMLGeneratorインスタンス生成（テンプレートパス、出力先パスを引数に）
4. **行249-254**: TocoConversionLogプロトバッファの読み込みとパース
5. **行257-260**: DOTファイルの読み込み
6. **行262-265**: HTML生成メソッド呼び出し

#### Step 3: HTML生成コアロジックを理解する

HTMLGeneratorクラスのgenerateメソッドでHTMLレポートが組み立てられる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gen_html.py | `tensorflow/lite/toco/logging/gen_html.py` | HTMLGeneratorクラス（行83-201）: コンストラクタでテンプレート読み込み、generateメソッドでプレースホルダ置換を行う |

**主要処理フロー**:
- **行86-105**: コンストラクタ - テンプレートHTML読み込みと出力ディレクトリ作成
- **行107-201**: generateメソッド - HTMLプレースホルダ辞書を構築し、テンプレート内のマーカーを順次置換
- **行142-155**: 変換サマリー情報（ステータス、Ops数）をHTML辞書に設定
- **行162-178**: オペレータプロファイル（変換前・後）のHTMLテーブル行を生成
- **行193-198**: テンプレート内の各マーカーを実テキストで置換し、置換漏れをチェック
- **行200-201**: 最終HTMLをファイルに書き出し

#### Step 4: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gen_html.py | `tensorflow/lite/toco/logging/gen_html.py` | `html_escape`（行33-34）、`get_input_type_from_signature`（行37-71）、`get_operator_type`（行74-80）の3つのヘルパー関数 |

### プログラム呼び出し階層図

```
gen_conversion_log_html() [行204]
    |
    +-- resource_loader.get_path_to_datafile("template.html") [行222]
    |
    +-- HTMLGenerator.__init__(template_path, export_path) [行86]
    |       +-- file_io.FileIO() - テンプレート読み込み [行101]
    |       +-- file_io.recursive_create_dir() - 出力ディレクトリ作成 [行104]
    |
    +-- TocoConversionLog.ParseFromString() - protoパース [行252-254]
    |
    +-- HTMLGenerator.generate() [行107]
            |
            +-- get_input_type_from_signature() [行37] - 入力テンソル型文字列パース
            |
            +-- get_operator_type() [行74] - オペレータ種別判定
            |
            +-- html_escape() [行33] - HTMLエスケープ処理
            |
            +-- file_io.FileIO() - HTML書き出し [行200]
```

### データフロー図

```
[入力]                          [処理]                           [出力]

toco_log_before.pb --------+
                            |
toco_log_after.pb ---------+---> HTMLGenerator.generate() -----> toco_conversion_summary.html
                            |         |
toco_tf_graph.dot ---------+    プレースホルダ置換
                            |
toco_tflite_graph.dot -----+
                            |
template.html -------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gen_html.py | `tensorflow/lite/toco/logging/gen_html.py` | ソース | HTML帳票生成のメインロジック |
| toco_conversion_log.proto | `tensorflow/lite/toco/logging/toco_conversion_log.proto` | 定義 | 変換ログのProtocol Buffers定義 |
| template.html | `tensorflow/lite/toco/logging/template.html` | テンプレート | HTMLレポートのテンプレート |
| toco_conversion_log_pb2.py | `tensorflow/lite/toco/logging/toco_conversion_log_pb2.py` | 生成コード | protoから自動生成されたPythonバインディング |
| file_io.py | `tensorflow/python/lib/io/file_io.py` | ライブラリ | ファイルI/O操作 |
| resource_loader.py | `tensorflow/python/platform/resource_loader.py` | ライブラリ | テンプレートファイルのパス解決 |
