# 帳票設計書 10-TensorTracerレポート

## 概要

本ドキュメントは、TPU実行時のテンソルトレース結果をレポートファイルとして出力する帳票の設計を定義する。テンソルの統計情報やトレース順序を含む。

### 本帳票の処理概要

TensorTracerレポートは、TPU上でのテンソル値のトレース結果を構造化されたテキストレポートおよびProtocol Buffers形式で出力する帳票機能である。グラフ内の各テンソルのトレース状態、キャッシュインデックスマッピング、オペレータ一覧、トポロジカルソート結果を含む包括的なデバッグレポートを生成する。

**業務上の目的・背景**：TPU上でのモデル実行時に数値異常（NaN、Inf）の発生箇所を特定したり、テンソルの統計情報（ノルム、最大値、最小値、平均、分散、スパース性等）を収集してデバッグを支援するために、テンソルトレース機能が必要である。本帳票はトレースの設定、トレース対象テンソル、グラフ構造を体系的に記録する。

**帳票の利用シーン**：TPU上でのモデルトレーニング時の数値異常デバッグ、テンソル値の分布分析、モデルの数値安定性評価、TPU実行パスの確認、トレース結果の事後分析などで使用される。

**主要な出力内容**：
1. 設定セクション（バージョン、デバイスタイプ、トレースモード、レプリカ数等）
2. オペレータリストセクション（全オペレータの名前、型、出力テンソルインデックス）
3. テンソルリストセクション（全テンソルの名前、消費者オペレータ）
4. チェックポイントセクション（プログラム的に追加されたトレースポイント）
5. キャッシュインデックスマッピングセクション（キャッシュID→テンソルIDマッピング）
6. 理由セクション（各テンソルのトレース/非トレース理由）
7. グラフセクション（トポロジカルソート結果）

**帳票の出力タイミング**：TensorTracerのグラフ変換時（グラフ構築フェーズ）に`create_report()`メソッドで出力される。`--report_file`パラメータで出力先を指定する。

**帳票の利用者**：TPUエンジニア、MLデバッガー、パフォーマンスエンジニア

## 帳票種別

デバッグレポート（構造化テキスト / Protocol Buffers）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | TPU実行環境 | N/A（プログラム実行） | TensorTracer設定でreport_fileパラメータ指定 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（セクション区切り形式） + Protocol Buffers（.report_pb） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | テキスト: `report_file`パラメータで指定、Proto: `tensor_tracer_report.report_pb.{tag}` |
| 出力方法 | テキスト: gfile.Openで書き出し、Proto: gfile.GFileでバイナリ書き出し |
| 文字コード | UTF-8（テキスト） / N/A（Proto） |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

レポートはセクション区切りマーカーで構造化されたテキスト形式で出力される。各セクションは`!!!!!!! section-begin:`と`!!!!!!! section-end:`で囲まれる。

```
[テキストレポート構造]
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: configuration |
| version, device, trace-mode, etc.            |
| [>>>TT>>>] !!!!!!! section-end: configuration   |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: op-list       |
| 全オペレータ一覧                               |
| [>>>TT>>>] !!!!!!! section-end: op-list         |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: tensor-list   |
| 全テンソル一覧                                 |
| [>>>TT>>>] !!!!!!! section-end: tensor-list     |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: tensor_tracer_checkpoint |
| チェックポイント一覧                            |
| [>>>TT>>>] !!!!!!! section-end: tensor_tracer_checkpoint   |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: cache-index-map |
| キャッシュインデックスマッピング                  |
| [>>>TT>>>] !!!!!!! section-end: cache-index-map   |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: reason        |
| トレース/非トレース理由一覧                     |
| [>>>TT>>>] !!!!!!! section-end: reason          |
+---------------------------------------------+
| [>>>TT>>>] !!!!!!! section-begin: graph         |
| グラフのトポロジカルソート結果                   |
| [>>>TT>>>] !!!!!!! section-end: graph           |
+---------------------------------------------+
```

### ヘッダー部（configurationセクション）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | TensorTracerバージョン | `tt_config.version` | 文字列（"use-outside-compilation"） |
| 2 | device | デバイスタイプ | `tt_config.device_type` | 文字列（"tpu"/"cpu"） |
| 3 | trace-mode | トレースモード | `tt_parameters.trace_mode` | 文字列 |
| 4 | submode | サブモード | `tt_parameters.submode` | 文字列 |
| 5 | num-replicas | レプリカ数 | `tt_config.num_replicas` | 整数 |
| 6 | num-replicas-per-host | ホストあたりレプリカ数 | `tt_config.num_replicas_per_host` | 整数 |
| 7 | num-hosts | ホスト数 | `tt_config.num_hosts` | 整数 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | オペレータ一覧 | 全オペレータのインデックス、名前、型、出力テンソルID | graph_order.operations | `{idx} "{name}" {type} {tensor_ids}` | N/A |
| 2 | テンソル一覧 | 全テンソルのインデックス、名前、消費者オペレータID | graph_order.tensors | `{idx} "{name}" {consumer_ids}` | N/A |
| 3 | キャッシュマッピング | キャッシュインデックスとテンソルインデックスの対応 | tensor_trace_order | `{cache_idx} {tensor_idx}` | N/A |
| 4 | トレース理由 | 各テンソル/オペレータのトレース/非トレース理由 | instrument_records | `"{name}" {reason}` | N/A |

### フッター部（graphセクション）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | トポロジカルソート成功 | ソートの成功/失敗フラグ | `graph_order.contains_cycle` | True/False |
| 2 | ソート済みオペレータ | トポロジカル順序のオペレータ一覧 | `graph_order.topological_order_or_cycle` | `{idx} "{name}"` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| report_file_path | レポートファイルの出力パス | No（未設定時はlogging.infoに出力） |
| TensorTracer有効 | tensor_tracer_paramsで有効化 | Yes |
| グラフ構築完了 | TFグラフの構築が完了していること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | オペレータ: トポロジカル順序 | 昇順 |
| 2 | テンソル: オペレータ順→出力順 | 昇順 |
| 3 | 理由: オペレータ/テンソル名のアルファベット順 | 昇順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| トポロジカルソート | `topological_sort(graph)` - NextIterationエッジをスキップしてDAG化 | N/A | tensor_tracer_report.py 行54-117 |
| テンソルインデックス | operations順にop.outputsを展開し連番付与 | N/A | tensor_tracer_report.py 行182-189 |
| キャッシュインデックス | traced_tensorsの出現順に連番付与 | N/A | tensor_tracer_report.py 行139-165 |
| プロトフィンガープリント | SHA-256ハッシュ（report protoのSerializeToString） | N/A | tensor_tracer_report.py 行213-216 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[TensorTracer グラフ変換] --> B[TTReportHandle.create_report呼び出し]
    B --> C[OpenReportFile - レポートファイルオープン]
    C --> D[_write_config_section - 設定情報書き込み]
    D --> E[_write_op_list_section - オペレータ一覧書き込み]
    E --> F[_write_tensor_list_section - テンソル一覧書き込み]
    F --> G[_write_trace_points - チェックポイント書き込み]
    G --> H[_write_cache_index_map_section - キャッシュマップ書き込み]
    H --> I[_write_reason_section - トレース理由書き込み]
    I --> J[_write_graph_section - グラフ情報書き込み]
    J --> K[ファイルクローズ]
    K --> L[create_report_proto - Proto版作成]
    L --> M[write_report_proto - Proto書き出し]
    M --> N[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| IOError | レポートファイルのオープン失敗 | IOErrorメッセージ | 出力パスの権限を確認 |
| ValueError | テンソルがtensor_to_idxに存在しない | `out_tensor is not in tensor_to_idx` | グラフの整合性を確認 |
| ValueError | 消費者オペレータがop_to_idxに存在しない | `consumer_op is not in op_to_idx` | グラフの整合性を確認 |
| RuntimeError | キャッシュマップのサイズ不整合 | `len(tensorname_to_cache_idx) must equal len(cache_idx_to_tensor_idx)` | 内部ロジックの確認 |
| ValueError | トポロジカルソートの次数計算で負の値 | `consumer:{name} degree mismatch` | グラフの循環を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | オペレータ数: 数百〜数万、テンソル数: 数百〜数万 |
| 目標出力時間 | 秒オーダー（グラフ規模に比例） |
| 同時出力数上限 | 1（グラフ構築フェーズで1回） |

## セキュリティ考慮事項

- レポートにはモデルの完全なグラフ構造が含まれるため、モデルの知的財産を保護する場合は厳重なアクセス制御が必要
- report_file_pathの値はファイルパスとして使用されるため、パストラバーサルに注意
- Proto版レポートにはGraphDef全体が含まれる（tensor_tracer_report.py 行292）

## 備考

- `_SKIP_REPORT_FILE = 'None'`を設定するとレポートファイルの書き出しがスキップされる（tensor_tracer.py 行95）
- report_file_pathが未設定の場合は`logging.info`でコンソールに出力される（tensor_tracer_report.py 行340-342）
- トレース理由には`traced-tensor`、`traced-scalar`、`not-traced-outside-op-range`等の定義済み定数が使用される（tensor_tracer.py 行68-84）
- Proto版レポートにはフィンガープリント（SHA-256）が含まれ、トレース設定の変更検出に使用される（tensor_tracer_report.py 行288-290）
- トポロジカルソートではNextIterationオペレータを「シンク」として扱い、while-loopの循環を回避する（tensor_tracer_report.py 行66-68）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | TensorTracerConfig（行120-128）、TensorTraceOrder（行131-165）、GraphWrapperのnamedtuple（行170-174）の構造を理解 |
| 1-2 | tensor_tracer_pb2.py | `tensorflow/python/tpu/tensor_tracer_pb2.py` | TensorTracerReport protoの構造 |

**読解のコツ**: GraphWrapperはgraph, operations, op_to_idx, tensors, tensor_to_idx, contains_cycle, topological_order_or_cycleの7つのフィールドを持つnamedtuple。sort_tensors_and_ops()で生成される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | `TTReportHandle.create_report()`（行314-324）がテキストレポート生成の起点 |

**主要処理フロー**:
1. **行317**: OpenReportFileでファイルオープン（コンテキストマネージャ）
2. **行318**: _write_config_section - 設定情報
3. **行319**: _write_op_list_section - オペレータ一覧
4. **行320**: _write_tensor_list_section - テンソル一覧
5. **行321**: _write_trace_points - チェックポイント
6. **行322**: _write_cache_index_map_section - キャッシュマップ
7. **行323**: _write_reason_section - トレース理由
8. **行324**: _write_graph_section - グラフ情報

#### Step 3: Proto版レポート生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | `create_report_proto()`（行235-293）: TensorTracerReport protoの構築とフィンガープリント計算 |

**主要処理フロー**:
- **行253-260**: configフィールド設定（version, device, num_cores, num_hosts, submode, trace_mode）
- **行262-264**: 署名タイプ設定
- **行266-287**: TracedTensorDef定義（名前、トレース状態、キャッシュインデックス、説明）
- **行288**: フィンガープリント計算
- **行292**: GraphDef設定

#### Step 4: トポロジカルソートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | `topological_sort()`（行54-117）: NextIterationエッジをスキップしたDAGソート |
| 4-2 | tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | `sort_tensors_and_ops()`（行168-190）: グラフラッパー生成 |

### プログラム呼び出し階層図

```
TensorTracer (tensor_tracer.py)
    |
    +-- TTReportHandle.create_report() [行314]
    |       |
    |       +-- OpenReportFile(tt_parameters) [行193]
    |       +-- _write_config_section() [行344]
    |       +-- _write_op_list_section() [行369]
    |       +-- _write_tensor_list_section() [行389]
    |       +-- _write_trace_points() [行326]
    |       +-- _write_cache_index_map_section() [行413]
    |       +-- _write_reason_section() [行361]
    |       +-- _write_graph_section() [行427]
    |
    +-- TTReportHandle.create_report_proto() [行235]
    |       |
    |       +-- proto_fingerprint() [行213]
    |
    +-- TTReportHandle.write_report_proto() [行308]

sort_tensors_and_ops(graph) [行168]
    |
    +-- topological_sort(graph) [行54]
            |
            +-- _is_loop_edge(op) [行66]
            +-- _in_op_degree(op) [行70]
```

### データフロー図

```
[入力]                          [処理]                             [出力]

tf.Graph -------> sort_tensors_and_ops()
                        |
                        +-- topological_sort()
                        +-- GraphWrapper生成
                                |
tt_config ---------+            v
                    |
tt_parameters -----+---> create_report() -------> report_file (テキスト)
                    |
tensor_trace_order +---> create_report_proto() --> report_pb (Proto)
                    |
instrument_records +
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tensor_tracer_report.py | `tensorflow/python/tpu/tensor_tracer_report.py` | ソース | レポート生成の中心（行1-437） |
| tensor_tracer.py | `tensorflow/python/tpu/tensor_tracer.py` | ソース | TensorTracerメインクラス、トレース理由定数定義 |
| tensor_tracer_flags.py | `tensorflow/python/tpu/tensor_tracer_flags.py` | ソース | トレースフラグ・パラメータ定義 |
| tensor_tracer_pb2.py | `tensorflow/python/tpu/tensor_tracer_pb2.py` | 生成コード | TensorTracerReport proto Pythonバインディング |
| gfile.py | `tensorflow/python/platform/gfile.py` | ライブラリ | ファイルI/O操作 |
