# 帳票設計書 11-プロファイラレポート

## 概要

本ドキュメントは、TensorFlowのプロファイラ機能が出力するプロファイラレポートの設計について記述する。TensorFlow 2.x Profiler APIを使用してモデル実行時のパフォーマンスデータを収集し、TensorBoard形式でエクスポートする帳票の仕様を定義する。

### 本帳票の処理概要

本帳票は、TensorFlowモデルの実行時パフォーマンスデータを収集・記録し、TensorBoard形式のプロファイリングレポートとして出力する機能を提供する。

**業務上の目的・背景**：機械学習モデルの学習・推論フェーズにおいて、CPU/GPU/TPUの利用状況やオペレーション単位の実行時間を把握し、パフォーマンスボトルネックを特定するために本帳票が必要である。モデルの最適化やハードウェアリソースの効率的な活用を支援する。

**帳票の利用シーン**：モデルの学習速度が期待を下回る場合のボトルネック分析、GPU/TPUの利用率の確認、オペレーション単位の実行時間プロファイリング、Pythonコールスタックのトレースなど、パフォーマンスチューニングの局面で利用される。

**主要な出力内容**：
1. ホストCPUのトレース情報（host_tracer_level設定に基づく3段階の詳細度）
2. デバイス（GPU/TPU）トレース情報（device_tracer_level設定に基づく有効/無効）
3. Python関数コールのトレース情報（python_tracer_level設定に基づく有効/無効）
4. TensorBoard Profileプラグインで可視化可能なイベントデータ

**帳票の出力タイミング**：`tf.profiler.experimental.start()`でプロファイリングを開始し、`tf.profiler.experimental.stop()`を呼び出した時点でTensorBoardのlogdirにエクスポートされる。または`tf.profiler.experimental.Profile`コンテキストマネージャのスコープ終了時に自動的に出力される。

**帳票の利用者**：機械学習エンジニア、MLOpsエンジニア、パフォーマンスチューニング担当者

## 帳票種別

プロファイリングデータ / パフォーマンス分析レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | TensorBoard Profile | `localhost:6006/#profile` | プロファイリングデータのアップロード後にブラウザで閲覧 |
| - | CLIインターフェース | - | `tf.profiler.experimental.stop()` 呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TensorBoard イベントファイル（protobuf形式） |
| 用紙サイズ | N/A（電子データ） |
| 向き | N/A |
| ファイル名 | TensorBoardのlogdir配下に自動生成される複数ファイル |
| 出力方法 | ファイルシステムへの書き出し |
| 文字コード | バイナリ（Protocol Buffers） |

### PDF固有設定

該当なし（バイナリプロファイルデータ）

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

プロファイラレポートはTensorBoardのProfileプラグインで可視化される。バイナリprotobuf形式のため、固定的なレイアウトは持たないが、TensorBoard上では以下の構成で表示される。

```
┌─────────────────────────────────────┐
│        Overview Page                 │
│  (実行サマリー、ステップ時間等)       │
├─────────────────────────────────────┤
│        Trace Viewer                  │
│  (タイムラインベースのトレース表示)   │
├─────────────────────────────────────┤
│        Op Profile                    │
│  (オペレーション単位のプロファイル)   │
├─────────────────────────────────────┤
│        Memory Profile                │
│  (メモリ使用量プロファイル)          │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | デバイス情報 | プロファイリング対象デバイス名 | ProfilerSession | テキスト |
| 2 | プロファイリング開始時刻 | データ収集開始のタイムスタンプ | ProfilerSession.start() | タイムスタンプ |
| 3 | プロファイリング終了時刻 | データ収集終了のタイムスタンプ | ProfilerSession.stop() | タイムスタンプ |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ホストトレースイベント | CPU側のイベントトレース | host_tracer_level | protobuf | 可変 |
| 2 | デバイストレースイベント | GPU/TPU側のイベントトレース | device_tracer_level | protobuf | 可変 |
| 3 | Pythonトレースイベント | Python関数呼び出しトレース | python_tracer_level | protobuf | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | プロファイリングオプション | 使用されたProfilerOptions設定 | ProfilerOptions | テキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| logdir | プロファイリング結果の出力先ディレクトリ | Yes |
| host_tracer_level | CPUトレースレベル（1:critical, 2:info, 3:verbose） | No（デフォルト: 2） |
| python_tracer_level | Pythonトレース有効/無効（0:無効, 1:有効） | No（デフォルト: 0） |
| device_tracer_level | デバイストレース有効/無効（0:無効, 1:有効） | No（デフォルト: 1） |
| delay_ms | 複数ホスト同期用の遅延時間（ミリ秒） | No（デフォルト: None） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | タイムスタンプ | 昇順 |

### 改ページ条件

該当なし（バイナリデータのため）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。TensorFlow実行ランタイムからリアルタイムにプロファイリングデータを収集する。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

該当なし

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| プロファイリング期間 | stop時刻 - start時刻 | なし | ランタイムで自動計算 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[tf.profiler.experimental.start logdir, options] --> B[ProfilerSessionの生成]
    B --> C[_pywrap_profiler.ProfilerSession.start]
    C --> D[プロファイリングデータ収集中]
    D --> E[tf.profiler.experimental.stop]
    E --> F{save=True?}
    F -->|Yes| G[_profiler.export_to_tb]
    F -->|No| H[セッション破棄]
    G --> I[TensorBoard logdirにデータ出力]
    I --> J[_profiler = None]
    H --> J
    J --> K[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| AlreadyExistsError | 既にプロファイリングセッションが実行中 | "Another profiler is running." | 既存セッションを停止してから再実行 |
| UnavailableError | stop()時にアクティブセッションがない | "Cannot export profiling results. No profiler is running." | start()を先に呼び出す |
| AlreadyExistsError（サーバー競合） | プロファイラサーバーとAPIの同時使用 | "Another profiler session is running which is probably created by profiler server." | プロファイラサーバーとAPIの同時使用を避ける |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | デバイス数 x イベント数（数千〜数百万イベント） |
| 目標出力時間 | プロファイリング期間に依存（export_to_tbは数秒以内） |
| 同時出力数上限 | 1（排他制御あり：_profiler_lockによるスレッドロック） |

## セキュリティ考慮事項

- プロファイリングデータにはモデルの内部構造（オペレーション名、テンソル形状等）が含まれるため、logdirのアクセス権限を適切に設定する必要がある
- プロファイラサーバーモード（`start_server`）使用時は、ポートへの外部アクセスを制限すべきである
- _profiler_lock（threading.Lock）によりシングルセッション排他制御が実装されている

## 備考

- Keras TensorBoardコールバックはサンプリングモードのプロファイリングを自動的に実行する。カスタムプロファイリングを有効にする場合は `profile_batches=[]` を設定して自動サンプリングを無効化する必要がある
- warmup()関数を使用することで、プロファイリングコンテキスト（CUPTIライブラリのロード等）を事前準備し、結果の正確性を向上できる
- Programmatic ModeとSampling Modeの同時使用は未定義動作であり、エラーになる可能性がある

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロファイラのオプション構造と、セッション管理のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | ProfilerOptionsのnamedtuple定義（行46-77）を理解する。host_tracer_level, python_tracer_level, device_tracer_level, delay_msの4つのフィールドとそのデフォルト値を確認する |
| 1-2 | _pywrap_profiler.pyi | `tensorflow/python/profiler/internal/_pywrap_profiler.pyi` | ProfilerSessionクラスの型定義（行16-20）を確認する。start, stop, export_to_tbの3メソッドを持つ |

**読解のコツ**: ProfilerOptionsはcollections.namedtupleを継承しており、__new__でデフォルト値を提供している。pybind11のnamedtuple未サポートのため、dict変換して渡している点に注意。

#### Step 2: エントリーポイントを理解する

プロファイリングの開始・停止関数がエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | start()関数（行80-126）がプロファイリングの開始エントリーポイント。@tf_exportデコレータにより`tf.profiler.experimental.start`として公開される |
| 2-2 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | stop()関数（行129-153）がプロファイリングの停止エントリーポイント。save=Trueの場合にexport_to_tb()でTensorBoardにエクスポートする |

**主要処理フロー**:
1. **行108-109**: _profiler_lockを取得し、既存セッションがないことを確認
2. **行112**: _pywrap_profiler.ProfilerSession()を生成
3. **行116-117**: optionsをdict変換し、_profiler.start(logdir, opts)を呼び出し
4. **行147-149**: stop()でsave=Trueの場合、_profiler.export_to_tb()を実行
5. **行153**: _profiler = Noneでセッションを解放

#### Step 3: コンテキストマネージャインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | Profileクラス（行183-212）はstart/stopをwithブロックで自動管理するコンテキストマネージャ。__enter__でstart、__exit__でstopを呼ぶ |

**主要処理フロー**:
- **行208-209**: __enter__でstart(self._logdir, self._options)を呼び出し
- **行211-212**: __exit__でstop()を呼び出し

#### Step 4: サーバーモードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | start_server()関数（行168-180）はgRPCプロファイラサーバーを起動する。プロセス終了まで待ち受ける |

### プログラム呼び出し階層図

```
tf.profiler.experimental.start(logdir, options)  [profiler_v2.py:81]
    |
    +-- _pywrap_profiler.ProfilerSession()  [C++バインディング]
    |       +-- ProfilerSession.start(logdir, opts)
    |
tf.profiler.experimental.stop(save=True)  [profiler_v2.py:130]
    |
    +-- _profiler.export_to_tb()  [C++バインディング]

tf.profiler.experimental.Profile(logdir, options)  [profiler_v2.py:184]
    |
    +-- __enter__ -> start(logdir, options)
    +-- __exit__  -> stop()

tf.profiler.experimental.server.start(port)  [profiler_v2.py:169]
    |
    +-- _pywrap_profiler.start_server(port)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

logdir (str)         -----> ProfilerSession.start()  ----->
ProfilerOptions      -----> (C++プロファイラカーネル)  ----->
                            データ収集                ----->
                            ProfilerSession.stop()   ----->
                            export_to_tb()           -----> TensorBoard logdir/
                                                            (イベントファイル群)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | ソース | プロファイラのPython APIエントリーポイント。start/stop/Profile/start_serverを提供 |
| _pywrap_profiler.pyi | `tensorflow/python/profiler/internal/_pywrap_profiler.pyi` | 型定義 | C++バインディングの型定義。ProfilerSessionクラスとstart_server関数 |
| tf_export.py | `tensorflow/python/util/tf_export.py` | ソース | tf.profiler.experimental名前空間へのAPI公開用デコレータ |
