# 帳票設計書 14-数値サマリーレポート

## 概要

本ドキュメントは、TensorFlowデバッガCLI（tfdbg）のテンソル数値統計サマリー機能の設計について記述する。`tensor_format.py`の`numeric_summary()`関数を用いてテンソルの数値統計情報（NaN数、Inf数、正負の数、最小値、最大値、平均値、標準偏差等）をデバッグ用にフォーマットしてレポートする帳票の仕様を定義する。

### 本帳票の処理概要

本帳票は、TensorFlowデバッガCLI上でテンソルの数値統計情報を2行のテーブル形式で表示するデバッグ用レポートを提供する。テンソルの健全性を迅速に把握するためのサマリー情報を出力する。

**業務上の目的・背景**：ニューラルネットワークの学習中に発生するNaN（非数）やInf（無限大）はモデルの学習失敗の主要な原因である。テンソルの数値分布を一目で確認できるサマリーレポートは、数値異常の早期発見とデバッグ効率の向上に不可欠である。

**帳票の利用シーン**：tfdbg CLIでのテンソルの検査（`print_tensor`コマンド等）、モデル学習中のNaN/Inf検出、テンソル値の分布確認、数値安定性の診断などの場面で利用される。

**主要な出力内容**：
1. カテゴリ別の要素数カウント：nan, -inf, 負数(-), ゼロ(0), 正数(+), +inf の各カウント
2. 合計要素数（total）
3. 統計情報：min, max, mean, std（NaN/Infを除外した有効値に対して計算）
4. Boolean型テンソルの場合：False/Trueのカウント

**帳票の出力タイミング**：tfdbg CLIの`format_tensor()`関数で`include_numeric_summary=True`を指定した場合、またはCLIコマンドによりテンソルを表示する際に自動的に出力される。

**帳票の利用者**：機械学習エンジニア、モデルデバッグ担当者、数値安定性の検証担当者

## 帳票種別

集計表 / デバッグ用統計レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | tfdbg CLI | ターミナル | print_tensorコマンド等でテンソルを表示した際に付加情報として表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | RichTextLines（CLIテキスト表示） |
| 用紙サイズ | N/A（ターミナル表示） |
| 向き | N/A |
| ファイル名 | N/A（インメモリ表示） |
| 出力方法 | tfdbg CLIターミナルへの直接表示 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

数値サマリーは2行のテーブル形式で表示される。1行目がカテゴリ名、2行目が対応するカウント/値を示す。

```
┌───────────────────────────────────────────────┐
│  Numeric summary:                              │
├───────────────────────────────────────────────┤
│  数値型テンソルの場合:                          │
│  | nan  -inf     -     0     +  +inf | total | │
│  |   0     0   100    50   350     0 |   500 | │
│  |  min   max   mean   std |                   │
│  | -2.5   3.8   0.45  1.23 |                   │
├───────────────────────────────────────────────┤
│  Boolean型テンソルの場合:                       │
│  | False  True | total |                       │
│  |   200   300 |   500 |                       │
└───────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | "Numeric summary:" | セクションラベル | 固定文字列 | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | nan | NaN要素の数 | np.sum(np.isnan(tensor)) | 整数 | 右寄せ（max_common_len） |
| 2 | -inf | 負の無限大の数 | np.sum(np.isneginf(tensor)) | 整数 | 右寄せ |
| 3 | - | 負数の数（-infを除く） | np.sum(tensor < 0 and not isneginf) | 整数 | 右寄せ |
| 4 | 0 | ゼロの数 | np.sum(tensor == 0.0) | 整数 | 右寄せ |
| 5 | + | 正数の数（+infを除く） | np.sum(tensor > 0 and not isposinf) | 整数 | 右寄せ |
| 6 | +inf | 正の無限大の数 | np.sum(np.isposinf(tensor)) | 整数 | 右寄せ |
| 7 | total | 全要素数 | np.size(tensor) | 整数 | 右寄せ |
| 8 | min | 最小値（有効値のみ） | np.min(valid_array) | 浮動小数点 | 右寄せ |
| 9 | max | 最大値（有効値のみ） | np.max(valid_array) | 浮動小数点 | 右寄せ |
| 10 | mean | 平均値（有効値のみ） | np.mean(valid_array) | 浮動小数点 | 右寄せ |
| 11 | std | 標準偏差（有効値のみ） | np.std(valid_array) | 浮動小数点 | 右寄せ |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | 該当なし | サマリーは自己完結する2行テーブルで完結 | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| tensor | numpy ndarray形式のテンソル値 | Yes |
| 対応dtype | int*, float*, complex*, bool | Yes（非対応型の場合はメッセージ出力） |
| include_numeric_summary | format_tensor()のフラグ（Trueで有効） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | カテゴリ順（固定: nan, -inf, -, 0, +, +inf） | 固定順序 |

### 改ページ条件

該当なし

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。numpy ndarrayに対して直接統計計算を行う。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

該当なし

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| nan | np.sum(np.isnan(tensor)) | なし | 行537 |
| -inf | np.sum(np.isneginf(tensor)) | なし | 行538 |
| 負数(-) | np.sum(tensor < 0.0 AND NOT isneginf(tensor)) | なし | 行539-540 |
| ゼロ(0) | np.sum(tensor == 0.0) | なし | 行541 |
| 正数(+) | np.sum(tensor > 0.0 AND NOT isposinf(tensor)) | なし | 行542-543 |
| +inf | np.sum(np.isposinf(tensor)) | なし | 行544 |
| valid_array | tensor[NOT (isinf(tensor) OR isnan(tensor))] | なし | NaN/Infを除外した部分配列（行547-548） |
| min | np.min(valid_array) | なし | 行551 |
| max | np.max(valid_array) | なし | 行552 |
| mean | np.mean(valid_array) | なし | 行553 |
| std | np.std(valid_array) | なし | 行554 |
| False（bool） | np.sum(tensor == 0) | なし | 行558 |
| True（bool） | np.sum(tensor > 0) | なし | 行559 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[numeric_summary tensor] --> B{テンソルが空?}
    B -->|Yes| C[No numeric summary available due to empty tensor]
    B -->|No| D{dtypeチェック}
    D -->|int/float/complex| E[数値カウント計算]
    D -->|bool| F[True/Falseカウント計算]
    D -->|その他| G[No numeric summary available due to tensor dtype]
    E --> H[counts: nan, -inf, -, 0, +, +inf]
    H --> I[_counts_summary出力]
    I --> J[valid_array: NaN/Inf除外]
    J --> K{valid_arrayが空?}
    K -->|No| L[stats: min, max, mean, std]
    K -->|Yes| M[統計情報なし]
    L --> N[_counts_summary出力 skip_zeros=False]
    N --> O[RichTextLinesとして返却]
    M --> O
    F --> P[_counts_summary出力]
    P --> O
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 空テンソル | テンソルがndarrayでないまたはサイズ0 | "No numeric summary available due to empty tensor." | 有効なテンソルを入力する |
| 非対応型 | dtypeがint/float/complex/bool以外 | "No numeric summary available due to tensor dtype: %s." | 対応するdtypeのテンソルを入力する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | テンソルの要素数（数個〜数百万要素） |
| 目標出力時間 | numpy演算のため、ミリ秒〜秒単位（テンソルサイズ依存） |
| 同時出力数上限 | 1（CLI上で1テンソルずつ表示） |

## セキュリティ考慮事項

- デバッグCLIはローカル実行環境での使用を前提としている
- テンソルの生データ値が表示されるため、学習データに個人情報が含まれる場合は画面共有等に注意が必要
- numeric_summary自体はテンソルの統計情報のみを表示するため、生データの露出リスクは低い

## 備考

- _counts_summary内部関数でskip_zeros=Trueの場合、カウント値が0のカテゴリは表示から除外される（デフォルト動作、数値カウント時）
- 統計情報（min, max, mean, std）の計算時はskip_zeros=Falseで全項目を表示
- 表示幅はmax_common_lenで自動調整され、各列が右寄せで揃えられる
- 数値サマリーはformat_tensor()の一部として呼び出され（行142-144）、テンソルの配列表示と併せて出力される
- RichTextLines / RichLineはdebugger_cli_common.pyで定義されたCLI表示用のリッチテキスト構造

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CLI表示用のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debugger_cli_common.py | `tensorflow/python/debug/cli/debugger_cli_common.py` | RichLineクラス（行46-54）：テキストとフォント属性を持つ単一行のリッチテキスト。text（str）とfont_attr_segs（リスト）を保持 |
| 1-2 | debugger_cli_common.py | `tensorflow/python/debug/cli/debugger_cli_common.py` | RichTextLinesクラス：複数のRichLineから構成される表示用テキストブロック。lines, font_attr_segs, annotationsを保持 |

**読解のコツ**: RichLineの`+`演算子（`__add__`）でリッチテキストを連結でき、_pad_string_to_lengthで右寄せ整形を行う。これらの組み合わせで2行テーブルのフォーマットを実現している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tensor_format.py | `tensorflow/python/debug/cli/tensor_format.py` | format_tensor()関数（行67-194）：include_numeric_summary=Trueの場合にnumeric_summary()を呼び出す（行142-144） |
| 2-2 | tensor_format.py | `tensorflow/python/debug/cli/tensor_format.py` | numeric_summary()関数（行483-564）：テンソルの数値統計サマリーを生成する主要関数 |

**主要処理フロー**:
1. **行142-144**: format_tensor内でinclude_numeric_summaryがTrueの場合、"Numeric summary:"ラベルを追加しnumeric_summary()を呼び出す
2. **行530-531**: テンソルが空の場合のガード処理
3. **行533-535**: dtype判定（int/float/complex の場合は数値カウント、boolの場合はTrue/Falseカウント）
4. **行536-544**: 6カテゴリの要素カウントを計算
5. **行545**: _counts_summaryで2行テーブルを生成
6. **行547-548**: valid_array（NaN/Inf除外）を生成
7. **行549-555**: 統計情報（min, max, mean, std）を計算・出力

#### Step 3: テーブルフォーマット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tensor_format.py | `tensorflow/python/debug/cli/tensor_format.py` | _counts_summary()内部関数（行498-528）：(key, value)ペアのリストを2行のRichTextLinesテーブルにフォーマットする |
| 3-2 | tensor_format.py | `tensorflow/python/debug/cli/tensor_format.py` | _pad_string_to_length()（行479-480）：右寄せパディング |

**主要処理フロー**:
- **行500-502**: skip_zeros=Trueの場合、値が0のカウントを除外
- **行503-507**: 各カラムの表示幅（max_common_len）を計算
- **行509-516**: key行とvalue行をRichLineで構築（パイプ区切り）
- **行518-525**: total_count指定時に合計列を追加

### プログラム呼び出し階層図

```
format_tensor(tensor, ..., include_numeric_summary=True)  [行67]
    |
    +-- numeric_summary(tensor)  [行483]
            |
            +-- (dtype判定)
            |
            +-- [int/float/complex の場合]
            |       +-- np.isnan, np.isneginf, np.isposinf 等  [行536-544]
            |       +-- _counts_summary(counts, total_count=np.size)  [行545]
            |       |       +-- _pad_string_to_length()  [行479]
            |       |       +-- RichLine連結
            |       |       +-- rich_text_lines_from_rich_line_list()
            |       +-- valid_array計算  [行547-548]
            |       +-- np.min, np.max, np.mean, np.std  [行550-554]
            |       +-- _counts_summary(stats, skip_zeros=False)  [行555]
            |
            +-- [bool の場合]
                    +-- np.sum(tensor == 0), np.sum(tensor > 0)  [行558-559]
                    +-- _counts_summary(counts, total_count=np.size)  [行561]
```

### データフロー図

```
[入力]                        [処理]                           [出力]

numpy ndarray          -----> dtype判定                  ----->
(tensor)                      int/float/complex/bool

                              [数値型の場合]
                              np.isnan, isneginf等       ----->  counts
                              (nan,-inf,-,0,+,+inf)             (key-value pairs)

                              _counts_summary()          ----->  RichTextLines
                                                                 (2行テーブル)

                              valid_array抽出            ----->
                              (NaN/Inf除外)

                              np.min/max/mean/std        ----->  stats
                                                                 (key-value pairs)

                              _counts_summary()          ----->  RichTextLines
                                                                 (2行テーブル追加)

                              [bool型の場合]
                              True/Falseカウント          ----->  RichTextLines
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tensor_format.py | `tensorflow/python/debug/cli/tensor_format.py` | ソース | テンソルの表示フォーマット。format_tensor, numeric_summary, locate_tensor_element等を提供 |
| debugger_cli_common.py | `tensorflow/python/debug/cli/debugger_cli_common.py` | ソース | CLI表示の基盤。RichLine, RichTextLines, rich_text_lines_from_rich_line_list等を定義 |
| debug_data.py | `tensorflow/python/debug/lib/debug_data.py` | ソース | InconvertibleTensorProto等のデバッグデータ型を定義 |
