# 帳票設計書 7-TensorBoardトレースエクスポート

## 概要

本ドキュメントは、プロファイリングトレースデータをTensorBoard形式でエクスポートする帳票の設計を定義する。

### 本帳票の処理概要

TensorBoardトレースエクスポートは、TensorFlowランタイムの計算グラフ実行トレースおよびプロファイリングデータを収集し、TensorBoardで可視化可能なイベントファイルとして出力する機能である。

**業務上の目的・背景**：モデルの実行パフォーマンスを分析・最適化するために、計算グラフの実行トレースとプロファイリング情報の記録が不可欠である。tf.functionの実行グラフの可視化や、演算ごとの実行時間分析により、ボトルネックの特定とパフォーマンス改善を支援する。

**帳票の利用シーン**：モデルのパフォーマンス最適化時にtf.function内の計算グラフを確認する場面、演算単位での実行時間を分析する場面、GPU/TPUの利用効率を評価する場面で使用される。

**主要な出力内容**：
1. 計算グラフのRunMetadata（partition_graphs, function_graphs）
2. プロファイリングデータ（profiler有効時）
3. 実行トレースのステップ情報
4. デバイス統計情報

**帳票の出力タイミング**：`tf.summary.trace_export()`関数の呼び出し時に出力される。事前に`tf.summary.trace_on()`でトレースを開始しておく必要がある。

**帳票の利用者**：パフォーマンスエンジニア、MLエンジニア、インフラエンジニア

## 帳票種別

イベントログ（TensorBoardサマリー） + プロファイルデータ

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | TensorBoard Graphsダッシュボード | http://localhost:6006/#graphs | `tf.summary.trace_export()` API呼び出し |
| N/A | TensorBoard Profileダッシュボード | http://localhost:6006/#profile | profiler有効時に自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TFEventファイル + プロファイルデータ |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | イベントファイル: `events.out.tfevents.*`、プロファイル: profiler_outdirに出力 |
| 出力方法 | SummaryWriter経由 + profiler API |
| 文字コード | N/A（バイナリ形式） |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

トレースデータは2種類の形式で出力される。計算グラフ情報はRunMetadataとしてイベントファイルに記録され、プロファイリングデータはprofiler_outdirに出力される。

```
[出力構造]
+-- logdir/
|   +-- events.out.tfevents.* (RunMetadata含む)
+-- profiler_outdir/
    +-- *.profile (プロファイルデータ)
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | タグ名 | トレースの識別名 | `name`引数 | 文字列 |
| 2 | ステップ | エクスポート時のステップ番号 | `step`引数 | int64 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | RunMetadata | 実行メタデータ（グラフ、デバイス統計） | `context.context().export_run_metadata()` | Protocol Buffers | N/A |
| 2 | partition_graphs | パーティショングラフ | RunMetadata.partition_graphs | GraphDef | N/A |
| 3 | function_graphs | 関数グラフ | RunMetadata.function_graphs | FunctionGraphs | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | SummaryMetadata | プラグイン情報 | 自動生成 | plugin_name="graph_run_metadata" or "graph_run_metadata_graph" |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| trace_on()呼び出し済み | トレースが事前に開始されていること | Yes |
| Eagerモード | Eager実行モードであること | Yes |
| tf.function外 | tf.function内からは呼び出せない | Yes |
| デフォルトSummaryWriter | 設定済みであること（グラフ出力時） | Yes |
| profiler_outdir | profiler有効時はtrace_on()で指定 | profiler使用時Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | N/A | N/A（単一エクスポート） |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| RunMetadata | `context.context().export_run_metadata()` | N/A | ランタイムから収集 |
| SummaryMetadata | plugin_name="graph_run_metadata" (profiler有効時) または "graph_run_metadata_graph" (graph only時) | N/A | summary_ops_v2.py 行1289,1328 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[tf.summary.trace_export呼び出し] --> B{tf.function内?}
    B -->|Yes| C[警告ログ出力・返却]
    B -->|No| D{Eagerモード?}
    D -->|No| E[警告ログ出力・返却]
    D -->|Yes| F{trace_on済み?}
    F -->|No| G[ValueError送出]
    F -->|Yes| H[RunMetadataエクスポート]
    H --> I{graph && !profiler?}
    I -->|Yes| J[run_metadata_graphs - グラフのみ記録]
    I -->|No| K[run_metadata - 全メタデータ記録]
    J --> L{profiler有効?}
    K --> L
    L -->|Yes| M[_profiler.stop - プロファイラ停止]
    L -->|No| N[trace_off呼び出し]
    M --> N
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ValueError | trace_on()未呼び出し | `Must enable trace before export through tf.summary.trace_on.` | trace_on()を事前に呼び出す |
| 警告 | tf.function内から呼び出し | `Cannot export trace inside a tf.function.` | tf.function外から呼び出す |
| 警告 | Eagerモードでない | `Can only export trace while executing eagerly.` | Eager実行モードに切り替える |
| ValueError | stepが未設定 | `No step set.` | step引数を指定する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1回のエクスポートで1セットのRunMetadata |
| 目標出力時間 | 数百ミリ秒〜数秒（グラフ規模に依存） |
| 同時出力数上限 | 1（グローバルトレースコンテキストは1つ） |

## セキュリティ考慮事項

- 計算グラフにはモデルアーキテクチャの詳細が含まれるため、知的財産保護の観点からアクセス制御が必要
- プロファイリングデータにはハードウェア構成情報が含まれる場合がある

## 備考

- トレースコンテキストはグローバルに1つのみ（`_current_trace_context`、summary_ops_v2.py 行1351）
- `_current_trace_context_lock`によりスレッドセーフに管理（行1350）
- profiler_outdirはtrace_on()で指定する方式に変更された（trace_export()での指定は無視される、行1455-1459）
- trace_off()はプロファイラのstop失敗を安全にキャッチする（行1480-1484）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.proto | `tensorflow/core/protobuf/config.proto` | RunMetadataの構造（partition_graphs, function_graphs, step_stats） |
| 1-2 | summary.proto | `tensorflow/core/framework/summary.proto` | SummaryMetadata.PluginData構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | summary_ops_v2.py | `tensorflow/python/ops/summary_ops_v2.py` | `trace_export()`関数（行1410-1462）: トレースデータのエクスポート処理 |

**主要処理フロー**:
1. **行1431-1432**: step値の検証
2. **行1434-1439**: tf.function内/非Eagerモードのチェック
3. **行1441-1445**: トレースコンテキストの存在確認（ロック付き）
4. **行1447**: RunMetadataのエクスポート
5. **行1449-1452**: graph/profiler設定に応じてrun_metadata_graphsまたはrun_metadataを呼び出し
6. **行1454-1460**: profiler停止（profiler_outdirの警告含む）
7. **行1462**: trace_off()呼び出し

#### Step 3: トレース制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | summary_ops_v2.py | `tensorflow/python/ops/summary_ops_v2.py` | `trace_on()`（行1354-1405）、`trace_off()`（行1465-1484）、`_TraceContext`（行1349） |

**主要処理フロー**:
- **行1349**: _TraceContextはnamedtuple(graph, profiler)
- **行1354-1405**: trace_on() - グラフ収集有効化/プロファイラ起動
- **行1465-1484**: trace_off() - run_metadata無効化/プロファイラ停止

#### Step 4: RunMetadata記録関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | summary_ops_v2.py | `tensorflow/python/ops/summary_ops_v2.py` | `run_metadata()`（行1264-1303）、`run_metadata_graphs()`（行1306-1346） |

### プログラム呼び出し階層図

```
tf.summary.trace_export() [行1410]
    |
    +-- _choose_step() [行1227]
    |
    +-- context.context().export_run_metadata() [行1447]
    |
    +-- run_metadata_graphs() [行1306] (graph && !profiler)
    |       |
    |       +-- summary_scope() [行700]
    |       +-- write() [行741]
    |
    +-- run_metadata() [行1264] (profiler enabled)
    |       |
    |       +-- summary_scope() [行700]
    |       +-- write() [行741]
    |
    +-- _profiler.stop() (profiler enabled)
    |
    +-- trace_off() [行1465]
            |
            +-- context.context().disable_run_metadata()
            +-- _profiler.stop() (安全にキャッチ)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

trace_on(graph, profiler)
        |
        v
TF Runtime -------> context.export_run_metadata()
        |                     |
        |                     +-- RunMetadata
        |                     |
        v                     v
trace_export(name, step) --> run_metadata() / run_metadata_graphs()
                                    |
                                    +-- write() --> events.out.tfevents.*
                                    |
_profiler -----> profiler.stop() --> profiler_outdir/*.profile
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| summary_ops_v2.py | `tensorflow/python/ops/summary_ops_v2.py` | ソース | trace_on/trace_export/trace_off定義 |
| profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | ソース | プロファイラの開始・停止 |
| config.proto | `tensorflow/core/protobuf/config.proto` | 定義 | RunMetadata Protocol Buffers定義 |
| gen_summary_ops.py | `tensorflow/python/ops/gen_summary_ops.py` | 生成コード | write_summaryバインディング |
