# 帳票設計書 9-量子化レポート（StableHLO）

## 概要

本ドキュメントは、StableHLO量子化処理の結果レポートを出力する帳票の設計を定義する。量子化された演算の一覧と結果を含む。

### 本帳票の処理概要

量子化レポート（StableHLO）は、StableHLO量子化パイプラインの実行結果を人間および機械可読な形式で出力する帳票機能である。量子化された演算と量子化されなかった演算の一覧を、QuantizationResults Protocol Buffers形式で出力する。

**業務上の目的・背景**：モデルの量子化はモバイル・エッジデバイスへのデプロイにおいて重要な最適化手法である。量子化プロセスの結果、どの演算が正常に量子化されたか、どの演算が量子化されなかったか（およびその理由）を把握することは、量子化品質の評価とデバッグに不可欠である。

**帳票の利用シーン**：モデル量子化後の品質評価、量子化対象演算の確認、量子化パイプラインのデバッグ、量子化設定の調整時の参考資料として使用される。

**主要な出力内容**：
1. 量子化されたユニット（Quantizable Unit）の名前
2. 各ユニットの量子化メソッド（Method）
3. 量子化されなかったユニット（NoQuantization）の識別
4. レポートテキスト（人間可読形式）

**帳票の出力タイミング**：StableHLO量子化パイプライン完了後、`QuantizationReport`クラスのコンストラクタまたは`Print()`/`Save()`メソッド呼び出し時に出力される。

**帳票の利用者**：MLエンジニア、量子化専門家、モデルデプロイ担当者

## 帳票種別

量子化結果レポート（テキスト / Protocol Buffers textproto）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | 量子化パイプライン実行 | N/A（プログラム実行） | QuantizationReport::Print() or Save() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（textproto形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | Save()呼び出し時の`file_path`引数で指定 |
| 出力方法 | Print(): 標準出力（llvm::outs）、Save(): ファイル出力 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

レポートはQuantizationResults Protocol Buffersのtextproto表現をヘッダー・フッターで囲んだテキスト形式で出力される。

```
[テキスト出力構造]
===== Quantization Report =====

results {
  quantizable_unit {
    name: "composite_xxx"
  }
  method {
    <量子化メソッド詳細>
  }
}
results {
  quantizable_unit {
    name: "composite_yyy"
  }
  method {
    no_quantization {}
  }
}

===== Quantization Report End =====
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | レポートヘッダー | "===== Quantization Report =====" | 固定文字列（report.cc 行158） | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | quantizable_unit.name | 量子化ユニットの名前 | ModuleOp内のCallOp/XlaCallModuleOp | composite_プレフィックス付き文字列 | N/A |
| 2 | method | 量子化メソッド | kQuantizationMethodAttr属性 | textproto形式 | N/A |
| 3 | no_quantization | 未量子化を示すフラグ | XlaCallModuleOpに残存する場合 | no_quantization {} | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | レポートフッター | "===== Quantization Report End =====" | 固定文字列（report.cc 行159） | テキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ModuleOp | 量子化処理済みのMLIR ModuleOp | Yes |
| 量子化パイプライン完了 | StableHLO量子化パスが完了していること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ModuleOp内のwalk順序 | MLIR IR内の出現順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| composite関数名 | `kCompositeFuncPrefix + quantized_func_name.rsplit(kQuantizedFuncPrefix).second` | N/A | report.cc 行47-51 |
| 量子化ユニット判定（CallOp） | callee名がkQuantizedFuncPrefixで始まるか | N/A | report.cc 行61 |
| 非量子化ユニット判定（XlaCallModuleOp） | _original_entry_function属性がkCompositeFuncPrefixで始まるか | N/A | report.cc 行95 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[量子化パイプライン完了] --> B[QuantizationReport コンストラクタ]
    B --> C[CollectResultsFromModuleOp]
    C --> D[PopulateQuantizedResults - CallOpをwalk]
    D --> E[PopulateNonQuantizedResults - XlaCallModuleOpをwalk]
    E --> F{出力方法}
    F -->|Print| G[ToString -> llvm::outs]
    F -->|Save| H[TextFormat::PrintToString -> WriteStringToFile]
    G --> I[終了]
    H --> I
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| emitError | kQuantizationMethodAttrの取得に失敗 | `Failed to get quantization method: {status}` | 量子化パイプラインの設定を確認 |
| absl::Status | Save()でファイル書き込み失敗 | WriteStringToFileのエラーステータス | 出力パスの権限を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 量子化ユニット数: 数十〜数百 |
| 目標出力時間 | ミリ秒以下（テキストシリアライズ） |
| 同時出力数上限 | 1（量子化パイプラインごとに1レポート） |

## セキュリティ考慮事項

- レポートにはモデルの演算構造情報が含まれるため、モデルの知的財産を保護する場合はアクセス制御が必要
- Save()のファイルパスはユーザー指定のため、パストラバーサルに注意

## 備考

- QuantizationReportはデフォルトコンストラクタでも作成可能で、後から`AddQuantizationResult()`で結果を追加することも可能（report.h 行33, 40-41）
- 量子化された演算は`func::CallOp`として表現され、calleeのプレフィックスが`quantized_`となる
- 量子化されなかった演算は`TF::XlaCallModuleOp`として残り、`_original_entry_function`属性に元の`composite_`プレフィックス付き名前を保持する
- ToString()はヘッダー・フッター付き人間可読テキストを返し、Save()はtextproto形式（ヘッダー・フッターなし）でファイルに保存する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | quantization_config.proto | `tensorflow/compiler/mlir/quantization/stablehlo/quantization_config.proto` | QuantizationResults, QuantizationResult, QuantizableUnit, Methodの定義 |

**読解のコツ**: QuantizationResultは「量子化ユニット名」と「量子化メソッド」のペア。Methodにはno_quantization（未量子化）を含む複数の量子化方式が定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | report.h | `tensorflow/compiler/mlir/quantization/stablehlo/cc/report.h` | QuantizationReportクラスのインターフェース（コンストラクタ、AddQuantizationResult、GetQuantizationResults、ToString、Print、Save） |

**主要処理フロー**:
1. **行37**: コンストラクタがModuleOpからQuantizationResultsを収集
2. **行40-41**: AddQuantizationResultで結果を追加可能
3. **行49**: ToString()で人間可読テキスト取得
4. **行53**: Print()でstdoutに出力
5. **行58**: Save()でファイルに保存

#### Step 3: 収集ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | report.cc | `tensorflow/compiler/mlir/quantization/stablehlo/cc/report.cc` | CollectResultsFromModuleOp（行140-148）、PopulateQuantizedResults（行109-118）、PopulateNonQuantizedResults（行123-133） |

**主要処理フロー**:
- **行109-118**: ModuleOp内のCallOpをwalkし、quantized_プレフィックス付きcalleeをQuantizationResultとして収集
- **行123-133**: ModuleOp内のXlaCallModuleOpをwalkし、composite_プレフィックス付きの残存OPをNoQuantizationとして収集
- **行140-148**: 上記2つの関数を順番に呼び出して結果を統合

#### Step 4: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | report.cc | `tensorflow/compiler/mlir/quantization/stablehlo/cc/report.cc` | GetCompositeFunctionName（行47-51）、GetQuantizationResult（CallOp版 行59-77、XlaCallModuleOp版 行85-104） |

### プログラム呼び出し階層図

```
QuantizationReport(module_op) [行137]
    |
    +-- CollectResultsFromModuleOp(module_op) [行140]
            |
            +-- PopulateQuantizedResults(module_op, results) [行109]
            |       |
            |       +-- module_op.walk<func::CallOp>()
            |       +-- GetQuantizationResult(call_op) [行59]
            |               |
            |               +-- GetCompositeFunctionName() [行47]
            |               +-- GetQuantizationMethod(call_op)
            |
            +-- PopulateNonQuantizedResults(module_op, results) [行123]
                    |
                    +-- module_op.walk<TF::XlaCallModuleOp>()
                    +-- GetQuantizationResult(xla_call_module_op) [行85]

QuantizationReport::ToString() [行154]
    +-- TextFormat::PrintToString(quantization_results_)
    +-- absl::StrCat("===== Quantization Report =====\n\n", ...)

QuantizationReport::Save(file_path) [行167]
    +-- TextFormat::PrintToString(GetQuantizationResults())
    +-- WriteStringToFile(file_path, results_str)
```

### データフロー図

```
[入力]                             [処理]                              [出力]

ModuleOp (量子化済み) -------> QuantizationReport()
                                    |
                                    +-- walk<CallOp> -----> 量子化済みResult
                                    |
                                    +-- walk<XlaCallModuleOp> -> 未量子化Result
                                    |
                                    +-- QuantizationResults proto
                                            |
                                            +-- ToString() --> stdout (テキスト)
                                            |
                                            +-- Save() -----> file (textproto)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| report.h | `tensorflow/compiler/mlir/quantization/stablehlo/cc/report.h` | ヘッダー | QuantizationReportクラス宣言 |
| report.cc | `tensorflow/compiler/mlir/quantization/stablehlo/cc/report.cc` | ソース | QuantizationReportクラス実装 |
| quantization_config.proto | `tensorflow/compiler/mlir/quantization/stablehlo/quantization_config.proto` | 定義 | QuantizationResults proto定義 |
| io.h | `tensorflow/compiler/mlir/quantization/stablehlo/cc/io.h` | ヘッダー | WriteStringToFile関数 |
| lift_as_function_call.h | `tensorflow/compiler/mlir/quantization/common/lift_as_function_call.h` | ヘッダー | kCompositeFuncPrefix, kQuantizedFuncPrefix定数定義 |
