---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：1-TFLite変換レポート（HTML）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：コードからの直接的な根拠なし
  2. **Bootstrap CDN依存**：テンプレートHTML確認が必要
  3. **セキュリティ考慮事項の網羅性**：追加リスクの有無を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tensorflow/lite/toco/logging/gen_html.py` 行1-266
- E-02: `tensorflow/lite/toco/logging/toco_conversion_log.proto` 行1-51
- E-03: `tensorflow/lite/toco/logging/template.html` 行1-50（先頭部分）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行2

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLGeneratorクラスがテンプレートのプレースホルダを置換してHTML帳票を生成する | E-01 (行83-201) | ○ |
| C-02 | gen_conversion_log_htmlが帳票生成のエントリーポイントである | E-01 (行204-265) | ○ |
| C-03 | 変換ステータスはtoco_err_logの有無で判定される | E-01 (行143-145) | ○ |
| C-04 | Built-in Ops数はbuilt_in_opsのvalues合計で算出される | E-01 (行150-151) | ○ |
| C-05 | Select Ops数はselect_opsのvalues合計で算出される | E-01 (行152-153) | ○ |
| C-06 | Custom Ops数はcustom_opsのvalues合計で算出される | E-01 (行154-155) | ○ |
| C-07 | get_input_type_from_signatureがop_signatureを解析して入力テンソル型を返す | E-01 (行37-71) | ○ |
| C-08 | get_operator_typeがBUILT-IN/CUSTOM OP/SELECT OPを判定する | E-01 (行74-80) | ○ |
| C-09 | html_escapeがXSS防止のためHTMLエスケープ処理を行う | E-01 (行24-34) | ○ |
| C-10 | 出力ファイル名はtoco_conversion_summary.htmlである | E-01 (行246) | ○ |
| C-11 | TocoConversionLogはprotoで定義されたメッセージである | E-02 (行21-50) | ○ |
| C-12 | op_listはrepeated string型である | E-02 (行23) | ○ |
| C-13 | built_in_opsはmap<string,int32>型である | E-02 (行26) | ○ |
| C-14 | テンプレートHTMLはBootstrapを使用している | E-03 (行12) | ○ |
| C-15 | マーカー置換失敗時にRuntimeErrorが発生する | E-01 (行197-198) | ○ |
| C-16 | 必要ファイルが存在しない場合IOErrorが発生する | E-01 (行99-100, 223-242) | ○ |
| C-17 | 変換前後のDOTファイルを読み込んでHTMLに埋め込む | E-01 (行182-183, 257-260) | ○ |
| C-18 | toco_err_logsはオプショナルなstringフィールドである | E-02 (行49) | ○ |
| C-19 | 帳票の出力タイミングはTFLiteコンバータ変換完了直後である | E-04 | ○ |
| C-20 | 想定オペレータ数は数十〜数千である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20のパフォーマンス要件の想定データ件数は、コードからの直接的な根拠がない。一般的なTFLiteモデルの規模から推定した値である。
  - 候補：TFLiteモデルのベンチマーク結果 / TFLite公式ドキュメント / 実運用事例

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 帳票レイアウトおよびデータ項目の記載はソースコードから正確に抽出されている
- 1: 中リスク - パフォーマンス要件は実測値ではなく推定値
- 0: 低リスク - セキュリティ考慮事項のHTMLエスケープ処理はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLテンプレート（template.html）のマーカー一覧が帳票設計書と一致しているか
- [ ] パフォーマンス要件の数値が実運用環境に適合しているか
- [ ] セキュリティ考慮事項に追加すべき項目がないか
