---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-プロファイラレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **TensorBoard上の表示構成**：TensorBoard Profileプラグインの実際のUIレイアウトはソースコード外で定義されており、本設計書の記述は一般的な説明
  2. **export_to_tbの出力ファイル形式詳細**：C++実装の内部で生成されるファイル構造の詳細が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/profiler/profiler_v2.py` - プロファイラAPIの主要実装
- E-02: `tensorflow/python/profiler/internal/_pywrap_profiler.pyi` - ProfilerSessionのC++バインディング型定義
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（No.11の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロファイラはProgrammatic ModeとSampling Modeの2つのモードを持つ | E-01（行18-24 docstring） | ○ |
| C-02 | ProfilerOptionsはhost_tracer_level, python_tracer_level, device_tracer_level, delay_msの4フィールドを持つ | E-01（行47-49） | ○ |
| C-03 | host_tracer_levelのデフォルト値は2 | E-01（行71） | ○ |
| C-04 | python_tracer_levelのデフォルト値は0 | E-01（行72） | ○ |
| C-05 | device_tracer_levelのデフォルト値は1 | E-01（行73） | ○ |
| C-06 | delay_msのデフォルト値はNone | E-01（行74） | ○ |
| C-07 | start()はlogdirを必須引数として受け取る | E-01（行81） | ○ |
| C-08 | 既にプロファイラが実行中の場合AlreadyExistsErrorが発生する | E-01（行109-111） | ○ |
| C-09 | stop()のsave引数のデフォルトはTrue | E-01（行130） | ○ |
| C-10 | save=Trueの場合export_to_tb()が呼ばれる | E-01（行147-149） | ○ |
| C-11 | stop()時にアクティブセッションがない場合UnavailableErrorが発生する | E-01（行143-146） | ○ |
| C-12 | _profiler_lockによるスレッドロックで排他制御が実装されている | E-01（行42, 108, 142） | ○ |
| C-13 | Profileクラスはコンテキストマネージャとして動作する | E-01（行183-212） | ○ |
| C-14 | start_server()はポート番号を引数として受け取る | E-01（行169） | ○ |
| C-15 | warmup()関数でプロファイリングコンテキストを事前準備できる | E-01（行156-165） | ○ |
| C-16 | optionsはnamedtupleからdict変換して渡される | E-01（行116） | ○ |
| C-17 | TensorBoard上ではOverview Page, Trace Viewer, Op Profile, Memory Profileの構成で表示される | **根拠なし** | △ |
| C-18 | export_to_tbの出力はprotobuf形式のイベントファイル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: TensorBoard Profileプラグインの画面構成はTensorBoardの実装に依存しており、本リポジトリのコードからは確認できない
  - 候補：TensorBoard Profileプラグインのソースコード / TensorBoard公式ドキュメント
- C-18: export_to_tb()の内部実装はC++側にあり、Python側の型定義（pyi）からはメソッドシグネチャのみ確認可能
  - 候補：tensorflow/core/profiler/ 配下のC++ソース / profiler_service.proto

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様（start/stop/Profile/ProfilerOptions）はソースコードで十分に確認済み
- 1: 中リスク - 出力ファイル形式の詳細がC++実装に依存しているため、完全な仕様把握には追加調査が必要
- 1: 中リスク - TensorBoard上での可視化レイアウトはTensorBoard側のプラグイン実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ProfilerOptionsの4つのフィールドとデフォルト値がソースコードと一致しているか確認
- [ ] start/stop関数のエラーケースがソースコードの例外処理と整合しているか確認
- [ ] TensorBoard Profileプラグインの実際の画面構成を最新バージョンで確認
- [ ] export_to_tb()の出力ファイル形式をC++実装またはドキュメントで確認
