---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-pprofプロファイルレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **profile_pb2のインポートパス**：`from proto import profile_pb2`のインポートパスが実際のビルド環境と一致するか要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/profiler/pprof_profiler.py` - pprofプロファイラの全実装
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（No.12の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProfileDatumはnode_exec_stats, op_type, tracebackの3フィールドを持つ | E-01（行55-56） | ○ |
| C-02 | StringTableの最初のエントリは空文字列 | E-01（行64） | ○ |
| C-03 | Functionsのキーは(file_path, function_name, start_line_number)のタプル | E-01（行125） | ○ |
| C-04 | Locationsのキーは(file_path, called_function_name, line_number)のタプル | E-01（行179） | ○ |
| C-05 | Samplesはcount, all_time, op_timeの3値を保持 | E-01（行232-233） | ○ |
| C-06 | op_timeはop_end_rel_micros - op_start_rel_microsで計算 | E-01（行244-246） | ○ |
| C-07 | all_timeはall_end_rel_microsの累積加算 | E-01（行243） | ○ |
| C-08 | _SOURCEと_SINKノードはプロファイルから除外される | E-01（行374） | ○ |
| C-09 | apply_opより前のスタックフレームは除外される | E-01（行331-334） | ○ |
| C-10 | デバイス名の/と:は_に変換される | E-01（行433-434） | ○ |
| C-11 | 出力ファイルはgzip圧縮される | E-01（行437） | ○ |
| C-12 | ファイル名にタイムスタンプが付与される（%Y%m%d%H%M%S形式） | E-01（行423） | ○ |
| C-13 | output_dirがNoneの場合は標準出力に表示 | E-01（行429-431） | ○ |
| C-14 | output_dirが存在しない場合は自動作成される | E-01（行421-422） | ○ |
| C-15 | sample_typeはcount, all_time, op_timeの3種類 | E-01（行341-352） | ○ |
| C-16 | sample_typeの単位はcount, nanoseconds, nanoseconds | E-01（行344, 348, 352） | ○ |
| C-17 | サンプルにはnode_nameとop_typeのラベルが付与される | E-01（行236-240） | ○ |
| C-18 | コメントにデバイス説明が記録される | E-01（行289-294） | ○ |
| C-19 | データ不足時に警告メッセージが出力される | E-01（行283-285） | ○ |
| C-20 | profile_pb2はprotoパッケージからインポートされる | **根拠なし（ビルド環境依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: `from proto import profile_pb2`のインポートパスはBazelビルド環境に依存しており、実際のパスがビルドルールで定義されている可能性がある
  - 候補：BUILD / BUILD.bazel ファイル / proto/BUILD 定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロファイルデータの構造と計算式はソースコードで完全に確認済み
- 0: 低リスク - ファイル出力仕様（gzip圧縮、命名規則）はソースコードで確認済み
- 1: 中リスク - profile_pb2のインポートパスの正確性はビルド環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] ProfileDatumの3フィールドの説明がソースコードと整合しているか確認
- [ ] Samplesの3つのvalue（count, all_time, op_time）の計算式が正確か確認
- [ ] ファイル名生成のタイムスタンプ形式とデバイス名変換ルールを確認
- [ ] profile_pb2のインポートパスがビルド環境で正しく解決されるか確認
