---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-数値サマリーレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **CLIコマンドからの呼び出しパス**：format_tensorがどのCLIコマンドから呼び出されるかの具体的なコマンドハンドラは本分析では未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/debug/cli/tensor_format.py` - numeric_summary及びformat_tensorの主要実装
- E-02: `tensorflow/python/debug/cli/debugger_cli_common.py` - RichLine/RichTextLinesの基盤実装
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（No.14の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | numeric_summaryはnumpy ndarrayを入力として受け取る | E-01（行483-490） | ○ |
| C-02 | 対応dtypeはint/float/complex/bool | E-01（行533-535, 557） | ○ |
| C-03 | nanカウントはnp.sum(np.isnan(tensor))で計算 | E-01（行537） | ○ |
| C-04 | -infカウントはnp.sum(np.isneginf(tensor))で計算 | E-01（行538） | ○ |
| C-05 | 負数カウントはtensor < 0 AND NOT isneginfで計算 | E-01（行539-540） | ○ |
| C-06 | ゼロカウントはnp.sum(tensor == 0.0)で計算 | E-01（行541） | ○ |
| C-07 | 正数カウントはtensor > 0 AND NOT isposinfで計算 | E-01（行542-543） | ○ |
| C-08 | +infカウントはnp.sum(np.isposinf(tensor))で計算 | E-01（行544） | ○ |
| C-09 | valid_arrayはNaN/Inf除外した部分配列 | E-01（行547-548） | ○ |
| C-10 | 統計情報はmin, max, mean, stdの4項目 | E-01（行550-554） | ○ |
| C-11 | Boolean型の場合はFalse/Trueの2カテゴリでカウント | E-01（行557-561） | ○ |
| C-12 | 空テンソルの場合は「No numeric summary available due to empty tensor.」を返す | E-01（行530-532） | ○ |
| C-13 | 非対応dtype時は「No numeric summary available due to tensor dtype: %s.」を返す | E-01（行563-564） | ○ |
| C-14 | _counts_summaryはskip_zeros=Trueでゼロカウントを除外する | E-01（行500-502） | ○ |
| C-15 | 各列は右寄せでmax_common_lenに合わせてパディングされる | E-01（行503-514） | ○ |
| C-16 | total_count指定時に合計列が追加される | E-01（行518-525） | ○ |
| C-17 | format_tensorのinclude_numeric_summary=Trueで呼び出される | E-01（行142-144） | ○ |
| C-18 | 出力はRichTextLines型で返却される | E-01（行527-528, 531, 561） | ○ |
| C-19 | tfdbg CLIのprint_tensorコマンドから呼び出される | **根拠なし（コマンドハンドラ未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: format_tensorがどのCLIコマンドハンドラから呼び出されるかの具体的なコードパスは、本分析対象のファイル群では確認できていない
  - 候補：tensorflow/python/debug/cli/ 配下の他のCLIハンドラファイル（analyzer_cli.py等）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - numeric_summaryの計算ロジック（6カテゴリ+統計情報）はソースコードで完全に確認済み
- 0: 低リスク - 出力フォーマット（_counts_summary, パディング）はソースコードで確認済み
- 1: 中リスク - CLIからの呼び出しパスの正確性は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] numeric_summaryの6つのカテゴリカウントの計算式がソースコードと一致しているか確認
- [ ] valid_arrayの生成ロジック（NaN/Inf除外）が正確か確認
- [ ] _counts_summaryのskip_zeros挙動（数値カウント時True、統計情報時False）を確認
- [ ] tfdbg CLIからformat_tensor/numeric_summaryが呼び出される具体的なコマンドパスを確認
