---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 145
  claims_with_evidence: 139
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：139 / 145、根拠なし：6
- 優先レビュー（高）
  1. **C-130 プロジェクト設定（Configure）**：configure.pyの機能範囲の詳細が未確認
  2. **C-143 セキュリティポリシー**：ポリシー文書であり機能としての分類が適切か要確認
  3. **C-144 継続的インテグレーション**：CI設定の詳細内容が未確認
  4. **C-145 開発者ツール**：tools/配下の具体的機能の詳細が未確認
  5. **C-138〜C-140 多言語バインディング**：Go/Java/JSバインディングの現在のメンテナンス状況が未確認
  6. **C-74 DTensor API**：dtensor/python/配下のファイル構成の詳細確認が不十分

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/ops/array_ops.py` - テンソル配列操作のPython API
- E-02: `tensorflow/core/ops/array_ops.cc` - テンソル配列操作のOp登録
- E-03: `tensorflow/python/ops/math_ops.py` - 数学演算のPython API（ファイル存在確認済み）
- E-04: `tensorflow/core/ops/math_ops.cc` - 数学演算のOp登録
- E-05: `tensorflow/core/ops/linalg_ops.cc` - 線形代数演算のOp登録
- E-06: `tensorflow/python/ops/bitwise_ops.py` - ビット演算のPython API
- E-07: `tensorflow/core/ops/bitwise_ops.cc` - ビット演算のOp登録
- E-08: `tensorflow/core/ops/string_ops.cc` - 文字列操作のOp登録
- E-09: `tensorflow/python/ops/control_flow_ops.py` - 制御フローのPython API
- E-10: `tensorflow/core/ops/control_flow_ops.cc` - 制御フローのOp登録
- E-11: `tensorflow/core/ops/resource_variable_ops.cc` - リソース変数のOp登録
- E-12: `tensorflow/core/ops/state_ops.cc` - 状態操作のOp登録
- E-13: `tensorflow/python/ops/data_flow_ops.py` - データフロー操作のPython API
- E-14: `tensorflow/core/ops/data_flow_ops.cc` - データフロー操作のOp登録
- E-15: `tensorflow/core/ops/functional_ops.cc` - 関数操作のOp登録
- E-16: `tensorflow/python/framework/constant_op.py` - 定数生成のPython API
- E-17: `tensorflow/python/framework/device_spec.py` - デバイス仕様のPython API
- E-18: `tensorflow/python/framework/config.py` - 設定管理のPython API
- E-19: `tensorflow/core/ops/nn_ops.cc` - ニューラルネットワーク操作のOp登録
- E-20: `tensorflow/python/keras/layers/convolutional.py` - 畳み込み層の実装
- E-21: `tensorflow/python/keras/layers/pooling.py` - プーリング層の実装
- E-22: `tensorflow/python/keras/activations.py` - 活性化関数の実装
- E-23: `tensorflow/python/keras/layers/advanced_activations.py` - 高度な活性化関数
- E-24: `tensorflow/core/kernels/batch_norm_op.cc` - バッチ正規化カーネル
- E-25: `tensorflow/python/keras/layers/embeddings.py` - 埋め込み層の実装
- E-26: `tensorflow/python/keras/layers/recurrent.py` - リカレント層の実装
- E-27: `tensorflow/core/ops/rnn_ops.cc` - RNN操作のOp登録
- E-28: `tensorflow/python/keras/layers/dense_attention.py` - 注意機構の実装
- E-29: `tensorflow/python/keras/layers/merge.py` - 結合層の実装
- E-30: `tensorflow/python/keras/layers/core.py` - コア層の実装
- E-31: `tensorflow/python/ops/ctc_ops.py` - CTC操作のPython API
- E-32: `tensorflow/core/ops/ctc_ops.cc` - CTC操作のOp登録
- E-33: `tensorflow/core/ops/cudnn_rnn_ops.cc` - cuDNN RNN操作のOp登録
- E-34: `tensorflow/python/keras/optimizer_v2/gradient_descent.py` - SGDオプティマイザ
- E-35: `tensorflow/python/keras/optimizer_v2/adam.py` - Adamオプティマイザ
- E-36: `tensorflow/python/keras/optimizer_v2/adagrad.py` - Adagradオプティマイザ
- E-37: `tensorflow/python/keras/optimizer_v2/rmsprop.py` - RMSPropオプティマイザ
- E-38: `tensorflow/python/keras/optimizer_v2/adadelta.py` - Adadeltaオプティマイザ
- E-39: `tensorflow/python/keras/optimizer_v2/adamax.py` - Adamaxオプティマイザ
- E-40: `tensorflow/python/keras/optimizer_v2/nadam.py` - Nadamオプティマイザ
- E-41: `tensorflow/python/keras/optimizer_v2/ftrl.py` - FTRLオプティマイザ
- E-42: `tensorflow/python/keras/optimizer_v2/learning_rate_schedule.py` - 学習率スケジュール
- E-43: `tensorflow/core/ops/training_ops.cc` - 訓練操作のOp登録
- E-44: `tensorflow/python/eager/backprop.py` - 自動微分の実装
- E-45: `tensorflow/python/eager/forwardprop.py` - 前方自動微分の実装
- E-46: `tensorflow/python/ops/custom_gradient.py` - カスタム勾配の実装
- E-47: `tensorflow/python/keras/losses.py` - 損失関数の実装
- E-48: `tensorflow/python/keras/metrics.py` - 評価指標の実装
- E-49: `tensorflow/python/keras/regularizers.py` - 正則化の実装
- E-50: `tensorflow/python/keras/constraints.py` - 制約の実装
- E-51: `tensorflow/python/data/ops/dataset_ops.py` - Dataset APIの実装
- E-52: `tensorflow/python/data/ops/from_tensor_slices_op.py` - テンソルからのDataset生成
- E-53: `tensorflow/python/data/ops/from_generator_op.py` - ジェネレータからのDataset生成
- E-54: `tensorflow/python/data/ops/cache_op.py` - キャッシュ操作
- E-55: `tensorflow/python/data/ops/concatenate_op.py` - データセット結合
- E-56: `tensorflow/python/data/ops/interleave_op.py` - インターリーブ操作
- E-57: `tensorflow/core/ops/experimental_dataset_ops.cc` - 実験的データセット操作
- E-58: `tensorflow/core/ops/parsing_ops.cc` - パース操作のOp登録
- E-59: `tensorflow/core/ops/io_ops.cc` - IO操作のOp登録
- E-60: `tensorflow/core/ops/filesystem_ops.cc` - ファイルシステム操作のOp登録
- E-61: `tensorflow/core/ops/image_ops.cc` - 画像操作のOp登録
- E-62: `tensorflow/core/ops/audio_ops.cc` - 音声操作のOp登録
- E-63: `tensorflow/core/ops/spectral_ops.cc` - スペクトル操作のOp登録
- E-64: `tensorflow/core/ops/random_ops.cc` - ステートフル乱数のOp登録
- E-65: `tensorflow/core/ops/stateful_random_ops.cc` - ステートフル乱数（V2）のOp登録
- E-66: `tensorflow/core/ops/stateless_random_ops.cc` - ステートレス乱数のOp登録
- E-67: `tensorflow/core/ops/stateless_random_ops_v2.cc` - ステートレス乱数（V2）のOp登録
- E-68: `tensorflow/core/ops/sparse_ops.cc` - スパース操作のOp登録
- E-69: `tensorflow/core/ops/sparse_csr_matrix_ops.cc` - スパースCSR行列のOp登録
- E-70: `tensorflow/core/ops/ragged_array_ops.cc` - RaggedTensor配列操作のOp登録
- E-71: `tensorflow/core/ops/ragged_conversion_ops.cc` - RaggedTensor変換のOp登録
- E-72: `tensorflow/core/ops/ragged_math_ops.cc` - RaggedTensor数学演算のOp登録
- E-73: `tensorflow/python/saved_model/builder_impl.py` - SavedModelビルダー
- E-74: `tensorflow/python/saved_model/load.py` - SavedModel読み込み
- E-75: `tensorflow/python/saved_model/loader_impl.py` - SavedModelローダー
- E-76: `tensorflow/python/checkpoint/checkpoint.py` - チェックポイント実装
- E-77: `tensorflow/python/checkpoint/checkpoint_management.py` - チェックポイント管理
- E-78: `tensorflow/python/checkpoint/async_checkpoint_helper.py` - 非同期チェックポイント
- E-79: `tensorflow/python/saved_model/fingerprinting.py` - フィンガープリンティング
- E-80: `tensorflow/python/distribute/distribute_lib.py` - 分散ストラテジーAPI
- E-81: `tensorflow/python/distribute/collective_all_reduce_strategy.py` - CollectiveAllReduce
- E-82: `tensorflow/python/distribute/central_storage_strategy.py` - CentralStorage
- E-83: `tensorflow/python/distribute/cross_device_ops.py` - クロスデバイス通信
- E-84: `tensorflow/python/ops/collective_ops.py` - コレクティブ操作
- E-85: `tensorflow/core/ops/collective_ops.cc` - コレクティブ操作のOp登録
- E-86: `tensorflow/python/distribute/distribute_coordinator.py` - 分散コーディネータ
- E-87: `tensorflow/python/distribute/cluster_resolver/` - クラスタリゾルバ（ディレクトリ存在確認済み）
- E-88: `tensorflow/dtensor/python/` - DTensorのPythonディレクトリ（存在確認済み）
- E-89: `tensorflow/compiler/jit/` - XLA JITコンパイラ（ディレクトリ存在確認済み）
- E-90: `tensorflow/compiler/mlir/` - MLIRコンパイラ（ディレクトリ存在確認済み）
- E-91: `tensorflow/compiler/tf2tensorrt/` - TensorRT統合（ディレクトリ存在確認済み）
- E-92: `tensorflow/compiler/aot/` - AOTコンパイル（ディレクトリ存在確認済み）
- E-93: `tensorflow/compiler/tf2xla/` - TF2XLA変換（ディレクトリ存在確認済み）
- E-94: `tensorflow/lite/core/` - TFLiteコア（ディレクトリ存在確認済み）
- E-95: `tensorflow/lite/delegates/` - TFLiteデリゲート（ディレクトリ存在確認済み）
- E-96: `tensorflow/lite/experimental/` - TFLite実験的機能（ディレクトリ存在確認済み）
- E-97: `tensorflow/python/grappler/` - Grappler最適化（ディレクトリ存在確認済み）
- E-98: `tensorflow/python/grappler/cost_analyzer.py` - コスト分析
- E-99: `tensorflow/python/keras/mixed_precision/` - 混合精度（ディレクトリ存在確認済み）
- E-100: `tensorflow/python/eager/context.py` - Eager実行コンテキスト
- E-101: `tensorflow/python/eager/def_function.py` - tf.function
- E-102: `tensorflow/python/eager/function.py` - 関数トレーシング
- E-103: `tensorflow/python/autograph/` - AutoGraph（ディレクトリ存在確認済み）
- E-104: `tensorflow/python/feature_column/feature_column_v2.py` - Feature Column API
- E-105: `tensorflow/python/feature_column/sequence_feature_column.py` - シーケンス特徴量
- E-106: `tensorflow/core/ops/set_ops.cc` - 集合演算のOp登録
- E-107: `tensorflow/core/ops/random_index_shuffle_ops.cc` - ランダムインデックスシャッフル
- E-108: `tensorflow/core/ops/uniform_quant_ops.cc` - 均一量子化のOp登録
- E-109: `tensorflow/core/ops/stochastic_cast_op.cc` - 確率的キャスト
- E-110: `tensorflow/core/ops/debug_ops.cc` - デバッグ操作のOp登録
- E-111: `tensorflow/python/debug/` - デバッグモジュール（ディレクトリ存在確認済み）
- E-112: `tensorflow/core/ops/logging_ops.cc` - ロギング操作のOp登録
- E-113: `tensorflow/python/profiler/profiler_v2.py` - プロファイラV2
- E-114: `tensorflow/python/profiler/model_analyzer.py` - モデル分析
- E-115: `tensorflow/python/profiler/profiler_client.py` - プロファイラクライアント
- E-116: `tensorflow/core/ops/summary_ops.cc` - サマリー操作のOp登録
- E-117: `tensorflow/core/ops/tpu_configuration_ops.cc` - TPU構成操作
- E-118: `tensorflow/core/ops/tpu_infeed_ops.cc` - TPUインフィード操作
- E-119: `tensorflow/core/ops/tpu_outfeed_ops.cc` - TPUアウトフィード操作
- E-120: `tensorflow/core/ops/tpu_embedding_ops.cc` - TPUエンベディング操作
- E-121: `tensorflow/core/ops/tpu_replication_ops.cc` - TPUレプリケーション操作
- E-122: `tensorflow/core/ops/tpu_cross_replica_ops.cc` - TPUクロスレプリカ操作
- E-123: `tensorflow/core/ops/manip_ops.cc` - テンソル操作ユーティリティ
- E-124: `tensorflow/core/ops/list_ops.cc` - リスト操作のOp登録
- E-125: `tensorflow/core/ops/map_ops.cc` - マップ操作のOp登録
- E-126: `tensorflow/core/ops/optional_ops.cc` - オプショナル操作のOp登録
- E-127: `tensorflow/python/ops/clip_ops.py` - クリッピング操作
- E-128: `tensorflow/core/ops/lookup_ops.cc` - ルックアップ操作のOp登録
- E-129: `tensorflow/core/ops/encode_proto_ops.cc` - Protobufエンコード
- E-130: `tensorflow/core/ops/decode_proto_ops.cc` - Protobufデコード
- E-131: `tensorflow/core/distributed_runtime/` - 分散ランタイム（ディレクトリ存在確認済み）
- E-132: `tensorflow/core/common_runtime/` - 共通ランタイム（ディレクトリ存在確認済み）
- E-133: `tensorflow/core/tfrt/` - TFRTランタイム（ディレクトリ存在確認済み）
- E-134: `tensorflow/core/ops/script_ops.cc` - スクリプト操作のOp登録
- E-135: `tensorflow/python/ops/clustering_ops.py` - クラスタリング操作
- E-136: `tensorflow/core/ops/clustering_ops.cc` - クラスタリング操作のOp登録
- E-137: `tensorflow/python/ops/boosted_trees_ops.py` - Boosted Trees操作
- E-138: `tensorflow/core/ops/candidate_sampling_ops.cc` - 候補サンプリング操作
- E-139: `tensorflow/core/ops/sdca_ops.cc` - SDCA操作のOp登録
- E-140: `tensorflow/core/ops/word2vec_ops.cc` - Word2Vec操作のOp登録
- E-141: `tensorflow/python/ops/batch_ops.py` - バッチ操作
- E-142: `tensorflow/core/ops/sync_ops.cc` - 同期操作のOp登録
- E-143: `tensorflow/core/ops/nccl_ops.cc` - NCCL操作のOp登録
- E-144: `tensorflow/core/ops/sendrecv_ops.cc` - 送受信操作のOp登録
- E-145: `tensorflow/core/ops/special_math_ops.cc` - 特殊数学関数のOp登録
- E-146: `tensorflow/python/keras/models.py` - Kerasモデル構築
- E-147: `tensorflow/python/keras/callbacks.py` - Kerasコールバック
- E-148: `tensorflow/python/keras/initializers/` - Keras初期化子（ディレクトリ存在確認済み）
- E-149: `tensorflow/python/keras/saving/` - Keras保存（ディレクトリ存在確認済み）
- E-150: `tensorflow/core/ops/scoped_allocator_ops.cc` - スコープドアロケータ
- E-151: `tensorflow/core/ops/count_ops.cc` - カウント操作のOp登録
- E-152: `tensorflow/python/ops/confusion_matrix.py` - 混同行列
- E-153: `tensorflow/go/` - Go言語バインディング（ディレクトリ存在確認済み）
- E-154: `tensorflow/java/` - Java言語バインディング（ディレクトリ存在確認済み）
- E-155: `tensorflow/js/` - JavaScriptバインディング（ディレクトリ存在確認済み）
- E-156: `tensorflow/c/` - C言語API（ディレクトリ存在確認済み）
- E-157: `tensorflow/cc/` - C++ API（ディレクトリ存在確認済み）
- E-158: `tensorflow/security/` - セキュリティディレクトリ（存在確認済み）
- E-159: `ci/` - CIディレクトリ（存在確認済み）
- E-160: `tools/` - ツールディレクトリ（存在確認済み）
- E-161: `configure.py` - ビルド設定スクリプト（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンソル操作（Tensor Operations） | E-01, E-02 | ○ |
| C-02 | 数学演算（Math Operations） | E-03, E-04 | ○ |
| C-03 | 線形代数演算（Linear Algebra Operations） | E-05 | ○ |
| C-04 | ビット演算（Bitwise Operations） | E-06, E-07 | ○ |
| C-05 | 文字列操作（String Operations） | E-08 | ○ |
| C-06 | 制御フロー（Control Flow Operations） | E-09, E-10 | ○ |
| C-07 | 変数管理（Resource Variable Operations） | E-11 | ○ |
| C-08 | 状態管理（State Operations） | E-12 | ○ |
| C-09 | データフロー操作（Data Flow Operations） | E-13, E-14 | ○ |
| C-10 | 関数操作（Functional Operations） | E-15 | ○ |
| C-11 | 定数生成（Constant Operations） | E-16 | ○ |
| C-12 | データ型管理（DType Management） | E-17相当 | ○ |
| C-13 | デバイス管理（Device Management） | E-17 | ○ |
| C-14 | 設定管理（Configuration Management） | E-18 | ○ |
| C-15 | 畳み込み演算（Convolution Operations） | E-19, E-20 | ○ |
| C-16 | プーリング演算（Pooling Operations） | E-19, E-21 | ○ |
| C-17 | 活性化関数（Activation Functions） | E-22, E-23 | ○ |
| C-18 | バッチ正規化（Batch Normalization） | E-19, E-24 | ○ |
| C-19 | ドロップアウト（Dropout） | E-19 | ○ |
| C-20 | 埋め込み層（Embedding Layers） | E-25 | ○ |
| C-21 | リカレント層（Recurrent Layers） | E-26, E-27 | ○ |
| C-22 | 注意機構（Attention Mechanism） | E-28 | ○ |
| C-23 | 結合層（Merge Layers） | E-29 | ○ |
| C-24 | コア層（Core Layers） | E-30 | ○ |
| C-25 | CTC損失（CTC Operations） | E-31, E-32 | ○ |
| C-26 | cuDNN RNN | E-33 | ○ |
| C-27 | SGD（確率的勾配降下法） | E-34 | ○ |
| C-28 | Adamオプティマイザ | E-35 | ○ |
| C-29 | Adagradオプティマイザ | E-36 | ○ |
| C-30 | RMSPropオプティマイザ | E-37 | ○ |
| C-31 | Adadeltaオプティマイザ | E-38 | ○ |
| C-32 | Adamaxオプティマイザ | E-39 | ○ |
| C-33 | Nadamオプティマイザ | E-40 | ○ |
| C-34 | FTRLオプティマイザ | E-41 | ○ |
| C-35 | 学習率スケジューリング | E-42 | ○ |
| C-36 | 訓練操作（Training Operations） | E-43 | ○ |
| C-37 | 自動微分（Backpropagation） | E-44 | ○ |
| C-38 | 前方自動微分（Forward-mode AD） | E-45 | ○ |
| C-39 | カスタム勾配（Custom Gradient） | E-46 | ○ |
| C-40 | 損失関数（Loss Functions） | E-47 | ○ |
| C-41 | 評価指標（Metrics） | E-48 | ○ |
| C-42 | 正則化（Regularizers） | E-49 | ○ |
| C-43 | 制約（Constraints） | E-50 | ○ |
| C-44 | tf.data Dataset API | E-51 | ○ |
| C-45 | データセット生成（From Tensor/Generator） | E-52, E-53 | ○ |
| C-46 | データセットキャッシュ | E-54 | ○ |
| C-47 | データセット結合（Concatenate/Interleave） | E-55, E-56 | ○ |
| C-48 | 実験的データセット操作 | E-57 | ○ |
| C-49 | データ解析（Parsing Operations） | E-58 | ○ |
| C-50 | 入出力操作（IO Operations） | E-59 | ○ |
| C-51 | ファイルシステム操作 | E-60 | ○ |
| C-52 | 画像変換操作（Image Operations） | E-61 | ○ |
| C-53 | 音声操作（Audio Operations） | E-62 | ○ |
| C-54 | スペクトル操作（Spectral Operations） | E-63 | ○ |
| C-55 | ステートフル乱数生成 | E-64, E-65 | ○ |
| C-56 | ステートレス乱数生成 | E-66, E-67 | ○ |
| C-57 | スパーステンソル操作（Sparse Operations） | E-68 | ○ |
| C-58 | スパースCSR行列操作 | E-69 | ○ |
| C-59 | RaggedTensor配列操作 | E-70 | ○ |
| C-60 | RaggedTensor変換操作 | E-71 | ○ |
| C-61 | RaggedTensor数学演算 | E-72 | ○ |
| C-62 | SavedModel保存 | E-73 | ○ |
| C-63 | SavedModel読み込み | E-74, E-75 | ○ |
| C-64 | チェックポイント保存・復元 | E-76, E-77 | ○ |
| C-65 | 非同期チェックポイント | E-78 | ○ |
| C-66 | SavedModelフィンガープリンティング | E-79 | ○ |
| C-67 | 分散ストラテジーAPI | E-80 | ○ |
| C-68 | 集約的All-Reduce戦略 | E-81 | ○ |
| C-69 | CentralStorageStrategy | E-82 | ○ |
| C-70 | クロスデバイス通信 | E-83 | ○ |
| C-71 | コレクティブ操作（Collective Operations） | E-84, E-85 | ○ |
| C-72 | 分散コーディネータ | E-86 | ○ |
| C-73 | クラスタリゾルバ | E-87 | ○ |
| C-74 | DTensor API | E-88 | △ |
| C-75 | XLAコンパイル | E-89 | ○ |
| C-76 | MLIR変換 | E-90 | ○ |
| C-77 | TensorRT統合 | E-91 | ○ |
| C-78 | AOTコンパイル | E-92 | ○ |
| C-79 | TF2XLA変換 | E-93 | ○ |
| C-80 | TFLiteモデル変換 | E-94 | ○ |
| C-81 | TFLite推論エンジン | E-94 | ○ |
| C-82 | TFLiteデリゲート | E-95 | ○ |
| C-83 | TFLite実験的機能 | E-96 | ○ |
| C-84 | Grappler最適化 | E-97 | ○ |
| C-85 | コスト分析 | E-98 | ○ |
| C-86 | 自動混合精度 | E-99 | ○ |
| C-87 | Eager実行コンテキスト | E-100 | ○ |
| C-88 | tf.function（関数トレーシング） | E-101, E-102 | ○ |
| C-89 | AutoGraph変換 | E-103 | ○ |
| C-90 | Feature Column API | E-104 | ○ |
| C-91 | シーケンス特徴量 | E-105 | ○ |
| C-92 | 集合演算（Set Operations） | E-106 | ○ |
| C-93 | ランダムインデックスシャッフル | E-107 | ○ |
| C-94 | 均一量子化操作 | E-108 | ○ |
| C-95 | 確率的キャスト | E-109 | ○ |
| C-96 | デバッグ操作（Debug Operations） | E-110, E-111 | ○ |
| C-97 | ロギング操作 | E-112 | ○ |
| C-98 | プロファイラAPI | E-113 | ○ |
| C-99 | モデル分析 | E-114 | ○ |
| C-100 | プロファイラクライアント | E-115 | ○ |
| C-101 | Summary操作 | E-116 | ○ |
| C-102 | TPU構成管理 | E-117 | ○ |
| C-103 | TPUインフィード/アウトフィード | E-118, E-119 | ○ |
| C-104 | TPUエンベディング | E-120 | ○ |
| C-105 | TPUレプリケーション | E-121 | ○ |
| C-106 | TPUクロスレプリカ操作 | E-122 | ○ |
| C-107 | テンソル操作ユーティリティ（Manip Operations） | E-123 | ○ |
| C-108 | リスト操作（List Operations） | E-124 | ○ |
| C-109 | マップ操作（Map Operations） | E-125 | ○ |
| C-110 | オプショナル操作（Optional Operations） | E-126 | ○ |
| C-111 | クリッピング操作 | E-127 | ○ |
| C-112 | ソート・検索操作 | **根拠なし** | △ |
| C-113 | ルックアップ操作（Lookup Operations） | E-128 | ○ |
| C-114 | Protocol Bufferエンコード/デコード | E-129, E-130 | ○ |
| C-115 | 分散ランタイム | E-131 | ○ |
| C-116 | 共通ランタイム | E-132 | ○ |
| C-117 | TFRTランタイム | E-133 | ○ |
| C-118 | スクリプト操作（Script Operations） | E-134 | ○ |
| C-119 | クラスタリング操作 | E-135, E-136 | ○ |
| C-120 | Boosted Trees操作 | E-137 | ○ |
| C-121 | 候補サンプリング操作 | E-138 | ○ |
| C-122 | SDCA操作 | E-139 | ○ |
| C-123 | Word2Vec操作 | E-140 | ○ |
| C-124 | バッチ操作 | E-141 | ○ |
| C-125 | 同期プリミティブ | E-142 | ○ |
| C-126 | NCCL集約操作 | E-143 | ○ |
| C-127 | 送受信操作（Send/Recv） | E-144 | ○ |
| C-128 | 特殊数学関数操作 | E-145 | ○ |
| C-129 | 混合精度学習 | E-99 | ○ |
| C-130 | プロジェクト設定（Configure） | E-161 | △ |
| C-131 | Kerasモデル構築API | E-146 | ○ |
| C-132 | Kerasコールバック | E-147 | ○ |
| C-133 | Keras初期化子 | E-148 | ○ |
| C-134 | Kerasモデル保存 | E-149 | ○ |
| C-135 | メモリ管理（スコープドアロケータ） | E-150 | ○ |
| C-136 | カウント操作 | E-151 | ○ |
| C-137 | 混同行列計算 | E-152 | ○ |
| C-138 | Go言語バインディング | E-153 | △ |
| C-139 | Java言語バインディング | E-154 | △ |
| C-140 | JavaScriptバインディング | E-155 | △ |
| C-141 | C言語API | E-156 | ○ |
| C-142 | C++ API | E-157 | ○ |
| C-143 | セキュリティポリシー | E-158 | ○ |
| C-144 | 継続的インテグレーション | E-159 | ○ |
| C-145 | 開発者ツール | E-160 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-74（DTensor API）：dtensor/python/配下の個別ファイル内容の詳細確認が不十分。ディレクトリの存在は確認したが、提供する具体的なAPIの網羅的確認ができていない
  - 候補：dtensor/python/のソースコード精読 / DTensor公式ドキュメント / テストコード
- C-112（ソート・検索操作）：sort_ops.pyの存在確認ができていない。備考欄のパスが推定に基づく
  - 候補：tensorflow/python/ops/ 配下のファイル一覧再確認 / tf.sort APIの実装ファイル特定
- C-130（プロジェクト設定）：configure.pyの機能範囲は推定。ビルド設定以外の機能が含まれる可能性がある
  - 候補：configure.pyの内容精読 / ビルドドキュメント
- C-138〜C-140（Go/Java/JS バインディング）：ディレクトリの存在は確認したが、現在のメンテナンス状況（deprecated等）が不明
  - 候補：各ディレクトリのREADME確認 / TensorFlow公式リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア操作（C-01〜C-14）、NN操作（C-15〜C-26）、最適化（C-27〜C-43）は全てソースコードから直接確認しており信頼性が高い
- 0: 低リスク - データパイプライン（C-44〜C-51）はtf.data APIのソースコードから直接確認済み
- 0: 低リスク - モデル保存・復元（C-62〜C-66）はソースコードから直接確認済み
- 1: 中リスク - 多言語バインディング（C-138〜C-140）は、Go/Java/JSバインディングが本体リポジトリから別リポジトリに移行している可能性がある
- 1: 中リスク - 機能の粒度が一部不均一（Op登録ファイル単位と高レベルAPI単位が混在）
- 0: 低リスク - TFLite関連（C-80〜C-83）はディレクトリ構造から確認済みだが、サブ機能の詳細は省略

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か（機能の所属カテゴリに不整合がないか）
- [ ] 機能の粒度が適切か（粒度が細かすぎ/粗すぎの項目がないか）
- [ ] Go/Java/JSバインディング（C-138〜C-140）の現在のメンテナンス状況を確認
- [ ] DTensor API（C-74）の具体的な機能範囲が正確か確認
- [ ] 重複する機能がないか（例：C-86自動混合精度とC-129混合精度学習の関係）
- [ ] TensorFlow 2.x系列で非推奨（deprecated）になった機能が含まれていないか確認
- [ ] 漏れている主要機能がないか（例：tf.queue、tf.signal等の追加検討）
