# 機能設計書 101-Summary操作

## 概要

本ドキュメントは、TensorFlowにおけるSummary操作機能の設計を記述する。Summary操作は、テンソルボード（TensorBoard）向けのスカラー、ヒストグラム、画像、音声、グラフなどのサマリーデータの書き出し機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：機械学習モデルの学習過程において、損失値、精度、重みの分布、生成画像、音声データなどの中間結果を記録し可視化することは、モデルのデバッグ・チューニングに不可欠である。Summary操作は、これらのデータをTensorBoard互換の形式で効率的にファイルやデータベースに書き出すための低レベル基盤を提供する。

**機能の利用シーン**：学習ループの各ステップにおいて、損失値をスカラーサマリーとして記録する、重みの分布をヒストグラムサマリーとして記録する、生成画像を画像サマリーとして記録する、音声合成結果を音声サマリーとして記録する、計算グラフの構造をグラフサマリーとして記録する、といった場面で利用される。

**主要な処理内容**：
1. SummaryWriterリソースの生成と管理（ファイルライター、DBライター）
2. スカラー値のサマリー書き出し（WriteScalarSummary）
3. ヒストグラムデータのサマリー書き出し（WriteHistogramSummary）
4. 画像データのサマリー書き出し（WriteImageSummary）
5. 音声データのサマリー書き出し（WriteAudioSummary）
6. 計算グラフのサマリー書き出し（WriteGraphSummary）
7. 汎用テンソルデータのサマリー書き出し（WriteSummary）
8. 生プロトコルバッファサマリーの書き出し（WriteRawProtoSummary）
9. イベントのインポート（ImportEvent）
10. サマリーライターのフラッシュとクローズ

**関連システム・外部連携**：TensorBoardと連携し、tf.Eventプロトコルバッファ形式のイベントファイルまたはSQLiteデータベースにサマリーデータを出力する。

**権限による制御**：特段の権限制御はない。ファイルシステムやデータベースへの書き込み権限が必要。

## 関連画面

本機能に関連する画面は画面機能マッピングに登録されていない。TensorBoardのWeb UIが主な可視化手段であるが、本機能はデータ書き出し側のみを担当する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | TensorBoard（外部） | 結果表示 | Summary操作で書き出されたデータを可視化 |

## 機能種別

データ連携（サマリーデータの書き出し）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| writer | resource | Yes | SummaryWriterリソースハンドル | 有効なリソースであること |
| step | int64 | Yes | 学習ステップ番号 | 非負整数 |
| tag | string | Yes | サマリーのタグ名 | 空文字列でないこと |
| tensor | T | Yes | 書き出すテンソルデータ | 型Tはオペレーションにより異なる |
| summary_metadata | string | No | メタデータ（WriteSummary時） | Protocol Buffer形式 |
| bad_color | uint8 | No | 不正ピクセルの代替色（画像サマリー時） | uint8テンソル |
| max_images | int | No | 最大画像数（デフォルト: 3） | >= 1 |
| max_outputs | int | No | 最大音声出力数（デフォルト: 3） | >= 1 |
| sample_rate | float | No | 音声サンプリングレート | 正の値 |
| logdir | string | Yes（ファイルライター生成時） | ログ出力ディレクトリ | 有効なパス |
| max_queue | int32 | Yes（ファイルライター生成時） | キューの最大サイズ | 正の整数 |
| flush_millis | int32 | Yes（ファイルライター生成時） | フラッシュ間隔（ミリ秒） | 正の整数 |
| filename_suffix | string | No | ファイル名サフィックス | 任意の文字列 |

### 入力データソース

学習ループ内で計算されたテンソルデータ（損失値、メトリクス、重み分布、生成画像、音声波形、計算グラフ等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| writer | resource | SummaryWriterリソースハンドル（SummaryWriter Opの出力） |
| (なし) | - | 各Write系Opは出力を持たない（副作用としてファイル/DBに書き込む） |

### 出力先

- ファイルシステム: tf.Eventプロトコルバッファ形式のイベントファイル（logdir配下）
- SQLiteデータベース: TensorBoard DB形式（db_uri指定時）

## 処理フロー

### 処理シーケンス

```
1. SummaryWriterリソースの生成
   └─ SummaryWriter Opでリソースハンドルを作成
2. ライターの初期化
   └─ CreateSummaryFileWriter または CreateSummaryDbWriter でライターを設定
3. サマリーデータの書き出し（学習ループ内で繰り返し）
   ├─ WriteScalarSummary: スカラー値の記録
   ├─ WriteHistogramSummary: ヒストグラムの記録
   ├─ WriteImageSummary: 画像の記録
   ├─ WriteAudioSummary: 音声の記録
   ├─ WriteGraphSummary: グラフ構造の記録
   ├─ WriteSummary: 汎用テンソルの記録
   └─ WriteRawProtoSummary: 生プロトコルバッファの記録
4. フラッシュ
   └─ FlushSummaryWriter でバッファ内のデータを強制書き出し
5. クローズ
   └─ CloseSummaryWriter でリソースを解放
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[SummaryWriter Op でリソース生成]
    B --> C{ライター種別}
    C -->|ファイル| D[CreateSummaryFileWriter]
    C -->|DB| E[CreateSummaryDbWriter]
    D --> F[学習ループ開始]
    E --> F
    F --> G{書き出し種別}
    G -->|スカラー| H[WriteScalarSummary]
    G -->|ヒストグラム| I[WriteHistogramSummary]
    G -->|画像| J[WriteImageSummary]
    G -->|音声| K[WriteAudioSummary]
    G -->|グラフ| L[WriteGraphSummary]
    G -->|汎用| M[WriteSummary]
    H --> N{ループ継続?}
    I --> N
    J --> N
    K --> N
    L --> N
    M --> N
    N -->|Yes| F
    N -->|No| O[FlushSummaryWriter]
    O --> P[CloseSummaryWriter]
    P --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101-01 | キューイング | max_queueで指定された数のサマリーをバッファし、flush_millisの間隔でフラッシュする | ファイルライター使用時 |
| BR-101-02 | 画像最大数制限 | max_imagesで指定された数を上限として画像サマリーを記録する | WriteImageSummary時 |
| BR-101-03 | 音声最大出力制限 | max_outputsで指定された数を上限として音声サマリーを記録する | WriteAudioSummary時 |
| BR-101-04 | 不正色置換 | 画像サマリーで不正なピクセル値がある場合、bad_colorで指定された色に置換する | WriteImageSummary時 |

### 計算ロジック

サマリーデータは各種コンバーター関数（AddTensorAsScalarToSummary、AddTensorAsHistogramToSummary等）によりTensor形式からSummaryプロトコルバッファ形式に変換される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| CreateSummaryDbWriter | Users, Experiments, Runs | INSERT | ユーザー、実験、ランのエントリを自動作成（存在しない場合） |
| WriteSummary等 | Tags, Tensors, TensorStrings | INSERT | サマリーデータを記録 |

### テーブル別操作詳細

#### Summary DB（SQLite）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_name, experiment_name, run_name | ライター生成時のパラメータ | 自動作成 |
| INSERT | tag, step, tensor_data | 各Writeオペレーションのパラメータ | ステップごとに記録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | バリデーションエラー | 不正なテンソル型やシェイプ | 入力データの型・形状を確認 |
| NotFound | リソースエラー | ライターリソースが見つからない | SummaryWriterの再生成 |
| PermissionDenied | ファイル権限エラー | logdirへの書き込み権限なし | ディレクトリの権限を確認 |

### リトライ仕様

ファイル書き出しにおいてI/Oエラーが発生した場合、フレームワーク側での自動リトライは行われない。アプリケーション側での再試行が必要。

## トランザクション仕様

DBライター使用時は、SQLiteのトランザクション機構により書き込みのアトミック性が保証される。ファイルライター使用時は追記専用（append-only）のイベントファイルに書き込むため、部分書き込みが発生する可能性がある。

## パフォーマンス要件

- max_queueパラメータによりバッファサイズを制御し、I/O頻度を調整可能
- flush_millisパラメータによりフラッシュ間隔を制御し、書き込みレイテンシとスループットのバランスを調整可能
- GCSなどのリモートファイルシステムでも効率的に動作するよう追記専用設計

## セキュリティ考慮事項

- ファイルライターはlogdirで指定されたディレクトリにファイルを作成するため、パス・トラバーサル攻撃に注意が必要
- DBライターはSQLite接続URIを受け取るため、URIの妥当性検証が必要
- サマリーデータに機密情報が含まれる場合、出力先のアクセス制御を適切に設定する必要がある

## 備考

- SummaryWriter OpのShapeFnはスカラー出力（リソースハンドル）を返す
- 各Write系OpのShapeFnはNoOutputs（出力なし）を返す
- TensorBoardとの連携はtf.Eventプロトコルバッファ形式を介して行われる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Summary操作の中心となるデータ構造は、tf.Eventプロトコルバッファとリソースハンドルである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | summary.proto | `tensorflow/core/framework/summary.proto` | Summaryメッセージの構造（Value、Image、Audio、Histogram等） |
| 1-2 | event.proto | `tensorflow/core/util/event.proto` | tf.Eventメッセージの構造（step、wall_time、summary） |
| 1-3 | summary_interface.h | `tensorflow/core/kernels/summary_interface.h` | SummaryWriterInterfaceの抽象インターフェース定義 |

**読解のコツ**: Protocol Bufferの定義ファイルから始めることで、データの構造と流れの全体像を把握できる。

#### Step 2: Op登録（エントリーポイント）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | summary_ops.cc | `tensorflow/core/ops/summary_ops.cc` | 全13個のSummary Opの登録定義 |

**主要処理フロー**:
1. **21-25行目**: SummaryWriter Op - リソースハンドルの生成（shared_name、containerアトリビュート）
2. **27-33行目**: CreateSummaryFileWriter Op - ファイルライターの初期化（logdir、max_queue、flush_millis、filename_suffix）
3. **35-41行目**: CreateSummaryDbWriter Op - DBライターの初期化（db_uri、experiment_name、run_name、user_name）
4. **51-58行目**: WriteSummary Op - 汎用テンソルサマリー書き出し（writer、step、tensor、tag、summary_metadata）
5. **71-77行目**: WriteScalarSummary Op - スカラーサマリー書き出し（realnumbertype制約）
6. **79-85行目**: WriteHistogramSummary Op - ヒストグラムサマリー書き出し（realnumbertype + bool）
7. **87-95行目**: WriteImageSummary Op - 画像サマリー書き出し（max_images、bad_color、uint8/double/float/half）
8. **97-104行目**: WriteAudioSummary Op - 音声サマリー書き出し（sample_rate、max_outputs）
9. **106-110行目**: WriteGraphSummary Op - グラフサマリー書き出し（string型テンソル）

#### Step 3: ライター実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | summary_file_writer.h | `tensorflow/core/summary/summary_file_writer.h` | ファイルライターの公開API（CreateSummaryFileWriter関数） |
| 3-2 | summary_file_writer.cc | `tensorflow/core/summary/summary_file_writer.cc` | ファイルライターの実装（キューイング、フラッシュ、tf.Event書き出し） |
| 3-3 | summary_db_writer.h | `tensorflow/core/summary/summary_db_writer.h` | DBライターの公開API（CreateSummaryDbWriter関数） |
| 3-4 | summary_db_writer.cc | `tensorflow/core/summary/summary_db_writer.cc` | SQLiteへのサマリー書き込み実装 |

**主要処理フロー**:
- **summary_file_writer.h 37-40行目**: CreateSummaryFileWriter関数シグネチャ - max_queue、flush_millis、logdir、filename_suffix、Envを受け取る
- **summary_db_writer.h 37-41行目**: CreateSummaryDbWriter関数シグネチャ - Sqliteオブジェクト、experiment_name、run_name、user_nameを受け取る

#### Step 4: テンソル変換処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | summary_converter.h | `tensorflow/core/summary/summary_converter.h` | テンソルからSummaryへの変換関数群の定義 |
| 4-2 | summary_converter.cc | `tensorflow/core/summary/summary_converter.cc` | 各種テンソル型からSummaryプロトへの変換ロジック |

**主要処理フロー**:
- **summary_converter.h 26-27行目**: AddTensorAsScalarToSummary - テンソルをスカラーサマリーに変換
- **summary_converter.h 28-29行目**: AddTensorAsHistogramToSummary - テンソルをヒストグラムサマリーに変換
- **summary_converter.h 30-32行目**: AddTensorAsImageToSummary - テンソルを画像サマリーに変換（max_images、bad_color指定）
- **summary_converter.h 33-35行目**: AddTensorAsAudioToSummary - テンソルを音声サマリーに変換（max_outputs、sample_rate指定）

### プログラム呼び出し階層図

```
SummaryWriter Op (リソース生成)
    │
    ├─ CreateSummaryFileWriter Op
    │      └─ CreateSummaryFileWriter()
    │             └─ SummaryFileWriter (SummaryWriterInterface実装)
    │
    ├─ CreateSummaryDbWriter Op
    │      └─ CreateSummaryDbWriter()
    │             └─ SummaryDbWriter (SummaryWriterInterface実装)
    │
    ├─ WriteScalarSummary Op
    │      └─ SummaryWriterInterface::WriteScalar()
    │             └─ AddTensorAsScalarToSummary()
    │
    ├─ WriteHistogramSummary Op
    │      └─ SummaryWriterInterface::WriteHistogram()
    │             └─ AddTensorAsHistogramToSummary()
    │
    ├─ WriteImageSummary Op
    │      └─ SummaryWriterInterface::WriteImage()
    │             └─ AddTensorAsImageToSummary()
    │
    ├─ WriteAudioSummary Op
    │      └─ SummaryWriterInterface::WriteAudio()
    │             └─ AddTensorAsAudioToSummary()
    │
    ├─ WriteGraphSummary Op
    │      └─ SummaryWriterInterface::WriteGraph()
    │
    ├─ WriteSummary Op
    │      └─ SummaryWriterInterface::WriteTensor()
    │
    ├─ FlushSummaryWriter Op
    │      └─ SummaryWriterInterface::Flush()
    │
    └─ CloseSummaryWriter Op
           └─ SummaryWriterInterface::Close()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

テンソルデータ ───▶ Write*Summary Op ───▶ SummaryConverter ───▶ Summaryプロト
(step, tag, value)         │                                        │
                           ▼                                        ▼
                    SummaryWriterInterface              ┌─── イベントファイル
                           │                           │    (logdir/*.events)
                           ├───────────────────────────┤
                           │                           └─── SQLite DB
                           ▼                                (db_uri)
                    FlushSummaryWriter
                    (バッファ強制書き出し)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| summary_ops.cc | `tensorflow/core/ops/summary_ops.cc` | ソース | Summary Op登録定義（13 Ops） |
| summary_file_writer.h | `tensorflow/core/summary/summary_file_writer.h` | ヘッダ | ファイルライター公開API |
| summary_file_writer.cc | `tensorflow/core/summary/summary_file_writer.cc` | ソース | ファイルライター実装 |
| summary_db_writer.h | `tensorflow/core/summary/summary_db_writer.h` | ヘッダ | DBライター公開API |
| summary_db_writer.cc | `tensorflow/core/summary/summary_db_writer.cc` | ソース | DBライター実装 |
| summary_converter.h | `tensorflow/core/summary/summary_converter.h` | ヘッダ | テンソル-Summary変換関数 |
| summary_converter.cc | `tensorflow/core/summary/summary_converter.cc` | ソース | テンソル-Summary変換実装 |
| schema.h | `tensorflow/core/summary/schema.h` | ヘッダ | DB スキーマ定義 |
| schema.cc | `tensorflow/core/summary/schema.cc` | ソース | DBスキーマ実装 |
| summary_interface.h | `tensorflow/core/kernels/summary_interface.h` | ヘッダ | SummaryWriterInterface抽象クラス |
| loader.cc | `tensorflow/core/summary/loader.cc` | ソース | サマリーデータローダー |
| vacuum.cc | `tensorflow/core/summary/vacuum.cc` | ソース | DBバキューム処理 |
