# 機能設計書 103-TPUインフィード/アウトフィード

## 概要

本ドキュメントは、TensorFlowにおけるTPUデバイスへのデータ転送（インフィード）およびTPUデバイスからのデータ取得（アウトフィード）機能の設計を記述する。

### 本機能の処理概要

**業務上の目的・背景**：TPUは独自のメモリ空間を持ち、ホストCPUから直接メモリアクセスできない。そのため、学習データや推論入力をTPUに転送するインフィード操作と、TPUの計算結果をホストに取り出すアウトフィード操作が必要となる。本機能はこのデータ転送のための低レベルOp群を提供する。

**機能の利用シーン**：TPU上でのモデル学習時のバッチデータ投入、TPU上の中間結果やデバッグデータのホストへの取り出し、TPUパイプラインの入出力処理、事前線形化（Prelinearize）によるデータ転送効率化などで利用される。

**主要な処理内容**：
1. 単一テンソルのTPUへのエンキュー（InfeedEnqueue）
2. 複数テンソルのTPUへのタプルエンキュー（InfeedEnqueueTuple）
3. TPUからの単一テンソルデキュー（InfeedDequeue）
4. TPUからの複数テンソルタプルデキュー（InfeedDequeueTuple）
5. データの事前線形化（Prelinearize、PrelinearizeTuple）
6. 事前線形化バッファのエンキュー（InfeedEnqueuePrelinearizedBuffer）
7. TPUからの単一テンソルアウトフィードエンキュー（OutfeedEnqueue）
8. TPUからの複数テンソルタプルアウトフィードエンキュー（OutfeedEnqueueTuple）
9. ホストでのアウトフィードデキュー（OutfeedDequeue、OutfeedDequeueV2）
10. ホストでの複数テンソルアウトフィードデキュー（OutfeedDequeueTuple、OutfeedDequeueTupleV2）

**関連システム・外部連携**：TPUデバイスとホストCPU間のDMAベースのデータ転送。

**権限による制御**：TPUデバイスへのアクセス権限が必要。device_ordinalパラメータで対象TPUデバイスを指定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能に関連する画面は登録されていない |

## 機能種別

データ連携（TPU-ホスト間データ転送）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input (InfeedEnqueue) | dtype | Yes | TPUに送信するテンソル | shape属性と一致 |
| inputs (InfeedEnqueueTuple) | dtypes list | Yes | TPUに送信するテンソルタプル | shapes属性と一致 |
| dtype | type | Yes | テンソルのデータ型 | 有効なTensorFlow型 |
| shape | shape | No | テンソルの形状（デフォルト: {}） | 有効な形状 |
| shapes | list(shape) | Yes（タプル操作時） | テンソルタプルの各形状 | 有効な形状リスト |
| layout | list(int) | No | メモリレイアウト指定（デフォルト: []） | 有効なレイアウト |
| layouts | list(int) | No | タプル操作時のレイアウト指定 | 有効なレイアウトリスト |
| device_ordinal | int | No | 対象TPUデバイス番号（デフォルト: -1 = 自動） | -1以上の整数 |
| input (Prelinearize) | dtype | Yes | 事前線形化するテンソル | shape属性と一致 |
| input (OutfeedEnqueue) | dtype | Yes | アウトフィードするテンソル | - |

### 入力データソース

ホストCPU上の学習データテンソル、TPU上の計算結果テンソル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output (InfeedDequeue) | dtype | TPUから取得したテンソル |
| outputs (InfeedDequeueTuple) | dtypes list | TPUから取得したテンソルタプル |
| output (Prelinearize) | variant | 事前線形化されたバッファ |
| output (OutfeedDequeue) | dtype | ホストで取得したアウトフィードテンソル |
| outputs (OutfeedDequeueTuple) | dtypes list | ホストで取得したアウトフィードテンソルタプル |

### 出力先

TPUデバイスメモリ（インフィード時）、ホストCPUメモリ（アウトフィード時）。

## 処理フロー

### 処理シーケンス

```
[インフィード]
1. ホスト側でデータをエンキュー
   ├─ InfeedEnqueue: 単一テンソルをTPUキューに投入
   ├─ InfeedEnqueueTuple: 複数テンソルをタプルとしてTPUキューに投入
   └─ InfeedEnqueuePrelinearizedBuffer: 事前線形化済みバッファを投入
2. TPU側でデータをデキュー
   ├─ InfeedDequeue: 単一テンソルを取得
   └─ InfeedDequeueTuple: テンソルタプルを取得

[アウトフィード]
3. TPU側でデータをエンキュー
   ├─ OutfeedEnqueue: 単一テンソルをアウトフィードキューに投入
   └─ OutfeedEnqueueTuple: 複数テンソルをタプルとしてキューに投入
4. ホスト側でデータをデキュー
   ├─ OutfeedDequeue / OutfeedDequeueV2: 単一テンソルを取得
   └─ OutfeedDequeueTuple / OutfeedDequeueTupleV2: テンソルタプルを取得
```

### フローチャート

```mermaid
flowchart LR
    subgraph Host
        A[入力テンソル] --> B{事前線形化?}
        B -->|Yes| C[Prelinearize]
        C --> D[InfeedEnqueuePrelinearizedBuffer]
        B -->|No| E[InfeedEnqueue/Tuple]
        H[OutfeedDequeue/Tuple] --> I[出力テンソル]
    end
    subgraph TPU
        F[InfeedDequeue/Tuple] --> G[TPU計算]
        G --> J[OutfeedEnqueue/Tuple]
    end
    D --> F
    E --> F
    J --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-103-01 | 型・形状一致 | インフィードのEnqueue/Dequeueでdtype/shapeが一致する必要がある | 全インフィード操作 |
| BR-103-02 | デバイス指定 | device_ordinal=-1の場合、システムが自動的にデバイスを選択 | device_ordinal未指定時 |
| BR-103-03 | V2 Op制約 | OutfeedDequeueV2/OutfeedDequeueTupleV2ではdevice_ordinalがスカラーint32入力として指定 | V2 Op使用時 |
| BR-103-04 | shapes/dtypes一致 | OutfeedDequeueTupleではshapesとdtypesの要素数が一致する必要がある | タプルアウトフィード時 |

### 計算ロジック

事前線形化（Prelinearize）は、テンソルデータをTPUのメモリレイアウトに最適化された形式に変換する前処理であり、variant型のスカラーとして出力される。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | バリデーションエラー | shapesとdtypesの要素数不一致 | shapes/dtypesリストのサイズを一致させる |
| InvalidArgument | バリデーションエラー | device_ordinalがスカラーでない（V2 Op） | スカラーint32を指定 |
| ResourceExhausted | メモリエラー | TPUメモリ不足 | バッチサイズ削減、テンソルサイズ確認 |

### リトライ仕様

自動リトライは行われない。TPUデバイスエラーの場合はTPUシステムの再初期化が必要。

## トランザクション仕様

インフィード/アウトフィードはキューベースの非同期通信であり、Enqueue/Dequeueが対をなして動作する。Enqueue側がDequeue側より先に実行される保証はなく、ブロッキング動作となる。全Opsはステートフル（SetIsStateful）として登録されている。

## パフォーマンス要件

- インフィード/アウトフィードはPCIe/ネットワーク帯域に依存
- 事前線形化（Prelinearize）により、転送効率を向上可能
- layout属性でメモリレイアウトを最適化可能

## セキュリティ考慮事項

- TPUデバイスへのアクセス制御が必要
- device_ordinalの妥当性検証

## 備考

- InfeedDequeue/OutfeedDequeueはExplicitShapeのShapeFnを使用（shape属性から出力形状を決定）
- V2版のOutfeed Opsはdevice_ordinalを入力テンソルとして動的に指定可能（V1版はアトリビュート）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shape_inference.h | `tensorflow/core/framework/shape_inference.h` | ShapeHandle、PartialTensorShapeの理解 |

**読解のコツ**: インフィード/アウトフィードでは型と形状の静的指定が重要。dtype/shape属性の整合性がOp間の契約となる。

#### Step 2: インフィードOp登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tpu_infeed_ops.cc | `tensorflow/core/ops/tpu_infeed_ops.cc` | インフィード関連7 Opの登録定義 |

**主要処理フロー**:
1. **25-30行目**: InfeedDequeue Op - dtype/shape属性、ExplicitShape
2. **32-39行目**: InfeedEnqueue Op - dtype/shape/layout/device_ordinal属性
3. **41-48行目**: InfeedEnqueueTuple Op - dtypes/shapes/layoutsリスト属性
4. **50-64行目**: InfeedDequeueTuple Op - shapes属性から出力形状を推論するShapeFn
5. **66-72行目**: Prelinearize Op - variant型スカラー出力
6. **74-80行目**: PrelinearizeTuple Op - dtypes/shapesリスト対応
7. **82-85行目**: InfeedEnqueuePrelinearizedBuffer Op - variant入力、device_ordinal属性

#### Step 3: アウトフィードOp登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tpu_outfeed_ops.cc | `tensorflow/core/ops/tpu_outfeed_ops.cc` | アウトフィード関連6 Opの登録定義 |

**主要処理フロー**:
1. **26-30行目**: OutfeedEnqueue Op - dtype入力、ステートフル
2. **32-36行目**: OutfeedEnqueueTuple Op - dtypesリスト入力
3. **38-44行目**: OutfeedDequeue Op - dtype/shape/device_ordinal属性
4. **46-67行目**: OutfeedDequeueTuple Op - shapes/dtypes整合性チェック付きShapeFn
5. **69-75行目**: OutfeedDequeueV2 Op - device_ordinalがint32入力テンソル
6. **77-101行目**: OutfeedDequeueTupleV2 Op - device_ordinalスカラー検証付き

### プログラム呼び出し階層図

```
[インフィード]
ホストCPU側:
    InfeedEnqueue / InfeedEnqueueTuple
        └─ TPUインフィードキューにデータ投入
    Prelinearize / PrelinearizeTuple
        └─ テンソルをTPUレイアウトに変換
    InfeedEnqueuePrelinearizedBuffer
        └─ 事前線形化バッファを投入

TPU側:
    InfeedDequeue / InfeedDequeueTuple
        └─ インフィードキューからデータ取得

[アウトフィード]
TPU側:
    OutfeedEnqueue / OutfeedEnqueueTuple
        └─ アウトフィードキューにデータ投入

ホストCPU側:
    OutfeedDequeue / OutfeedDequeueTuple
        └─ アウトフィードキューからデータ取得
    OutfeedDequeueV2 / OutfeedDequeueTupleV2
        └─ 動的device_ordinal指定でデータ取得
```

### データフロー図

```
[ホストCPU]                    [TPU]

学習データ ──InfeedEnqueue──▶ InfeedDequeue ──▶ TPU計算
           ──InfeedEnqueueTuple──▶ InfeedDequeueTuple ──▶
           ──Prelinearize──▶ InfeedEnqueuePrelinearizedBuffer──▶

                               TPU計算結果
OutfeedDequeue ◀──OutfeedEnqueue──
OutfeedDequeueTuple ◀──OutfeedEnqueueTuple──
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tpu_infeed_ops.cc | `tensorflow/core/ops/tpu_infeed_ops.cc` | ソース | インフィードOp登録定義（7 Ops） |
| tpu_outfeed_ops.cc | `tensorflow/core/ops/tpu_outfeed_ops.cc` | ソース | アウトフィードOp登録定義（6 Ops） |
