# 機能設計書 107-テンソル操作ユーティリティ（Manip Operations）

## 概要

本ドキュメントは、テンソルのロール（循環シフト）などの操作ユーティリティ機能の設計を記述する。

### 本機能の処理概要

**業務上の目的・背景**：テンソルデータの前処理やデータ拡張において、テンソルの要素を指定した軸に沿って循環的にシフトさせる操作が必要となる。本機能はそのようなテンソル操作のユーティリティOp群を提供する。NumPyのnp.rollに相当するTensorFlowネイティブ実装である。

**機能の利用シーン**：画像の循環シフトによるデータ拡張、時系列データのオフセット調整、テンソル要素の周期的な並べ替え。

**主要な処理内容**：
1. Roll操作 - テンソル要素を指定された軸に沿って指定量だけ循環シフトする

**関連システム・外部連携**：特になし。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能に関連する画面は登録されていない |

## 機能種別

計算処理（テンソル変換）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | T | Yes | 操作対象テンソル | ランク1以上 |
| shift | Tshift (int32/int64) | Yes | シフト量（スカラーまたは1次元） | ランク0または1 |
| axis | Taxis (int32/int64) | Yes | シフト軸（スカラーまたは1次元） | ランク0または1、shiftと同一形状 |

### 入力データソース

任意のテンソルデータ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output | T | 循環シフト後のテンソル（入力と同一形状） |

### 出力先

計算グラフ内の後続Opへの入力。

## 処理フロー

### 処理シーケンス

```
1. 入力テンソルのランク検証（1以上）
2. shift/axisの形状検証（スカラーまたは1次元、同一形状）
3. 指定された各軸に沿ってshift量だけ要素を循環シフト
4. 入力と同一形状の出力テンソルを返却
```

### フローチャート

```mermaid
flowchart TD
    A[入力テンソル] --> B{ランク >= 1?}
    B -->|Yes| C{shift/axis形状一致?}
    B -->|No| E[エラー]
    C -->|Yes| D[各軸でshift量だけ循環シフト]
    C -->|No| E
    D --> F[出力テンソル（同一形状）]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-01 | ランク制約 | 入力テンソルはランク1以上である必要がある | 常に |
| BR-107-02 | shift/axis一致 | shiftとaxisは同一形状（スカラーまたは同一長の1次元） | 常に |
| BR-107-03 | 循環シフト | シフトはモジュロ演算で循環する（端を超えた要素は反対側に回り込む） | 常に |
| BR-107-04 | 形状不変 | 出力テンソルの形状は入力と同一 | 常に |

### 計算ロジック

Roll操作は、テンソルの指定軸に沿って要素を循環的にシフトする。shiftが正の場合は末尾方向にシフトし、はみ出した要素は先頭に回り込む。負の場合は逆方向。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | ランクエラー | 入力テンソルのランクが0 | ランク1以上のテンソルを使用 |
| InvalidArgument | 形状不一致 | shiftのランクが2以上 | スカラーまたは1次元を指定 |
| InvalidArgument | 形状不一致 | axisのランクが2以上 | スカラーまたは1次元を指定 |
| InvalidArgument | 形状不一致 | shiftとaxisの形状が異なる | 同一形状に揃える |

### リトライ仕様

自動リトライは行われない。

## トランザクション仕様

ステートレスな計算操作であり、トランザクション管理は不要。

## パフォーマンス要件

- 入力テンソルのサイズに比例した計算量

## セキュリティ考慮事項

- 特になし

## 備考

- Roll Opはtype属性で任意の型をサポート
- ShapeFnはUnchangedShape（入力形状をそのまま出力形状とする）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | manip_ops.cc | `tensorflow/core/ops/manip_ops.cc` | Roll Opの登録定義 |

**主要処理フロー**:
1. **23-42行目**: Roll Op - input(T型)、shift(Tshift: int32/int64)、axis(Taxis: int32/int64)
2. **34行目**: 入力テンソルのランク検証（WithRankAtLeast: 1以上）
3. **36行目**: shiftのランク検証（WithRankAtMost: 1以下）
4. **38行目**: axisのランク検証（WithRankAtMost: 1以下）
5. **40行目**: shiftとaxisの形状マージ（同一形状であることを検証）
6. **41行目**: UnchangedShape - 出力形状は入力と同一

**読解のコツ**: Roll OpのShapeFnでは、入力の形状検証のみを行い、出力形状は入力と同一であることを保証する。実際のシフト計算はカーネル実装で行われる。

### プログラム呼び出し階層図

```
Roll Op
    ├─ ShapeFn
    │      ├─ WithRankAtLeast(input, 1) - 入力ランク検証
    │      ├─ WithRankAtMost(shift, 1) - shiftランク検証
    │      ├─ WithRankAtMost(axis, 1) - axisランク検証
    │      ├─ Merge(shift, axis) - shift/axis形状一致検証
    │      └─ UnchangedShape - 出力形状 = 入力形状
    │
    └─ RollKernel (カーネル実装)
           └─ 各軸でモジュロ循環シフト
```

### データフロー図

```
[入力]                    [処理]                    [出力]

テンソル [a,b,c,d,e] ──▶ Roll(shift=2, axis=0) ──▶ [d,e,a,b,c]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| manip_ops.cc | `tensorflow/core/ops/manip_ops.cc` | ソース | Roll Op登録定義（1 Op） |
