# 機能設計書 109-マップ操作（Map Operations）

## 概要

本ドキュメントは、TensorFlowにおけるTensorMapの生成・要素追加・取得・削除・キー確認操作の設計を記述する。

### 本機能の処理概要

**業務上の目的・背景**：キーと値のペアでテンソルデータを管理する必要がある場面（辞書的なデータ構造、動的なマッピング管理など）において、TensorMapはvariant型のキー・バリューストアを提供する。本機能はこのTensorMapの基本操作を実現するOp群を提供する。

**機能の利用シーン**：計算グラフ内での動的なキー・バリューマッピング、条件分岐に基づくテンソルの格納・取得、制御フロー内での名前付きテンソル管理。

**主要な処理内容**：
1. 空のTensorMapの生成（EmptyTensorMap）
2. マップサイズの取得（TensorMapSize）
3. キーによる値の検索（TensorMapLookup）
4. キー・値ペアの挿入（TensorMapInsert）
5. キーによる要素の削除（TensorMapErase）
6. キーの存在確認（TensorMapHasKey）
7. 全キーのスタック取得（TensorMapStackKeys）

**関連システム・外部連携**：特になし。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能に関連する画面は登録されていない |

## 機能種別

データ構造操作（キー・バリューマップ管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input_handle | variant | Yes（操作時） | TensorMapハンドル | 有効なvariant |
| key | key_dtype | Yes（Lookup/Insert/Erase/HasKey時） | 検索・操作キー | key_dtype属性で指定された型 |
| value | value_dtype | Yes（Insert時） | 挿入する値テンソル | value_dtype属性で指定された型 |
| key_dtype | type | Yes | キーのデータ型 | 有効なTensorFlow型 |
| value_dtype | type | Yes（Lookup/Insert/Erase時） | 値のデータ型 | 有効なTensorFlow型 |

### 入力データソース

計算グラフ内のテンソルデータ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| handle | variant | TensorMapハンドル（EmptyTensorMap出力、スカラー） |
| output_handle | variant | 操作後のTensorMapハンドル（Insert/Erase出力、スカラー） |
| size | int32 | マップ内の要素数（スカラー） |
| value | value_dtype | 検索結果の値テンソル（形状不明） |
| has_key | bool | キー存在フラグ（スカラー） |
| keys | key_dtype | 全キーテンソル（形状不明） |

### 出力先

計算グラフ内の後続Opへの入力。

## 処理フロー

### 処理シーケンス

```
1. EmptyTensorMapで空のマップを生成
   └─ スカラーvariantハンドルを返却
2. TensorMapInsertでキー・値ペアを挿入
   └─ 新しいマップハンドルを返却
3. TensorMapLookupでキーから値を取得
   └─ 値テンソルを返却
4. TensorMapHasKeyでキーの存在を確認
   └─ boolスカラーを返却
5. TensorMapEraseでキーを削除
   └─ 新しいマップハンドルを返却
6. TensorMapSizeでマップサイズを取得
   └─ int32スカラーを返却
7. TensorMapStackKeysで全キーを取得
   └─ キーテンソルを返却
```

### フローチャート

```mermaid
flowchart TD
    A[EmptyTensorMap] --> B[TensorMapハンドル]
    B --> C{操作種別}
    C -->|挿入| D[TensorMapInsert]
    C -->|検索| E[TensorMapLookup]
    C -->|存在確認| F[TensorMapHasKey]
    C -->|削除| G[TensorMapErase]
    C -->|サイズ| H[TensorMapSize]
    C -->|全キー| I[TensorMapStackKeys]
    D --> B
    G --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-109-01 | イミュータブル操作 | Insert/Eraseは新しいマップハンドルを返す（元のマップは変更されない） | Insert/Erase時 |
| BR-109-02 | 型指定 | key_dtypeとvalue_dtypeはOp登録時に指定し、操作間で一貫性がある必要がある | 全操作 |

### 計算ロジック

特段の計算ロジックはない。各操作は辞書型データ構造の標準的なCRUD操作に対応する。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | キーエラー | Lookupで存在しないキーを指定 | HasKeyで事前確認 |
| InvalidArgument | 型エラー | key_dtype/value_dtypeの不一致 | 型を統一 |

### リトライ仕様

自動リトライは行われない。

## トランザクション仕様

TensorMapはイミュータブルなデータ構造であり、各操作は新しいvariantハンドルを返す。トランザクション管理は不要。

## パフォーマンス要件

- 各操作の計算量はマップのサイズに依存
- StackKeysはO(n)

## セキュリティ考慮事項

- 特になし

## 備考

- 現在はスカラー値のみサポート（ファイル内TODOコメント: "Support non-scalar values"）
- TensorMapLookupの出力形状はUnknownShape（実行時に決定）
- TensorMapStackKeysの出力形状もUnknownShape

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | map_ops.cc | `tensorflow/core/ops/map_ops.cc` | 全7個のTensorMap Op登録定義 |

**主要処理フロー**:
1. **24-29行目**: EmptyTensorMap Op - 出力はスカラーvariant
2. **31-34行目**: TensorMapSize Op - 入力variant、出力スカラーint32
3. **36-45行目**: TensorMapLookup Op - key_dtype/value_dtype属性、出力UnknownShape
4. **47-57行目**: TensorMapInsert Op - key/value入力、出力スカラーvariant
5. **59-68行目**: TensorMapErase Op - key入力、出力スカラーvariant（key_dtypeとvalue_dtype両方指定）
6. **70-75行目**: TensorMapHasKey Op - key入力、出力スカラーbool
7. **77-84行目**: TensorMapStackKeys Op - 出力UnknownShape（全キーのスタック）

**読解のコツ**: TensorMapのOp定義はシンプルで、大部分のShapeFnはスカラーまたはUnknownShapeを返す。TensorMapEraseではvalue_dtype属性も必要（内部型追跡のため）。

### プログラム呼び出し階層図

```
EmptyTensorMap
    └─ variant(スカラー) ハンドル生成

TensorMapInsert
    ├─ input_handle: variant
    ├─ key: key_dtype
    ├─ value: value_dtype
    └─ output_handle: variant(スカラー)

TensorMapLookup
    ├─ input_handle: variant
    ├─ key: key_dtype
    └─ value: value_dtype(UnknownShape)

TensorMapErase
    ├─ input_handle: variant
    ├─ key: key_dtype
    └─ output_handle: variant(スカラー)

TensorMapHasKey
    ├─ input_handle: variant
    ├─ key: key_dtype
    └─ has_key: bool(スカラー)

TensorMapStackKeys
    ├─ input_handle: variant
    └─ keys: key_dtype(UnknownShape)
```

### データフロー図

```
[入力]                  [処理]                    [出力]

(なし) ──────▶ EmptyTensorMap ──────▶ 空マップハンドル
key + value ──▶ TensorMapInsert ──▶ 更新マップハンドル
key ──────────▶ TensorMapLookup ──▶ 値テンソル
key ──────────▶ TensorMapHasKey ──▶ bool(存在フラグ)
key ──────────▶ TensorMapErase ──▶ 更新マップハンドル
(なし) ──────▶ TensorMapStackKeys ──▶ 全キーテンソル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| map_ops.cc | `tensorflow/core/ops/map_ops.cc` | ソース | TensorMap Op登録定義（7 Ops） |
