# 機能設計書 110-オプショナル操作（Optional Operations）

## 概要

本ドキュメントは、TensorFlowにおけるOptionalTensor（値の有無を表現するコンテナ）の操作機能の設計を記述する。

### 本機能の処理概要

**業務上の目的・背景**：tf.data.Datasetのイテレータ処理において、データセットの終端（要素なし）を表現する必要がある。OptionalTensorは「値が存在する」または「値が存在しない」の2状態を持つvariant型のコンテナであり、イテレータのget_next_as_optionalパターンで利用される。本機能はこのOptional型の生成・検査・値取得操作を提供する。

**機能の利用シーン**：tf.data.Datasetのイテレータ終端検出、条件付きデータ取得、Optional型によるNull安全なテンソル操作。

**主要な処理内容**：
1. 値からOptionalの生成（OptionalFromValue）
2. 空のOptionalの生成（OptionalNone）
3. 値の存在確認（OptionalHasValue）
4. 値の取得（OptionalGetValue）

**関連システム・外部連携**：tf.data Dataset API、DatasetIterator。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能に関連する画面は登録されていない |

## 機能種別

データ構造操作（Optional型コンテナ管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| components (FromValue) | Toutput_types | Yes | Optionalに格納するテンソル群 | list(type) >= 1 |
| optional (HasValue/GetValue) | variant | Yes | Optionalハンドル | 有効なvariant |
| Toutput_types | list(type) | Yes（FromValue） | コンポーネントの型リスト | 1つ以上 |
| output_types | list(type) | Yes（GetValue） | 出力の型リスト | 1つ以上 |
| output_shapes | list(shape) | Yes（GetValue） | 出力の形状リスト | 1つ以上 |

### 入力データソース

tf.data.Datasetイテレータの出力テンソル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| optional (FromValue/None) | variant | Optionalハンドル（スカラー） |
| has_value | bool | 値存在フラグ（スカラー） |
| components (GetValue) | output_types | 格納されたテンソル群 |

### 出力先

計算グラフ内の後続Opへの入力。

## 処理フロー

### 処理シーケンス

```
1. OptionalFromValueで値を持つOptionalを生成
   └─ テンソル群をvariantコンテナに格納
2. OptionalNoneで空のOptionalを生成
   └─ 値なしのvariantコンテナを生成
3. OptionalHasValueで値の存在を確認
   └─ boolスカラーを返却
4. OptionalGetValueで値を取得
   └─ 格納されたテンソル群を返却
```

### フローチャート

```mermaid
flowchart TD
    A{データソース} -->|値あり| B[OptionalFromValue]
    A -->|終端| C[OptionalNone]
    B --> D[Optionalハンドル]
    C --> D
    D --> E[OptionalHasValue]
    E -->|true| F[OptionalGetValue]
    E -->|false| G[処理終了/ループ脱出]
    F --> H[テンソルコンポーネント]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-110-01 | 型リスト制約 | OptionalFromValueのToutput_typesとOptionalGetValueのoutput_typesは一致する必要がある | FromValue/GetValue間 |
| BR-110-02 | 空Optional取得禁止 | OptionalNoneで生成されたOptionalに対してGetValueを実行するとエラー | GetValue時 |
| BR-110-03 | FullTypeDef追跡 | OptionalFromValueではTFT_OPTIONALによる型追跡が行われる | FromValue時 |

### 計算ロジック

特段の計算ロジックはない。OptionalGetValueのShapeFnはDatasetIteratorShapeを使用（output_shapes属性から出力形状を決定）。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 値なしエラー | OptionalNoneに対するGetValue | HasValueで事前確認 |
| InvalidArgument | 型不一致 | output_typesがOptional内の型と不一致 | 型を一致させる |

### リトライ仕様

自動リトライは行われない。

## トランザクション仕様

Optionalはイミュータブルなデータ構造であり、トランザクション管理は不要。

## パフォーマンス要件

- 各操作はO(1)の計算量（コンテナの参照操作）

## セキュリティ考慮事項

- 特になし

## 備考

- OptionalFromValueのSetTypeConstructorはVariadicTensorContainer(TFT_OPTIONAL)を使用
- OptionalGetValueのShapeFnはDatasetIteratorShapeを使用（tf.dataとの統合）
- ret_types.args(0)は全コンポーネントを包含するOptional型を表す（個別要素ではない）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | optional_ops.cc | `tensorflow/core/ops/optional_ops.cc` | 全4個のOptional Op登録定義 |

**主要処理フロー**:
1. **25-56行目**: OptionalFromValue Op - Toutput_types属性、VariadicTensorContainer(TFT_OPTIONAL)、入力テンソル群のShapeAndType追跡
2. **31-34行目**: スカラーvariant出力の設定
3. **35-36行目**: ShapeAndTypesの構築（各入力テンソルの形状・型・ret_types.args(0)を保持）
4. **38-52行目**: TODOコメント - ret_types.args(0)の型表現に関する設計ノート
5. **54行目**: set_output_handle_shapes_and_typesで型情報を出力に付与
6. **58-60行目**: OptionalNone Op - スカラーvariant出力（値なし）
7. **62-65行目**: OptionalHasValue Op - スカラーbool出力
8. **67-72行目**: OptionalGetValue Op - output_types/output_shapes属性、DatasetIteratorShape ShapeFn

**読解のコツ**: OptionalFromValueのShapeFnは最も複雑で、FullTypeDef型システムとの統合部分（TFT_OPTIONALコンテナ型の追跡）に注目する。ret_types.args(0)は0番目の出力の型（Optional[Record[...]]形式）を表し、set_output_handle_shapes_and_typesは転置形式で同じ情報を追跡する。

### プログラム呼び出し階層図

```
OptionalFromValue
    ├─ SetTypeConstructor: VariadicTensorContainer(TFT_OPTIONAL)
    ├─ ShapeFn:
    │      ├─ スカラー出力設定
    │      ├─ ShapeAndType構築（各コンポーネント）
    │      └─ set_output_handle_shapes_and_types
    └─ variant(TFT_OPTIONAL)ハンドル出力

OptionalNone
    └─ ScalarShape

OptionalHasValue
    └─ ScalarShape (bool)

OptionalGetValue
    └─ DatasetIteratorShape (output_types/output_shapes属性から)
```

### データフロー図

```
[入力]                      [処理]                        [出力]

テンソル群 ──────▶ OptionalFromValue ──────▶ Optional(variant)
(なし) ──────────▶ OptionalNone ────────────▶ Optional(variant, empty)

Optional ────────▶ OptionalHasValue ────────▶ bool (true/false)
Optional ────────▶ OptionalGetValue ────────▶ テンソル群 (components)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| optional_ops.cc | `tensorflow/core/ops/optional_ops.cc` | ソース | Optional Op登録定義（4 Ops） |
