# 機能設計書 117-TFRTランタイム

## 概要

本ドキュメントは、TensorFlow Runtime（TFRT）による新しい非同期実行ランタイムの設計を記述する。

### 本機能の処理概要

TFRTは次世代のTensorFlow実行ランタイムであり、非同期実行モデル、効率的なメモリ管理、高性能なカーネル実行を提供する。従来の共通ランタイム（DirectSession + Executor）に代わる、より低レイテンシ・高スループットな実行基盤を目指している。

**業務上の目的・背景**：従来のTensorFlowランタイムでは、Pythonインタプリタとの相互作用、グラフ実行のオーバーヘッド、同期的なOp実行が性能ボトルネックとなっていた。TFRTはこれらの課題を解決するため、完全に非同期な実行モデルを採用し、Op間の依存関係を最小化した効率的なスケジューリングを実現する。

**機能の利用シーン**：TFRTはTensorFlowの内部ランタイムとして、SavedModelの推論、tf.functionの実行、GPU/TPU上でのカーネル実行などで暗黙的に利用される。特にサービング環境での低レイテンシ推論に効果を発揮する。

**主要な処理内容**：
1. Runtime - TFRTランタイムのメインクラス。ワークキュー管理と実行コンテキストの提供
2. GraphExecutor - TFRTベースのグラフ実行エンジン
3. MLRT - 軽量ランタイムによる効率的な実行
4. SavedModel統合 - SavedModelの読み込みとTFRT上での実行
5. Fallback - 未サポートOpのTF1ランタイムへのフォールバック
6. GPU統合 - GPU上でのTFRTカーネル実行

**関連システム・外部連携**：共通ランタイム（No.116）、SavedModel保存・読み込み（No.62, No.63）、XLAコンパイラ（No.75）、MLIR（No.76）と連携する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当なし | - | 本機能はバックエンドランタイム機能 |

## 機能種別

ランタイムインフラストラクチャ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SavedModel | ディレクトリパス | Yes（推論時） | SavedModelのパス | 有効なSavedModelであること |
| GraphDef / MLIR | protobuf / MLIRモジュール | Yes | 実行するグラフ定義 | - |
| input_tensors | map<string, Tensor> | Yes | 入力テンソル | - |
| WorkQueueInterface | インタフェース | Yes | ワークキュー実装 | - |

### 入力データソース

TensorFlow Python API、TFRTセッション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output_tensors | list<Tensor> | 実行結果のテンソルリスト |
| status | Status | 操作の成功/失敗ステータス |

### 出力先

呼び出し元への戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. ランタイム初期化
   └─ Runtime::Create でランタイムインスタンスを生成
   └─ WorkQueueInterfaceの設定

2. SavedModelロード
   └─ SavedModelのロードとMLIR変換
   └─ TFRT用のグラフ表現に変換

3. グラフ実行
   └─ GraphExecutorで非同期実行
   └─ 各Opを適切なデバイスに配置
   └─ 未サポートOpはfallbackカーネル経由で実行

4. 結果収集
   └─ 非同期結果の同期的な収集
   └─ テンソルの返却
```

### フローチャート

```mermaid
flowchart TD
    A[SavedModel / GraphDef] --> B[MLIR変換]
    B --> C[TFRTグラフ表現]
    C --> D[GraphExecutor]
    D --> E{Op対応状況}
    E -->|TFRTネイティブ| F[TFRTカーネル実行]
    E -->|未サポート| G[Fallbackカーネル]
    F --> H[結果収集]
    G --> H
    H --> I[出力テンソル]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-117-01 | フォールバック | 未対応OpはTF1ランタイムにフォールバック | TFRTネイティブカーネルが存在しないOp |
| BR-117-02 | 非同期実行 | 全てのOp実行は非同期で行われる | TFRT実行時 |
| BR-117-03 | ステップID | 各実行ステップには一意のステップIDが割り当てられる | グラフ実行時 |

### 計算ロジック

該当なし（ランタイムインフラストラクチャ）

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Internal | カーネルエラー | TFRTカーネル実行時のエラー | エラーメッセージに基づきデバッグ |
| InvalidArgument | グラフ変換エラー | MLIR変換の失敗 | グラフ定義を確認 |
| Unavailable | デバイスエラー | 指定デバイスが利用不可 | デバイス設定を確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

非同期実行モデルにより、Op間のパイプライン並列度を最大化。ホストCPUの使用率を削減し、GPU/TPUのアクセラレータ利用率を向上させる。

## セキュリティ考慮事項

特になし。

## 備考

- TFRTは段階的に従来ランタイムを置き換えていく計画。
- MLRTはTFRTの軽量版として、特定のユースケースで使用される。
- IFRTはTPU/GPU向けの統合ランタイムインタフェース。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ランタイム基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runtime.h | `tensorflow/core/tfrt/runtime/runtime.h` | Runtimeクラスのインタフェース |
| 1-2 | work_queue_interface.h | `tensorflow/core/tfrt/runtime/work_queue_interface.h` | ワークキューの抽象インタフェース |

**読解のコツ**: TFRTは非同期実行モデルを採用しており、ワークキューベースのタスクスケジューリングが中核。WorkQueueInterfaceを理解することで実行モデルの全体像が把握できる。

#### Step 2: グラフ実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | graph_executor/ | `tensorflow/core/tfrt/graph_executor/` | TFRTベースのグラフ実行エンジン |

#### Step 3: SavedModel統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | saved_model/ | `tensorflow/core/tfrt/saved_model/` | SavedModelのTFRT上でのロード・実行 |

#### Step 4: フォールバック機構を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fallback/ | `tensorflow/core/tfrt/fallback/` | TF1ランタイムへのフォールバックカーネル |

### プログラム呼び出し階層図

```
TFRTSession
    │
    ├─ Runtime
    │      ├─ WorkQueueInterface
    │      └─ StepId管理
    │
    ├─ GraphExecutor
    │      ├─ TFRTネイティブカーネル
    │      └─ Fallbackカーネル
    │             └─ TF1ランタイム(Executor)
    │
    ├─ SavedModel統合
    │      └─ MLIR変換 → TFRTグラフ
    │
    ├─ MLRT（軽量ランタイム）
    │
    └─ GPU統合
           └─ Stream管理
```

### データフロー図

```
[入力]                     [処理]                          [出力]

SavedModel   ───────▶ MLIR変換 ──▶ TFRTグラフ
                                        │
input_tensors ──────▶ GraphExecutor ──▶ output_tensors
                           │
                           ├─▶ TFRTカーネル（ネイティブ）
                           └─▶ Fallbackカーネル（TF1互換）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runtime.h/.cc | `tensorflow/core/tfrt/runtime/runtime.h` | ソース | TFRTランタイムメインクラス |
| work_queue_interface.h/.cc | `tensorflow/core/tfrt/runtime/work_queue_interface.h` | ソース | ワークキューインタフェース |
| step_id.h/.cc | `tensorflow/core/tfrt/runtime/step_id.h` | ソース | ステップID管理 |
| stream.h/.cc | `tensorflow/core/tfrt/runtime/stream.h` | ソース | ストリーム管理 |
| graph_executor/ | `tensorflow/core/tfrt/graph_executor/` | ディレクトリ | グラフ実行エンジン |
| saved_model/ | `tensorflow/core/tfrt/saved_model/` | ディレクトリ | SavedModel統合 |
| fallback/ | `tensorflow/core/tfrt/fallback/` | ディレクトリ | フォールバックカーネル |
| mlrt/ | `tensorflow/core/tfrt/mlrt/` | ディレクトリ | 軽量ランタイム（MLRT） |
| gpu/ | `tensorflow/core/tfrt/gpu/` | ディレクトリ | GPU統合 |
| ifrt/ | `tensorflow/core/tfrt/ifrt/` | ディレクトリ | 統合ランタイムインタフェース |
| tfrt_session/ | `tensorflow/core/tfrt/tfrt_session/` | ディレクトリ | TFRTセッション |
| common/ | `tensorflow/core/tfrt/common/` | ディレクトリ | 共通ユーティリティ |
