# 機能設計書 123-Word2Vec操作

## 概要

本ドキュメントは、TensorFlowにおけるWord2Vec操作の機能設計を記述する。Word2Vecスキップグラムモデルの学習操作（Skipgram、NegTrain）を提供する。なお、本機能はバージョン19で非推奨（deprecated）となり、tensorflow_models/tutorialsへ移行されている。

### 本機能の処理概要

**業務上の目的・背景**：自然言語処理において、単語をベクトル空間上の密ベクトル（分散表現）に変換するWord2Vecは、単語間の意味的関係を捉える基礎技術である。本操作はWord2VecのスキップグラムモデルをネイティブOpとして実装し、学習の高速化を図ったものである。

**機能の利用シーン**：テキストデータからの単語埋め込みベクトルの学習。自然言語処理タスクの前処理として単語の分散表現を獲得する場面で使用される（現在は非推奨）。

**主要な処理内容**：
1. Skipgram Op: テキストコーパスファイルからスキップグラムの訓練サンプル（単語ペア）を生成
2. NegTrain Op: 負例サンプリングによるスキップグラムモデルの重み更新（学習ステップ）
3. 語彙の読み込みと頻度情報の管理

**関連システム・外部連携**：テキストコーパスファイルを入力として読み込む。tensorflow_models/tutorialsに後継実装が移行済み。

**権限による制御**：特になし。全ユーザが利用可能。ただし非推奨（Deprecated at version 19）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はバックエンド計算操作であり、直接関連する画面はない |

## 機能種別

計算処理（単語埋め込み学習）

## 入力仕様

### 入力パラメータ

#### Skipgram Op

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filename | string | Yes | 学習用テキストコーパスファイルパス | - |
| batch_size | int | Yes | バッチサイズ | - |
| window_size | int | No | スキップグラムのウィンドウサイズ | デフォルト 5 |
| min_count | int | No | 最低出現頻度 | デフォルト 5 |
| subsample | float | No | サブサンプリング閾値 | デフォルト 1e-3 |

#### NegTrain Op

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| w_in | Ref(float) | Yes | 入力重み行列 | - |
| w_out | Ref(float) | Yes | 出力重み行列 | - |
| examples | int32 | Yes | 訓練サンプル（単語ID） | - |
| labels | int32 | Yes | ラベル（コンテキスト単語ID） | - |
| lr | float | Yes | 学習率 | - |
| vocab_count | list(int) | Yes | 語彙の出現頻度リスト | - |
| num_negative_samples | int | Yes | 負例サンプル数 | - |

### 入力データソース

テキストコーパスファイル（Skipgram Op）。プログラム内部で生成される訓練データテンソル（NegTrain Op）。

## 出力仕様

### 出力データ

#### Skipgram Op

| 項目名 | 型 | 説明 |
|--------|-----|------|
| vocab_word | string | 語彙の単語リスト |
| vocab_freq | int32 | 語彙の出現頻度リスト |
| words_per_epoch | int64 | エポックあたりの総単語数 |
| current_epoch | int32 | 現在のエポック番号 |
| total_words_processed | int64 | 処理済み総単語数 |
| examples | int32 | 訓練サンプル（単語ID） |
| labels | int32 | ラベル（コンテキスト単語ID） |

#### NegTrain Op

出力テンソルなし（Ref型のw_in, w_outを直接更新）。

### 出力先

Skipgram Opの出力はNegTrain Opへの入力として使用。NegTrain Opは重み行列を直接更新。

## 処理フロー

### 処理シーケンス

```
1. コーパスファイルの読み込み（Skipgram）
   └─ テキストファイルから語彙構築、頻度カウント
2. スキップグラムペアの生成（Skipgram）
   └─ ウィンドウサイズに基づく単語ペアのサンプリング
3. 負例サンプリング学習（NegTrain）
   └─ 正例と負例に対する重み更新
```

### フローチャート

```mermaid
flowchart TD
    A[テキストコーパス] --> B[Skipgram Op]
    B --> C[語彙構築・頻度カウント]
    C --> D[スキップグラムペア生成]
    D --> E[examples, labels]
    E --> F[NegTrain Op]
    F --> G[重み更新: w_in, w_out]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-123-1 | 非推奨 | バージョン19以降非推奨。tensorflow_models/tutorialsへ移行 | 常時 |
| BR-123-2 | 最低出現頻度 | min_count未満の単語は語彙から除外 | Skipgram Op |
| BR-123-3 | サブサンプリング | 高頻度語は確率的に学習対象から除外 | subsample > 0 |
| BR-123-4 | ウィンドウサイズ | コンテキスト単語はwindow_size以内の単語から選択 | Skipgram Op |

### 計算ロジック

- **サブサンプリング確率**: P(w) = 1 - sqrt(subsample / freq(w))
- **負例サンプリング**: vocab_countに基づく3/4乗確率分布からnum_negative_samples個をサンプリング
- **重み更新**: SGDによるw_in, w_outの直接更新（lr * gradient）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。ファイルI/Oおよびインメモリ演算のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | ファイルエラー | filenameで指定したファイルが存在しない | 正しいファイルパスを指定 |
| InvalidArgument | パラメータエラー | batch_sizeが不正 | 正の整数を指定 |
| DeprecationWarning | 非推奨警告 | バージョン19以降の使用 | tensorflow_models/tutorialsの実装を使用 |

### リトライ仕様

ファイル読み込みエラーの場合はリトライ不可。学習ステップ自体は反復実行される設計。

## トランザクション仕様

トランザクション管理なし。NegTrain OpはRef型でw_in, w_outを直接更新するため、並行更新に注意。

## パフォーマンス要件

ネイティブC++ OpとしてSkipgramペア生成と負例学習を実装することで、Python実装に比べて大幅な高速化を実現。ただし現在は非推奨。

## セキュリティ考慮事項

入力テキストファイルのパスバリデーション。悪意のあるファイルパスの指定に注意。

## 備考

- 本Opはバージョン19で非推奨（Deprecated）となっている
- 後継実装はtensorflow_models/tutorialsに移行
- Skipgram OpはSetIsStateful()によりステートフル（内部でファイル読み込み位置などの状態を保持）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Word2Vecの入出力テンソルの型と構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | word2vec_ops.cc | `tensorflow/core/ops/word2vec_ops.cc` | Skipgram Opの7つの出力とNegTrain Opの入力構造 |

**読解のコツ**: `.Deprecated(19, ...)`はこのOpがバージョン19で非推奨になったことを示す。`Ref(float)`はミュータブルな変数参照で、Opがテンソルを直接更新可能であることを意味する。

#### Step 2: Skipgram Opを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | word2vec_ops.cc | `tensorflow/core/ops/word2vec_ops.cc` | Skipgram Op登録 |

**主要処理フロー**:
1. **21-38行目**: Skipgram Op - 7つの出力（vocab_word, vocab_freq, words_per_epoch, current_epoch, total_words_processed, examples, labels）を持つステートフルOp
2. **33行目**: filename属性 - 学習コーパスファイルパス
3. **34行目**: batch_size属性 - 1回のcallで返すペア数
4. **35-37行目**: window_size, min_count, subsample - 学習ハイパーパラメータ

#### Step 3: NegTrain Opを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | word2vec_ops.cc | `tensorflow/core/ops/word2vec_ops.cc` | NegTrain Op登録 |

**主要処理フロー**:
- **40-52行目**: NegTrain Op - Ref(float)のw_in, w_outを直接更新する学習Op
- **44行目**: w_in: Ref(float) - 入力層の重み行列（可変参照）
- **45行目**: w_out: Ref(float) - 出力層の重み行列（可変参照）
- **50行目**: vocab_count - 負例サンプリング確率の計算に使用
- **51行目**: num_negative_samples - 各正例に対する負例数

### プログラム呼び出し階層図

```
word2vec_ops.cc (Op定義)
    |
    +-- REGISTER_OP("Skipgram")    [Deprecated v19]
    |     +-- filename → コーパス読み込み
    |     +-- batch_size, window_size → ペア生成パラメータ
    |     +-- 出力: vocab_word, vocab_freq, examples, labels 等
    |
    +-- REGISTER_OP("NegTrain")    [Deprecated v19]
          +-- w_in, w_out → Ref型重み（直接更新）
          +-- examples, labels → 訓練データ
          +-- lr → 学習率
```

### データフロー図

```
[入力]                    [処理]                       [出力]

テキストファイル ───▶ Skipgram Op ──────────────▶ vocab_word, vocab_freq
(filename)              (コーパス解析・ペア生成)       examples, labels
                                                      words_per_epoch 等
                              |
                              v
examples, labels ─────▶ NegTrain Op ──────────▶ (w_in, w_out を直接更新)
w_in, w_out (Ref) ────▶   (負例サンプリング学習)
lr ───────────────────▶
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| word2vec_ops.cc | `tensorflow/core/ops/word2vec_ops.cc` | ソース | Op定義（Skipgram, NegTrain） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | UnknownShape形状推論 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ |
