# 機能設計書 125-同期プリミティブ

## 概要

本ドキュメントは、TensorFlowにおける同期プリミティブ操作（Synchronization Primitives）の機能設計を記述する。GPUストリームの同期を行うSyncDevice Opを提供する。

### 本機能の処理概要

**業務上の目的・背景**：GPU上での非同期計算において、特定のタイミングでGPUストリームの完了を待つ必要がある。SyncDevice Opは、GPUストリームの同期を明示的に実行するための操作であり、計算グラフ内で同期ポイントを挿入するために使用される。

**機能の利用シーン**：GPU計算の同期が必要な場面、例えばGPUメモリのコピー前に計算完了を保証する場合や、プロファイリングのための同期ポイントの挿入、異なるGPUストリーム間のデータ依存関係の解決時に使用される。

**主要な処理内容**：
1. SyncDevice Op: GPUストリームを同期し、当該デバイス上の全計算の完了を待機

**関連システム・外部連携**：CUDA/ROCmランタイムとの連携。GPUストリーム管理サブシステムとの統合。

**権限による制御**：特になし。全ユーザが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はバックエンドデバイス同期操作であり、直接関連する画面はない |

## 機能種別

計算処理（デバイス同期）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | SyncDevice Opは入力テンソルを持たない | - |

### 入力データソース

入力なし。計算グラフ内の依存関係によって実行タイミングが制御される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | - | SyncDevice Opは出力テンソルを持たない |

### 出力先

出力なし。副作用（GPUストリームの同期）のみ。

## 処理フロー

### 処理シーケンス

```
1. SyncDevice Opの実行
   └─ GPUストリームの同期（cudaStreamSynchronize相当）を実行
2. 完了待ち
   └─ ストリーム上の全カーネルの完了を待機
3. 後続処理への制御移行
   └─ 同期完了後、計算グラフの後続ノードが実行可能に
```

### フローチャート

```mermaid
flowchart TD
    A[前段のGPU計算] --> B[SyncDevice Op]
    B --> C[GPUストリーム同期]
    C --> D[全カーネル完了待ち]
    D --> E[後続処理の実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-125-1 | ステートフル性 | SetIsStateful()により副作用を持つOpとしてマーク。最適化パスで除去されない | 常時 |
| BR-125-2 | 出力なし | NoOutputs形状推論により出力テンソルなし | 常時 |

### 計算ロジック

本Op自体に計算ロジックはない。GPUストリームの同期（バリア操作）のみを実行する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Internal | デバイスエラー | GPUストリーム同期に失敗 | デバイスの状態を確認 |

### リトライ仕様

GPUエラーの場合、一般的にリトライは困難。デバイスの再初期化が必要となる場合がある。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

SyncDevice OpはGPUストリームの完了を待つため、レイテンシが発生する。不要な同期の挿入はパフォーマンスを低下させるため、最小限の使用が推奨される。

## セキュリティ考慮事項

特になし。

## 備考

- ソースコードのコメントに「SetIsStateful()がないと最適化パス（dead code elimination等）で誤って除去される可能性がある」と明記されている
- 2023年に追加された比較的新しいOp
- コメントに「GPU steam」というtypoがある（正しくはGPU stream）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op定義を理解する

非常にシンプルなOp定義で、入出力なし、ステートフルの3点が要点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sync_ops.cc | `tensorflow/core/ops/sync_ops.cc` | SyncDevice Op定義 |

**読解のコツ**: `SetIsStateful()`はOpが副作用を持つことを示し、グラフ最適化パスが不要なOpとして除去しないようにする重要なマーカーである。`shape_inference::NoOutputs`は出力テンソルがないことを示す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sync_ops.cc | `tensorflow/core/ops/sync_ops.cc` | REGISTER_OP("SyncDevice") |

**主要処理フロー**:
1. **20-22行目**: コメント - SyncDeviceがステートフルである理由の説明（GPUストリームの同期という副作用を持つため）
2. **23-25行目**: REGISTER_OP("SyncDevice") - 入出力なし、SetIsStateful()、NoOutputs形状推論

### プログラム呼び出し階層図

```
sync_ops.cc (Op定義)
    |
    +-- REGISTER_OP("SyncDevice")
          +-- SetIsStateful() ... 最適化パスで除去されない
          +-- NoOutputs ... 出力テンソルなし
```

### データフロー図

```
[入力]          [処理]              [出力]

(なし) ───▶ SyncDevice Op ───▶ (なし / 副作用のみ)
              (GPUストリーム同期)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sync_ops.cc | `tensorflow/core/ops/sync_ops.cc` | ソース | SyncDevice Op定義 |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | NoOutputs形状推論 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ |
