# 機能設計書 127-送受信操作（Send/Recv）

## 概要

本ドキュメントは、TensorFlowにおける送受信操作（Send/Recv Operations）の機能設計を記述する。デバイス間・プロセス間のテンソル送受信操作を提供し、分散実行やデバイス間データ転送の基盤となる。

### 本機能の処理概要

**業務上の目的・背景**：TensorFlowの計算グラフは複数のデバイス（CPU、GPU）やプロセスにまたがって実行される。異なるデバイスやプロセス上のOp間でテンソルデータを転送する基本的な通信プリミティブとして、Send/Recv操作が必要となる。これは分散実行ランタイムの最も低レベルな通信機構である。

**機能の利用シーン**：計算グラフの自動デバイス配置により、異なるデバイスに配置されたOp間でのデータ転送が必要な場合に、ランタイムが自動的にSend/Recvペアを挿入する。また、クライアント側のfeed/fetch操作でも使用される。

**主要な処理内容**：
1. Send / _Send: 指定デバイスからテンソルを送信
2. Recv / _Recv: 指定デバイスでテンソルを受信
3. _HostSend: ホストメモリ上のテンソルを送信
4. _HostRecv: ホストメモリ上でテンソルを受信
5. デバイスインカーネーション管理による通信のバージョニング

**関連システム・外部連携**：分散ランタイム（gRPC）、デバイスマネージャ、Rendezvousメカニズム。

**権限による制御**：特になし。ランタイムが内部的に使用する低レベル操作。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はランタイム内部の通信操作であり、直接関連する画面はない |

## 機能種別

データ連携（デバイス間・プロセス間テンソル転送）

## 入力仕様

### 入力パラメータ

#### Send / _Send

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tensor | T | Yes | 送信するテンソル | 任意の型 |
| tensor_name | string | Yes | テンソルの識別名 | - |
| send_device | string | Yes | 送信元デバイス名 | - |
| send_device_incarnation | int | Yes | 送信デバイスの現在のインカーネーション | - |
| recv_device | string | Yes | 受信先デバイス名 | - |
| client_terminated | bool | No | クライアント側feed/fetchの場合true | デフォルト false |

#### Recv / _Recv

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tensor_type | type | Yes | 受信テンソルの型 | - |
| tensor_name | string | Yes | テンソルの識別名（Sendと一致） | - |
| send_device | string | Yes | 送信元デバイス名 | - |
| send_device_incarnation | int | Yes | 送信デバイスのインカーネーション | - |
| recv_device | string | Yes | 受信先デバイス名 | - |
| client_terminated | bool | No | クライアント側feed/fetchの場合true | デフォルト false |

### 入力データソース

計算グラフ内の先行ノードの出力テンソル。

## 出力仕様

### 出力データ

#### Send / _Send / _HostSend

出力テンソルなし（送信のみ）。

#### Recv / _Recv / _HostRecv

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tensor | tensor_type | 受信したテンソル |

### 出力先

Recvの出力は後続Opの入力として使用される。

## 処理フロー

### 処理シーケンス

```
1. Sendの実行
   └─ テンソルをRendezvousに登録
2. Recvの実行
   └─ Rendezvousからテンソルを取得（到着まで待機）
3. デバイス間転送
   └─ 同一プロセス: メモリコピー
   └─ 異プロセス: gRPCによるネットワーク転送
```

### フローチャート

```mermaid
flowchart TD
    A[Send Op @ Device A] --> B[Rendezvousに登録]
    B --> C{同一プロセス?}
    C -->|Yes| D[メモリコピー/DMA転送]
    C -->|No| E[gRPCによるネットワーク転送]
    D --> F[Rendezvousから取得]
    E --> F
    F --> G[Recv Op @ Device B]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-127-1 | ペア一致 | SendとRecvはtensor_name, send_device, recv_deviceが一致する必要がある | 常時 |
| BR-127-2 | インカーネーション | send_device_incarnationでデバイスの世代を識別 | 常時 |
| BR-127-3 | ホストメモリ | _HostSend/_HostRecvはホストメモリ上で動作、_Send/_Recvはデバイスメモリ上で動作 | デバイスメモリ種別 |
| BR-127-4 | 分散通信マーク | _Recv, Recvは SetIsDistributedCommunication() でマーク | Recv系Op |
| BR-127-5 | client_terminated | feed/fetch起因の場合、対応するSend/Recvはクライアントがローカルに管理 | クライアント操作時 |

### 計算ロジック

本Op自体に計算ロジックはない。テンソルのバイト列をそのまま転送する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DeadlineExceeded | タイムアウト | Recvがタイムアウト内にSendからデータを受信できない | タイムアウト設定の調整 |
| Cancelled | キャンセル | 対応するSend/Recvが存在しない | グラフ構築を確認 |
| Internal | 通信エラー | gRPC通信に失敗 | ネットワーク接続を確認 |

### リトライ仕様

gRPC通信エラーの場合、ランタイムレベルでリトライが実行される場合がある。

## トランザクション仕様

トランザクション管理なし。SetIsStateful()によりステートフルOpとしてマーク。

## パフォーマンス要件

同一プロセス内のデバイス間転送はDMA（PCIe/NVLink）により高速に実行。異プロセス間はgRPCのオーバーヘッドが発生するため、大きなテンソルのバッチ転送が推奨。

## セキュリティ考慮事項

gRPCベースの分散通信では、TLS/SSLによる暗号化やクラスタ間認証の設定が推奨される。

## 備考

- SendとRecvには公開版（Send, Recv）と内部版（_Send, _Recv）が存在
- _HostSend/_HostRecvはデバイスメモリではなくホストメモリ上で動作する点が通常版と異なる
- Rendezvousメカニズムにより、Send/Recvの実行順序に関わらずデータ転送が成立する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op定義を理解する

6つのOp（Send, _Send, Recv, _Recv, _HostSend, _HostRecv）の入出力と属性を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sendrecv_ops.cc | `tensorflow/core/ops/sendrecv_ops.cc` | 6つのOp定義の共通パターンと差異 |

**読解のコツ**: Send系OpはInput("tensor: T")を持ち出力なし。Recv系OpはOutput("tensor: tensor_type")を持ち入力なし。全Opで共通の属性セット（tensor_name, send_device, recv_device, send_device_incarnation, client_terminated）を持つ。

#### Step 2: 内部版Send/Recvを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sendrecv_ops.cc | `tensorflow/core/ops/sendrecv_ops.cc` | _Send, _Recv |

**主要処理フロー**:
1. **21-43行目**: _Send - テンソルを送信。Docコメントで属性の意味を詳細説明
2. **56-79行目**: _Recv - テンソルを受信。SetIsDistributedCommunication()マーク付き
3. **39-42行目**: client_terminated属性 - feed/fetch操作の場合にtrueとなり、ローカル管理

#### Step 3: 公開版Send/Recvを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sendrecv_ops.cc | `tensorflow/core/ops/sendrecv_ops.cc` | Send, Recv |

**主要処理フロー**:
- **45-54行目**: Send - _Sendと同じ属性だがDocなし
- **81-91行目**: Recv - _Recvと同じ属性だがDocなし

#### Step 4: ホストメモリ版を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | sendrecv_ops.cc | `tensorflow/core/ops/sendrecv_ops.cc` | _HostSend, _HostRecv |

**主要処理フロー**:
- **93-118行目**: _HostSend - ホストメモリ上の入力を要求（_Sendはデバイスメモリ）
- **120-148行目**: _HostRecv - ホストメモリ上に出力（_Recvはデバイスメモリ）

### プログラム呼び出し階層図

```
sendrecv_ops.cc (Op定義)
    |
    +-- REGISTER_OP("_Send")      ... 内部版送信（デバイスメモリ）
    +-- REGISTER_OP("Send")       ... 公開版送信
    +-- REGISTER_OP("_Recv")      ... 内部版受信（デバイスメモリ）+ DistributedCommunication
    +-- REGISTER_OP("Recv")       ... 公開版受信 + DistributedCommunication
    +-- REGISTER_OP("_HostSend")  ... ホストメモリ版送信
    +-- REGISTER_OP("_HostRecv")  ... ホストメモリ版受信 + DistributedCommunication
```

### データフロー図

```
[Device A]                [Rendezvous]              [Device B]

tensor ──▶ Send Op ──▶ 登録 ──────────────▶ 取得 ──▶ Recv Op ──▶ tensor
           (send_device)    (tensor_name)           (recv_device)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sendrecv_ops.cc | `tensorflow/core/ops/sendrecv_ops.cc` | ソース | Op定義（6つのOp） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | UnknownShape形状推論 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ |
