# 機能設計書 128-特殊数学関数操作

## 概要

本ドキュメントは、TensorFlowにおける特殊数学関数操作（Special Math Operations）の機能設計を記述する。ベッセル関数、ドーソン関数、フレネル積分、スペンス関数、指数積分などの特殊関数を提供する。

### 本機能の処理概要

**業務上の目的・背景**：科学技術計算や確率分布の計算において、ベッセル関数やガンマ関数などの特殊関数が必要となる場面が多い。これらの特殊関数をGPU上で高速に計算できるようにすることで、統計モデリング、物理シミュレーション、確率的推論などのワークロードをTensorFlow上で効率的に実行可能にする。

**機能の利用シーン**：ガウス過程回帰におけるベッセル関数の計算、ベイズ推論における特殊関数の計算、信号処理におけるフレネル積分、光学シミュレーションにおけるベッセル関数、統計分布（カイ二乗分布等）の累積分布関数の計算などに使用される。

**主要な処理内容**：
1. ベッセル関数（第1種・第2種、修正ベッセル関数）: BesselI0, BesselI1, BesselI0e, BesselI1e, BesselK0, BesselK1, BesselK0e, BesselK1e, BesselJ0, BesselJ1, BesselY0, BesselY1
2. ドーソン関数: Dawsn
3. 指数積分: Expint
4. フレネル積分: FresnelCos, FresnelSin
5. スペンス関数: Spence

**関連システム・外部連携**：特になし。純粋な数学演算Op群。

**権限による制御**：特になし。全ユーザが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はバックエンド数学演算であり、直接関連する画面はない |

## 機能種別

計算処理（特殊数学関数）

## 入力仕様

### 入力パラメータ

全Opに共通の入力パラメータ:

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| x | T | Yes | 入力テンソル | T: bfloat16, half, float, double |

### 入力データソース

プログラム内部で生成されるテンソルデータ。

## 出力仕様

### 出力データ

全Opに共通の出力:

| 項目名 | 型 | 説明 |
|--------|-----|------|
| y | T | 特殊関数の計算結果（入力と同じ形状・型） |

### 出力先

後続のテンソル演算への入力。

## 処理フロー

### 処理シーケンス

```
1. 入力テンソルの受け取り
   └─ 任意形状の浮動小数点テンソル
2. 要素ごとの特殊関数計算
   └─ 各要素に対して指定された特殊関数を適用
3. 結果の出力
   └─ 入力と同じ形状・型のテンソルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[入力テンソル x] --> B[要素ごとの特殊関数計算]
    B --> C[出力テンソル y = f_x_]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-128-1 | 型制約 | bfloat16, half, float, doubleのみサポート | 全Op |
| BR-128-2 | 形状不変 | 出力形状は入力形状と同一（UnchangedShape） | 全Op |
| BR-128-3 | 要素ごと計算 | 各要素に独立して関数を適用 | 全Op |

### 計算ロジック

**ベッセル関数（第1種修正）**:
- BesselI0(x): I_0(x) - 第1種修正ベッセル関数（0次）
- BesselI1(x): I_1(x) - 第1種修正ベッセル関数（1次）
- BesselI0e(x): e^(-|x|) * I_0(x) - 指数スケーリング版
- BesselI1e(x): e^(-|x|) * I_1(x) - 指数スケーリング版

**ベッセル関数（第2種修正）**:
- BesselK0(x): K_0(x) - 第2種修正ベッセル関数（0次）
- BesselK1(x): K_1(x) - 第2種修正ベッセル関数（1次）
- BesselK0e(x): e^x * K_0(x) - 指数スケーリング版
- BesselK1e(x): e^x * K_1(x) - 指数スケーリング版

**ベッセル関数（第1種・第2種）**:
- BesselJ0(x): J_0(x) - 第1種ベッセル関数（0次）
- BesselJ1(x): J_1(x) - 第1種ベッセル関数（1次）
- BesselY0(x): Y_0(x) - 第2種ベッセル関数（0次）
- BesselY1(x): Y_1(x) - 第2種ベッセル関数（1次）

**その他の特殊関数**:
- Dawsn(x): D(x) = e^(-x^2) * integral(0, x, e^(t^2) dt) - ドーソン関数
- Expint(x): Ei(x) = integral(-inf, x, e^t/t dt) - 指数積分
- FresnelCos(x): C(x) = integral(0, x, cos(pi*t^2/2) dt) - フレネルコサイン積分
- FresnelSin(x): S(x) = integral(0, x, sin(pi*t^2/2) dt) - フレネルサイン積分
- Spence(x): Li_2(x) = -integral(0, x, ln(1-t)/t dt) - スペンス関数（二重対数関数）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 型エラー | サポートされない型が入力された | bfloat16/half/float/doubleを使用 |
| - | 数値エラー | 定義域外の入力（例: BesselK0(0)） | 入力値を確認。NaN/Infが返される場合がある |

### リトライ仕様

リトライ不要。決定論的な数学計算。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

要素ごとの計算であり、GPUでの並列計算に適している。bfloat16/half精度では計算速度が向上するが、精度が低下する。

## セキュリティ考慮事項

特になし。

## 備考

- 全17のOpが同一のマクロパターン（UNARY_REAL）で定義されている
- UNARY_REALマクロは入力x: T、出力y: T、型制約T: {bfloat16, half, float, double}、形状推論UnchangedShapeを一括定義
- 指数スケーリング版（e付き）のベッセル関数は大きなxに対する数値安定性を向上させる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: マクロ定義を理解する

全Opに共通のUNARY_REALマクロが定義パターンを規定している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | special_math_ops.cc | `tensorflow/core/ops/special_math_ops.cc` | UNARY_REALマクロ定義 |

**読解のコツ**: `#define UNARY_REAL()` マクロにより、全Opが同一の入出力パターン（Input("x: T"), Output("y: T"), Attr("T: {bfloat16, half, float, double}"), UnchangedShape）を持つ。各REGISTER_OP("OpName").UNARY_REAL()は1行で完結する。

#### Step 2: 各Op登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | special_math_ops.cc | `tensorflow/core/ops/special_math_ops.cc` | 各特殊関数のOp登録 |

**主要処理フロー**:
1. **23-27行目**: UNARY_REALマクロ定義 - 入力x, 出力y, 型制約, UnchangedShape
2. **29-33行目**: 基本特殊関数 - Dawsn, Expint, FresnelCos, FresnelSin, Spence
3. **37-40行目**: 第1種修正ベッセル関数 - BesselI0, BesselI1, BesselI0e, BesselI1e
4. **42-45行目**: 第2種修正ベッセル関数 - BesselK0, BesselK1, BesselK0e, BesselK1e
5. **47-50行目**: 第1種・第2種ベッセル関数 - BesselJ0, BesselJ1, BesselY0, BesselY1

### プログラム呼び出し階層図

```
special_math_ops.cc (Op定義)
    |
    +-- UNARY_REAL() マクロ (共通パターン)
    |
    +-- 基本特殊関数
    |     +-- Dawsn, Expint, FresnelCos, FresnelSin, Spence
    |
    +-- 第1種修正ベッセル関数
    |     +-- BesselI0, BesselI1, BesselI0e, BesselI1e
    |
    +-- 第2種修正ベッセル関数
    |     +-- BesselK0, BesselK1, BesselK0e, BesselK1e
    |
    +-- 第1種・第2種ベッセル関数
          +-- BesselJ0, BesselJ1, BesselY0, BesselY1
```

### データフロー図

```
[入力]          [処理]                    [出力]

x: T ──────▶ 特殊関数Op ──────────▶ y: T
(任意形状)     (要素ごとの計算)         (入力と同形状)

例: x = [1.0, 2.0, 3.0]
    BesselI0(x) → [I_0(1.0), I_0(2.0), I_0(3.0)]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| special_math_ops.cc | `tensorflow/core/ops/special_math_ops.cc` | ソース | 17個のOp定義 |
| numeric_op.h | `tensorflow/core/framework/numeric_op.h` | ヘッダ | 数値Op基盤 |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | UnchangedShape形状推論 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ |
| shape_inference.h | `tensorflow/core/framework/shape_inference.h` | ヘッダ | 形状推論フレームワーク |
